/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.precision;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.index.strtree.ItemBoundable;
import com.vividsolutions.jts.index.strtree.ItemDistance;
import com.vividsolutions.jts.operation.distance.FacetSequence;
import com.vividsolutions.jts.operation.distance.FacetSequenceTreeBuilder;

public class MinimumClearance {
    private Geometry inputGeom;
    private double minClearance;
    private Coordinate[] minClearancePts;

    public MinimumClearance(Geometry geometry) {
        this.inputGeom = geometry;
    }

    private void compute() {
        if (this.minClearancePts != null) {
            return;
        }
        this.minClearancePts = new Coordinate[2];
        this.minClearance = Double.MAX_VALUE;
        if (this.inputGeom.isEmpty()) {
            return;
        }
        Object[] objectArray = FacetSequenceTreeBuilder.build(this.inputGeom).nearestNeighbour(new MinClearanceDistance());
        MinClearanceDistance minClearanceDistance = new MinClearanceDistance();
        this.minClearance = minClearanceDistance.distance((FacetSequence)objectArray[0], (FacetSequence)objectArray[1]);
        this.minClearancePts = minClearanceDistance.getCoordinates();
    }

    public static double getDistance(Geometry geometry) {
        return new MinimumClearance(geometry).getDistance();
    }

    public static Geometry getLine(Geometry geometry) {
        return new MinimumClearance(geometry).getLine();
    }

    public double getDistance() {
        this.compute();
        return this.minClearance;
    }

    public LineString getLine() {
        this.compute();
        Coordinate[] coordinateArray = this.minClearancePts;
        if (coordinateArray != null && coordinateArray[0] != null) {
            return this.inputGeom.getFactory().createLineString(this.minClearancePts);
        }
        return this.inputGeom.getFactory().createLineString((Coordinate[])null);
    }

    private static class MinClearanceDistance
    implements ItemDistance {
        private double minDist = Double.MAX_VALUE;
        private Coordinate[] minPts = new Coordinate[2];

        private MinClearanceDistance() {
        }

        private double segmentDistance(FacetSequence facetSequence, FacetSequence facetSequence2) {
            int n = 0;
            block0: while (n < facetSequence.size()) {
                int n2 = 1;
                while (true) {
                    double d;
                    if (n2 >= facetSequence2.size()) {
                        ++n;
                        continue block0;
                    }
                    Coordinate coordinate = facetSequence.getCoordinate(n);
                    Coordinate coordinate2 = facetSequence2.getCoordinate(n2 - 1);
                    Coordinate coordinate3 = facetSequence2.getCoordinate(n2);
                    if (!coordinate.equals2D(coordinate2) && !coordinate.equals2D(coordinate3) && (d = CGAlgorithms.distancePointLine(coordinate, coordinate2, coordinate3)) < this.minDist) {
                        this.minDist = d;
                        this.updatePts(coordinate, coordinate2, coordinate3);
                        if (d == 0.0) {
                            return d;
                        }
                    }
                    ++n2;
                }
                break;
            }
            return this.minDist;
        }

        private void updatePts(Coordinate coordinate, Coordinate comparable, Coordinate coordinate2) {
            this.minPts[0] = coordinate;
            comparable = new LineSegment((Coordinate)comparable, coordinate2);
            this.minPts[1] = new Coordinate(((LineSegment)comparable).closestPoint(coordinate));
        }

        private double vertexDistance(FacetSequence facetSequence, FacetSequence facetSequence2) {
            int n = 0;
            block0: while (n < facetSequence.size()) {
                int n2 = 0;
                while (true) {
                    double d;
                    Coordinate coordinate;
                    if (n2 >= facetSequence2.size()) {
                        ++n;
                        continue block0;
                    }
                    Coordinate coordinate2 = facetSequence.getCoordinate(n);
                    if (!coordinate2.equals2D(coordinate = facetSequence2.getCoordinate(n2)) && (d = coordinate2.distance(coordinate)) < this.minDist) {
                        this.minDist = d;
                        Coordinate[] coordinateArray = this.minPts;
                        coordinateArray[0] = coordinate2;
                        coordinateArray[1] = coordinate;
                        if (d == 0.0) {
                            return d;
                        }
                    }
                    ++n2;
                }
                break;
            }
            return this.minDist;
        }

        @Override
        public double distance(ItemBoundable object, ItemBoundable object2) {
            object = (FacetSequence)((ItemBoundable)object).getItem();
            object2 = (FacetSequence)((ItemBoundable)object2).getItem();
            this.minDist = Double.MAX_VALUE;
            return this.distance((FacetSequence)object, (FacetSequence)object2);
        }

        public double distance(FacetSequence facetSequence, FacetSequence facetSequence2) {
            this.vertexDistance(facetSequence, facetSequence2);
            if (facetSequence.size() == 1 && facetSequence2.size() == 1) {
                return this.minDist;
            }
            double d = this.minDist;
            if (d <= 0.0) {
                return d;
            }
            this.segmentDistance(facetSequence, facetSequence2);
            d = this.minDist;
            if (d <= 0.0) {
                return d;
            }
            this.segmentDistance(facetSequence2, facetSequence);
            return this.minDist;
        }

        public Coordinate[] getCoordinates() {
            return this.minPts;
        }
    }
}

