/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.precision;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateFilter;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;

public class SimpleMinimumClearance {
    private Geometry inputGeom;
    private double minClearance;
    private Coordinate[] minClearancePts;

    public SimpleMinimumClearance(Geometry geometry) {
        this.inputGeom = geometry;
    }

    private void compute() {
        if (this.minClearancePts != null) {
            return;
        }
        this.minClearancePts = new Coordinate[2];
        this.minClearance = Double.MAX_VALUE;
        this.inputGeom.apply(new VertexCoordinateFilter());
    }

    public static double getDistance(Geometry geometry) {
        return new SimpleMinimumClearance(geometry).getDistance();
    }

    public static Geometry getLine(Geometry geometry) {
        return new SimpleMinimumClearance(geometry).getLine();
    }

    private void updateClearance(double d, Coordinate coordinate, Coordinate coordinate2) {
        if (d < this.minClearance) {
            this.minClearance = d;
            this.minClearancePts[0] = new Coordinate(coordinate);
            this.minClearancePts[1] = new Coordinate(coordinate2);
        }
    }

    private void updateClearance(double d, Coordinate coordinate, Coordinate comparable, Coordinate coordinate2) {
        if (d < this.minClearance) {
            this.minClearance = d;
            this.minClearancePts[0] = new Coordinate(coordinate);
            comparable = new LineSegment((Coordinate)comparable, coordinate2);
            this.minClearancePts[1] = new Coordinate(((LineSegment)comparable).closestPoint(coordinate));
        }
    }

    public double getDistance() {
        this.compute();
        return this.minClearance;
    }

    public LineString getLine() {
        this.compute();
        return this.inputGeom.getFactory().createLineString(this.minClearancePts);
    }

    private class ComputeMCCoordinateSequenceFilter
    implements CoordinateSequenceFilter {
        private Coordinate queryPt;

        public ComputeMCCoordinateSequenceFilter(Coordinate coordinate) {
            this.queryPt = coordinate;
        }

        private void checkSegmentDistance(Coordinate coordinate, Coordinate coordinate2) {
            double d;
            if (!this.queryPt.equals2D(coordinate) && !this.queryPt.equals2D(coordinate2) && (d = CGAlgorithms.distancePointLine(this.queryPt, coordinate2, coordinate)) > 0.0) {
                SimpleMinimumClearance.this.updateClearance(d, this.queryPt, coordinate2, coordinate);
            }
        }

        private void checkVertexDistance(Coordinate coordinate) {
            double d = coordinate.distance(this.queryPt);
            if (d > 0.0) {
                SimpleMinimumClearance.this.updateClearance(d, this.queryPt, coordinate);
            }
        }

        @Override
        public void filter(CoordinateSequence coordinateSequence, int n) {
            this.checkVertexDistance(coordinateSequence.getCoordinate(n));
            if (n > 0) {
                this.checkSegmentDistance(coordinateSequence.getCoordinate(n - 1), coordinateSequence.getCoordinate(n));
            }
        }

        @Override
        public boolean isDone() {
            return false;
        }

        @Override
        public boolean isGeometryChanged() {
            return false;
        }
    }

    private class VertexCoordinateFilter
    implements CoordinateFilter {
        @Override
        public void filter(Coordinate coordinate) {
            SimpleMinimumClearance.this.inputGeom.apply(new ComputeMCCoordinateSequenceFilter(coordinate));
        }
    }
}

