/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.shape;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineSegment;

public abstract class GeometricShapeBuilder {
    protected Envelope extent = new Envelope(0.0, 1.0, 0.0, 1.0);
    protected GeometryFactory geomFactory;
    protected int numPts = 0;

    public GeometricShapeBuilder(GeometryFactory geometryFactory) {
        this.geomFactory = geometryFactory;
    }

    protected Coordinate createCoord(double d, double d2) {
        Coordinate coordinate = new Coordinate(d, d2);
        this.geomFactory.getPrecisionModel().makePrecise(coordinate);
        return coordinate;
    }

    public Coordinate getCentre() {
        return this.extent.centre();
    }

    public double getDiameter() {
        return Math.min(this.extent.getHeight(), this.extent.getWidth());
    }

    public Envelope getExtent() {
        return this.extent;
    }

    public abstract Geometry getGeometry();

    public double getRadius() {
        return this.getDiameter() / 2.0;
    }

    public LineSegment getSquareBaseLine() {
        double d = this.getRadius();
        Coordinate coordinate = this.getCentre();
        return new LineSegment(new Coordinate(coordinate.x - d, coordinate.y - d), new Coordinate(coordinate.x + d, coordinate.y - d));
    }

    public Envelope getSquareExtent() {
        double d = this.getRadius();
        Coordinate coordinate = this.getCentre();
        return new Envelope(coordinate.x - d, coordinate.x + d, coordinate.y - d, coordinate.y + d);
    }

    public void setExtent(Envelope envelope) {
        this.extent = envelope;
    }

    public void setNumPoints(int n) {
        this.numPts = n;
    }
}

