/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.shape.fractal;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.shape.GeometricShapeBuilder;
import java.util.ArrayList;
import java.util.List;

public class SierpinskiCarpetBuilder
extends GeometricShapeBuilder {
    private CoordinateList coordList = new CoordinateList();

    public SierpinskiCarpetBuilder(GeometryFactory geometryFactory) {
        super(geometryFactory);
    }

    private void addHoles(int n, double d, double d2, double d3, List list) {
        if (n < 0) {
            return;
        }
        double d4 = d3 / 3.0;
        this.addHoles(--n, d, d2, d4, list);
        d3 = d + d4;
        this.addHoles(n, d3, d2, d4, list);
        double d5 = d4 * 2.0;
        double d6 = d + d5;
        this.addHoles(n, d6, d2, d4, list);
        double d7 = d2 + d4;
        this.addHoles(n, d, d7, d4, list);
        this.addHoles(n, d6, d7, d4, list);
        this.addHoles(n, d, d2 += d5, d4, list);
        this.addHoles(n, d3, d2, d4, list);
        this.addHoles(n, d6, d2, d4, list);
        list.add(this.createSquareHole(d3, d7, d4));
    }

    private LinearRing createSquareHole(double d, double d2, double d3) {
        Coordinate coordinate = new Coordinate(d, d2);
        double d4 = d + d3;
        Coordinate coordinate2 = new Coordinate(d4, d2);
        Coordinate coordinate3 = new Coordinate(d4, d3 += d2);
        Coordinate coordinate4 = new Coordinate(d, d3);
        Coordinate coordinate5 = new Coordinate(d, d2);
        return this.geomFactory.createLinearRing(new Coordinate[]{coordinate, coordinate2, coordinate3, coordinate4, coordinate5});
    }

    private LinearRing[] getHoles(int n, double d, double d2, double d3) {
        ArrayList arrayList = new ArrayList();
        this.addHoles(n, d, d2, d3, arrayList);
        return GeometryFactory.toLinearRingArray(arrayList);
    }

    public static int recursionLevelForSize(int n) {
        return (int)(Math.log(n / 3) / Math.log(4.0));
    }

    @Override
    public Geometry getGeometry() {
        int n = SierpinskiCarpetBuilder.recursionLevelForSize(this.numPts);
        LinearRing[] linearRingArray = this.getSquareBaseLine().getCoordinate(0);
        linearRingArray = this.getHoles(n, linearRingArray.x, linearRingArray.y, this.getDiameter());
        LinearRing linearRing = (LinearRing)((Polygon)this.geomFactory.toGeometry(this.getSquareExtent())).getExteriorRing();
        return this.geomFactory.createPolygon(linearRing, linearRingArray);
    }
}

