/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.shape.random;

import com.vividsolutions.jts.algorithm.locate.IndexedPointInAreaLocator;
import com.vividsolutions.jts.algorithm.locate.PointOnGeometryLocator;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Polygonal;
import com.vividsolutions.jts.shape.GeometricShapeBuilder;

public class RandomPointsBuilder
extends GeometricShapeBuilder {
    private PointOnGeometryLocator extentLocator;
    protected Geometry maskPoly = null;

    public RandomPointsBuilder() {
        super(new GeometryFactory());
    }

    public RandomPointsBuilder(GeometryFactory geometryFactory) {
        super(geometryFactory);
    }

    @Override
    protected Coordinate createCoord(double d, double d2) {
        Coordinate coordinate = new Coordinate(d, d2);
        this.geomFactory.getPrecisionModel().makePrecise(coordinate);
        return coordinate;
    }

    protected Coordinate createRandomCoord(Envelope envelope) {
        return this.createCoord(envelope.getMinX() + envelope.getWidth() * Math.random(), envelope.getMinY() + envelope.getHeight() * Math.random());
    }

    @Override
    public Geometry getGeometry() {
        Coordinate[] coordinateArray = new Coordinate[this.numPts];
        int n = 0;
        while (n < this.numPts) {
            Coordinate coordinate = this.createRandomCoord(this.getExtent());
            if (this.extentLocator != null && !this.isInExtent(coordinate)) continue;
            coordinateArray[n] = coordinate;
            ++n;
        }
        return this.geomFactory.createMultiPoint(coordinateArray);
    }

    protected boolean isInExtent(Coordinate coordinate) {
        PointOnGeometryLocator pointOnGeometryLocator = this.extentLocator;
        if (pointOnGeometryLocator != null) {
            return pointOnGeometryLocator.locate(coordinate) != 2;
        }
        return this.getExtent().contains(coordinate);
    }

    public void setExtent(Geometry geometry) {
        if (geometry instanceof Polygonal) {
            this.maskPoly = geometry;
            this.setExtent(geometry.getEnvelopeInternal());
            this.extentLocator = new IndexedPointInAreaLocator(geometry);
            return;
        }
        throw new IllegalArgumentException("Only polygonal extents are supported");
    }
}

