/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.shape.random;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.math.MathUtil;
import com.vividsolutions.jts.shape.GeometricShapeBuilder;

public class RandomPointsInGridBuilder
extends GeometricShapeBuilder {
    private double gutterFraction = 0.0;
    private boolean isConstrainedToCircle = false;

    public RandomPointsInGridBuilder() {
        super(new GeometryFactory());
    }

    public RandomPointsInGridBuilder(GeometryFactory geometryFactory) {
        super(geometryFactory);
    }

    private Coordinate randomPointInCell(double d, double d2, double d3, double d4) {
        if (this.isConstrainedToCircle) {
            return RandomPointsInGridBuilder.randomPointInCircle(d, d2, d3, d4);
        }
        return this.randomPointInGridCell(d, d2, d3, d4);
    }

    private static Coordinate randomPointInCircle(double d, double d2, double d3, double d4) {
        double d5 = Math.random() * (Math.PI * 2);
        double d6 = Math.sqrt(Math.random());
        return new Coordinate(d + (d3 /= 2.0) + d3 * d6 * Math.cos(d5), d2 + (d4 /= 2.0) + d4 * d6 * Math.sin(d5));
    }

    private Coordinate randomPointInGridCell(double d, double d2, double d3, double d4) {
        return this.createCoord(d + d3 * Math.random(), d2 + d4 * Math.random());
    }

    @Override
    public Geometry getGeometry() {
        int n;
        int n2 = n = (int)Math.sqrt(this.numPts);
        if (n * n < this.numPts) {
            n2 = n + 1;
        }
        double d = this.getExtent().getWidth();
        double d2 = n2;
        d /= d2;
        d2 = this.getExtent().getHeight() / d2;
        double d3 = MathUtil.clamp(this.gutterFraction, 0.0, 1.0);
        double d4 = d * d3 / 2.0;
        double d5 = d2 * d3 / 2.0;
        d3 = 1.0 - d3;
        Coordinate[] coordinateArray = new Coordinate[n2 * n2];
        n = 0;
        int n3 = 0;
        block0: while (n3 < n2) {
            int n4 = 0;
            while (true) {
                if (n4 >= n2) {
                    ++n3;
                    continue block0;
                }
                coordinateArray[n] = this.randomPointInCell(this.getExtent().getMinX() + (double)n3 * d + d4, this.getExtent().getMinY() + (double)n4 * d2 + d5, d3 * d, d3 * d2);
                ++n4;
                ++n;
            }
            break;
        }
        return this.geomFactory.createMultiPoint(coordinateArray);
    }

    public void setConstrainedToCircle(boolean bl) {
        this.isConstrainedToCircle = bl;
    }

    public void setGutterFraction(double d) {
        this.gutterFraction = d;
    }
}

