/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.simplify;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.LineSegment;
import java.util.ArrayList;

class DouglasPeuckerLineSimplifier {
    private double distanceTolerance;
    private Coordinate[] pts;
    private LineSegment seg = new LineSegment();
    private boolean[] usePt;

    public DouglasPeuckerLineSimplifier(Coordinate[] coordinateArray) {
        this.pts = coordinateArray;
    }

    public static Coordinate[] simplify(Coordinate[] object, double d) {
        object = new DouglasPeuckerLineSimplifier((Coordinate[])object);
        ((DouglasPeuckerLineSimplifier)object).setDistanceTolerance(d);
        return ((DouglasPeuckerLineSimplifier)object).simplify();
    }

    private void simplifySection(int n, int n2) {
        int n3 = n + 1;
        if (n3 == n2) {
            return;
        }
        this.seg.p0 = this.pts[n];
        this.seg.p1 = this.pts[n2];
        double d = -1.0;
        int n4 = n;
        int n5 = n3;
        while (true) {
            if (n5 >= n2) {
                if (d <= this.distanceTolerance) {
                    while (n3 < n2) {
                        this.usePt[n3] = false;
                        ++n3;
                    }
                } else {
                    this.simplifySection(n, n4);
                    this.simplifySection(n4, n2);
                }
                return;
            }
            double d2 = this.seg.distance(this.pts[n5]);
            double d3 = d;
            if (d2 > d) {
                n4 = n5;
                d3 = d2;
            }
            ++n5;
            d = d3;
        }
    }

    public void setDistanceTolerance(double d) {
        this.distanceTolerance = d;
    }

    public Coordinate[] simplify() {
        this.usePt = new boolean[this.pts.length];
        int n = 0;
        int n2 = 0;
        while (true) {
            Object object;
            if (n2 >= ((Coordinate[])(object = this.pts)).length) {
                this.simplifySection(0, ((Coordinate[])object).length - 1);
                object = new CoordinateList();
                n2 = n;
                while (true) {
                    Coordinate[] coordinateArray;
                    if (n2 >= (coordinateArray = this.pts).length) {
                        return ((CoordinateList)object).toCoordinateArray();
                    }
                    if (this.usePt[n2]) {
                        ((ArrayList)object).add(new Coordinate(coordinateArray[n2]));
                    }
                    ++n2;
                }
            }
            this.usePt[n2] = true;
            ++n2;
        }
    }
}

