/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.simplify;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.index.ItemVisitor;
import com.vividsolutions.jts.index.quadtree.Quadtree;
import com.vividsolutions.jts.simplify.LineSegmentVisitor;
import com.vividsolutions.jts.simplify.TaggedLineString;
import java.util.List;

class LineSegmentIndex {
    private Quadtree index = new Quadtree();

    public void add(LineSegment lineSegment) {
        this.index.insert(new Envelope(lineSegment.p0, lineSegment.p1), lineSegment);
    }

    public void add(TaggedLineString taggedLineSegmentArray) {
        taggedLineSegmentArray = taggedLineSegmentArray.getSegments();
        int n = 0;
        while (n < taggedLineSegmentArray.length) {
            this.add(taggedLineSegmentArray[n]);
            ++n;
        }
        return;
    }

    public List query(LineSegment object) {
        Envelope envelope = new Envelope(((LineSegment)object).p0, ((LineSegment)object).p1);
        object = new LineSegmentVisitor((LineSegment)object);
        this.index.query(envelope, (ItemVisitor)object);
        return ((LineSegmentVisitor)object).getItems();
    }

    public void remove(LineSegment lineSegment) {
        this.index.remove(new Envelope(lineSegment.p0, lineSegment.p1), lineSegment);
    }
}

