/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.simplify;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.Triangle;

class VWLineSimplifier {
    private Coordinate[] pts;
    private double tolerance;

    public VWLineSimplifier(Coordinate[] coordinateArray, double d) {
        this.pts = coordinateArray;
        this.tolerance = d * d;
    }

    public static Coordinate[] simplify(Coordinate[] coordinateArray, double d) {
        return new VWLineSimplifier(coordinateArray, d).simplify();
    }

    private double simplifyVertex(VWVertex vWVertex) {
        double d = vWVertex.getArea();
        VWVertex vWVertex2 = null;
        VWVertex vWVertex3 = vWVertex;
        while (true) {
            if (vWVertex3 == null) {
                if (vWVertex2 != null && d < this.tolerance) {
                    vWVertex2.remove();
                }
                if (!vWVertex.isLive()) {
                    d = -1.0;
                }
                return d;
            }
            double d2 = vWVertex3.getArea();
            double d3 = d;
            if (d2 < d) {
                vWVertex2 = vWVertex3;
                d3 = d2;
            }
            vWVertex3 = vWVertex3.next;
            d = d3;
        }
    }

    public Coordinate[] simplify() {
        Coordinate[] coordinateArray = VWVertex.buildLine(this.pts);
        while (this.simplifyVertex((VWVertex)coordinateArray) < this.tolerance) {
        }
        if ((coordinateArray = coordinateArray.getCoordinates()).length < 2) {
            return new Coordinate[]{coordinateArray[0], new Coordinate(coordinateArray[0])};
        }
        return coordinateArray;
    }

    static class VWVertex {
        public static double MAX_AREA = Double.MAX_VALUE;
        private double area = MAX_AREA;
        private boolean isLive = true;
        private VWVertex next;
        private VWVertex prev;
        private Coordinate pt;

        public VWVertex(Coordinate coordinate) {
            this.pt = coordinate;
        }

        public static VWVertex buildLine(Coordinate[] coordinateArray) {
            VWVertex vWVertex = null;
            VWVertex vWVertex2 = null;
            int n = 0;
            while (n < coordinateArray.length) {
                VWVertex vWVertex3 = new VWVertex(coordinateArray[n]);
                VWVertex vWVertex4 = vWVertex;
                if (vWVertex == null) {
                    vWVertex4 = vWVertex3;
                }
                vWVertex3.setPrev(vWVertex2);
                if (vWVertex2 != null) {
                    vWVertex2.setNext(vWVertex3);
                    vWVertex2.updateArea();
                }
                ++n;
                vWVertex2 = vWVertex3;
                vWVertex = vWVertex4;
            }
            return vWVertex;
        }

        public double getArea() {
            return this.area;
        }

        public Coordinate[] getCoordinates() {
            VWVertex vWVertex;
            CoordinateList coordinateList = new CoordinateList();
            VWVertex vWVertex2 = this;
            do {
                coordinateList.add(vWVertex2.pt, false);
                vWVertex2 = vWVertex = vWVertex2.next;
            } while (vWVertex != null);
            return coordinateList.toCoordinateArray();
        }

        public boolean isLive() {
            return this.isLive;
        }

        public VWVertex remove() {
            VWVertex vWVertex = this.prev;
            VWVertex vWVertex2 = this.next;
            if (vWVertex != null) {
                vWVertex.setNext(vWVertex2);
                this.prev.updateArea();
                vWVertex2 = this.prev;
            } else {
                vWVertex2 = null;
            }
            VWVertex vWVertex3 = this.next;
            VWVertex vWVertex4 = vWVertex2;
            if (vWVertex3 != null) {
                vWVertex3.setPrev(vWVertex);
                this.next.updateArea();
                vWVertex4 = vWVertex2;
                if (vWVertex2 == null) {
                    vWVertex4 = this.next;
                }
            }
            this.isLive = false;
            return vWVertex4;
        }

        public void setNext(VWVertex vWVertex) {
            this.next = vWVertex;
        }

        public void setPrev(VWVertex vWVertex) {
            this.prev = vWVertex;
        }

        public void updateArea() {
            VWVertex vWVertex;
            VWVertex vWVertex2 = this.prev;
            if (vWVertex2 != null && (vWVertex = this.next) != null) {
                this.area = Math.abs(Triangle.area(vWVertex2.pt, this.pt, vWVertex.pt));
                return;
            }
            this.area = MAX_AREA;
        }
    }
}

