/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.simplify;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.util.GeometryTransformer;
import com.vividsolutions.jts.simplify.VWLineSimplifier;

public class VWSimplifier {
    private double distanceTolerance;
    private Geometry inputGeom;
    private boolean isEnsureValidTopology = true;

    public VWSimplifier(Geometry geometry) {
        this.inputGeom = geometry;
    }

    public static Geometry simplify(Geometry object, double d) {
        object = new VWSimplifier((Geometry)object);
        ((VWSimplifier)object).setDistanceTolerance(d);
        return ((VWSimplifier)object).getResultGeometry();
    }

    public Geometry getResultGeometry() {
        if (this.inputGeom.isEmpty()) {
            return (Geometry)this.inputGeom.clone();
        }
        return new VWTransformer(this.isEnsureValidTopology).transform(this.inputGeom);
    }

    public void setDistanceTolerance(double d) {
        if (!(d < 0.0)) {
            this.distanceTolerance = d;
            return;
        }
        throw new IllegalArgumentException("Tolerance must be non-negative");
    }

    public void setEnsureValid(boolean bl) {
        this.isEnsureValidTopology = bl;
    }

    class VWTransformer
    extends GeometryTransformer {
        private boolean isEnsureValidTopology = true;

        public VWTransformer(boolean bl) {
            this.isEnsureValidTopology = bl;
        }

        private Geometry createValidArea(Geometry geometry) {
            Geometry geometry2 = geometry;
            if (this.isEnsureValidTopology) {
                geometry2 = geometry.buffer(0.0);
            }
            return geometry2;
        }

        @Override
        protected CoordinateSequence transformCoordinates(CoordinateSequence coordinateArray, Geometry geometry) {
            coordinateArray = (coordinateArray = coordinateArray.toCoordinateArray()).length == 0 ? new Coordinate[]{} : VWLineSimplifier.simplify(coordinateArray, VWSimplifier.this.distanceTolerance);
            return this.factory.getCoordinateSequenceFactory().create(coordinateArray);
        }

        @Override
        protected Geometry transformLinearRing(LinearRing geometry, Geometry geometry2) {
            boolean bl = geometry2 instanceof Polygon;
            geometry2 = super.transformLinearRing((LinearRing)geometry, geometry2);
            geometry = geometry2;
            if (bl) {
                geometry = geometry2;
                if (!(geometry2 instanceof LinearRing)) {
                    geometry = null;
                }
            }
            return geometry;
        }

        @Override
        protected Geometry transformMultiPolygon(MultiPolygon multiPolygon, Geometry geometry) {
            return this.createValidArea(super.transformMultiPolygon(multiPolygon, geometry));
        }

        @Override
        protected Geometry transformPolygon(Polygon geometry, Geometry geometry2) {
            if (geometry.isEmpty()) {
                return null;
            }
            geometry = super.transformPolygon((Polygon)geometry, geometry2);
            if (geometry2 instanceof MultiPolygon) {
                return geometry;
            }
            return this.createValidArea(geometry);
        }
    }
}

