/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.triangulate;

import com.vividsolutions.jts.triangulate.quadedge.QuadEdge;
import com.vividsolutions.jts.triangulate.quadedge.QuadEdgeSubdivision;
import com.vividsolutions.jts.triangulate.quadedge.Vertex;
import java.util.Collection;

public class IncrementalDelaunayTriangulator {
    private boolean isUsingTolerance;
    private QuadEdgeSubdivision subdiv;

    public IncrementalDelaunayTriangulator(QuadEdgeSubdivision quadEdgeSubdivision) {
        boolean bl = false;
        this.isUsingTolerance = false;
        this.subdiv = quadEdgeSubdivision;
        if (quadEdgeSubdivision.getTolerance() > 0.0) {
            bl = true;
        }
        this.isUsingTolerance = bl;
    }

    public QuadEdge insertSite(Vertex vertex) {
        QuadEdge quadEdge;
        QuadEdge quadEdge2 = this.subdiv.locate(vertex);
        if (this.subdiv.isVertexOfEdge(quadEdge2, vertex)) {
            return quadEdge2;
        }
        QuadEdge quadEdge3 = quadEdge2;
        if (this.subdiv.isOnEdge(quadEdge2, vertex.getCoordinate())) {
            quadEdge3 = quadEdge2.oPrev();
            this.subdiv.delete(quadEdge3.oNext());
        }
        QuadEdge quadEdge4 = this.subdiv.makeEdge(quadEdge3.orig(), vertex);
        QuadEdge.splice(quadEdge4, quadEdge3);
        quadEdge2 = quadEdge4;
        QuadEdge quadEdge5 = quadEdge3;
        do {
            quadEdge = this.subdiv.connect(quadEdge5, quadEdge2.sym());
            quadEdge5 = quadEdge3 = quadEdge.oPrev();
            quadEdge2 = quadEdge;
        } while (quadEdge3.lNext() != quadEdge4);
        while (true) {
            if ((quadEdge2 = quadEdge3.oPrev()).dest().rightOf(quadEdge3) && vertex.isInCircle(quadEdge3.orig(), quadEdge2.dest(), quadEdge3.dest())) {
                QuadEdge.swap(quadEdge3);
                quadEdge3 = quadEdge3.oPrev();
                continue;
            }
            if (quadEdge3.oNext() == quadEdge4) {
                return quadEdge;
            }
            quadEdge3 = quadEdge3.oNext().lPrev();
        }
    }

    public void insertSites(Collection object) {
        object = object.iterator();
        while (object.hasNext()) {
            this.insertSite((Vertex)object.next());
        }
        return;
    }
}

