/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.triangulate;

import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.triangulate.DelaunayTriangulationBuilder;
import com.vividsolutions.jts.triangulate.IncrementalDelaunayTriangulator;
import com.vividsolutions.jts.triangulate.quadedge.QuadEdgeSubdivision;
import java.util.ArrayList;
import java.util.Collection;

public class VoronoiDiagramBuilder {
    private Envelope clipEnv = null;
    private Envelope diagramEnv = null;
    private Collection siteCoords;
    private QuadEdgeSubdivision subdiv = null;
    private double tolerance = 0.0;

    private static Geometry clipGeometryCollection(Geometry geometry, Envelope envelope) {
        Geometry geometry2 = geometry.getFactory().toGeometry(envelope);
        ArrayList<Geometry> arrayList = new ArrayList<Geometry>();
        int n = 0;
        while (n < geometry.getNumGeometries()) {
            Geometry geometry3 = geometry.getGeometryN(n);
            Geometry geometry4 = null;
            if (envelope.contains(geometry3.getEnvelopeInternal())) {
                geometry4 = geometry3;
            } else if (envelope.intersects(geometry3.getEnvelopeInternal())) {
                geometry4 = geometry2.intersection(geometry3);
                geometry4.setUserData(geometry3.getUserData());
            }
            if (geometry4 != null && !geometry4.isEmpty()) {
                arrayList.add(geometry4);
            }
            ++n;
        }
        return geometry.getFactory().createGeometryCollection(GeometryFactory.toGeometryArray(arrayList));
    }

    private void create() {
        if (this.subdiv != null) {
            return;
        }
        Object object = DelaunayTriangulationBuilder.envelope(this.siteCoords);
        this.diagramEnv = object;
        double d = Math.max(((Envelope)object).getWidth(), this.diagramEnv.getHeight());
        this.diagramEnv.expandBy(d);
        Object object2 = this.clipEnv;
        if (object2 != null) {
            this.diagramEnv.expandToInclude((Envelope)object2);
        }
        object2 = DelaunayTriangulationBuilder.toVertices(this.siteCoords);
        this.subdiv = object = new QuadEdgeSubdivision((Envelope)object, this.tolerance);
        new IncrementalDelaunayTriangulator((QuadEdgeSubdivision)object).insertSites((Collection)object2);
    }

    public Geometry getDiagram(GeometryFactory geometryFactory) {
        this.create();
        return VoronoiDiagramBuilder.clipGeometryCollection(this.subdiv.getVoronoiDiagram(geometryFactory), this.diagramEnv);
    }

    public QuadEdgeSubdivision getSubdivision() {
        this.create();
        return this.subdiv;
    }

    public void setClipEnvelope(Envelope envelope) {
        this.clipEnv = envelope;
    }

    public void setSites(Geometry geometry) {
        this.siteCoords = DelaunayTriangulationBuilder.extractUniqueCoordinates(geometry);
    }

    public void setSites(Collection collection) {
        this.siteCoords = DelaunayTriangulationBuilder.unique(CoordinateArrays.toCoordinateArray(collection));
    }

    public void setTolerance(double d) {
        this.tolerance = d;
    }
}

