/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.triangulate.quadedge;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.Triangle;
import com.vividsolutions.jts.io.WKTWriter;
import com.vividsolutions.jts.triangulate.quadedge.LastFoundQuadEdgeLocator;
import com.vividsolutions.jts.triangulate.quadedge.LocateFailureException;
import com.vividsolutions.jts.triangulate.quadedge.QuadEdge;
import com.vividsolutions.jts.triangulate.quadedge.QuadEdgeLocator;
import com.vividsolutions.jts.triangulate.quadedge.TriangleVisitor;
import com.vividsolutions.jts.triangulate.quadedge.Vertex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;

public class QuadEdgeSubdivision {
    private static final double EDGE_COINCIDENCE_TOL_FACTOR = 1000.0;
    private double edgeCoincidenceTolerance;
    private Envelope frameEnv;
    private Vertex[] frameVertex;
    private QuadEdgeLocator locator = null;
    private List quadEdges = new ArrayList();
    private LineSegment seg;
    private QuadEdge startingEdge;
    private double tolerance;
    private QuadEdge[] triEdges;
    private int visitedKey = 0;

    public QuadEdgeSubdivision(Envelope envelope, double d) {
        this.frameVertex = new Vertex[3];
        this.seg = new LineSegment();
        this.triEdges = new QuadEdge[3];
        this.tolerance = d;
        this.edgeCoincidenceTolerance = d / 1000.0;
        this.createFrame(envelope);
        this.startingEdge = this.initSubdiv();
        this.locator = new LastFoundQuadEdgeLocator(this);
    }

    private void createFrame(Envelope envelope) {
        double d;
        double d2 = envelope.getWidth();
        d = d2 > (d = envelope.getHeight()) ? d2 * 10.0 : (d *= 10.0);
        this.frameVertex[0] = new Vertex((envelope.getMaxX() + envelope.getMinX()) / 2.0, envelope.getMaxY() + d);
        this.frameVertex[1] = new Vertex(envelope.getMinX() - d, envelope.getMinY() - d);
        this.frameVertex[2] = new Vertex(envelope.getMaxX() + d, envelope.getMinY() - d);
        this.frameEnv = envelope = new Envelope(this.frameVertex[0].getCoordinate(), this.frameVertex[1].getCoordinate());
        envelope.expandToInclude(this.frameVertex[2].getCoordinate());
    }

    private QuadEdge[] fetchTriangleToVisit(QuadEdge quadEdge, Stack stack, boolean bl, Set set) {
        boolean bl2;
        QuadEdge quadEdge2;
        int n = 0;
        QuadEdge quadEdge3 = quadEdge;
        boolean bl3 = false;
        do {
            this.triEdges[n] = quadEdge3;
            bl2 = bl3;
            if (this.isFrameEdge(quadEdge3)) {
                bl2 = true;
            }
            if (!set.contains(quadEdge2 = quadEdge3.sym())) {
                stack.push(quadEdge2);
            }
            set.add(quadEdge3);
            ++n;
            quadEdge2 = quadEdge3.lNext();
            bl3 = bl2;
            quadEdge3 = quadEdge2;
        } while (quadEdge2 != quadEdge);
        if (bl2 && !bl) {
            return null;
        }
        return this.triEdges;
    }

    public static void getTriangleEdges(QuadEdge quadEdge, QuadEdge[] quadEdgeArray) {
        quadEdgeArray[0] = quadEdge;
        quadEdgeArray[1] = quadEdgeArray[0].lNext();
        quadEdgeArray[2] = quadEdgeArray[1].lNext();
        if (quadEdgeArray[2].lNext() == quadEdgeArray[0]) {
            return;
        }
        throw new IllegalArgumentException("Edges do not form a triangle");
    }

    private QuadEdge initSubdiv() {
        Object object = this.frameVertex;
        object = this.makeEdge(object[0], object[1]);
        Object object2 = this.frameVertex;
        object2 = this.makeEdge(object2[1], object2[2]);
        QuadEdge.splice(((QuadEdge)object).sym(), (QuadEdge)object2);
        Object object3 = this.frameVertex;
        object3 = this.makeEdge(object3[2], object3[0]);
        QuadEdge.splice(((QuadEdge)object2).sym(), (QuadEdge)object3);
        QuadEdge.splice(((QuadEdge)object3).sym(), (QuadEdge)object);
        return object;
    }

    public QuadEdge connect(QuadEdge quadEdge, QuadEdge quadEdge2) {
        quadEdge = QuadEdge.connect(quadEdge, quadEdge2);
        this.quadEdges.add(quadEdge);
        return quadEdge;
    }

    public void delete(QuadEdge quadEdge) {
        QuadEdge.splice(quadEdge, quadEdge.oPrev());
        QuadEdge.splice(quadEdge.sym(), quadEdge.sym().oPrev());
        QuadEdge quadEdge2 = quadEdge.sym();
        QuadEdge quadEdge3 = quadEdge.rot();
        QuadEdge quadEdge4 = quadEdge.rot().sym();
        this.quadEdges.remove(quadEdge);
        this.quadEdges.remove(quadEdge2);
        this.quadEdges.remove(quadEdge3);
        this.quadEdges.remove(quadEdge4);
        quadEdge.delete();
        quadEdge2.delete();
        quadEdge3.delete();
        quadEdge4.delete();
    }

    public Geometry getEdges(GeometryFactory geometryFactory) {
        Object object = this.getPrimaryEdges(false);
        LineString[] lineStringArray = new LineString[object.size()];
        Iterator iterator2 = object.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            object = (QuadEdge)iterator2.next();
            lineStringArray[n] = geometryFactory.createLineString(new Coordinate[]{((QuadEdge)object).orig().getCoordinate(), ((QuadEdge)object).dest().getCoordinate()});
            ++n;
        }
        return geometryFactory.createMultiLineString(lineStringArray);
    }

    public Collection getEdges() {
        return this.quadEdges;
    }

    public Envelope getEnvelope() {
        return new Envelope(this.frameEnv);
    }

    public List getPrimaryEdges(boolean bl) {
        ++this.visitedKey;
        ArrayList<QuadEdge> arrayList = new ArrayList<QuadEdge>();
        Stack<QuadEdge> stack = new Stack<QuadEdge>();
        stack.push(this.startingEdge);
        HashSet<QuadEdge> hashSet = new HashSet<QuadEdge>();
        while (!stack.empty()) {
            QuadEdge quadEdge = (QuadEdge)stack.pop();
            if (hashSet.contains(quadEdge)) continue;
            QuadEdge quadEdge2 = quadEdge.getPrimary();
            if (bl || !this.isFrameEdge(quadEdge2)) {
                arrayList.add(quadEdge2);
            }
            stack.push(quadEdge.oNext());
            stack.push(quadEdge.sym().oNext());
            hashSet.add(quadEdge);
            hashSet.add(quadEdge.sym());
        }
        return arrayList;
    }

    public double getTolerance() {
        return this.tolerance;
    }

    public List getTriangleCoordinates(boolean bl) {
        TriangleCoordinatesVisitor triangleCoordinatesVisitor = new TriangleCoordinatesVisitor();
        this.visitTriangles(triangleCoordinatesVisitor, bl);
        return triangleCoordinatesVisitor.getTriangles();
    }

    public List getTriangleEdges(boolean bl) {
        TriangleEdgesListVisitor triangleEdgesListVisitor = new TriangleEdgesListVisitor();
        this.visitTriangles(triangleEdgesListVisitor, bl);
        return triangleEdgesListVisitor.getTriangleEdges();
    }

    public List getTriangleVertices(boolean bl) {
        TriangleVertexListVisitor triangleVertexListVisitor = new TriangleVertexListVisitor();
        this.visitTriangles(triangleVertexListVisitor, bl);
        return triangleVertexListVisitor.getTriangleVertices();
    }

    public Geometry getTriangles(GeometryFactory geometryFactory) {
        int n = 0;
        Object object = this.getTriangleCoordinates(false);
        Geometry[] geometryArray = new Polygon[object.size()];
        object = object.iterator();
        while (object.hasNext()) {
            geometryArray[n] = geometryFactory.createPolygon(geometryFactory.createLinearRing((Coordinate[])object.next()), null);
            ++n;
        }
        return geometryFactory.createGeometryCollection(geometryArray);
    }

    public List getVertexUniqueEdges(boolean bl) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        HashSet<Object> hashSet = new HashSet<Object>();
        Iterator iterator2 = this.quadEdges.iterator();
        while (iterator2.hasNext()) {
            Object object = (QuadEdge)iterator2.next();
            Object object2 = ((QuadEdge)object).orig();
            if (!hashSet.contains(object2)) {
                hashSet.add(object2);
                if (bl || !this.isFrameVertex((Vertex)object2)) {
                    arrayList.add(object);
                }
            }
            if (hashSet.contains(object = ((QuadEdge)(object2 = ((QuadEdge)object).sym())).orig())) continue;
            hashSet.add(object);
            if (!bl && this.isFrameVertex((Vertex)object)) continue;
            arrayList.add(object2);
        }
        return arrayList;
    }

    public Collection getVertices(boolean bl) {
        HashSet<Object> hashSet = new HashSet<Object>();
        Iterator iterator2 = this.quadEdges.iterator();
        while (iterator2.hasNext()) {
            Object object = (QuadEdge)iterator2.next();
            Vertex vertex = ((QuadEdge)object).orig();
            if (bl || !this.isFrameVertex(vertex)) {
                hashSet.add(vertex);
            }
            object = ((QuadEdge)object).dest();
            if (!bl && this.isFrameVertex((Vertex)object)) continue;
            hashSet.add(object);
        }
        return hashSet;
    }

    public Polygon getVoronoiCellPolygon(QuadEdge quadEdge, GeometryFactory serializable) {
        QuadEdge quadEdge2;
        ArrayList<Coordinate> arrayList = new ArrayList<Coordinate>();
        Object object = quadEdge;
        do {
            arrayList.add(((QuadEdge)object).rot().orig().getCoordinate());
            quadEdge2 = ((QuadEdge)object).oPrev();
            object = quadEdge2;
        } while (quadEdge2 != quadEdge);
        object = new CoordinateList();
        ((CoordinateList)object).addAll(arrayList, false);
        ((CoordinateList)object).closeRing();
        if (((ArrayList)object).size() < 4) {
            System.out.println(object);
            ((CoordinateList)object).add(((ArrayList)object).get(((ArrayList)object).size() - 1), true);
        }
        serializable = ((GeometryFactory)serializable).createPolygon(((GeometryFactory)serializable).createLinearRing(((CoordinateList)object).toCoordinateArray()), null);
        ((Geometry)serializable).setUserData(quadEdge.orig().getCoordinate());
        return serializable;
    }

    public List getVoronoiCellPolygons(GeometryFactory geometryFactory) {
        this.visitTriangles(new TriangleCircumcentreVisitor(), true);
        ArrayList<Polygon> arrayList = new ArrayList<Polygon>();
        Iterator iterator2 = this.getVertexUniqueEdges(false).iterator();
        while (iterator2.hasNext()) {
            arrayList.add(this.getVoronoiCellPolygon((QuadEdge)iterator2.next(), geometryFactory));
        }
        return arrayList;
    }

    public Geometry getVoronoiDiagram(GeometryFactory geometryFactory) {
        return geometryFactory.createGeometryCollection(GeometryFactory.toGeometryArray(this.getVoronoiCellPolygons(geometryFactory)));
    }

    public QuadEdge insertSite(Vertex object) {
        QuadEdge quadEdge = this.locate((Vertex)object);
        if (!((Vertex)object).equals(quadEdge.orig(), this.tolerance) && !((Vertex)object).equals(quadEdge.dest(), this.tolerance)) {
            QuadEdge quadEdge2 = this.makeEdge(quadEdge.orig(), (Vertex)object);
            QuadEdge.splice(quadEdge2, quadEdge);
            QuadEdge quadEdge3 = quadEdge2;
            object = quadEdge;
            do {
                quadEdge3 = this.connect((QuadEdge)object, quadEdge3.sym());
                quadEdge = quadEdge3.oPrev();
                object = quadEdge;
            } while (quadEdge.lNext() != quadEdge2);
            return quadEdge2;
        }
        return quadEdge;
    }

    public boolean isFrameBorderEdge(QuadEdge quadEdge) {
        QuadEdgeSubdivision.getTriangleEdges(quadEdge, new QuadEdge[3]);
        QuadEdge[] quadEdgeArray = new QuadEdge[3];
        QuadEdgeSubdivision.getTriangleEdges(quadEdge.sym(), quadEdgeArray);
        if (this.isFrameVertex(quadEdge.lNext().dest())) {
            return true;
        }
        return this.isFrameVertex(quadEdge.sym().lNext().dest());
    }

    public boolean isFrameEdge(QuadEdge quadEdge) {
        return this.isFrameVertex(quadEdge.orig()) || this.isFrameVertex(quadEdge.dest());
        {
        }
    }

    public boolean isFrameVertex(Vertex vertex) {
        if (vertex.equals(this.frameVertex[0])) {
            return true;
        }
        if (vertex.equals(this.frameVertex[1])) {
            return true;
        }
        return vertex.equals(this.frameVertex[2]);
    }

    public boolean isOnEdge(QuadEdge quadEdge, Coordinate coordinate) {
        this.seg.setCoordinates(quadEdge.orig().getCoordinate(), quadEdge.dest().getCoordinate());
        return this.seg.distance(coordinate) < this.edgeCoincidenceTolerance;
    }

    public boolean isVertexOfEdge(QuadEdge quadEdge, Vertex vertex) {
        return vertex.equals(quadEdge.orig(), this.tolerance) || vertex.equals(quadEdge.dest(), this.tolerance);
        {
        }
    }

    public QuadEdge locate(Coordinate coordinate) {
        return this.locator.locate(new Vertex(coordinate));
    }

    public QuadEdge locate(Coordinate object, Coordinate coordinate) {
        QuadEdge quadEdge = this.locator.locate(new Vertex((Coordinate)object));
        if (quadEdge == null) {
            return null;
        }
        QuadEdge quadEdge2 = quadEdge;
        if (quadEdge.dest().getCoordinate().equals2D((Coordinate)object)) {
            quadEdge2 = quadEdge.sym();
        }
        object = quadEdge2;
        do {
            if (((QuadEdge)object).dest().getCoordinate().equals2D(coordinate)) {
                return object;
            }
            quadEdge = ((QuadEdge)object).oNext();
            object = quadEdge;
        } while (quadEdge != quadEdge2);
        return null;
    }

    public QuadEdge locate(Vertex vertex) {
        return this.locator.locate(vertex);
    }

    public QuadEdge locateFromEdge(Vertex vertex, QuadEdge quadEdge) {
        int n = this.quadEdges.size();
        int n2 = 0;
        while (++n2 <= n) {
            if (!vertex.equals(quadEdge.orig()) && !vertex.equals(quadEdge.dest())) {
                if (vertex.rightOf(quadEdge)) {
                    quadEdge = quadEdge.sym();
                    continue;
                }
                if (!vertex.rightOf(quadEdge.oNext())) {
                    quadEdge = quadEdge.oNext();
                    continue;
                }
                if (!vertex.rightOf(quadEdge.dPrev())) {
                    quadEdge = quadEdge.dPrev();
                    continue;
                }
            }
            return quadEdge;
        }
        throw new LocateFailureException(quadEdge.toLineSegment());
    }

    public QuadEdge makeEdge(Vertex object, Vertex vertex) {
        object = QuadEdge.makeEdge((Vertex)object, vertex);
        this.quadEdges.add(object);
        return object;
    }

    public void setLocator(QuadEdgeLocator quadEdgeLocator) {
        this.locator = quadEdgeLocator;
    }

    public void visitTriangles(TriangleVisitor triangleVisitor, boolean bl) {
        ++this.visitedKey;
        Stack<QuadEdge> stack = new Stack<QuadEdge>();
        stack.push(this.startingEdge);
        HashSet hashSet = new HashSet();
        while (!stack.empty()) {
            QuadEdge[] quadEdgeArray = (QuadEdge[])stack.pop();
            if (hashSet.contains(quadEdgeArray) || (quadEdgeArray = this.fetchTriangleToVisit((QuadEdge)quadEdgeArray, stack, bl, hashSet)) == null) continue;
            triangleVisitor.visit(quadEdgeArray);
        }
        return;
    }

    private static class TriangleCircumcentreVisitor
    implements TriangleVisitor {
        @Override
        public void visit(QuadEdge[] quadEdgeArray) {
            int n = 0;
            Vertex vertex = new Vertex(Triangle.circumcentre(quadEdgeArray[0].orig().getCoordinate(), quadEdgeArray[1].orig().getCoordinate(), quadEdgeArray[2].orig().getCoordinate()));
            while (n < 3) {
                quadEdgeArray[n].rot().setOrig(vertex);
                ++n;
            }
            return;
        }
    }

    private static class TriangleCoordinatesVisitor
    implements TriangleVisitor {
        private CoordinateList coordList = new CoordinateList();
        private List triCoords = new ArrayList();

        private void checkTriangleSize(Coordinate[] coordinateArray) {
            if (coordinateArray.length >= 2) {
                WKTWriter.toLineString(coordinateArray[0], coordinateArray[1]);
            } else if (coordinateArray.length >= 1) {
                WKTWriter.toPoint(coordinateArray[0]);
            }
        }

        public List getTriangles() {
            return this.triCoords;
        }

        @Override
        public void visit(QuadEdge[] objectArray) {
            this.coordList.clear();
            int n = 0;
            while (true) {
                if (n >= 3) {
                    if (this.coordList.size() > 0) {
                        this.coordList.closeRing();
                        objectArray = this.coordList.toCoordinateArray();
                        if (objectArray.length != 4) {
                            return;
                        }
                        this.triCoords.add(objectArray);
                    }
                    return;
                }
                Vertex vertex = objectArray[n].orig();
                this.coordList.add(vertex.getCoordinate());
                ++n;
            }
        }
    }

    private static class TriangleEdgesListVisitor
    implements TriangleVisitor {
        private List triList = new ArrayList();

        private TriangleEdgesListVisitor() {
        }

        public List getTriangleEdges() {
            return this.triList;
        }

        @Override
        public void visit(QuadEdge[] quadEdgeArray) {
            this.triList.add(quadEdgeArray.clone());
        }
    }

    private static class TriangleVertexListVisitor
    implements TriangleVisitor {
        private List triList = new ArrayList();

        private TriangleVertexListVisitor() {
        }

        public List getTriangleVertices() {
            return this.triList;
        }

        @Override
        public void visit(QuadEdge[] quadEdgeArray) {
            this.triList.add(new Vertex[]{quadEdgeArray[0].orig(), quadEdgeArray[1].orig(), quadEdgeArray[2].orig()});
        }
    }
}

