/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.util;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.util.Stopwatch;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;

public class Debug {
    private static final String DEBUG_LINE_TAG = "D! ";
    public static String DEBUG_PROPERTY_NAME = "jts.debug";
    public static String DEBUG_PROPERTY_VALUE_ON = "on";
    public static String DEBUG_PROPERTY_VALUE_TRUE = "true";
    private static final Debug debug;
    private static boolean debugOn = false;
    private static final GeometryFactory fact;
    private static long lastTimePrinted;
    private static Stopwatch stopwatch;
    private Object[] args = new Object[1];
    private PrintStream out = System.out;
    private Class[] printArgs;
    private Object watchObj = null;

    static {
        String string2 = System.getProperty("jts.debug");
        if (string2 != null && (string2.equalsIgnoreCase(DEBUG_PROPERTY_VALUE_ON) || string2.equalsIgnoreCase(DEBUG_PROPERTY_VALUE_TRUE))) {
            debugOn = true;
        }
        stopwatch = new Stopwatch();
        debug = new Debug();
        fact = new GeometryFactory();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Debug() {
        Class[] classArray = new Class[1];
        this.printArgs = classArray;
        try {
            classArray[0] = Class.forName("java.io.PrintStream");
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public static void addWatch(Object object) {
        debug.instanceAddWatch(object);
    }

    public static void breakIf(boolean bl) {
        if (bl) {
            Debug.doBreak();
        }
    }

    public static void breakIfEqual(Coordinate coordinate, Coordinate coordinate2, double d) {
        if (coordinate.distance(coordinate2) <= d) {
            Debug.doBreak();
        }
    }

    public static void breakIfEqual(Object object, Object object2) {
        if (object.equals(object2)) {
            Debug.doBreak();
        }
    }

    private static void doBreak() {
    }

    public static boolean equals(Coordinate coordinate, Coordinate coordinate2, double d) {
        return coordinate.distance(coordinate2) <= d;
    }

    private static String formatField(String string2, int n) {
        int n2 = n - string2.length();
        if (n2 <= 0) {
            return string2;
        }
        StringBuilder stringBuilder = new StringBuilder(String.valueOf(Debug.spaces(n2)));
        stringBuilder.append(string2);
        string2 = stringBuilder.toString();
        return string2.substring(string2.length() - n);
    }

    public static boolean hasSegment(Geometry geometry, Coordinate object, Coordinate coordinate) {
        object = new SegmentFindingFilter((Coordinate)object, coordinate);
        geometry.apply((CoordinateSequenceFilter)object);
        return ((SegmentFindingFilter)object).hasSegment();
    }

    private void instanceAddWatch(Object object) {
        this.watchObj = object;
    }

    private void instancePrint(String string2) {
        this.out.print(DEBUG_LINE_TAG);
        this.out.print(string2);
    }

    public static boolean isDebugging() {
        return debugOn;
    }

    public static void main(String[] object) {
        PrintStream printStream = System.out;
        StringBuilder stringBuilder = new StringBuilder("JTS Debugging is ");
        object = debugOn ? "ON" : "OFF";
        stringBuilder.append((String)object);
        printStream.println(stringBuilder.toString());
    }

    public static void print(Object object) {
        if (!debugOn) {
            return;
        }
        debug.instancePrint(object);
    }

    public static void print(String string2) {
        if (!debugOn) {
            return;
        }
        debug.instancePrint(string2);
    }

    public static void print(boolean bl, Object object) {
        if (!debugOn) {
            return;
        }
        if (!bl) {
            return;
        }
        debug.instancePrint(object);
    }

    public static void printIfWatch(Object object) {
        debug.instancePrintIfWatch(object);
    }

    public static void printTime(String string2) {
        if (!debugOn) {
            return;
        }
        long l = stopwatch.getTime();
        long l2 = lastTimePrinted;
        Debug debug = Debug.debug;
        StringBuilder stringBuilder = new StringBuilder(String.valueOf(Debug.formatField(Stopwatch.getTimeString(l), 10)));
        stringBuilder.append(" (");
        stringBuilder.append(Debug.formatField(Stopwatch.getTimeString(l - l2), 10));
        stringBuilder.append(" ) ");
        stringBuilder.append(string2);
        debug.instancePrint(stringBuilder.toString());
        debug.println();
        lastTimePrinted = l;
    }

    public static void printWatch() {
        debug.instancePrintWatch();
    }

    public static void println(Object object) {
        if (!debugOn) {
            return;
        }
        Debug debug = Debug.debug;
        debug.instancePrint(object);
        debug.println();
    }

    public static void resetTime() {
        stopwatch.reset();
        lastTimePrinted = stopwatch.getTime();
    }

    private static String spaces(int n) {
        char[] cArray = new char[n];
        int n2 = 0;
        while (n2 < n) {
            cArray[n2] = (char)32;
            ++n2;
        }
        return new String(cArray);
    }

    public static LineString toLine(Coordinate coordinate, Coordinate coordinate2) {
        return fact.createLineString(new Coordinate[]{coordinate, coordinate2});
    }

    public static LineString toLine(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        return fact.createLineString(new Coordinate[]{coordinate, coordinate2, coordinate3});
    }

    public static LineString toLine(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3, Coordinate coordinate4) {
        return fact.createLineString(new Coordinate[]{coordinate, coordinate2, coordinate3, coordinate4});
    }

    public void instancePrint(Object object) {
        if (object instanceof Collection) {
            this.instancePrint(((Collection)object).iterator());
        } else if (object instanceof Iterator) {
            this.instancePrint((Iterator)object);
        } else {
            this.instancePrintObject(object);
        }
    }

    public void instancePrint(Iterator iterator2) {
        while (iterator2.hasNext()) {
            this.instancePrintObject(iterator2.next());
        }
        return;
    }

    public void instancePrintIfWatch(Object object) {
        Object object2 = this.watchObj;
        if (object != object2) {
            return;
        }
        if (object2 == null) {
            return;
        }
        this.instancePrint(object2);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void instancePrintObject(Object object) {
        PrintStream printStream;
        Method method;
        try {
            Object[] objectArray = object.getClass();
            try {
                method = objectArray.getMethod("print", this.printArgs);
                objectArray = this.args;
                printStream = this.out;
                objectArray[0] = printStream;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.instancePrint(object.toString());
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(this.out);
            return;
        }
        {
            printStream.print(DEBUG_LINE_TAG);
            method.invoke(object, this.args);
            return;
        }
    }

    public void instancePrintWatch() {
        Object object = this.watchObj;
        if (object == null) {
            return;
        }
        this.instancePrint(object);
    }

    public void println() {
        this.out.println();
    }

    private static class SegmentFindingFilter
    implements CoordinateSequenceFilter {
        private boolean hasSegment = false;
        private Coordinate p0;
        private Coordinate p1;

        public SegmentFindingFilter(Coordinate coordinate, Coordinate coordinate2) {
            this.p0 = coordinate;
            this.p1 = coordinate2;
        }

        @Override
        public void filter(CoordinateSequence coordinateSequence, int n) {
            if (n == 0) {
                return;
            }
            boolean bl = this.p0.equals2D(coordinateSequence.getCoordinate(n - 1)) && this.p1.equals2D(coordinateSequence.getCoordinate(n));
            this.hasSegment = bl;
        }

        public boolean hasSegment() {
            return this.hasSegment;
        }

        @Override
        public boolean isDone() {
            return this.hasSegment;
        }

        @Override
        public boolean isGeometryChanged() {
            return false;
        }
    }
}

