/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.util;

public class Stopwatch {
    private boolean isRunning = false;
    private long startTimestamp;
    private long totalTime = 0L;

    public Stopwatch() {
        this.start();
    }

    public static String getTimeString(long l) {
        CharSequence charSequence;
        if (l < 10000L) {
            charSequence = new StringBuilder(String.valueOf(l));
            ((StringBuilder)charSequence).append(" ms");
            charSequence = ((StringBuilder)charSequence).toString();
        } else {
            charSequence = new StringBuilder(String.valueOf((double)l / 1000.0));
            ((StringBuilder)charSequence).append(" s");
            charSequence = ((StringBuilder)charSequence).toString();
        }
        return charSequence;
    }

    private void updateTotalTime() {
        long l = System.currentTimeMillis();
        long l2 = this.startTimestamp;
        this.startTimestamp = l;
        this.totalTime += l - l2;
    }

    public long getTime() {
        this.updateTotalTime();
        return this.totalTime;
    }

    public String getTimeString() {
        return Stopwatch.getTimeString(this.getTime());
    }

    public void reset() {
        this.totalTime = 0L;
        this.startTimestamp = System.currentTimeMillis();
    }

    public long split() {
        if (this.isRunning) {
            this.updateTotalTime();
        }
        return this.totalTime;
    }

    public void start() {
        if (this.isRunning) {
            return;
        }
        this.startTimestamp = System.currentTimeMillis();
        this.isRunning = true;
    }

    public long stop() {
        if (this.isRunning) {
            this.updateTotalTime();
            this.isRunning = false;
        }
        return this.totalTime;
    }
}

