/*
 * Decompiled with CFR 0.152.
 */
package com.welie.blessed;

import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Objects;

public class BluetoothBytesParser {
    public static final int FORMAT_FLOAT = 52;
    public static final int FORMAT_SFLOAT = 50;
    public static final int FORMAT_SINT16 = 34;
    public static final int FORMAT_SINT24 = 35;
    public static final int FORMAT_SINT32 = 36;
    public static final int FORMAT_SINT8 = 33;
    public static final int FORMAT_UINT16 = 18;
    public static final int FORMAT_UINT24 = 19;
    public static final int FORMAT_UINT32 = 20;
    public static final int FORMAT_UINT8 = 17;
    private static final String INVALID_OFFSET = "invalid offset";
    private static final String OFFSET_MUST_BE_GREATER_OR_EQUAL_TO_ZERO = "offset must be greater or equal to zero";
    private static final String UNSUPPORTED_FORMAT_TYPE = "unsupported format type";
    private final ByteOrder internalByteOrder;
    private int internalOffset;
    private byte[] mValue;

    public BluetoothBytesParser() {
        ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
        this(new byte[0], byteOrder);
    }

    public BluetoothBytesParser(ByteOrder byteOrder) {
        this(new byte[0], byteOrder);
    }

    public BluetoothBytesParser(byte[] byArray) {
        this(byArray, 0, ByteOrder.LITTLE_ENDIAN);
    }

    public BluetoothBytesParser(byte[] byArray, int n) {
        this(byArray, n, ByteOrder.LITTLE_ENDIAN);
    }

    public BluetoothBytesParser(byte[] byArray, int n, ByteOrder byteOrder) {
        if (n >= 0) {
            Objects.requireNonNull(byteOrder);
            if (byteOrder != ByteOrder.LITTLE_ENDIAN && byteOrder != ByteOrder.BIG_ENDIAN) {
                throw new IllegalArgumentException("unsupported ByteOrder value");
            }
            Objects.requireNonNull(byArray);
            this.mValue = byArray;
            this.internalOffset = n;
            this.internalByteOrder = byteOrder;
            return;
        }
        throw new IllegalArgumentException(OFFSET_MUST_BE_GREATER_OR_EQUAL_TO_ZERO);
    }

    public BluetoothBytesParser(byte[] byArray, ByteOrder byteOrder) {
        this(byArray, 0, byteOrder);
    }

    public static String bytes2String(byte[] byArray) {
        if (byArray == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(String.format("%02x", byArray[i] & 0xFF));
        }
        return stringBuilder.toString();
    }

    private float bytesToFloat(byte by, byte by2) {
        int n = this.unsignedToSigned(this.unsignedByteToInt(by) + ((this.unsignedByteToInt(by2) & 0xF) << 8), 12);
        int n2 = this.unsignedToSigned(this.unsignedByteToInt(by2) >> 4, 4);
        return (float)((double)n * Math.pow(10.0, n2));
    }

    private float bytesToFloat(byte by, byte by2, byte by3, byte by4) {
        return (float)((double)this.unsignedToSigned(this.unsignedByteToInt(by) + (this.unsignedByteToInt(by2) << 8) + (this.unsignedByteToInt(by3) << 16), 24) * Math.pow(10.0, by4));
    }

    private int getTypeLen(int n) {
        return n & 0xF;
    }

    private int intToSignedBits(int n, int n2) {
        if (n < 0) {
            n2 = 1 << n2 - 1;
            return n2 + (n & n2 - 1);
        }
        return n;
    }

    public static byte[] mergeArrays(byte[] ... byArray) {
        int n;
        int n2 = byArray.length;
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            n3 += byArray[n].length;
        }
        byte[] byArray2 = new byte[n3];
        n2 = byArray.length;
        n = 0;
        for (n3 = 0; n3 < n2; ++n3) {
            byte[] byArray3 = byArray[n3];
            System.arraycopy(byArray3, 0, byArray2, n, byArray3.length);
            n += byArray3.length;
        }
        return byArray2;
    }

    private void prepareArray(int n) {
        byte[] byArray;
        if (this.mValue == null) {
            this.mValue = new byte[n];
        }
        if (n > (byArray = this.mValue).length) {
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            this.mValue = byArray2;
        }
    }

    public static byte[] string2bytes(String string2) {
        if (string2 == null) {
            return new byte[0];
        }
        int n = string2.length() / 2;
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            int n2 = i * 2;
            byArray[i] = (byte)Integer.parseInt(string2.substring(n2, n2 + 2), 16);
        }
        return byArray;
    }

    private int unsignedByteToInt(byte by) {
        return by & 0xFF;
    }

    private int unsignedBytesToInt(byte by, byte by2) {
        return this.unsignedByteToInt(by) + (this.unsignedByteToInt(by2) << 8);
    }

    private int unsignedBytesToInt(byte by, byte by2, byte by3, byte by4) {
        return this.unsignedByteToInt(by) + (this.unsignedByteToInt(by2) << 8) + (this.unsignedByteToInt(by3) << 16) + (this.unsignedByteToInt(by4) << 24);
    }

    private int unsignedToSigned(int n, int n2) {
        if ((n & (n2 = 1 << n2 - 1)) != 0) {
            return (n2 - (n & n2 - 1)) * -1;
        }
        return n;
    }

    public byte[] getByteArray(int n) {
        byte[] byArray = this.mValue;
        int n2 = this.internalOffset;
        byArray = Arrays.copyOfRange(byArray, n2, n2 + n);
        this.internalOffset += n;
        return byArray;
    }

    public ByteOrder getByteOrder() {
        return this.internalByteOrder;
    }

    public Date getDateTime() {
        Date date = this.getDateTime(this.internalOffset);
        this.internalOffset += 7;
        return date;
    }

    public Date getDateTime(int n) {
        if (n >= 0) {
            if (n + 7 <= this.mValue.length) {
                int n2 = this.getIntValue(18, n, ByteOrder.LITTLE_ENDIAN);
                int n3 = n + this.getTypeLen(18);
                n = this.getIntValue(17, n3, ByteOrder.LITTLE_ENDIAN);
                int n4 = n3 + this.getTypeLen(17);
                n3 = this.getIntValue(17, n4, ByteOrder.LITTLE_ENDIAN);
                int n5 = n4 + this.getTypeLen(17);
                n4 = this.getIntValue(17, n5, ByteOrder.LITTLE_ENDIAN);
                return new GregorianCalendar(n2, n - 1, n3, n4, this.getIntValue(17, n5 += this.getTypeLen(17), ByteOrder.LITTLE_ENDIAN), this.getIntValue(17, n5 + this.getTypeLen(17), ByteOrder.LITTLE_ENDIAN)).getTime();
            }
            throw new IllegalArgumentException(INVALID_OFFSET);
        }
        throw new IllegalArgumentException(OFFSET_MUST_BE_GREATER_OR_EQUAL_TO_ZERO);
    }

    public Float getFloatValue(int n) {
        Float f = this.getFloatValue(n, this.internalOffset, this.internalByteOrder);
        this.internalOffset += this.getTypeLen(n);
        return f;
    }

    public Float getFloatValue(int n, int n2, ByteOrder object) {
        Objects.requireNonNull(object);
        if (n2 >= 0) {
            if (this.getTypeLen(n) + n2 <= this.mValue.length) {
                if (n != 50) {
                    if (n == 52) {
                        if (object == ByteOrder.LITTLE_ENDIAN) {
                            object = this.mValue;
                            return Float.valueOf(this.bytesToFloat((byte)object[n2], (byte)object[n2 + 1], (byte)object[n2 + 2], (byte)object[n2 + 3]));
                        }
                        object = this.mValue;
                        return Float.valueOf(this.bytesToFloat((byte)object[n2 + 3], (byte)object[n2 + 2], (byte)object[n2 + 1], (byte)object[n2]));
                    }
                    throw new IllegalArgumentException(UNSUPPORTED_FORMAT_TYPE);
                }
                if (object == ByteOrder.LITTLE_ENDIAN) {
                    object = this.mValue;
                    return Float.valueOf(this.bytesToFloat((byte)object[n2], (byte)object[n2 + 1]));
                }
                object = this.mValue;
                return Float.valueOf(this.bytesToFloat((byte)object[n2 + 1], (byte)object[n2]));
            }
            throw new IllegalArgumentException(INVALID_OFFSET);
        }
        throw new IllegalArgumentException(OFFSET_MUST_BE_GREATER_OR_EQUAL_TO_ZERO);
    }

    public Float getFloatValue(int n, ByteOrder object) {
        Objects.requireNonNull(object);
        object = this.getFloatValue(n, this.internalOffset, (ByteOrder)object);
        this.internalOffset += this.getTypeLen(n);
        return object;
    }

    public Integer getIntValue(int n) {
        Integer n2 = this.getIntValue(n, this.internalOffset, this.internalByteOrder);
        this.internalOffset += this.getTypeLen(n);
        return n2;
    }

    public Integer getIntValue(int n, int n2, ByteOrder object) {
        Objects.requireNonNull(object);
        if (n2 >= 0) {
            byte[] byArray;
            int n3 = this.getTypeLen(n);
            if (n3 + n2 <= (byArray = this.mValue).length) {
                switch (n) {
                    default: {
                        switch (n) {
                            default: {
                                throw new IllegalArgumentException(UNSUPPORTED_FORMAT_TYPE);
                            }
                            case 36: {
                                if (object == ByteOrder.LITTLE_ENDIAN) {
                                    object = this.mValue;
                                    return this.unsignedToSigned(this.unsignedBytesToInt((byte)object[n2], (byte)object[n2 + 1], (byte)object[n2 + 2], (byte)object[n2 + 3]), 32);
                                }
                                object = this.mValue;
                                return this.unsignedToSigned(this.unsignedBytesToInt((byte)object[n2 + 3], (byte)object[n2 + 2], (byte)object[n2 + 1], (byte)object[n2]), 32);
                            }
                            case 35: {
                                if (object == ByteOrder.LITTLE_ENDIAN) {
                                    object = this.mValue;
                                    return this.unsignedToSigned(this.unsignedBytesToInt((byte)object[n2], (byte)object[n2 + 1], (byte)object[n2 + 2], (byte)0), 24);
                                }
                                object = this.mValue;
                                return this.unsignedToSigned(this.unsignedBytesToInt((byte)object[n2 + 2], (byte)object[n2 + 1], (byte)object[n2], (byte)0), 24);
                            }
                            case 34: {
                                if (object == ByteOrder.LITTLE_ENDIAN) {
                                    object = this.mValue;
                                    return this.unsignedToSigned(this.unsignedBytesToInt((byte)object[n2], (byte)object[n2 + 1]), 16);
                                }
                                object = this.mValue;
                                return this.unsignedToSigned(this.unsignedBytesToInt((byte)object[n2 + 1], (byte)object[n2]), 16);
                            }
                            case 33: 
                        }
                        return this.unsignedToSigned(this.unsignedByteToInt(byArray[n2]), 8);
                    }
                    case 20: {
                        if (object == ByteOrder.LITTLE_ENDIAN) {
                            object = this.mValue;
                            return this.unsignedBytesToInt((byte)object[n2], (byte)object[n2 + 1], (byte)object[n2 + 2], (byte)object[n2 + 3]);
                        }
                        object = this.mValue;
                        return this.unsignedBytesToInt((byte)object[n2 + 3], (byte)object[n2 + 2], (byte)object[n2 + 1], (byte)object[n2]);
                    }
                    case 19: {
                        if (object == ByteOrder.LITTLE_ENDIAN) {
                            object = this.mValue;
                            return this.unsignedBytesToInt((byte)object[n2], (byte)object[n2 + 1], (byte)object[n2 + 2], (byte)0);
                        }
                        object = this.mValue;
                        return this.unsignedBytesToInt((byte)object[n2 + 2], (byte)object[n2 + 1], (byte)object[n2], (byte)0);
                    }
                    case 18: {
                        if (object == ByteOrder.LITTLE_ENDIAN) {
                            object = this.mValue;
                            return this.unsignedBytesToInt((byte)object[n2], (byte)object[n2 + 1]);
                        }
                        object = this.mValue;
                        return this.unsignedBytesToInt((byte)object[n2 + 1], (byte)object[n2]);
                    }
                    case 17: 
                }
                return this.unsignedByteToInt(byArray[n2]);
            }
            throw new IllegalArgumentException(INVALID_OFFSET);
        }
        throw new IllegalArgumentException(OFFSET_MUST_BE_GREATER_OR_EQUAL_TO_ZERO);
    }

    public Integer getIntValue(int n, ByteOrder object) {
        Objects.requireNonNull(object);
        object = this.getIntValue(n, this.internalOffset, (ByteOrder)object);
        this.internalOffset += this.getTypeLen(n);
        return object;
    }

    public Long getLongValue() {
        return this.getLongValue(this.internalByteOrder);
    }

    public Long getLongValue(int n, ByteOrder byteOrder) {
        Objects.requireNonNull(byteOrder);
        if (n >= 0) {
            if (n + 8 <= this.mValue.length) {
                if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                    long l = this.mValue[n + 7] & 0xFF;
                    for (int i = 6; i >= 0; --i) {
                        l = (l << 8) + (long)(this.mValue[i + n] & 0xFF);
                    }
                    return l;
                }
                if (byteOrder == ByteOrder.BIG_ENDIAN) {
                    long l = this.mValue[n] & 0xFF;
                    for (int i = 1; i < 8; ++i) {
                        l = (l << 8) + (long)(this.mValue[i + n] & 0xFF);
                    }
                    return l;
                }
                throw new IllegalArgumentException("invalid byte order");
            }
            throw new IllegalArgumentException(INVALID_OFFSET);
        }
        throw new IllegalArgumentException(OFFSET_MUST_BE_GREATER_OR_EQUAL_TO_ZERO);
    }

    public Long getLongValue(ByteOrder byteOrder) {
        Objects.requireNonNull(byteOrder);
        long l = this.getLongValue(this.internalOffset, byteOrder);
        this.internalOffset += 8;
        return l;
    }

    public int getOffset() {
        return this.internalOffset;
    }

    public String getStringValue() {
        return this.getStringValue(this.internalOffset);
    }

    public String getStringValue(int n) {
        if (n >= 0) {
            byte[] byArray = this.mValue;
            if (byArray != null && n <= byArray.length) {
                int n2;
                int n3 = byArray.length - n;
                byArray = new byte[n3];
                int n4 = 0;
                while (true) {
                    byte[] byArray2 = this.mValue;
                    if (n4 == byArray2.length - n) break;
                    byArray[n4] = byArray2[n + n4];
                    ++n4;
                }
                for (n2 = n3; n2 > 0 && (byArray[n = n2 - 1] == 0 || byArray[n] == 32); --n2) {
                }
                return new String(byArray, 0, n2, StandardCharsets.ISO_8859_1);
            }
            throw new IllegalArgumentException(INVALID_OFFSET);
        }
        throw new IllegalArgumentException(OFFSET_MUST_BE_GREATER_OR_EQUAL_TO_ZERO);
    }

    public byte[] getValue() {
        return this.mValue;
    }

    public void setByteArray(byte[] byArray) {
        this.setByteArray(byArray, this.internalOffset);
        this.internalOffset += byArray.length;
    }

    public void setByteArray(byte[] byArray, int n) {
        this.prepareArray(byArray.length + n);
        System.arraycopy(byArray, 0, this.getValue(), n, byArray.length);
    }

    public void setCurrentTime(Calendar calendar) {
        Objects.requireNonNull(calendar);
        byte[] byArray = new byte[10];
        this.mValue = byArray;
        byArray[0] = (byte)calendar.get(1);
        this.mValue[1] = (byte)(calendar.get(1) >> 8);
        this.mValue[2] = (byte)(calendar.get(2) + 1);
        this.mValue[3] = (byte)calendar.get(5);
        this.mValue[4] = (byte)calendar.get(11);
        this.mValue[5] = (byte)calendar.get(12);
        this.mValue[6] = (byte)calendar.get(13);
        this.mValue[7] = (byte)((calendar.get(7) + 5) % 7 + 1);
        this.mValue[8] = (byte)(calendar.get(14) * 256 / 1000);
        this.mValue[9] = (byte)1;
    }

    public void setDateTime(Calendar calendar) {
        Objects.requireNonNull(calendar);
        byte[] byArray = new byte[7];
        this.mValue = byArray;
        byArray[0] = (byte)calendar.get(1);
        this.mValue[1] = (byte)(calendar.get(1) >> 8);
        this.mValue[2] = (byte)(calendar.get(2) + 1);
        this.mValue[3] = (byte)calendar.get(5);
        this.mValue[4] = (byte)calendar.get(11);
        this.mValue[5] = (byte)calendar.get(12);
        this.mValue[6] = (byte)calendar.get(13);
    }

    public void setFloatValue(float f, int n) {
        this.setFloatValue((int)((double)f * Math.pow(10.0, n)), -n, 52, this.internalOffset);
        this.internalOffset += this.getTypeLen(52);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setFloatValue(int n, int n2, int n3, int n4) {
        if (n4 < 0) throw new IllegalArgumentException(OFFSET_MUST_BE_GREATER_OR_EQUAL_TO_ZERO);
        this.prepareArray(this.getTypeLen(n3) + n4);
        if (n3 != 50) {
            if (n3 != 52) throw new IllegalArgumentException(UNSUPPORTED_FORMAT_TYPE);
            n = this.intToSignedBits(n, 24);
            n2 = this.intToSignedBits(n2, 8);
            if (this.internalByteOrder == ByteOrder.LITTLE_ENDIAN) {
                byte[] byArray = this.mValue;
                n3 = n4 + 1;
                byArray[n4] = (byte)(n & 0xFF);
                n4 = n3 + 1;
                byArray[n3] = (byte)(n >> 8 & 0xFF);
                n3 = n4 + 1;
                byArray[n4] = (byte)(n >> 16 & 0xFF);
                byArray[n3] = (byte)(byArray[n3] + (byte)(n2 & 0xFF));
                return;
            } else {
                byte[] byArray = this.mValue;
                n3 = n4 + 1;
                byArray[n4] = (byte)(byArray[n4] + (byte)(n2 & 0xFF));
                n2 = n3 + 1;
                byArray[n3] = (byte)(n >> 16 & 0xFF);
                byArray[n2] = (byte)(n >> 8 & 0xFF);
                byArray[n2 + 1] = (byte)(n & 0xFF);
            }
            return;
        } else {
            n3 = this.intToSignedBits(n, 12);
            n2 = this.intToSignedBits(n2, 4);
            if (this.internalByteOrder == ByteOrder.LITTLE_ENDIAN) {
                byte[] byArray = this.mValue;
                n = n4 + 1;
                byArray[n4] = (byte)(n3 & 0xFF);
                byArray[n] = (byte)(n3 >> 8 & 0xF);
                byArray[n] = (byte)(byArray[n] + (byte)((n2 & 0xF) << 4));
                return;
            } else {
                byte[] byArray = this.mValue;
                byArray[n4] = (byte)(n3 >> 8 & 0xF);
                byArray[n4] = (byte)(byArray[n4] + (byte)((n2 & 0xF) << 4));
                byArray[n4 + 1] = (byte)(n & 0xFF);
            }
        }
    }

    public void setIntValue(int n, int n2) {
        this.setIntValue(n, n2, this.internalOffset);
        this.internalOffset += this.getTypeLen(n2);
    }

    /*
     * Handled duff style switch with additional control
     * Enabled aggressive block sorting
     */
    public void setIntValue(int n, int n2, int n3) {
        if (n3 < 0) throw new IllegalArgumentException(OFFSET_MUST_BE_GREATER_OR_EQUAL_TO_ZERO);
        this.prepareArray(this.getTypeLen(n2) + n3);
        int n4 = n;
        int n5 = n;
        int n6 = n;
        int n7 = n;
        int n8 = 0;
        block12: do {
            block0 : switch (n8 == 0 ? n2 : n8) {
                default: {
                    switch (n2) {
                        default: {
                            throw new IllegalArgumentException(UNSUPPORTED_FORMAT_TYPE);
                        }
                        case 36: {
                            n4 = this.intToSignedBits(n, 32);
                            break;
                        }
                        case 35: {
                            n5 = this.intToSignedBits(n, 24);
                            n8 = 19;
                            continue block12;
                        }
                        case 34: {
                            n6 = this.intToSignedBits(n, 16);
                            n8 = 18;
                            continue block12;
                        }
                        case 33: {
                            n7 = this.intToSignedBits(n, 8);
                            break block0;
                        }
                    }
                }
                case 20: {
                    if (this.internalByteOrder == ByteOrder.LITTLE_ENDIAN) {
                        byte[] byArray = this.mValue;
                        n = n3 + 1;
                        byArray[n3] = (byte)(n4 & 0xFF);
                        n2 = n + 1;
                        byArray[n] = (byte)(n4 >> 8 & 0xFF);
                        byArray[n2] = (byte)(n4 >> 16 & 0xFF);
                        byArray[n2 + 1] = (byte)(n4 >> 24 & 0xFF);
                        return;
                    }
                    byte[] byArray = this.mValue;
                    n = n3 + 1;
                    byArray[n3] = (byte)(n4 >> 24 & 0xFF);
                    n2 = n + 1;
                    byArray[n] = (byte)(n4 >> 16 & 0xFF);
                    byArray[n2] = (byte)(n4 >> 8 & 0xFF);
                    byArray[n2 + 1] = (byte)(n4 & 0xFF);
                    return;
                }
                case 19: {
                    if (this.internalByteOrder == ByteOrder.LITTLE_ENDIAN) {
                        byte[] byArray = this.mValue;
                        n = n3 + 1;
                        byArray[n3] = (byte)(n5 & 0xFF);
                        byArray[n] = (byte)(n5 >> 8 & 0xFF);
                        byArray[n + 1] = (byte)(n5 >> 16 & 0xFF);
                        return;
                    }
                    byte[] byArray = this.mValue;
                    n = n3 + 1;
                    byArray[n3] = (byte)(n5 >> 16 & 0xFF);
                    byArray[n] = (byte)(n5 >> 8 & 0xFF);
                    byArray[n + 1] = (byte)(n5 & 0xFF);
                    return;
                }
                case 18: {
                    if (this.internalByteOrder == ByteOrder.LITTLE_ENDIAN) {
                        byte[] byArray = this.mValue;
                        byArray[n3] = (byte)(n6 & 0xFF);
                        byArray[n3 + 1] = (byte)(n6 >> 8 & 0xFF);
                        return;
                    }
                    byte[] byArray = this.mValue;
                    byArray[n3] = (byte)(n6 >> 8 & 0xFF);
                    byArray[n3 + 1] = (byte)(n6 & 0xFF);
                    return;
                }
                case 17: 
            }
            break;
        } while (true);
        this.mValue[n3] = (byte)(n7 & 0xFF);
    }

    public void setLong(long l) {
        this.setLong(l, this.internalOffset);
        this.internalOffset += 8;
    }

    public void setLong(long l, int n) {
        if (n >= 0) {
            this.prepareArray(n + 8);
            if (this.internalByteOrder == ByteOrder.BIG_ENDIAN) {
                for (int i = 7; i >= 0; --i) {
                    this.mValue[i + n] = (byte)(l & 0xFFL);
                    l >>= 8;
                }
            } else {
                for (int i = 0; i < 8; ++i) {
                    this.mValue[i + n] = (byte)(l & 0xFFL);
                    l >>= 8;
                }
            }
            return;
        }
        throw new IllegalArgumentException(OFFSET_MUST_BE_GREATER_OR_EQUAL_TO_ZERO);
    }

    public void setOffset(int n) {
        if (n >= 0) {
            this.internalOffset = n;
            return;
        }
        throw new IllegalArgumentException(OFFSET_MUST_BE_GREATER_OR_EQUAL_TO_ZERO);
    }

    public void setString(String string2) {
        Objects.requireNonNull(string2);
        this.setString(string2, this.internalOffset);
        this.internalOffset += string2.getBytes().length;
    }

    public void setString(String string2, int n) {
        Objects.requireNonNull(string2);
        this.setByteArray(string2.getBytes(), n);
    }

    public void setValue(byte[] byArray) {
        Objects.requireNonNull(byArray);
        this.mValue = byArray;
    }

    public String toString() {
        return BluetoothBytesParser.bytes2String(this.mValue);
    }
}

