/*
 * Decompiled with CFR 0.152.
 */
package com.welie.blessed;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.util.Log;
import com.welie.blessed.BluetoothBytesParser;
import com.welie.blessed.BluetoothPeripheralCallback;
import com.welie.blessed.BondState;
import com.welie.blessed.ConnectionPriority;
import com.welie.blessed.ConnectionState;
import com.welie.blessed.GattStatus;
import com.welie.blessed.HciStatus;
import com.welie.blessed.Logger;
import com.welie.blessed.PeripheralType;
import com.welie.blessed.PhyOptions;
import com.welie.blessed.PhyType;
import com.welie.blessed.Transport;
import com.welie.blessed.WriteType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;

public class BluetoothPeripheral {
    private static final long AVG_REQUEST_CONNECTION_PRIORITY_DURATION = 500L;
    private static final UUID CCC_DESCRIPTOR_UUID = UUID.fromString("00002902-0000-1000-8000-00805f9b34fb");
    private static final int CONNECTION_TIMEOUT_IN_MS = 35000;
    private static final int DEFAULT_MTU = 23;
    private static final long DELAY_AFTER_BOND_LOST = 1000L;
    private static final int DIRECT_CONNECTION_DELAY_IN_MS = 100;
    private static final int IDLE = 0;
    public static final int MAX_MTU = 517;
    private static final int MAX_TRIES = 2;
    private static final String NO_VALID_CHARACTERISTIC_PROVIDED = "no valid characteristic provided";
    private static final String NO_VALID_CHARACTERISTIC_UUID_PROVIDED = "no valid characteristic UUID provided";
    private static final String NO_VALID_DESCRIPTOR_PROVIDED = "no valid descriptor provided";
    private static final String NO_VALID_DEVICE_PROVIDED = "no valid device provided";
    private static final String NO_VALID_PERIPHERAL_CALLBACK_PROVIDED = "no valid peripheral callback provided";
    private static final String NO_VALID_PRIORITY_PROVIDED = "no valid priority provided";
    private static final String NO_VALID_SERVICE_UUID_PROVIDED = "no valid service UUID provided";
    private static final String NO_VALID_VALUE_PROVIDED = "no valid value provided";
    private static final String NO_VALID_WRITE_TYPE_PROVIDED = "no valid writeType provided";
    private static final int PAIRING_VARIANT_CONSENT = 3;
    private static final int PAIRING_VARIANT_DISPLAY_PASSKEY = 4;
    private static final int PAIRING_VARIANT_DISPLAY_PIN = 5;
    private static final int PAIRING_VARIANT_OOB_CONSENT = 6;
    private static final int PAIRING_VARIANT_PASSKEY = 1;
    private static final int PAIRING_VARIANT_PASSKEY_CONFIRMATION = 2;
    private static final int PAIRING_VARIANT_PIN = 0;
    private static final String PERIPHERAL_NOT_CONNECTED = "peripheral not connected";
    private static final int REQUEST_MTU_COMMAND = 1;
    private static final int SET_PHY_TYPE_COMMAND = 2;
    private static final String TAG = "BluetoothPeripheral";
    private static final int TIMEOUT_THRESHOLD_DEFAULT = 25000;
    private static final int TIMEOUT_THRESHOLD_SAMSUNG = 4500;
    private static final String VALUE_BYTE_ARRAY_IS_EMPTY = "value byte array is empty";
    private static final String VALUE_BYTE_ARRAY_IS_TOO_LONG = "value byte array is too long";
    private volatile BluetoothGatt bluetoothGatt;
    private final BluetoothGattCallback bluetoothGattCallback;
    private boolean bondLost = false;
    private final BroadcastReceiver bondStateReceiver;
    private String cachedName = "";
    private final Handler callbackHandler;
    private final Queue<Runnable> commandQueue = new ConcurrentLinkedQueue<Runnable>();
    private volatile boolean commandQueueBusy = false;
    private long connectTimestamp;
    private final Context context;
    private int currentCommand = 0;
    private int currentMtu = 23;
    private byte[] currentWriteBytes = new byte[0];
    private BluetoothDevice device;
    private Runnable discoverServicesRunnable;
    private boolean discoveryStarted = false;
    private boolean isRetrying;
    private final InternalCallback listener;
    private final Handler mainHandler;
    private boolean manuallyBonding = false;
    private final Set<BluetoothGattCharacteristic> notifyingCharacteristics = new HashSet<BluetoothGattCharacteristic>();
    private int nrTries;
    private final BroadcastReceiver pairingRequestBroadcastReceiver;
    protected BluetoothPeripheralCallback peripheralCallback;
    private volatile boolean peripheralInitiatedBonding = false;
    private volatile int state = 0;
    private Runnable timeoutRunnable;
    private final Transport transport;

    BluetoothPeripheral(Context object, BluetoothDevice bluetoothDevice, InternalCallback internalCallback, BluetoothPeripheralCallback bluetoothPeripheralCallback, Handler handler, Transport transport) {
        this.mainHandler = new Handler(Looper.getMainLooper());
        this.bluetoothGattCallback = new BluetoothGattCallback(){

            private boolean failureThatShouldTriggerBonding(GattStatus gattStatus) {
                if ((gattStatus == GattStatus.AUTHORIZATION_FAILED || gattStatus == GattStatus.INSUFFICIENT_AUTHENTICATION || gattStatus == GattStatus.INSUFFICIENT_ENCRYPTION) && Build.VERSION.SDK_INT < 26) {
                    Logger.i(TAG, "operation will be retried after bonding, bonding should be in progress");
                    return true;
                }
                return false;
            }

            public int getUnsignedByte(byte by) {
                return by & 0xFF;
            }

            public void onCharacteristicChanged(BluetoothGatt object, BluetoothGattCharacteristic bluetoothGattCharacteristic) {
                CharSequence charSequence;
                byte[] byArray = BluetoothPeripheral.this.nonnullOf(bluetoothGattCharacteristic.getValue());
                int n = byArray.length;
                object = "";
                for (int i = 0; i < n; ++i) {
                    byte by = byArray[i];
                    charSequence = new StringBuilder();
                    ((StringBuilder)charSequence).append((String)object);
                    ((StringBuilder)charSequence).append(this.getUnsignedByte(by));
                    ((StringBuilder)charSequence).append(", ");
                    object = ((StringBuilder)charSequence).toString();
                }
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append(" (\u539f\u59cb) -> ");
                ((StringBuilder)charSequence).append((String)object);
                charSequence = ((StringBuilder)charSequence).toString();
                String string2 = TAG;
                object = new StringBuilder();
                ((StringBuilder)object).append("onCharacteristicChanged1 data.length = ");
                ((StringBuilder)object).append(byArray.length);
                ((StringBuilder)object).append(", ");
                ((StringBuilder)object).append((String)charSequence);
                Log.d((String)string2, (String)((StringBuilder)object).toString());
                BluetoothPeripheral.this.peripheralCallback.onCharacteristicUpdate(BluetoothPeripheral.this, byArray, bluetoothGattCharacteristic, GattStatus.SUCCESS);
            }

            public void onCharacteristicRead(BluetoothGatt object, BluetoothGattCharacteristic bluetoothGattCharacteristic, int n) {
                GattStatus gattStatus = GattStatus.fromValue(n);
                if (gattStatus != GattStatus.SUCCESS) {
                    Logger.e(TAG, "read failed for characteristic <%s>, status '%s'", new Object[]{bluetoothGattCharacteristic.getUuid(), gattStatus});
                    if (this.failureThatShouldTriggerBonding(gattStatus)) {
                        return;
                    }
                }
                object = BluetoothPeripheral.this.nonnullOf(bluetoothGattCharacteristic.getValue());
                BluetoothPeripheral.this.callbackHandler.post(new Runnable((byte[])object, bluetoothGattCharacteristic, gattStatus){
                    final /* synthetic */ BluetoothGattCharacteristic val$characteristic;
                    final /* synthetic */ GattStatus val$gattStatus;
                    final /* synthetic */ byte[] val$value;
                    {
                        this.val$value = byArray;
                        this.val$characteristic = bluetoothGattCharacteristic;
                        this.val$gattStatus = gattStatus;
                    }

                    @Override
                    public void run() {
                        BluetoothPeripheral.this.peripheralCallback.onCharacteristicUpdate(BluetoothPeripheral.this, this.val$value, this.val$characteristic, this.val$gattStatus);
                    }
                });
                BluetoothPeripheral.this.completedCommand();
            }

            public void onCharacteristicWrite(BluetoothGatt object, BluetoothGattCharacteristic bluetoothGattCharacteristic, int n) {
                GattStatus gattStatus = GattStatus.fromValue(n);
                if (gattStatus != GattStatus.SUCCESS) {
                    Logger.e(TAG, "writing <%s> to characteristic <%s> failed, status '%s'", new Object[]{BluetoothBytesParser.bytes2String(BluetoothPeripheral.this.currentWriteBytes), bluetoothGattCharacteristic.getUuid(), gattStatus});
                    if (this.failureThatShouldTriggerBonding(gattStatus)) {
                        return;
                    }
                }
                object = BluetoothPeripheral.this.currentWriteBytes;
                BluetoothPeripheral.access$902(BluetoothPeripheral.this, new byte[0]);
                BluetoothPeripheral.this.peripheralCallback.onCharacteristicWrite(BluetoothPeripheral.this, (byte[])object, bluetoothGattCharacteristic, gattStatus);
                BluetoothPeripheral.this.completedCommand();
            }

            public void onConnectionStateChange(BluetoothGatt object, int n, int n2) {
                if (n2 != 1) {
                    BluetoothPeripheral.this.cancelConnectionTimer();
                }
                int n3 = BluetoothPeripheral.this.state;
                BluetoothPeripheral.access$102(BluetoothPeripheral.this, n2);
                object = HciStatus.fromValue(n);
                if (object == HciStatus.SUCCESS) {
                    if (n2 != 0) {
                        if (n2 != 1) {
                            if (n2 != 2) {
                                if (n2 != 3) {
                                    Logger.e(TAG, "unknown state received");
                                } else {
                                    Logger.i(TAG, "peripheral '%s' is disconnecting", BluetoothPeripheral.this.getAddress());
                                    BluetoothPeripheral.this.listener.disconnecting(BluetoothPeripheral.this);
                                }
                            } else {
                                BluetoothPeripheral.this.successfullyConnected();
                            }
                        } else {
                            Logger.i(TAG, "peripheral '%s' is connecting", BluetoothPeripheral.this.getAddress());
                            BluetoothPeripheral.this.listener.connecting(BluetoothPeripheral.this);
                        }
                    } else {
                        BluetoothPeripheral.this.successfullyDisconnected(n3);
                    }
                } else {
                    BluetoothPeripheral.this.connectionStateChangeUnsuccessful((HciStatus)((Object)object), n3, n2);
                }
            }

            public void onConnectionUpdated(BluetoothGatt object, final int n, final int n2, final int n3, int n4) {
                object = GattStatus.fromValue(n4);
                if (object == GattStatus.SUCCESS) {
                    String string2 = String.format(Locale.ENGLISH, "connection parameters: interval=%.1fms latency=%d timeout=%ds", Float.valueOf((float)n * 1.25f), n2, n3 / 100);
                    Logger.d(TAG, string2);
                } else {
                    Logger.e(TAG, "connection parameters update failed with status '%s'", object);
                }
                BluetoothPeripheral.this.callbackHandler.post(new Runnable((GattStatus)((Object)object)){
                    final /* synthetic */ GattStatus val$gattStatus;
                    {
                        this.val$gattStatus = gattStatus;
                    }

                    @Override
                    public void run() {
                        BluetoothPeripheral.this.peripheralCallback.onConnectionUpdated(BluetoothPeripheral.this, n, n2, n3, this.val$gattStatus);
                    }
                });
            }

            public void onDescriptorRead(BluetoothGatt object, final BluetoothGattDescriptor bluetoothGattDescriptor, int n) {
                object = GattStatus.fromValue(n);
                if (object != GattStatus.SUCCESS) {
                    Logger.e(TAG, "reading descriptor <%s> failed for device '%s, status '%s'", bluetoothGattDescriptor.getUuid(), BluetoothPeripheral.this.getAddress(), object);
                    if (this.failureThatShouldTriggerBonding((GattStatus)((Object)object))) {
                        return;
                    }
                }
                final byte[] byArray = BluetoothPeripheral.this.nonnullOf(bluetoothGattDescriptor.getValue());
                BluetoothPeripheral.this.callbackHandler.post(new Runnable((GattStatus)((Object)object)){
                    final /* synthetic */ GattStatus val$gattStatus;
                    {
                        this.val$gattStatus = gattStatus;
                    }

                    @Override
                    public void run() {
                        BluetoothPeripheral.this.peripheralCallback.onDescriptorRead(BluetoothPeripheral.this, byArray, bluetoothGattDescriptor, this.val$gattStatus);
                    }
                });
                BluetoothPeripheral.this.completedCommand();
            }

            public void onDescriptorWrite(BluetoothGatt object, BluetoothGattDescriptor object2, int n) {
                object = GattStatus.fromValue(n);
                final BluetoothGattCharacteristic bluetoothGattCharacteristic = object2.getCharacteristic();
                if (object != GattStatus.SUCCESS) {
                    Logger.e(TAG, "failed to write <%s> to descriptor of characteristic <%s> for device: '%s', status '%s' ", BluetoothBytesParser.bytes2String(BluetoothPeripheral.this.currentWriteBytes), bluetoothGattCharacteristic.getUuid(), BluetoothPeripheral.this.getAddress(), object);
                    if (this.failureThatShouldTriggerBonding((GattStatus)((Object)object))) {
                        return;
                    }
                }
                if (object2.getUuid().equals(CCC_DESCRIPTOR_UUID)) {
                    if (object == GattStatus.SUCCESS) {
                        if (!Arrays.equals((byte[])(object2 = (Object)BluetoothPeripheral.this.nonnullOf(object2.getValue())), BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE) && !Arrays.equals((byte[])object2, BluetoothGattDescriptor.ENABLE_INDICATION_VALUE)) {
                            if (Arrays.equals((byte[])object2, BluetoothGattDescriptor.DISABLE_NOTIFICATION_VALUE)) {
                                BluetoothPeripheral.this.notifyingCharacteristics.remove(bluetoothGattCharacteristic);
                            }
                        } else {
                            BluetoothPeripheral.this.notifyingCharacteristics.add(bluetoothGattCharacteristic);
                        }
                    }
                    BluetoothPeripheral.this.callbackHandler.post(new Runnable((GattStatus)((Object)object)){
                        final /* synthetic */ GattStatus val$gattStatus;
                        {
                            this.val$gattStatus = gattStatus;
                        }

                        @Override
                        public void run() {
                            BluetoothPeripheral.this.peripheralCallback.onNotificationStateUpdate(BluetoothPeripheral.this, bluetoothGattCharacteristic, this.val$gattStatus);
                        }
                    });
                } else {
                    BluetoothPeripheral.this.callbackHandler.post(new Runnable((BluetoothGattDescriptor)object2, (GattStatus)((Object)object)){
                        final /* synthetic */ BluetoothGattDescriptor val$descriptor;
                        final /* synthetic */ GattStatus val$gattStatus;
                        {
                            this.val$descriptor = bluetoothGattDescriptor;
                            this.val$gattStatus = gattStatus;
                        }

                        @Override
                        public void run() {
                            BluetoothPeripheral.this.peripheralCallback.onDescriptorWrite(BluetoothPeripheral.this, BluetoothPeripheral.this.currentWriteBytes, this.val$descriptor, this.val$gattStatus);
                        }
                    });
                }
                BluetoothPeripheral.this.completedCommand();
            }

            public void onMtuChanged(BluetoothGatt object, final int n, int n2) {
                final GattStatus gattStatus = GattStatus.fromValue(n2);
                if (gattStatus != GattStatus.SUCCESS) {
                    Logger.e(TAG, "change MTU failed, status '%s'", new Object[]{gattStatus});
                }
                BluetoothPeripheral.access$1302(BluetoothPeripheral.this, n);
                object = new StringBuilder();
                ((StringBuilder)object).append("onMtuChanged->");
                ((StringBuilder)object).append(BluetoothPeripheral.this.currentMtu);
                Log.d((String)"Jeff1111", (String)((StringBuilder)object).toString());
                BluetoothPeripheral.this.callbackHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        BluetoothPeripheral.this.peripheralCallback.onMtuChanged(BluetoothPeripheral.this, n, gattStatus);
                    }
                });
                if (BluetoothPeripheral.this.currentCommand == 1) {
                    BluetoothPeripheral.access$1402(BluetoothPeripheral.this, 0);
                    BluetoothPeripheral.this.completedCommand();
                }
            }

            public void onPhyRead(BluetoothGatt object, final int n, final int n2, int n3) {
                object = GattStatus.fromValue(n3);
                if (object != GattStatus.SUCCESS) {
                    Logger.e(TAG, "read Phy failed, status '%s'", object);
                } else {
                    Logger.i(TAG, "updated Phy: tx = %s, rx = %s", new Object[]{PhyType.fromValue(n), PhyType.fromValue(n2)});
                }
                BluetoothPeripheral.this.callbackHandler.post(new Runnable((GattStatus)((Object)object)){
                    final /* synthetic */ GattStatus val$gattStatus;
                    {
                        this.val$gattStatus = gattStatus;
                    }

                    @Override
                    public void run() {
                        BluetoothPeripheral.this.peripheralCallback.onPhyUpdate(BluetoothPeripheral.this, PhyType.fromValue(n), PhyType.fromValue(n2), this.val$gattStatus);
                    }
                });
                BluetoothPeripheral.this.completedCommand();
            }

            public void onPhyUpdate(BluetoothGatt object, final int n, final int n2, int n3) {
                object = GattStatus.fromValue(n3);
                if (object != GattStatus.SUCCESS) {
                    Logger.e(TAG, "update Phy failed, status '%s'", object);
                } else {
                    Logger.i(TAG, "updated Phy: tx = %s, rx = %s", new Object[]{PhyType.fromValue(n), PhyType.fromValue(n2)});
                }
                BluetoothPeripheral.this.callbackHandler.post(new Runnable((GattStatus)((Object)object)){
                    final /* synthetic */ GattStatus val$gattStatus;
                    {
                        this.val$gattStatus = gattStatus;
                    }

                    @Override
                    public void run() {
                        BluetoothPeripheral.this.peripheralCallback.onPhyUpdate(BluetoothPeripheral.this, PhyType.fromValue(n), PhyType.fromValue(n2), this.val$gattStatus);
                    }
                });
                if (BluetoothPeripheral.this.currentCommand == 2) {
                    BluetoothPeripheral.access$1402(BluetoothPeripheral.this, 0);
                    BluetoothPeripheral.this.completedCommand();
                }
            }

            public void onReadRemoteRssi(BluetoothGatt object, final int n, int n2) {
                object = GattStatus.fromValue(n2);
                if (object != GattStatus.SUCCESS) {
                    Logger.e(TAG, "reading RSSI failed, status '%s'", object);
                }
                BluetoothPeripheral.this.callbackHandler.post(new Runnable((GattStatus)((Object)object)){
                    final /* synthetic */ GattStatus val$gattStatus;
                    {
                        this.val$gattStatus = gattStatus;
                    }

                    @Override
                    public void run() {
                        BluetoothPeripheral.this.peripheralCallback.onReadRemoteRssi(BluetoothPeripheral.this, n, this.val$gattStatus);
                    }
                });
                BluetoothPeripheral.this.completedCommand();
            }

            public void onServiceChanged(BluetoothGatt bluetoothGatt) {
                Logger.d(TAG, "onServiceChangedCalled");
                BluetoothPeripheral.this.commandQueue.clear();
                BluetoothPeripheral.access$1602(BluetoothPeripheral.this, false);
                BluetoothPeripheral.this.delayedDiscoverServices(100L);
            }

            public void onServicesDiscovered(BluetoothGatt object, int n) {
                GattStatus gattStatus = GattStatus.fromValue(n);
                if (gattStatus != GattStatus.SUCCESS) {
                    Logger.e(TAG, "service discovery failed due to internal error '%s', disconnecting", new Object[]{gattStatus});
                    BluetoothPeripheral.this.disconnect();
                    return;
                }
                object = object.getServices();
                Logger.i(TAG, "discovered %d services for '%s'", object.size(), BluetoothPeripheral.this.getName());
                BluetoothPeripheral.this.listener.connected(BluetoothPeripheral.this);
                BluetoothPeripheral.this.callbackHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        BluetoothPeripheral.this.peripheralCallback.onServicesDiscovered(BluetoothPeripheral.this);
                    }
                });
            }
        };
        this.bondStateReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                String string2 = intent.getAction();
                if (string2 == null) {
                    return;
                }
                context = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                if (context == null) {
                    return;
                }
                if (!context.getAddress().equalsIgnoreCase(BluetoothPeripheral.this.getAddress())) {
                    return;
                }
                if (string2.equals("android.bluetooth.device.action.BOND_STATE_CHANGED")) {
                    int n = intent.getIntExtra("android.bluetooth.device.extra.BOND_STATE", Integer.MIN_VALUE);
                    int n2 = intent.getIntExtra("android.bluetooth.device.extra.PREVIOUS_BOND_STATE", Integer.MIN_VALUE);
                    BluetoothPeripheral.this.handleBondStateChange(n, n2);
                }
            }
        };
        this.pairingRequestBroadcastReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent object) {
                context = (BluetoothDevice)object.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                if (context == null) {
                    return;
                }
                if (!context.getAddress().equalsIgnoreCase(BluetoothPeripheral.this.getAddress())) {
                    return;
                }
                int n = object.getIntExtra("android.bluetooth.device.extra.PAIRING_VARIANT", Integer.MIN_VALUE);
                String string2 = TAG;
                object = new StringBuilder();
                ((StringBuilder)object).append("pairing request received: ");
                ((StringBuilder)object).append(BluetoothPeripheral.this.pairingVariantToString(n));
                ((StringBuilder)object).append(" (");
                ((StringBuilder)object).append(n);
                ((StringBuilder)object).append(")");
                Logger.d(string2, ((StringBuilder)object).toString());
                if (n == 0 && (object = BluetoothPeripheral.this.listener.getPincode(BluetoothPeripheral.this)) != null) {
                    Logger.d(TAG, "setting PIN code for this peripheral using '%s'", object);
                    context.setPin(((String)object).getBytes());
                    this.abortBroadcast();
                }
            }
        };
        Objects.requireNonNull(object, "no valid context provided");
        Context context = object;
        this.context = object;
        Objects.requireNonNull(bluetoothDevice, NO_VALID_DEVICE_PROVIDED);
        object = bluetoothDevice;
        this.device = bluetoothDevice;
        Objects.requireNonNull(internalCallback, "no valid listener provided");
        object = internalCallback;
        this.listener = internalCallback;
        Objects.requireNonNull(bluetoothPeripheralCallback, NO_VALID_PERIPHERAL_CALLBACK_PROVIDED);
        object = bluetoothPeripheralCallback;
        this.peripheralCallback = bluetoothPeripheralCallback;
        Objects.requireNonNull(handler, "no valid callback handler provided");
        object = handler;
        this.callbackHandler = handler;
        Objects.requireNonNull(transport, "no valid transport provided");
        object = transport;
        this.transport = transport;
    }

    static /* synthetic */ int access$102(BluetoothPeripheral bluetoothPeripheral, int n) {
        bluetoothPeripheral.state = n;
        return n;
    }

    static /* synthetic */ int access$1302(BluetoothPeripheral bluetoothPeripheral, int n) {
        bluetoothPeripheral.currentMtu = n;
        return n;
    }

    static /* synthetic */ int access$1402(BluetoothPeripheral bluetoothPeripheral, int n) {
        bluetoothPeripheral.currentCommand = n;
        return n;
    }

    static /* synthetic */ boolean access$1602(BluetoothPeripheral bluetoothPeripheral, boolean bl) {
        bluetoothPeripheral.commandQueueBusy = bl;
        return bl;
    }

    static /* synthetic */ BluetoothGatt access$1802(BluetoothPeripheral bluetoothPeripheral, BluetoothGatt bluetoothGatt) {
        bluetoothPeripheral.bluetoothGatt = bluetoothGatt;
        return bluetoothGatt;
    }

    static /* synthetic */ boolean access$1902(BluetoothPeripheral bluetoothPeripheral, boolean bl) {
        bluetoothPeripheral.discoveryStarted = bl;
        return bl;
    }

    static /* synthetic */ Runnable access$2002(BluetoothPeripheral bluetoothPeripheral, Runnable runnable) {
        bluetoothPeripheral.discoverServicesRunnable = runnable;
        return runnable;
    }

    static /* synthetic */ long access$2702(BluetoothPeripheral bluetoothPeripheral, long l) {
        bluetoothPeripheral.connectTimestamp = l;
        return l;
    }

    static /* synthetic */ boolean access$3202(BluetoothPeripheral bluetoothPeripheral, boolean bl) {
        bluetoothPeripheral.manuallyBonding = bl;
        return bl;
    }

    static /* synthetic */ int access$3308(BluetoothPeripheral bluetoothPeripheral) {
        int n = bluetoothPeripheral.nrTries;
        bluetoothPeripheral.nrTries = n + 1;
        return n;
    }

    static /* synthetic */ Runnable access$3902(BluetoothPeripheral bluetoothPeripheral, Runnable runnable) {
        bluetoothPeripheral.timeoutRunnable = runnable;
        return runnable;
    }

    static /* synthetic */ byte[] access$902(BluetoothPeripheral bluetoothPeripheral, byte[] byArray) {
        bluetoothPeripheral.currentWriteBytes = byArray;
        return byArray;
    }

    private void adjustWriteTypeIfNeeded(BluetoothGattCharacteristic bluetoothGattCharacteristic) {
        if (Build.VERSION.SDK_INT < 24) {
            bluetoothGattCharacteristic.setWriteType(2);
        }
    }

    private void cancelConnectionTimer() {
        Runnable runnable = this.timeoutRunnable;
        if (runnable != null) {
            this.mainHandler.removeCallbacks(runnable);
            this.timeoutRunnable = null;
        }
    }

    private void cancelPendingServiceDiscovery() {
        Runnable runnable = this.discoverServicesRunnable;
        if (runnable != null) {
            this.mainHandler.removeCallbacks(runnable);
            this.discoverServicesRunnable = null;
        }
    }

    private void completeDisconnect(boolean bl, HciStatus hciStatus) {
        if (this.bluetoothGatt != null) {
            this.bluetoothGatt.close();
            this.bluetoothGatt = null;
        }
        this.commandQueue.clear();
        this.commandQueueBusy = false;
        this.notifyingCharacteristics.clear();
        this.currentMtu = 23;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("completeDisconnect mtu->");
        stringBuilder.append(this.currentMtu);
        Log.d((String)"Jeff1111", (String)stringBuilder.toString());
        this.currentCommand = 0;
        this.manuallyBonding = false;
        this.peripheralInitiatedBonding = false;
        this.discoveryStarted = false;
        try {
            this.unregisterBondingBroadcastReceivers();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.bondLost = false;
        if (bl) {
            this.listener.disconnected(this, hciStatus);
        }
    }

    private void completedCommand() {
        this.isRetrying = false;
        this.commandQueue.poll();
        this.commandQueueBusy = false;
        this.nextCommand();
    }

    /*
     * WARNING - void declaration
     */
    private BluetoothGatt connectGattCompat(BluetoothGattCallback bluetoothGattCallback, BluetoothDevice bluetoothDevice, boolean bl) {
        if (Build.VERSION.SDK_INT >= 23) {
            return bluetoothDevice.connectGatt(this.context, bl, bluetoothGattCallback, this.transport.value);
        }
        Method method = bluetoothDevice.getClass().getMethod("connectGatt", Context.class, Boolean.TYPE, BluetoothGattCallback.class, Integer.TYPE);
        try {
            method = (BluetoothGatt)method.invoke((Object)bluetoothDevice, this.context, bl, bluetoothGattCallback, this.transport.value);
            return method;
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        try {
            void var4_7;
            var4_7.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        return bluetoothDevice.connectGatt(this.context, bl, bluetoothGattCallback);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BluetoothGatt connectGattHelper(BluetoothDevice bluetoothDevice, boolean bl, BluetoothGattCallback bluetoothGattCallback) {
        if (bluetoothDevice == null) {
            return null;
        }
        if (Build.VERSION.SDK_INT >= 24) return this.connectGattCompat(bluetoothGattCallback, bluetoothDevice, bl);
        if (!bl) {
            return this.connectGattCompat(bluetoothGattCallback, bluetoothDevice, bl);
        }
        try {
            Object object = this.getIBluetoothGatt(this.getIBluetoothManager());
            if (object == null) {
                Logger.e(TAG, "could not get iBluetoothGatt object");
                return this.connectGattCompat(bluetoothGattCallback, bluetoothDevice, true);
            }
            if ((object = this.createBluetoothGatt(object, bluetoothDevice)) == null) {
                Logger.e(TAG, "could not create BluetoothGatt object");
                return this.connectGattCompat(bluetoothGattCallback, bluetoothDevice, true);
            }
            if (this.connectUsingReflection(bluetoothDevice, (BluetoothGatt)object, bluetoothGattCallback, true)) return object;
            Logger.i(TAG, "connection using reflection failed, closing gatt");
            object.close();
            return object;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException exception) {
            Logger.e(TAG, "error during reflection");
            return this.connectGattCompat(bluetoothGattCallback, bluetoothDevice, true);
        }
    }

    private boolean connectUsingReflection(BluetoothDevice object, BluetoothGatt bluetoothGatt, BluetoothGattCallback bluetoothGattCallback, boolean bl) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, NoSuchFieldException {
        this.setAutoConnectValue(bluetoothGatt, bl);
        object = bluetoothGatt.getClass().getDeclaredMethod("connect", Boolean.class, BluetoothGattCallback.class);
        ((Method)object).setAccessible(true);
        return (Boolean)((Method)object).invoke((Object)bluetoothGatt, true, bluetoothGattCallback);
    }

    private void connectionStateChangeUnsuccessful(HciStatus hciStatus, int n, int n2) {
        this.cancelPendingServiceDiscovery();
        boolean bl = this.getServices().isEmpty();
        if (n == 1) {
            n = SystemClock.elapsedRealtime() - this.connectTimestamp > (long)this.getTimoutThreshold() ? 1 : 0;
            HciStatus hciStatus2 = hciStatus;
            if (hciStatus == HciStatus.ERROR) {
                hciStatus2 = hciStatus;
                if (n != 0) {
                    hciStatus2 = HciStatus.CONNECTION_FAILED_ESTABLISHMENT;
                }
            }
            Logger.i(TAG, "connection failed with status '%s'", new Object[]{hciStatus2});
            this.completeDisconnect(false, hciStatus2);
            this.listener.connectFailed(this, hciStatus2);
        } else if (n == 2 && n2 == 0 && !(bl ^ true)) {
            Logger.i(TAG, "peripheral '%s' disconnected with status '%s' (%d) before completing service discovery", new Object[]{this.getName(), hciStatus, hciStatus.value});
            this.completeDisconnect(false, hciStatus);
            this.listener.connectFailed(this, hciStatus);
        } else {
            if (n2 == 0) {
                Logger.i(TAG, "peripheral '%s' disconnected with status '%s' (%d)", new Object[]{this.getName(), hciStatus, hciStatus.value});
            } else {
                Logger.i(TAG, "unexpected connection state change for '%s' status '%s' (%d)", new Object[]{this.getName(), hciStatus, hciStatus.value});
            }
            this.completeDisconnect(true, hciStatus);
        }
    }

    private BluetoothGatt createBluetoothGatt(Object object, BluetoothDevice bluetoothDevice) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        Constructor<?> constructor = BluetoothGatt.class.getDeclaredConstructors()[0];
        constructor.setAccessible(true);
        if (constructor.getParameterTypes().length == 4) {
            return (BluetoothGatt)constructor.newInstance(this.context, object, bluetoothDevice, this.transport.value);
        }
        return (BluetoothGatt)constructor.newInstance(this.context, object, bluetoothDevice);
    }

    private void delayedDiscoverServices(final long l) {
        Runnable runnable;
        this.discoverServicesRunnable = runnable = new Runnable(){

            @Override
            public void run() {
                Logger.d(TAG, "discovering services of '%s' with delay of %d ms", BluetoothPeripheral.this.getName(), l);
                if (BluetoothPeripheral.this.bluetoothGatt != null && BluetoothPeripheral.this.bluetoothGatt.discoverServices()) {
                    BluetoothPeripheral.access$1902(BluetoothPeripheral.this, true);
                } else {
                    Logger.e(TAG, "discoverServices failed to start");
                }
                BluetoothPeripheral.access$2002(BluetoothPeripheral.this, null);
            }
        };
        this.mainHandler.postDelayed(runnable, l);
    }

    private void disconnect() {
        if (this.state != 2 && this.state != 1) {
            this.listener.disconnected(this, HciStatus.SUCCESS);
        } else {
            this.bluetoothGattCallback.onConnectionStateChange(this.bluetoothGatt, HciStatus.SUCCESS.value, 3);
            this.mainHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (BluetoothPeripheral.this.state == 3 && BluetoothPeripheral.this.bluetoothGatt != null) {
                        BluetoothPeripheral.this.bluetoothGatt.disconnect();
                        Logger.i(TAG, "force disconnect '%s' (%s)", BluetoothPeripheral.this.getName(), BluetoothPeripheral.this.getAddress());
                    }
                }
            });
        }
    }

    private boolean doesNotSupportReading(BluetoothGattCharacteristic bluetoothGattCharacteristic) {
        boolean bl = (bluetoothGattCharacteristic.getProperties() & 2) == 0;
        return bl;
    }

    private boolean doesNotSupportWriteType(BluetoothGattCharacteristic bluetoothGattCharacteristic, WriteType writeType) {
        boolean bl = (bluetoothGattCharacteristic.getProperties() & writeType.property) == 0;
        return bl;
    }

    private boolean enqueue(Runnable runnable) {
        boolean bl = this.commandQueue.add(runnable);
        if (bl) {
            this.nextCommand();
        } else {
            Logger.e(TAG, "could not enqueue command");
        }
        return bl;
    }

    private Object getIBluetoothGatt(Object object) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        if (object == null) {
            return null;
        }
        return this.getMethodFromClass(object.getClass(), "getBluetoothGatt").invoke(object, new Object[0]);
    }

    private Object getIBluetoothManager() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (bluetoothAdapter == null) {
            return null;
        }
        return this.getMethodFromClass(bluetoothAdapter.getClass(), "getBluetoothManager").invoke((Object)bluetoothAdapter, new Object[0]);
    }

    private Method getMethodFromClass(Class<?> genericDeclaration, String string2) throws NoSuchMethodException {
        genericDeclaration = ((Class)genericDeclaration).getDeclaredMethod(string2, new Class[0]);
        ((Method)genericDeclaration).setAccessible(true);
        return genericDeclaration;
    }

    private long getServiceDiscoveryDelay(BondState bondState) {
        int n = Build.VERSION.SDK_INT;
        long l = 0L;
        long l2 = n <= 24 ? 1000L : 0L;
        if (bondState == BondState.BONDED) {
            l = l2;
        }
        return l;
    }

    private int getTimoutThreshold() {
        if (Build.MANUFACTURER.equalsIgnoreCase("samsung")) {
            return 4500;
        }
        return 25000;
    }

    private void handleBondStateChange(int n, int n2) {
        switch (n) {
            default: {
                break;
            }
            case 12: {
                Logger.d(TAG, "bonded with '%s' (%s)", this.getName(), this.getAddress());
                this.callbackHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        BluetoothPeripheral.this.peripheralCallback.onBondingSucceeded(BluetoothPeripheral.this);
                    }
                });
                if (this.bluetoothGatt == null) {
                    this.connect();
                    return;
                }
                if (this.getServices().isEmpty() && !this.discoveryStarted) {
                    this.delayedDiscoverServices(0L);
                }
                if (Build.VERSION.SDK_INT < 26 && this.commandQueueBusy && !this.manuallyBonding) {
                    this.mainHandler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            Logger.d(TAG, "retrying command after bonding");
                            BluetoothPeripheral.this.retryCommand();
                        }
                    }, 50L);
                }
                if (this.manuallyBonding) {
                    this.manuallyBonding = false;
                    this.completedCommand();
                }
                if (!this.peripheralInitiatedBonding) break;
                this.peripheralInitiatedBonding = false;
                this.nextCommand();
                break;
            }
            case 11: {
                Logger.d(TAG, "starting bonding with '%s' (%s)", this.getName(), this.getAddress());
                this.callbackHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        BluetoothPeripheral.this.peripheralCallback.onBondingStarted(BluetoothPeripheral.this);
                    }
                });
                break;
            }
            case 10: {
                if (n2 == 11) {
                    Logger.e(TAG, "bonding failed for '%s', disconnecting device", this.getName());
                    this.unregisterBondingBroadcastReceivers();
                    this.callbackHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            BluetoothPeripheral.this.peripheralCallback.onBondingFailed(BluetoothPeripheral.this);
                        }
                    });
                } else {
                    Logger.e(TAG, "bond lost for '%s'", this.getName());
                    this.bondLost = true;
                    this.cancelPendingServiceDiscovery();
                    this.unregisterBondingBroadcastReceivers();
                    this.callbackHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            BluetoothPeripheral.this.peripheralCallback.onBondLost(BluetoothPeripheral.this);
                        }
                    });
                }
                this.mainHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        if (BluetoothPeripheral.this.getState() == ConnectionState.CONNECTED) {
                            BluetoothPeripheral.this.disconnect();
                        }
                    }
                }, 100L);
            }
        }
    }

    private boolean isConnected() {
        boolean bl = this.bluetoothGatt != null && this.state == 2;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void nextCommand() {
        synchronized (this) {
            if (this.commandQueueBusy) {
                return;
            }
            final Runnable runnable = this.commandQueue.peek();
            if (runnable == null) {
                return;
            }
            if (this.bluetoothGatt == null) {
                Logger.e(TAG, "gatt is 'null' for peripheral '%s', clearing command queue", this.getAddress());
                this.commandQueue.clear();
                this.commandQueueBusy = false;
                return;
            }
            if (this.getBondState() == BondState.BONDING) {
                Logger.w(TAG, "bonding is in progress, waiting for bonding to complete");
                this.peripheralInitiatedBonding = true;
                return;
            }
            this.commandQueueBusy = true;
            if (!this.isRetrying) {
                this.nrTries = 0;
            }
            Handler handler = this.mainHandler;
            Runnable runnable2 = new Runnable(){

                @Override
                public void run() {
                    try {
                        runnable.run();
                    }
                    catch (Exception exception) {
                        Logger.e(TAG, "command exception for device '%s'", BluetoothPeripheral.this.getName());
                        Logger.e(TAG, exception.toString());
                        BluetoothPeripheral.this.completedCommand();
                    }
                }
            };
            handler.post(runnable2);
            return;
        }
    }

    private boolean notConnected() {
        return this.isConnected() ^ true;
    }

    private String pairingVariantToString(int n) {
        switch (n) {
            default: {
                return "UNKNOWN";
            }
            case 6: {
                return "PAIRING_VARIANT_OOB_CONSENT";
            }
            case 5: {
                return "PAIRING_VARIANT_DISPLAY_PIN";
            }
            case 4: {
                return "PAIRING_VARIANT_DISPLAY_PASSKEY";
            }
            case 3: {
                return "PAIRING_VARIANT_CONSENT";
            }
            case 2: {
                return "PAIRING_VARIANT_PASSKEY_CONFIRMATION";
            }
            case 1: {
                return "PAIRING_VARIANT_PASSKEY";
            }
            case 0: 
        }
        return "PAIRING_VARIANT_PIN";
    }

    private void registerBondingBroadcastReceivers() {
        this.context.registerReceiver(this.bondStateReceiver, new IntentFilter("android.bluetooth.device.action.BOND_STATE_CHANGED"));
        this.context.registerReceiver(this.pairingRequestBroadcastReceiver, new IntentFilter("android.bluetooth.device.action.PAIRING_REQUEST"));
    }

    private void retryCommand() {
        this.commandQueueBusy = false;
        if (this.commandQueue.peek() != null) {
            if (this.nrTries >= 2) {
                Logger.d(TAG, "max number of tries reached, not retrying operation anymore");
                this.commandQueue.poll();
            } else {
                this.isRetrying = true;
            }
        }
        this.nextCommand();
    }

    private void setAutoConnectValue(BluetoothGatt bluetoothGatt, boolean bl) throws NoSuchFieldException, IllegalAccessException {
        Field field = bluetoothGatt.getClass().getDeclaredField("mAutoConnect");
        field.setAccessible(true);
        field.setBoolean(bluetoothGatt, bl);
    }

    private void startConnectionTimer(BluetoothPeripheral object) {
        this.cancelConnectionTimer();
        this.timeoutRunnable = object = new Runnable((BluetoothPeripheral)object){
            final /* synthetic */ BluetoothPeripheral val$peripheral;
            {
                this.val$peripheral = bluetoothPeripheral2;
            }

            @Override
            public void run() {
                Logger.e(TAG, "connection timout, disconnecting '%s'", this.val$peripheral.getName());
                BluetoothPeripheral.this.disconnect();
                BluetoothPeripheral.this.mainHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        BluetoothPeripheral.this.bluetoothGattCallback.onConnectionStateChange(BluetoothPeripheral.this.bluetoothGatt, HciStatus.CONNECTION_FAILED_ESTABLISHMENT.value, 0);
                    }
                }, 50L);
                BluetoothPeripheral.access$3902(BluetoothPeripheral.this, null);
            }
        };
        this.mainHandler.postDelayed((Runnable)object, 35000L);
    }

    private void successfullyConnected() {
        BondState bondState = this.getBondState();
        long l = SystemClock.elapsedRealtime();
        long l2 = this.connectTimestamp;
        String string2 = TAG;
        Logger.i(string2, "connected to '%s' (%s) in %.1fs", new Object[]{this.getName(), bondState, Float.valueOf((float)(l - l2) / 1000.0f)});
        if (bondState != BondState.NONE && bondState != BondState.BONDED) {
            if (bondState == BondState.BONDING) {
                Logger.i(string2, "waiting for bonding to complete");
            }
        } else {
            this.delayedDiscoverServices(this.getServiceDiscoveryDelay(bondState));
        }
    }

    private void successfullyDisconnected(int n) {
        if (n != 2 && n != 3) {
            if (n == 1) {
                Logger.i(TAG, "cancelling connect attempt");
            }
        } else {
            Logger.i(TAG, "disconnected '%s' on request", this.getName());
        }
        if (this.bondLost) {
            Logger.d(TAG, "disconnected because of bond lost");
            this.callbackHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (BluetoothPeripheral.this.getServices().isEmpty()) {
                        BluetoothPeripheral.this.completeDisconnect(false, HciStatus.AUTHENTICATION_FAILURE);
                        BluetoothPeripheral.this.listener.connectFailed(BluetoothPeripheral.this, HciStatus.AUTHENTICATION_FAILURE);
                    } else {
                        BluetoothPeripheral.this.completeDisconnect(true, HciStatus.AUTHENTICATION_FAILURE);
                    }
                }
            }, 1000L);
        } else {
            this.completeDisconnect(true, HciStatus.SUCCESS);
        }
    }

    private void unregisterBondingBroadcastReceivers() {
        this.context.unregisterReceiver(this.bondStateReceiver);
        this.context.unregisterReceiver(this.pairingRequestBroadcastReceiver);
    }

    private boolean willCauseLongWrite(byte[] byArray, WriteType writeType) {
        boolean bl = byArray.length > this.currentMtu - 3 && writeType == WriteType.WITH_RESPONSE;
        return bl;
    }

    void autoConnect() {
        if (this.state == 0) {
            this.mainHandler.post(new Runnable(){

                @Override
                public void run() {
                    Logger.i(TAG, "autoConnect to '%s' (%s) using transport %s", BluetoothPeripheral.this.getName(), BluetoothPeripheral.this.getAddress(), BluetoothPeripheral.this.transport.name());
                    BluetoothPeripheral.this.registerBondingBroadcastReceivers();
                    BluetoothPeripheral.access$1902(BluetoothPeripheral.this, false);
                    BluetoothPeripheral.access$2702(BluetoothPeripheral.this, SystemClock.elapsedRealtime());
                    BluetoothPeripheral bluetoothPeripheral = BluetoothPeripheral.this;
                    BluetoothPeripheral.access$1802(bluetoothPeripheral, bluetoothPeripheral.connectGattHelper(bluetoothPeripheral.device, true, BluetoothPeripheral.this.bluetoothGattCallback));
                    BluetoothPeripheral.this.bluetoothGattCallback.onConnectionStateChange(BluetoothPeripheral.this.bluetoothGatt, HciStatus.SUCCESS.value, 1);
                }
            });
        } else {
            Logger.e(TAG, "peripheral '%s' not yet disconnected, will not connect", this.getName());
        }
    }

    public void cancelConnection() {
        if (this.bluetoothGatt == null) {
            Logger.w(TAG, "cannot cancel connection because no connection attempt is made yet");
            return;
        }
        if (this.state != 0 && this.state != 3) {
            this.cancelConnectionTimer();
            if (this.state == 1) {
                this.disconnect();
                this.mainHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        BluetoothPeripheral.this.bluetoothGattCallback.onConnectionStateChange(BluetoothPeripheral.this.bluetoothGatt, HciStatus.SUCCESS.value, 0);
                    }
                }, 50L);
            } else {
                this.disconnect();
            }
        }
    }

    public boolean clearServicesCache() {
        boolean bl;
        block4: {
            Object object = this.bluetoothGatt;
            boolean bl2 = false;
            if (object == null) {
                return false;
            }
            object = this.bluetoothGatt.getClass().getMethod("refresh", new Class[0]);
            bl = bl2;
            if (object == null) break block4;
            try {
                bl = (Boolean)((Method)object).invoke((Object)this.bluetoothGatt, new Object[0]);
            }
            catch (Exception exception) {
                Logger.e(TAG, "could not invoke refresh method");
                bl = bl2;
            }
        }
        return bl;
    }

    void connect() {
        if (this.state == 0) {
            this.mainHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    Logger.i(TAG, "connect to '%s' (%s) using transport %s", BluetoothPeripheral.this.getName(), BluetoothPeripheral.this.getAddress(), BluetoothPeripheral.this.transport.name());
                    BluetoothPeripheral.this.registerBondingBroadcastReceivers();
                    BluetoothPeripheral.access$1902(BluetoothPeripheral.this, false);
                    BluetoothPeripheral.access$2702(BluetoothPeripheral.this, SystemClock.elapsedRealtime());
                    BluetoothPeripheral bluetoothPeripheral = BluetoothPeripheral.this;
                    bluetoothPeripheral.startConnectionTimer(bluetoothPeripheral);
                    BluetoothPeripheral.this.bluetoothGattCallback.onConnectionStateChange(BluetoothPeripheral.this.bluetoothGatt, HciStatus.SUCCESS.value, 1);
                    bluetoothPeripheral = BluetoothPeripheral.this;
                    BluetoothPeripheral.access$1802(bluetoothPeripheral, bluetoothPeripheral.connectGattHelper(bluetoothPeripheral.device, false, BluetoothPeripheral.this.bluetoothGattCallback));
                }
            }, 100L);
        } else {
            Logger.e(TAG, "peripheral '%s' not yet disconnected, will not connect", this.getName());
        }
    }

    byte[] copyOf(byte[] byArray) {
        byArray = byArray == null ? new byte[]{} : Arrays.copyOf(byArray, byArray.length);
        return byArray;
    }

    public boolean createBond() {
        if (this.bluetoothGatt == null) {
            Logger.d(TAG, "connecting and creating bond with '%s'", this.getName());
            this.registerBondingBroadcastReceivers();
            return this.device.createBond();
        }
        return this.enqueue(new Runnable(){

            @Override
            public void run() {
                BluetoothPeripheral.access$3202(BluetoothPeripheral.this, true);
                if (!BluetoothPeripheral.this.device.createBond()) {
                    Logger.e(TAG, "bonding failed for %s", BluetoothPeripheral.this.getAddress());
                    BluetoothPeripheral.this.completedCommand();
                } else {
                    Logger.d(TAG, "manually bonding %s", BluetoothPeripheral.this.getAddress());
                    BluetoothPeripheral.access$3308(BluetoothPeripheral.this);
                }
            }
        });
    }

    void disconnectWhenBluetoothOff() {
        this.bluetoothGatt = null;
        this.state = 0;
        this.completeDisconnect(true, HciStatus.SUCCESS);
    }

    public String getAddress() {
        return this.device.getAddress();
    }

    public BondState getBondState() {
        return BondState.fromValue(this.device.getBondState());
    }

    public BluetoothGattCharacteristic getCharacteristic(UUID uUID, UUID uUID2) {
        Objects.requireNonNull(uUID, NO_VALID_SERVICE_UUID_PROVIDED);
        Objects.requireNonNull(uUID2, NO_VALID_CHARACTERISTIC_UUID_PROVIDED);
        uUID = this.getService(uUID);
        if (uUID != null) {
            return uUID.getCharacteristic(uUID2);
        }
        return null;
    }

    public int getCurrentMtu() {
        return this.currentMtu;
    }

    public int getMaximumWriteValueLength(WriteType writeType) {
        Objects.requireNonNull(writeType, "writetype is null");
        int n = 29.$SwitchMap$com$welie$blessed$WriteType[writeType.ordinal()];
        if (n != 1) {
            if (n != 2) {
                return this.currentMtu - 3;
            }
            return this.currentMtu - 15;
        }
        return 512;
    }

    public String getName() {
        String string2 = this.device.getName();
        if (string2 != null) {
            this.cachedName = string2;
            return string2;
        }
        return this.cachedName;
    }

    public Set<BluetoothGattCharacteristic> getNotifyingCharacteristics() {
        return Collections.unmodifiableSet(this.notifyingCharacteristics);
    }

    public BluetoothGattService getService(UUID uUID) {
        Objects.requireNonNull(uUID, NO_VALID_SERVICE_UUID_PROVIDED);
        if (this.bluetoothGatt != null) {
            return this.bluetoothGatt.getService(uUID);
        }
        return null;
    }

    public List<BluetoothGattService> getServices() {
        if (this.bluetoothGatt != null) {
            return this.bluetoothGatt.getServices();
        }
        return Collections.emptyList();
    }

    public ConnectionState getState() {
        return ConnectionState.fromValue(this.state);
    }

    public Transport getTransport() {
        return this.transport;
    }

    public PeripheralType getType() {
        return PeripheralType.fromValue(this.device.getType());
    }

    public boolean isNotifying(BluetoothGattCharacteristic bluetoothGattCharacteristic) {
        Objects.requireNonNull(bluetoothGattCharacteristic, NO_VALID_CHARACTERISTIC_PROVIDED);
        return this.notifyingCharacteristics.contains(bluetoothGattCharacteristic);
    }

    public boolean isUncached() {
        boolean bl = this.getType() == PeripheralType.UNKNOWN;
        return bl;
    }

    byte[] nonnullOf(byte[] byArray) {
        byte[] byArray2 = byArray;
        if (byArray == null) {
            byArray2 = new byte[]{};
        }
        return byArray2;
    }

    public boolean readCharacteristic(final BluetoothGattCharacteristic bluetoothGattCharacteristic) {
        Objects.requireNonNull(bluetoothGattCharacteristic, NO_VALID_CHARACTERISTIC_PROVIDED);
        if (this.notConnected()) {
            Logger.e(TAG, PERIPHERAL_NOT_CONNECTED);
            return false;
        }
        if (!this.doesNotSupportReading(bluetoothGattCharacteristic)) {
            return this.enqueue(new Runnable(){

                @Override
                public void run() {
                    if (BluetoothPeripheral.this.isConnected()) {
                        if (BluetoothPeripheral.this.bluetoothGatt.readCharacteristic(bluetoothGattCharacteristic)) {
                            Logger.d(TAG, "reading characteristic <%s>", bluetoothGattCharacteristic.getUuid());
                            BluetoothPeripheral.access$3308(BluetoothPeripheral.this);
                        } else {
                            Logger.e(TAG, "readCharacteristic failed for characteristic: %s", bluetoothGattCharacteristic.getUuid());
                            BluetoothPeripheral.this.completedCommand();
                        }
                    } else {
                        BluetoothPeripheral.this.completedCommand();
                    }
                }
            });
        }
        throw new IllegalArgumentException(String.format("characteristic <%s> does not have read property", bluetoothGattCharacteristic.getUuid()));
    }

    public boolean readCharacteristic(UUID uUID, UUID uUID2) {
        Objects.requireNonNull(uUID, NO_VALID_SERVICE_UUID_PROVIDED);
        Objects.requireNonNull(uUID2, NO_VALID_CHARACTERISTIC_UUID_PROVIDED);
        uUID = this.getCharacteristic(uUID, uUID2);
        if (uUID != null) {
            return this.readCharacteristic((BluetoothGattCharacteristic)uUID);
        }
        return false;
    }

    public boolean readDescriptor(final BluetoothGattDescriptor bluetoothGattDescriptor) {
        Objects.requireNonNull(bluetoothGattDescriptor, NO_VALID_DESCRIPTOR_PROVIDED);
        if (this.notConnected()) {
            Logger.e(TAG, PERIPHERAL_NOT_CONNECTED);
            return false;
        }
        return this.enqueue(new Runnable(){

            @Override
            public void run() {
                if (BluetoothPeripheral.this.isConnected()) {
                    if (BluetoothPeripheral.this.bluetoothGatt.readDescriptor(bluetoothGattDescriptor)) {
                        Logger.d(TAG, "reading descriptor <%s>", bluetoothGattDescriptor.getUuid());
                        BluetoothPeripheral.access$3308(BluetoothPeripheral.this);
                    } else {
                        Logger.e(TAG, "readDescriptor failed for characteristic: %s", bluetoothGattDescriptor.getUuid());
                        BluetoothPeripheral.this.completedCommand();
                    }
                } else {
                    BluetoothPeripheral.this.completedCommand();
                }
            }
        });
    }

    public boolean readPhy() {
        if (this.notConnected()) {
            Logger.e(TAG, PERIPHERAL_NOT_CONNECTED);
            return false;
        }
        if (Build.VERSION.SDK_INT < 26) {
            Logger.e(TAG, "setPreferredPhy requires Android 8.0 or newer");
            return false;
        }
        return this.enqueue(new Runnable(){

            @Override
            public void run() {
                if (BluetoothPeripheral.this.isConnected()) {
                    if (Build.VERSION.SDK_INT >= 26) {
                        BluetoothPeripheral.this.bluetoothGatt.readPhy();
                        Logger.d(TAG, "reading Phy");
                    }
                } else {
                    BluetoothPeripheral.this.completedCommand();
                }
            }
        });
    }

    public boolean readRemoteRssi() {
        if (this.notConnected()) {
            Logger.e(TAG, PERIPHERAL_NOT_CONNECTED);
            return false;
        }
        return this.enqueue(new Runnable(){

            @Override
            public void run() {
                if (BluetoothPeripheral.this.isConnected()) {
                    if (!BluetoothPeripheral.this.bluetoothGatt.readRemoteRssi()) {
                        Logger.e(TAG, "readRemoteRssi failed");
                        BluetoothPeripheral.this.completedCommand();
                    }
                } else {
                    BluetoothPeripheral.this.completedCommand();
                }
            }
        });
    }

    public boolean requestConnectionPriority(final ConnectionPriority connectionPriority) {
        Objects.requireNonNull(connectionPriority, NO_VALID_PRIORITY_PROVIDED);
        if (this.notConnected()) {
            Logger.e(TAG, PERIPHERAL_NOT_CONNECTED);
            return false;
        }
        return this.enqueue(new Runnable(){

            @Override
            public void run() {
                if (BluetoothPeripheral.this.isConnected()) {
                    if (BluetoothPeripheral.this.bluetoothGatt.requestConnectionPriority(connectionPriority.value)) {
                        Logger.d(TAG, "requesting connection priority %s", new Object[]{connectionPriority});
                    } else {
                        Logger.e(TAG, "could not request connection priority");
                    }
                }
                BluetoothPeripheral.this.callbackHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        BluetoothPeripheral.this.completedCommand();
                    }
                }, 500L);
            }
        });
    }

    public boolean requestMtu(final int n) {
        if (n >= 23 && n <= 517) {
            if (this.notConnected()) {
                Logger.e(TAG, PERIPHERAL_NOT_CONNECTED);
                return false;
            }
            return this.enqueue(new Runnable(){

                @Override
                public void run() {
                    if (BluetoothPeripheral.this.isConnected()) {
                        if (BluetoothPeripheral.this.bluetoothGatt.requestMtu(n)) {
                            BluetoothPeripheral.access$1402(BluetoothPeripheral.this, 1);
                            Logger.i(TAG, "requesting MTU of %d", n);
                        } else {
                            Logger.e(TAG, "requestMtu failed");
                            BluetoothPeripheral.this.completedCommand();
                        }
                    } else {
                        BluetoothPeripheral.this.completedCommand();
                    }
                }
            });
        }
        throw new IllegalArgumentException("mtu must be between 23 and 517");
    }

    void setDevice(BluetoothDevice bluetoothDevice) {
        Objects.requireNonNull(bluetoothDevice, NO_VALID_DEVICE_PROVIDED);
        BluetoothDevice bluetoothDevice2 = bluetoothDevice;
        this.device = bluetoothDevice;
    }

    public boolean setNotify(final BluetoothGattCharacteristic bluetoothGattCharacteristic, final boolean bl) {
        block5: {
            block8: {
                byte[] byArray;
                BluetoothGattDescriptor bluetoothGattDescriptor;
                block7: {
                    int n;
                    block6: {
                        Objects.requireNonNull(bluetoothGattCharacteristic, NO_VALID_CHARACTERISTIC_PROVIDED);
                        if (this.notConnected()) {
                            Logger.e(TAG, PERIPHERAL_NOT_CONNECTED);
                            return false;
                        }
                        bluetoothGattDescriptor = bluetoothGattCharacteristic.getDescriptor(CCC_DESCRIPTOR_UUID);
                        if (bluetoothGattDescriptor == null) break block5;
                        n = bluetoothGattCharacteristic.getProperties();
                        if ((n & 0x10) <= 0) break block6;
                        byArray = BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE;
                        break block7;
                    }
                    if ((n & 0x20) <= 0) break block8;
                    byArray = BluetoothGattDescriptor.ENABLE_INDICATION_VALUE;
                }
                if (!bl) {
                    byArray = BluetoothGattDescriptor.DISABLE_NOTIFICATION_VALUE;
                }
                return this.enqueue(new Runnable(){

                    @Override
                    public void run() {
                        if (BluetoothPeripheral.this.notConnected()) {
                            BluetoothPeripheral.this.completedCommand();
                            return;
                        }
                        if (!BluetoothPeripheral.this.bluetoothGatt.setCharacteristicNotification(bluetoothGattCharacteristic, bl)) {
                            Logger.e(TAG, "setCharacteristicNotification failed for characteristic: %s", bluetoothGattCharacteristic.getUuid());
                            BluetoothPeripheral.this.completedCommand();
                            return;
                        }
                        BluetoothPeripheral.this.adjustWriteTypeIfNeeded(bluetoothGattCharacteristic);
                        BluetoothPeripheral.access$902(BluetoothPeripheral.this, byArray);
                        bluetoothGattDescriptor.setValue(byArray);
                        if (BluetoothPeripheral.this.bluetoothGatt.writeDescriptor(bluetoothGattDescriptor)) {
                            BluetoothPeripheral.access$3308(BluetoothPeripheral.this);
                        } else {
                            Logger.e(TAG, "writeDescriptor failed for descriptor: %s", bluetoothGattDescriptor.getUuid());
                            BluetoothPeripheral.this.completedCommand();
                        }
                    }
                });
            }
            throw new IllegalArgumentException(String.format("characteristic %s does not have notify or indicate property", bluetoothGattCharacteristic.getUuid()));
        }
        throw new IllegalArgumentException(String.format("could not get CCC descriptor for characteristic %s", bluetoothGattCharacteristic.getUuid()));
    }

    public boolean setNotify(UUID uUID, UUID uUID2, boolean bl) {
        Objects.requireNonNull(uUID, NO_VALID_SERVICE_UUID_PROVIDED);
        Objects.requireNonNull(uUID2, NO_VALID_CHARACTERISTIC_UUID_PROVIDED);
        uUID = this.getCharacteristic(uUID, uUID2);
        if (uUID != null) {
            return this.setNotify((BluetoothGattCharacteristic)uUID, bl);
        }
        return false;
    }

    void setPeripheralCallback(BluetoothPeripheralCallback bluetoothPeripheralCallback) {
        Objects.requireNonNull(bluetoothPeripheralCallback, NO_VALID_PERIPHERAL_CALLBACK_PROVIDED);
        BluetoothPeripheralCallback bluetoothPeripheralCallback2 = bluetoothPeripheralCallback;
        this.peripheralCallback = bluetoothPeripheralCallback;
    }

    public boolean setPreferredPhy(final PhyType phyType, final PhyType phyType2, final PhyOptions phyOptions) {
        Objects.requireNonNull(phyType);
        Objects.requireNonNull(phyType2);
        Objects.requireNonNull(phyOptions);
        if (this.notConnected()) {
            Logger.e(TAG, PERIPHERAL_NOT_CONNECTED);
            return false;
        }
        if (Build.VERSION.SDK_INT < 26) {
            Logger.e(TAG, "setPreferredPhy requires Android 8.0 or newer");
            return false;
        }
        return this.enqueue(new Runnable(){

            @Override
            public void run() {
                if (BluetoothPeripheral.this.isConnected()) {
                    if (Build.VERSION.SDK_INT >= 26) {
                        BluetoothPeripheral.access$1402(BluetoothPeripheral.this, 2);
                        Logger.i(TAG, "setting preferred Phy: tx = %s, rx = %s, options = %s", new Object[]{phyType, phyType2, phyOptions});
                        BluetoothPeripheral.this.bluetoothGatt.setPreferredPhy(phyType.mask, phyType2.mask, phyOptions.value);
                    }
                } else {
                    BluetoothPeripheral.this.completedCommand();
                }
            }
        });
    }

    public boolean writeCharacteristic(BluetoothGattCharacteristic bluetoothGattCharacteristic, byte[] byArray, WriteType writeType) {
        Objects.requireNonNull(bluetoothGattCharacteristic, NO_VALID_CHARACTERISTIC_PROVIDED);
        Objects.requireNonNull(byArray, NO_VALID_VALUE_PROVIDED);
        Objects.requireNonNull(writeType, NO_VALID_WRITE_TYPE_PROVIDED);
        if (this.notConnected()) {
            Logger.e(TAG, PERIPHERAL_NOT_CONNECTED);
            return false;
        }
        if (byArray.length != 0) {
            if (byArray.length <= this.getMaximumWriteValueLength(writeType)) {
                if (!this.doesNotSupportWriteType(bluetoothGattCharacteristic, writeType)) {
                    return this.enqueue(new Runnable(this.copyOf(byArray), bluetoothGattCharacteristic, writeType){
                        final /* synthetic */ byte[] val$bytesToWrite;
                        final /* synthetic */ BluetoothGattCharacteristic val$characteristic;
                        final /* synthetic */ WriteType val$writeType;
                        {
                            this.val$bytesToWrite = byArray;
                            this.val$characteristic = bluetoothGattCharacteristic;
                            this.val$writeType = writeType;
                        }

                        @Override
                        public void run() {
                            if (BluetoothPeripheral.this.isConnected()) {
                                BluetoothPeripheral.access$902(BluetoothPeripheral.this, this.val$bytesToWrite);
                                this.val$characteristic.setWriteType(this.val$writeType.writeType);
                                if (BluetoothPeripheral.this.willCauseLongWrite(this.val$bytesToWrite, this.val$writeType)) {
                                    Logger.w(TAG, "value byte array is longer than allowed by MTU, write will fail if peripheral does not support long writes");
                                }
                                this.val$characteristic.setValue(this.val$bytesToWrite);
                                if (BluetoothPeripheral.this.bluetoothGatt.writeCharacteristic(this.val$characteristic)) {
                                    Logger.d(TAG, "writing <%s> to characteristic <%s>", BluetoothBytesParser.bytes2String(this.val$bytesToWrite), this.val$characteristic.getUuid());
                                    BluetoothPeripheral.access$3308(BluetoothPeripheral.this);
                                } else {
                                    Logger.e(TAG, "writeCharacteristic failed for characteristic: %s", this.val$characteristic.getUuid());
                                    BluetoothPeripheral.this.completedCommand();
                                }
                            } else {
                                BluetoothPeripheral.this.completedCommand();
                            }
                        }
                    });
                }
                throw new IllegalArgumentException(String.format("characteristic <%s> does not support writeType '%s'", new Object[]{bluetoothGattCharacteristic.getUuid(), writeType}));
            }
            throw new IllegalArgumentException(VALUE_BYTE_ARRAY_IS_TOO_LONG);
        }
        throw new IllegalArgumentException(VALUE_BYTE_ARRAY_IS_EMPTY);
    }

    public boolean writeCharacteristic(UUID uUID, UUID uUID2, byte[] byArray, WriteType writeType) {
        Objects.requireNonNull(uUID, NO_VALID_SERVICE_UUID_PROVIDED);
        Objects.requireNonNull(uUID2, NO_VALID_CHARACTERISTIC_UUID_PROVIDED);
        Objects.requireNonNull(byArray, NO_VALID_VALUE_PROVIDED);
        Objects.requireNonNull(writeType, NO_VALID_WRITE_TYPE_PROVIDED);
        uUID = this.getCharacteristic(uUID, uUID2);
        if (uUID != null) {
            return this.writeCharacteristic((BluetoothGattCharacteristic)uUID, byArray, writeType);
        }
        return false;
    }

    public boolean writeDescriptor(BluetoothGattDescriptor bluetoothGattDescriptor, byte[] byArray) {
        Objects.requireNonNull(bluetoothGattDescriptor, NO_VALID_DESCRIPTOR_PROVIDED);
        Objects.requireNonNull(byArray, NO_VALID_VALUE_PROVIDED);
        if (this.notConnected()) {
            Logger.e(TAG, PERIPHERAL_NOT_CONNECTED);
            return false;
        }
        if (byArray.length != 0) {
            if (byArray.length <= this.getMaximumWriteValueLength(WriteType.WITH_RESPONSE)) {
                return this.enqueue(new Runnable(this.copyOf(byArray), bluetoothGattDescriptor){
                    final /* synthetic */ byte[] val$bytesToWrite;
                    final /* synthetic */ BluetoothGattDescriptor val$descriptor;
                    {
                        this.val$bytesToWrite = byArray;
                        this.val$descriptor = bluetoothGattDescriptor;
                    }

                    @Override
                    public void run() {
                        if (BluetoothPeripheral.this.isConnected()) {
                            BluetoothPeripheral.access$902(BluetoothPeripheral.this, this.val$bytesToWrite);
                            this.val$descriptor.setValue(this.val$bytesToWrite);
                            if (BluetoothPeripheral.this.bluetoothGatt.writeDescriptor(this.val$descriptor)) {
                                Logger.d(TAG, "writing <%s> to descriptor <%s>", BluetoothBytesParser.bytes2String(this.val$bytesToWrite), this.val$descriptor.getUuid());
                                BluetoothPeripheral.access$3308(BluetoothPeripheral.this);
                            } else {
                                Logger.e(TAG, "writeDescriptor failed for descriptor: %s", this.val$descriptor.getUuid());
                                BluetoothPeripheral.this.completedCommand();
                            }
                        } else {
                            BluetoothPeripheral.this.completedCommand();
                        }
                    }
                });
            }
            throw new IllegalArgumentException(VALUE_BYTE_ARRAY_IS_TOO_LONG);
        }
        throw new IllegalArgumentException(VALUE_BYTE_ARRAY_IS_EMPTY);
    }

    static interface InternalCallback {
        public void connectFailed(BluetoothPeripheral var1, HciStatus var2);

        public void connected(BluetoothPeripheral var1);

        public void connecting(BluetoothPeripheral var1);

        public void disconnected(BluetoothPeripheral var1, HciStatus var2);

        public void disconnecting(BluetoothPeripheral var1);

        public String getPincode(BluetoothPeripheral var1);
    }
}

