/*
 * Decompiled with CFR 0.152.
 */
package com.welie.blessed;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattServer;
import android.bluetooth.BluetoothGattServerCallback;
import android.bluetooth.BluetoothGattService;
import android.bluetooth.BluetoothManager;
import android.bluetooth.le.AdvertiseCallback;
import android.bluetooth.le.AdvertiseData;
import android.bluetooth.le.AdvertiseSettings;
import android.bluetooth.le.BluetoothLeAdvertiser;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.Looper;
import com.welie.blessed.AdvertiseError;
import com.welie.blessed.BluetoothBytesParser;
import com.welie.blessed.BluetoothCentral;
import com.welie.blessed.BluetoothPeripheralManagerCallback;
import com.welie.blessed.GattStatus;
import com.welie.blessed.Logger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public class BluetoothPeripheralManager {
    private static final String ADDRESS_IS_NULL = "address is null";
    private static final String BLUETOOTH_MANAGER_IS_NULL = "BluetoothManager is null";
    protected static final UUID CCC_DESCRIPTOR_UUID = UUID.fromString("00002902-0000-1000-8000-00805f9b34fb");
    private static final String CENTRAL_IS_NULL = "central is null";
    private static final String CHARACTERISTIC_IS_NULL = "characteristic is null";
    private static final String CHARACTERISTIC_VALUE_IS_NULL = "characteristic value is null";
    private static final String CONTEXT_IS_NULL = "context is null";
    private static final String DEVICE_IS_NULL = "device is null";
    private static final String SERVICE_IS_NULL = "service is null";
    private static final String TAG = "BluetoothPeripheralManager";
    private final BroadcastReceiver adapterStateReceiver;
    protected final AdvertiseCallback advertiseCallback;
    private final BluetoothAdapter bluetoothAdapter;
    private final BluetoothGattServer bluetoothGattServer;
    protected final BluetoothGattServerCallback bluetoothGattServerCallback;
    private final BluetoothLeAdvertiser bluetoothLeAdvertiser;
    private final BluetoothManager bluetoothManager;
    private final BluetoothPeripheralManagerCallback callback;
    protected final Queue<Runnable> commandQueue;
    private volatile boolean commandQueueBusy = false;
    private final Map<String, BluetoothCentral> connectedCentralsMap;
    private final Context context;
    private BluetoothGattCharacteristic currentNotifyCharacteristic = null;
    private byte[] currentNotifyValue;
    private final Handler mainHandler = new Handler(Looper.getMainLooper());
    private final HashMap<BluetoothGattCharacteristic, byte[]> writeLongCharacteristicTemporaryBytes;
    private final HashMap<BluetoothGattDescriptor, byte[]> writeLongDescriptorTemporaryBytes;

    public BluetoothPeripheralManager(Context context, BluetoothManager bluetoothManager, BluetoothPeripheralManagerCallback bluetoothPeripheralManagerCallback) {
        BroadcastReceiver broadcastReceiver;
        BluetoothGattServerCallback bluetoothGattServerCallback;
        this.commandQueue = new ConcurrentLinkedQueue<Runnable>();
        this.writeLongCharacteristicTemporaryBytes = new HashMap();
        this.writeLongDescriptorTemporaryBytes = new HashMap();
        this.connectedCentralsMap = new ConcurrentHashMap<String, BluetoothCentral>();
        this.currentNotifyValue = new byte[0];
        this.bluetoothGattServerCallback = bluetoothGattServerCallback = new BluetoothGattServerCallback(){

            private GattStatus checkCccDescriptorValue(byte[] byArray, BluetoothGattCharacteristic bluetoothGattCharacteristic) {
                GattStatus gattStatus;
                GattStatus gattStatus2 = GattStatus.SUCCESS;
                if (byArray.length != 2) {
                    gattStatus = GattStatus.INVALID_ATTRIBUTE_VALUE_LENGTH;
                } else if (!(Arrays.equals(byArray, BluetoothGattDescriptor.ENABLE_INDICATION_VALUE) || Arrays.equals(byArray, BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE) || Arrays.equals(byArray, BluetoothGattDescriptor.DISABLE_NOTIFICATION_VALUE))) {
                    gattStatus = GattStatus.VALUE_NOT_ALLOWED;
                } else if (!BluetoothPeripheralManager.this.supportsIndicate(bluetoothGattCharacteristic) && Arrays.equals(byArray, BluetoothGattDescriptor.ENABLE_INDICATION_VALUE)) {
                    gattStatus = GattStatus.REQUEST_NOT_SUPPORTED;
                } else {
                    gattStatus = gattStatus2;
                    if (!BluetoothPeripheralManager.this.supportsNotify(bluetoothGattCharacteristic)) {
                        gattStatus = gattStatus2;
                        if (Arrays.equals(byArray, BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE)) {
                            gattStatus = GattStatus.REQUEST_NOT_SUPPORTED;
                        }
                    }
                }
                return gattStatus;
            }

            private void handleDeviceConnected(BluetoothDevice object) {
                Logger.i(TAG, "Central '%s' (%s) connected", object.getName(), object.getAddress());
                object = new BluetoothCentral(object.getAddress(), object.getName());
                BluetoothPeripheralManager.this.connectedCentralsMap.put(((BluetoothCentral)object).getAddress(), object);
                BluetoothPeripheralManager.this.mainHandler.post(new Runnable((BluetoothCentral)object){
                    final /* synthetic */ BluetoothCentral val$bluetoothCentral;
                    {
                        this.val$bluetoothCentral = bluetoothCentral;
                    }

                    @Override
                    public void run() {
                        BluetoothPeripheralManager.this.callback.onCentralConnected(this.val$bluetoothCentral);
                    }
                });
            }

            private void handleDeviceDisconnected(BluetoothDevice bluetoothDevice) {
                final BluetoothCentral bluetoothCentral = BluetoothPeripheralManager.this.getCentral(bluetoothDevice);
                Logger.i(TAG, "Central '%s' (%s) disconnected", bluetoothCentral.getName(), bluetoothCentral.getAddress());
                BluetoothPeripheralManager.this.mainHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        BluetoothPeripheralManager.this.callback.onCentralDisconnected(bluetoothCentral);
                    }
                });
                BluetoothPeripheralManager.this.removeCentral(bluetoothDevice);
            }

            public void onCharacteristicReadRequest(final BluetoothDevice bluetoothDevice, final int n, final int n2, final BluetoothGattCharacteristic bluetoothGattCharacteristic) {
                Logger.i(TAG, "read request for characteristic <%s> with offset %d", bluetoothGattCharacteristic.getUuid(), n2);
                final BluetoothCentral bluetoothCentral = BluetoothPeripheralManager.this.getCentral(bluetoothDevice);
                BluetoothPeripheralManager.this.mainHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (n2 == 0) {
                            BluetoothPeripheralManager.this.callback.onCharacteristicRead(bluetoothCentral, bluetoothGattCharacteristic);
                        }
                        byte[] byArray = BluetoothPeripheralManager.this.chopValue(bluetoothGattCharacteristic.getValue(), n2);
                        BluetoothPeripheralManager.this.bluetoothGattServer.sendResponse(bluetoothDevice, n, 0, n2, byArray);
                    }
                });
            }

            public void onCharacteristicWriteRequest(BluetoothDevice bluetoothDevice, int n, BluetoothGattCharacteristic bluetoothGattCharacteristic, final boolean bl, boolean bl2, int n2, byte[] byArray) {
                String string2 = TAG;
                Object object = bl2 ? "WITH_RESPONSE" : "WITHOUT_RESPONSE";
                Logger.i(string2, "write characteristic %s request <%s> offset %d for <%s>", object, BluetoothBytesParser.bytes2String(byArray), n2, bluetoothGattCharacteristic.getUuid());
                byArray = BluetoothPeripheralManager.this.nonnullOf(byArray);
                object = BluetoothPeripheralManager.this.getCentral(bluetoothDevice);
                BluetoothPeripheralManager.this.mainHandler.post(new Runnable((BluetoothCentral)object, bluetoothGattCharacteristic, byArray, n2, bl2, bluetoothDevice, n){
                    final /* synthetic */ BluetoothCentral val$bluetoothCentral;
                    final /* synthetic */ BluetoothGattCharacteristic val$characteristic;
                    final /* synthetic */ BluetoothDevice val$device;
                    final /* synthetic */ int val$offset;
                    final /* synthetic */ int val$requestId;
                    final /* synthetic */ boolean val$responseNeeded;
                    final /* synthetic */ byte[] val$safeValue;
                    {
                        this.val$bluetoothCentral = bluetoothCentral;
                        this.val$characteristic = bluetoothGattCharacteristic;
                        this.val$safeValue = byArray;
                        this.val$offset = n;
                        this.val$responseNeeded = bl2;
                        this.val$device = bluetoothDevice;
                        this.val$requestId = n2;
                    }

                    @Override
                    public void run() {
                        GattStatus gattStatus = GattStatus.SUCCESS;
                        if (!bl) {
                            GattStatus gattStatus2;
                            gattStatus = gattStatus2 = BluetoothPeripheralManager.this.callback.onCharacteristicWrite(this.val$bluetoothCentral, this.val$characteristic, this.val$safeValue);
                            if (gattStatus2 == GattStatus.SUCCESS) {
                                this.val$characteristic.setValue(this.val$safeValue);
                                gattStatus = gattStatus2;
                            }
                        } else if (this.val$offset == 0) {
                            BluetoothPeripheralManager.this.writeLongCharacteristicTemporaryBytes.put(this.val$characteristic, this.val$safeValue);
                        } else {
                            byte[] byArray = (byte[])BluetoothPeripheralManager.this.writeLongCharacteristicTemporaryBytes.get(this.val$characteristic);
                            if (byArray != null && this.val$offset == byArray.length) {
                                BluetoothPeripheralManager.this.writeLongCharacteristicTemporaryBytes.put(this.val$characteristic, BluetoothBytesParser.mergeArrays(byArray, this.val$safeValue));
                            } else {
                                gattStatus = GattStatus.INVALID_OFFSET;
                            }
                        }
                        if (this.val$responseNeeded) {
                            BluetoothPeripheralManager.this.bluetoothGattServer.sendResponse(this.val$device, this.val$requestId, gattStatus.value, this.val$offset, this.val$safeValue);
                        }
                    }
                });
            }

            public void onConnectionStateChange(BluetoothDevice bluetoothDevice, int n, int n2) {
                if (n == 0) {
                    if (n2 == 2) {
                        if (BluetoothPeripheralManager.this.connectedCentralsMap.containsKey(bluetoothDevice.getAddress())) {
                            return;
                        }
                        BluetoothPeripheralManager.this.bluetoothGattServer.connect(bluetoothDevice, false);
                        this.handleDeviceConnected(bluetoothDevice);
                    } else if (n2 == 0) {
                        if (!BluetoothPeripheralManager.this.connectedCentralsMap.containsKey(bluetoothDevice.getAddress())) {
                            return;
                        }
                        this.handleDeviceDisconnected(bluetoothDevice);
                    }
                } else {
                    Logger.i(TAG, "Device '%s' disconnected with status %d", bluetoothDevice.getName(), n);
                    this.handleDeviceDisconnected(bluetoothDevice);
                }
            }

            public void onDescriptorReadRequest(final BluetoothDevice bluetoothDevice, final int n, final int n2, final BluetoothGattDescriptor bluetoothGattDescriptor) {
                Logger.i(TAG, "read request for descriptor <%s> with offset %d", bluetoothGattDescriptor.getUuid(), n2);
                final BluetoothCentral bluetoothCentral = BluetoothPeripheralManager.this.getCentral(bluetoothDevice);
                BluetoothPeripheralManager.this.mainHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (n2 == 0) {
                            BluetoothPeripheralManager.this.callback.onDescriptorRead(bluetoothCentral, bluetoothGattDescriptor);
                        }
                        byte[] byArray = BluetoothPeripheralManager.this.chopValue(bluetoothGattDescriptor.getValue(), n2);
                        BluetoothPeripheralManager.this.bluetoothGattServer.sendResponse(bluetoothDevice, n, 0, n2, byArray);
                    }
                });
            }

            public void onDescriptorWriteRequest(BluetoothDevice bluetoothDevice, int n, final BluetoothGattDescriptor bluetoothGattDescriptor, final boolean bl, boolean bl2, int n2, byte[] object) {
                final byte[] byArray = BluetoothPeripheralManager.this.nonnullOf(object);
                final BluetoothGattCharacteristic bluetoothGattCharacteristic = bluetoothGattDescriptor.getCharacteristic();
                Objects.requireNonNull(bluetoothGattCharacteristic, "Descriptor does not have characteristic");
                Object object2 = bluetoothGattCharacteristic;
                String string2 = TAG;
                object2 = bl2 ? "WITH_RESPONSE" : "WITHOUT_RESPONSE";
                Logger.i(string2, "write descriptor %s request <%s> offset %d for <%s>", object2, BluetoothBytesParser.bytes2String(object), n2, bluetoothGattDescriptor.getUuid());
                object = BluetoothPeripheralManager.this.getCentral(bluetoothDevice);
                BluetoothPeripheralManager.this.mainHandler.post(new Runnable((BluetoothCentral)object, n2, bl2, bluetoothDevice, n){
                    final /* synthetic */ BluetoothCentral val$bluetoothCentral;
                    final /* synthetic */ BluetoothDevice val$device;
                    final /* synthetic */ int val$offset;
                    final /* synthetic */ int val$requestId;
                    final /* synthetic */ boolean val$responseNeeded;
                    {
                        this.val$bluetoothCentral = bluetoothCentral;
                        this.val$offset = n;
                        this.val$responseNeeded = bl2;
                        this.val$device = bluetoothDevice;
                        this.val$requestId = n2;
                    }

                    @Override
                    public void run() {
                        GattStatus gattStatus = GattStatus.SUCCESS;
                        if (bluetoothGattDescriptor.getUuid().equals(CCC_DESCRIPTOR_UUID)) {
                            gattStatus = this.checkCccDescriptorValue(byArray, bluetoothGattCharacteristic);
                        } else if (!bl) {
                            gattStatus = BluetoothPeripheralManager.this.callback.onDescriptorWrite(this.val$bluetoothCentral, bluetoothGattDescriptor, byArray);
                        } else if (this.val$offset == 0) {
                            BluetoothPeripheralManager.this.writeLongDescriptorTemporaryBytes.put(bluetoothGattDescriptor, byArray);
                        } else {
                            byte[] byArray2 = (byte[])BluetoothPeripheralManager.this.writeLongDescriptorTemporaryBytes.get(bluetoothGattDescriptor);
                            if (byArray2 != null && this.val$offset == byArray2.length) {
                                BluetoothPeripheralManager.this.writeLongDescriptorTemporaryBytes.put(bluetoothGattDescriptor, BluetoothBytesParser.mergeArrays(byArray2, byArray));
                            } else {
                                gattStatus = GattStatus.INVALID_OFFSET;
                            }
                        }
                        if (gattStatus == GattStatus.SUCCESS && !bl) {
                            bluetoothGattDescriptor.setValue(byArray);
                        }
                        if (this.val$responseNeeded) {
                            BluetoothPeripheralManager.this.bluetoothGattServer.sendResponse(this.val$device, this.val$requestId, gattStatus.value, this.val$offset, byArray);
                        }
                        if (gattStatus == GattStatus.SUCCESS && bluetoothGattDescriptor.getUuid().equals(CCC_DESCRIPTOR_UUID)) {
                            if (!Arrays.equals(byArray, BluetoothGattDescriptor.ENABLE_INDICATION_VALUE) && !Arrays.equals(byArray, BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE)) {
                                Logger.i(TAG, "notifying disabled for <%s>", bluetoothGattCharacteristic.getUuid());
                                BluetoothPeripheralManager.this.callback.onNotifyingDisabled(this.val$bluetoothCentral, bluetoothGattCharacteristic);
                            } else {
                                Logger.i(TAG, "notifying enabled for <%s>", bluetoothGattCharacteristic.getUuid());
                                BluetoothPeripheralManager.this.callback.onNotifyingEnabled(this.val$bluetoothCentral, bluetoothGattCharacteristic);
                            }
                        }
                    }
                });
            }

            public void onExecuteWrite(final BluetoothDevice bluetoothDevice, final int n, boolean bl) {
                final BluetoothCentral bluetoothCentral = BluetoothPeripheralManager.this.getCentral(bluetoothDevice);
                if (bl) {
                    BluetoothPeripheralManager.this.mainHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            GattStatus gattStatus;
                            GattStatus gattStatus2 = GattStatus.SUCCESS;
                            if (!BluetoothPeripheralManager.this.writeLongCharacteristicTemporaryBytes.isEmpty()) {
                                BluetoothGattCharacteristic bluetoothGattCharacteristic = (BluetoothGattCharacteristic)BluetoothPeripheralManager.this.writeLongCharacteristicTemporaryBytes.keySet().iterator().next();
                                gattStatus = gattStatus2;
                                if (bluetoothGattCharacteristic != null) {
                                    gattStatus = gattStatus2 = BluetoothPeripheralManager.this.callback.onCharacteristicWrite(bluetoothCentral, bluetoothGattCharacteristic, (byte[])BluetoothPeripheralManager.this.writeLongCharacteristicTemporaryBytes.get(bluetoothGattCharacteristic));
                                    if (gattStatus2 == GattStatus.SUCCESS) {
                                        bluetoothGattCharacteristic.setValue((byte[])BluetoothPeripheralManager.this.writeLongCharacteristicTemporaryBytes.get(bluetoothGattCharacteristic));
                                        BluetoothPeripheralManager.this.writeLongCharacteristicTemporaryBytes.clear();
                                        gattStatus = gattStatus2;
                                    }
                                }
                            } else {
                                gattStatus = gattStatus2;
                                if (!BluetoothPeripheralManager.this.writeLongDescriptorTemporaryBytes.isEmpty()) {
                                    BluetoothGattDescriptor bluetoothGattDescriptor = (BluetoothGattDescriptor)BluetoothPeripheralManager.this.writeLongDescriptorTemporaryBytes.keySet().iterator().next();
                                    gattStatus = gattStatus2;
                                    if (bluetoothGattDescriptor != null) {
                                        gattStatus = gattStatus2 = BluetoothPeripheralManager.this.callback.onDescriptorWrite(bluetoothCentral, bluetoothGattDescriptor, (byte[])BluetoothPeripheralManager.this.writeLongDescriptorTemporaryBytes.get(bluetoothGattDescriptor));
                                        if (gattStatus2 == GattStatus.SUCCESS) {
                                            bluetoothGattDescriptor.setValue((byte[])BluetoothPeripheralManager.this.writeLongDescriptorTemporaryBytes.get(bluetoothGattDescriptor));
                                            BluetoothPeripheralManager.this.writeLongDescriptorTemporaryBytes.clear();
                                            gattStatus = gattStatus2;
                                        }
                                    }
                                }
                            }
                            BluetoothPeripheralManager.this.bluetoothGattServer.sendResponse(bluetoothDevice, n, gattStatus.value, 0, null);
                        }
                    });
                } else {
                    BluetoothPeripheralManager.this.writeLongCharacteristicTemporaryBytes.clear();
                    BluetoothPeripheralManager.this.writeLongDescriptorTemporaryBytes.clear();
                    BluetoothPeripheralManager.this.bluetoothGattServer.sendResponse(bluetoothDevice, n, GattStatus.SUCCESS.value, 0, null);
                }
            }

            public void onMtuChanged(BluetoothDevice bluetoothDevice, int n) {
                Logger.i(TAG, "new MTU: %d", n);
                BluetoothPeripheralManager.this.getCentral(bluetoothDevice).setCurrentMtu(n);
            }

            public void onNotificationSent(BluetoothDevice bluetoothDevice, int n) {
                final BluetoothCentral bluetoothCentral = BluetoothPeripheralManager.this.getCentral(bluetoothDevice);
                bluetoothDevice = BluetoothPeripheralManager.this.currentNotifyCharacteristic;
                Objects.requireNonNull(bluetoothDevice);
                Object object = (BluetoothGattCharacteristic)bluetoothDevice;
                object = BluetoothPeripheralManager.this.currentNotifyValue;
                Objects.requireNonNull(object);
                object = (byte[])object;
                BluetoothPeripheralManager.access$1602(BluetoothPeripheralManager.this, new byte[0]);
                BluetoothPeripheralManager.this.mainHandler.post(new Runnable((byte[])object, (BluetoothGattCharacteristic)bluetoothDevice, n){
                    final /* synthetic */ BluetoothGattCharacteristic val$characteristic;
                    final /* synthetic */ int val$status;
                    final /* synthetic */ byte[] val$value;
                    {
                        this.val$value = byArray;
                        this.val$characteristic = bluetoothGattCharacteristic;
                        this.val$status = n;
                    }

                    @Override
                    public void run() {
                        BluetoothPeripheralManager.this.callback.onNotificationSent(bluetoothCentral, this.val$value, this.val$characteristic, GattStatus.fromValue(this.val$status));
                    }
                });
                BluetoothPeripheralManager.this.completedCommand();
            }

            public void onPhyRead(BluetoothDevice bluetoothDevice, int n, int n2, int n3) {
                super.onPhyRead(bluetoothDevice, n, n2, n3);
            }

            public void onPhyUpdate(BluetoothDevice bluetoothDevice, int n, int n2, int n3) {
                super.onPhyUpdate(bluetoothDevice, n, n2, n3);
            }

            public void onServiceAdded(final int n, final BluetoothGattService bluetoothGattService) {
                BluetoothPeripheralManager.this.mainHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        BluetoothPeripheralManager.this.callback.onServiceAdded(GattStatus.fromValue(n), bluetoothGattService);
                    }
                });
                BluetoothPeripheralManager.this.completedCommand();
            }
        };
        this.advertiseCallback = new AdvertiseCallback(){

            public void onStartFailure(int n) {
                final AdvertiseError advertiseError = AdvertiseError.fromValue(n);
                Logger.e(TAG, "advertising failed with error '%s'", new Object[]{advertiseError});
                BluetoothPeripheralManager.this.mainHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        BluetoothPeripheralManager.this.callback.onAdvertiseFailure(advertiseError);
                    }
                });
            }

            public void onStartSuccess(final AdvertiseSettings advertiseSettings) {
                Logger.i(TAG, "advertising started");
                BluetoothPeripheralManager.this.mainHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        BluetoothPeripheralManager.this.callback.onAdvertisingStarted(advertiseSettings);
                    }
                });
            }
        };
        this.adapterStateReceiver = broadcastReceiver = new BroadcastReceiver(){

            public void onReceive(Context object, Intent intent) {
                object = intent.getAction();
                if (object == null) {
                    return;
                }
                if (((String)object).equals("android.bluetooth.adapter.action.STATE_CHANGED")) {
                    int n = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", Integer.MIN_VALUE);
                    BluetoothPeripheralManager.this.handleAdapterState(n);
                }
            }
        };
        Objects.requireNonNull(context, CONTEXT_IS_NULL);
        Object object = context;
        this.context = context;
        Objects.requireNonNull(bluetoothPeripheralManagerCallback, "Callback is null");
        object = bluetoothPeripheralManagerCallback;
        this.callback = bluetoothPeripheralManagerCallback;
        Objects.requireNonNull(bluetoothManager, BLUETOOTH_MANAGER_IS_NULL);
        bluetoothPeripheralManagerCallback = bluetoothManager;
        this.bluetoothManager = bluetoothManager;
        bluetoothPeripheralManagerCallback = bluetoothManager.getAdapter();
        this.bluetoothAdapter = bluetoothPeripheralManagerCallback;
        this.bluetoothLeAdvertiser = bluetoothPeripheralManagerCallback.getBluetoothLeAdvertiser();
        this.bluetoothGattServer = bluetoothManager.openGattServer(context, bluetoothGattServerCallback);
        context.registerReceiver(broadcastReceiver, new IntentFilter("android.bluetooth.adapter.action.STATE_CHANGED"));
    }

    static /* synthetic */ BluetoothGattCharacteristic access$1502(BluetoothPeripheralManager bluetoothPeripheralManager, BluetoothGattCharacteristic bluetoothGattCharacteristic) {
        bluetoothPeripheralManager.currentNotifyCharacteristic = bluetoothGattCharacteristic;
        return bluetoothGattCharacteristic;
    }

    static /* synthetic */ byte[] access$1602(BluetoothPeripheralManager bluetoothPeripheralManager, byte[] byArray) {
        bluetoothPeripheralManager.currentNotifyValue = byArray;
        return byArray;
    }

    private void cancelAllConnectionsWhenBluetoothOff() {
        for (BluetoothCentral bluetoothCentral : this.getConnectedCentrals()) {
            this.bluetoothGattServerCallback.onConnectionStateChange(this.bluetoothAdapter.getRemoteDevice(bluetoothCentral.getAddress()), 0, 0);
        }
        this.onAdvertisingStopped();
    }

    private void cancelConnection(BluetoothDevice bluetoothDevice) {
        Objects.requireNonNull(bluetoothDevice, DEVICE_IS_NULL);
        Logger.i(TAG, "cancelConnection with '%s' (%s)", bluetoothDevice.getName(), bluetoothDevice.getAddress());
        this.bluetoothGattServer.cancelConnection(bluetoothDevice);
    }

    private byte[] chopValue(byte[] byArray, int n) {
        byte[] byArray2 = new byte[]{};
        if (byArray == null) {
            return byArray2;
        }
        if (n <= byArray.length) {
            byArray2 = Arrays.copyOfRange(byArray, n, byArray.length);
        }
        return byArray2;
    }

    private void completedCommand() {
        this.commandQueue.poll();
        this.commandQueueBusy = false;
        this.nextCommand();
    }

    private boolean doesNotSupportNotifying(BluetoothGattCharacteristic bluetoothGattCharacteristic) {
        boolean bl = !this.supportsIndicate(bluetoothGattCharacteristic) && !this.supportsNotify(bluetoothGattCharacteristic);
        return bl;
    }

    private boolean enqueue(Runnable runnable) {
        boolean bl = this.commandQueue.add(runnable);
        if (bl) {
            this.nextCommand();
        } else {
            Logger.e(TAG, "could not enqueue command");
        }
        return bl;
    }

    private BluetoothCentral getCentral(BluetoothDevice bluetoothDevice) {
        BluetoothCentral bluetoothCentral;
        Objects.requireNonNull(bluetoothDevice, DEVICE_IS_NULL);
        BluetoothCentral bluetoothCentral2 = bluetoothCentral = this.connectedCentralsMap.get(bluetoothDevice.getAddress());
        if (bluetoothCentral == null) {
            bluetoothCentral2 = new BluetoothCentral(bluetoothDevice.getAddress(), bluetoothDevice.getName());
        }
        return bluetoothCentral2;
    }

    private List<BluetoothDevice> getConnectedDevices() {
        return this.bluetoothManager.getConnectedDevices(7);
    }

    private void handleAdapterState(int n) {
        switch (n) {
            default: {
                break;
            }
            case 13: {
                Logger.d(TAG, "bluetooth turning off");
                break;
            }
            case 12: {
                Logger.d(TAG, "bluetooth turned on");
                break;
            }
            case 11: {
                Logger.d(TAG, "bluetooth turning on");
                break;
            }
            case 10: {
                Logger.d(TAG, "bluetooth turned off");
                this.cancelAllConnectionsWhenBluetoothOff();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void nextCommand() {
        synchronized (this) {
            if (this.commandQueueBusy) {
                return;
            }
            final Runnable runnable = this.commandQueue.peek();
            if (runnable == null) {
                return;
            }
            this.commandQueueBusy = true;
            Handler handler = this.mainHandler;
            Runnable runnable2 = new Runnable(){

                @Override
                public void run() {
                    try {
                        runnable.run();
                    }
                    catch (Exception exception) {
                        Logger.e(TAG, "command exception");
                        Logger.e(TAG, exception.toString());
                        BluetoothPeripheralManager.this.completedCommand();
                    }
                }
            };
            handler.post(runnable2);
            return;
        }
    }

    private byte[] nonnullOf(byte[] byArray) {
        byte[] byArray2 = byArray;
        if (byArray == null) {
            byArray2 = new byte[]{};
        }
        return byArray2;
    }

    private boolean notifyCharacteristicChanged(final byte[] byArray, final BluetoothDevice bluetoothDevice, final BluetoothGattCharacteristic bluetoothGattCharacteristic) {
        Objects.requireNonNull(byArray, CHARACTERISTIC_VALUE_IS_NULL);
        Objects.requireNonNull(bluetoothDevice, DEVICE_IS_NULL);
        Objects.requireNonNull(bluetoothGattCharacteristic, CHARACTERISTIC_IS_NULL);
        Objects.requireNonNull(bluetoothGattCharacteristic.getValue(), CHARACTERISTIC_VALUE_IS_NULL);
        if (this.doesNotSupportNotifying(bluetoothGattCharacteristic)) {
            return false;
        }
        byte[] byArray2 = bluetoothGattCharacteristic.getDescriptor(CCC_DESCRIPTOR_UUID).getValue();
        final boolean bl = this.supportsIndicate(bluetoothGattCharacteristic) && Arrays.equals(byArray2, BluetoothGattDescriptor.ENABLE_INDICATION_VALUE);
        return this.enqueue(new Runnable(){

            @Override
            public void run() {
                BluetoothPeripheralManager.access$1602(BluetoothPeripheralManager.this, byArray);
                BluetoothPeripheralManager.access$1502(BluetoothPeripheralManager.this, bluetoothGattCharacteristic);
                bluetoothGattCharacteristic.setValue(byArray);
                if (!BluetoothPeripheralManager.this.bluetoothGattServer.notifyCharacteristicChanged(bluetoothDevice, bluetoothGattCharacteristic, bl)) {
                    Logger.e(TAG, "notifying characteristic changed failed for <%s>", bluetoothGattCharacteristic.getUuid());
                    BluetoothPeripheralManager.this.completedCommand();
                }
            }
        });
    }

    private void removeCentral(BluetoothDevice bluetoothDevice) {
        Objects.requireNonNull(bluetoothDevice, DEVICE_IS_NULL);
        this.connectedCentralsMap.remove(bluetoothDevice.getAddress());
    }

    private boolean supportsIndicate(BluetoothGattCharacteristic bluetoothGattCharacteristic) {
        boolean bl = (bluetoothGattCharacteristic.getProperties() & 0x20) > 0;
        return bl;
    }

    private boolean supportsNotify(BluetoothGattCharacteristic bluetoothGattCharacteristic) {
        boolean bl = (bluetoothGattCharacteristic.getProperties() & 0x10) > 0;
        return bl;
    }

    public boolean add(final BluetoothGattService bluetoothGattService) {
        Objects.requireNonNull(bluetoothGattService, SERVICE_IS_NULL);
        return this.enqueue(new Runnable(){

            @Override
            public void run() {
                if (!BluetoothPeripheralManager.this.bluetoothGattServer.addService(bluetoothGattService)) {
                    Logger.e(TAG, "adding service %s failed", bluetoothGattService.getUuid());
                    BluetoothPeripheralManager.this.completedCommand();
                }
            }
        });
    }

    public void cancelConnection(BluetoothCentral bluetoothCentral) {
        Objects.requireNonNull(bluetoothCentral, CENTRAL_IS_NULL);
        this.cancelConnection(this.bluetoothAdapter.getRemoteDevice(bluetoothCentral.getAddress()));
    }

    public void close() {
        this.stopAdvertising();
        this.context.unregisterReceiver(this.adapterStateReceiver);
        this.bluetoothGattServer.close();
    }

    byte[] copyOf(byte[] byArray) {
        byArray = byArray == null ? new byte[]{} : Arrays.copyOf(byArray, byArray.length);
        return byArray;
    }

    public BluetoothCentral getCentral(String string2) {
        Objects.requireNonNull(string2, ADDRESS_IS_NULL);
        return this.connectedCentralsMap.get(string2);
    }

    public Set<BluetoothCentral> getConnectedCentrals() {
        return Collections.unmodifiableSet(new HashSet<BluetoothCentral>(this.connectedCentralsMap.values()));
    }

    public List<BluetoothGattService> getServices() {
        return this.bluetoothGattServer.getServices();
    }

    public boolean notifyCharacteristicChanged(byte[] byArray, BluetoothGattCharacteristic bluetoothGattCharacteristic) {
        Objects.requireNonNull(byArray, CHARACTERISTIC_VALUE_IS_NULL);
        Objects.requireNonNull(bluetoothGattCharacteristic, CHARACTERISTIC_IS_NULL);
        if (this.doesNotSupportNotifying(bluetoothGattCharacteristic)) {
            return false;
        }
        boolean bl = true;
        for (BluetoothDevice bluetoothDevice : this.getConnectedDevices()) {
            if (this.notifyCharacteristicChanged(this.copyOf(byArray), bluetoothDevice, bluetoothGattCharacteristic)) continue;
            bl = false;
        }
        return bl;
    }

    protected void onAdvertisingStopped() {
        Logger.i(TAG, "advertising stopped");
        this.mainHandler.post(new Runnable(){

            @Override
            public void run() {
                BluetoothPeripheralManager.this.callback.onAdvertisingStopped();
            }
        });
    }

    public boolean remove(BluetoothGattService bluetoothGattService) {
        Objects.requireNonNull(bluetoothGattService, SERVICE_IS_NULL);
        return this.bluetoothGattServer.removeService(bluetoothGattService);
    }

    public void removeAllServices() {
        this.bluetoothGattServer.clearServices();
    }

    public void startAdvertising(AdvertiseSettings advertiseSettings, AdvertiseData advertiseData, AdvertiseData advertiseData2) {
        if (!this.bluetoothAdapter.isMultipleAdvertisementSupported()) {
            Logger.e(TAG, "device does not support advertising");
        } else {
            this.bluetoothLeAdvertiser.startAdvertising(advertiseSettings, advertiseData, advertiseData2, this.advertiseCallback);
        }
    }

    public void stopAdvertising() {
        this.bluetoothLeAdvertiser.stopAdvertising(this.advertiseCallback);
        this.onAdvertisingStopped();
    }
}

