/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.internal.lifecycle;

import android.app.Application;
import android.os.Bundle;
import androidx.activity.ComponentActivity;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.SavedStateViewModelFactory;
import androidx.lifecycle.ViewModelProvider;
import androidx.savedstate.SavedStateRegistryOwner;
import dagger.Module;
import dagger.hilt.EntryPoints;
import dagger.hilt.android.internal.builders.ViewModelComponentBuilder;
import dagger.hilt.android.internal.lifecycle.HiltViewModelFactory;
import dagger.multibindings.Multibinds;
import java.util.Set;
import javax.inject.Inject;

public final class DefaultViewModelFactories {
    private DefaultViewModelFactories() {
    }

    public static ViewModelProvider.Factory getActivityFactory(ComponentActivity componentActivity, ViewModelProvider.Factory factory) {
        return EntryPoints.get(componentActivity, ActivityEntryPoint.class).getHiltInternalFactoryFactory().fromActivity(componentActivity, factory);
    }

    public static ViewModelProvider.Factory getFragmentFactory(Fragment fragment, ViewModelProvider.Factory factory) {
        return EntryPoints.get(fragment, FragmentEntryPoint.class).getHiltInternalFactoryFactory().fromFragment(fragment, factory);
    }

    public static interface ActivityEntryPoint {
        public InternalFactoryFactory getHiltInternalFactoryFactory();
    }

    @Module
    static interface ActivityModule {
        @Multibinds
        public Set<String> viewModelKeys();
    }

    public static interface FragmentEntryPoint {
        public InternalFactoryFactory getHiltInternalFactoryFactory();
    }

    public static final class InternalFactoryFactory {
        private final Application application;
        private final Set<String> keySet;
        private final ViewModelComponentBuilder viewModelComponentBuilder;

        @Inject
        InternalFactoryFactory(Application application, Set<String> set, ViewModelComponentBuilder viewModelComponentBuilder) {
            this.application = application;
            this.keySet = set;
            this.viewModelComponentBuilder = viewModelComponentBuilder;
        }

        private ViewModelProvider.Factory getHiltViewModelFactory(SavedStateRegistryOwner savedStateRegistryOwner, Bundle bundle, ViewModelProvider.Factory factory) {
            ViewModelProvider.Factory factory2 = factory;
            if (factory == null) {
                factory2 = new SavedStateViewModelFactory(this.application, savedStateRegistryOwner, bundle);
            }
            return new HiltViewModelFactory(savedStateRegistryOwner, bundle, this.keySet, factory2, this.viewModelComponentBuilder);
        }

        ViewModelProvider.Factory fromActivity(ComponentActivity componentActivity, ViewModelProvider.Factory factory) {
            Bundle bundle = componentActivity.getIntent() != null ? componentActivity.getIntent().getExtras() : null;
            return this.getHiltViewModelFactory((SavedStateRegistryOwner)componentActivity, bundle, factory);
        }

        ViewModelProvider.Factory fromFragment(Fragment fragment, ViewModelProvider.Factory factory) {
            return this.getHiltViewModelFactory((SavedStateRegistryOwner)fragment, fragment.getArguments(), factory);
        }
    }
}

