/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.internal.lifecycle;

import android.app.Activity;
import android.os.Bundle;
import androidx.lifecycle.AbstractSavedStateViewModelFactory;
import androidx.lifecycle.SavedStateHandle;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import androidx.savedstate.SavedStateRegistryOwner;
import dagger.Module;
import dagger.hilt.EntryPoints;
import dagger.hilt.android.internal.builders.ViewModelComponentBuilder;
import dagger.multibindings.Multibinds;
import java.util.Map;
import java.util.Set;
import javax.inject.Provider;

public final class HiltViewModelFactory
implements ViewModelProvider.Factory {
    private final ViewModelProvider.Factory delegateFactory;
    private final AbstractSavedStateViewModelFactory hiltViewModelFactory;
    private final Set<String> hiltViewModelKeys;

    public HiltViewModelFactory(SavedStateRegistryOwner savedStateRegistryOwner, Bundle bundle, Set<String> set, ViewModelProvider.Factory factory, final ViewModelComponentBuilder viewModelComponentBuilder) {
        this.hiltViewModelKeys = set;
        this.delegateFactory = factory;
        this.hiltViewModelFactory = new AbstractSavedStateViewModelFactory(savedStateRegistryOwner, bundle){

            protected <T extends ViewModel> T create(String provider, Class<T> clazz, SavedStateHandle savedStateHandle) {
                provider = EntryPoints.get(viewModelComponentBuilder.savedStateHandle(savedStateHandle).build(), ViewModelFactoriesEntryPoint.class).getHiltViewModelMap().get(clazz.getName());
                if (provider != null) {
                    return (T)((ViewModel)provider.get());
                }
                provider = new StringBuilder();
                ((StringBuilder)((Object)provider)).append("Expected the @HiltViewModel-annotated class '");
                ((StringBuilder)((Object)provider)).append(clazz.getName());
                ((StringBuilder)((Object)provider)).append("' to be available in the multi-binding of @HiltViewModelMap but none was found.");
                throw new IllegalStateException(((StringBuilder)((Object)provider)).toString());
            }
        };
    }

    public static ViewModelProvider.Factory createInternal(Activity object, SavedStateRegistryOwner savedStateRegistryOwner, Bundle bundle, ViewModelProvider.Factory factory) {
        object = EntryPoints.get(object, ActivityCreatorEntryPoint.class);
        return new HiltViewModelFactory(savedStateRegistryOwner, bundle, object.getViewModelKeys(), factory, object.getViewModelComponentBuilder());
    }

    public <T extends ViewModel> T create(Class<T> clazz) {
        if (this.hiltViewModelKeys.contains(clazz.getName())) {
            return (T)this.hiltViewModelFactory.create(clazz);
        }
        return (T)this.delegateFactory.create(clazz);
    }

    static interface ActivityCreatorEntryPoint {
        public ViewModelComponentBuilder getViewModelComponentBuilder();

        public Set<String> getViewModelKeys();
    }

    public static interface ViewModelFactoriesEntryPoint {
        public Map<String, Provider<ViewModel>> getHiltViewModelMap();
    }

    @Module
    static interface ViewModelModule {
        @Multibinds
        public Map<String, ViewModel> hiltViewModelMap();
    }
}

