/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.internal.managers;

import android.app.Activity;
import android.app.Application;
import androidx.activity.ComponentActivity;
import dagger.hilt.EntryPoints;
import dagger.hilt.android.components.ActivityRetainedComponent;
import dagger.hilt.android.internal.builders.ActivityComponentBuilder;
import dagger.hilt.android.internal.managers.ActivityRetainedComponentManager;
import dagger.hilt.internal.GeneratedComponentManager;

public class ActivityComponentManager
implements GeneratedComponentManager<Object> {
    protected final Activity activity;
    private final GeneratedComponentManager<ActivityRetainedComponent> activityRetainedComponentManager;
    private volatile Object component;
    private final Object componentLock = new Object();

    public ActivityComponentManager(Activity activity) {
        this.activity = activity;
        this.activityRetainedComponentManager = new ActivityRetainedComponentManager((ComponentActivity)activity);
    }

    protected Object createComponent() {
        if (!(this.activity.getApplication() instanceof GeneratedComponentManager)) {
            if (Application.class.equals(this.activity.getApplication().getClass())) {
                throw new IllegalStateException("Hilt Activity must be attached to an @HiltAndroidApp Application. Did you forget to specify your Application's class name in your manifest's <application />'s android:name attribute?");
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Hilt Activity must be attached to an @AndroidEntryPoint Application. Found: ");
            stringBuilder.append(this.activity.getApplication().getClass());
            throw new IllegalStateException(stringBuilder.toString());
        }
        return EntryPoints.get(this.activityRetainedComponentManager, ActivityComponentBuilderEntryPoint.class).activityComponentBuilder().activity(this.activity).build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object generatedComponent() {
        if (this.component != null) return this.component;
        Object object = this.componentLock;
        synchronized (object) {
            if (this.component != null) return this.component;
            this.component = this.createComponent();
            return this.component;
        }
    }

    public static interface ActivityComponentBuilderEntryPoint {
        public ActivityComponentBuilder activityComponentBuilder();
    }
}

