/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.internal.managers;

import android.content.Context;
import androidx.activity.ComponentActivity;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import dagger.Binds;
import dagger.Module;
import dagger.hilt.EntryPoints;
import dagger.hilt.android.ActivityRetainedLifecycle;
import dagger.hilt.android.EntryPointAccessors;
import dagger.hilt.android.components.ActivityRetainedComponent;
import dagger.hilt.android.internal.ThreadUtil;
import dagger.hilt.android.internal.builders.ActivityRetainedComponentBuilder;
import dagger.hilt.internal.GeneratedComponentManager;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.inject.Inject;

final class ActivityRetainedComponentManager
implements GeneratedComponentManager<ActivityRetainedComponent> {
    private volatile ActivityRetainedComponent component;
    private final Object componentLock = new Object();
    private final ViewModelProvider viewModelProvider;

    ActivityRetainedComponentManager(ComponentActivity componentActivity) {
        this.viewModelProvider = this.getViewModelProvider((ViewModelStoreOwner)componentActivity, (Context)componentActivity);
    }

    private ActivityRetainedComponent createComponent() {
        return ((ActivityRetainedComponentViewModel)this.viewModelProvider.get(ActivityRetainedComponentViewModel.class)).getComponent();
    }

    private ViewModelProvider getViewModelProvider(ViewModelStoreOwner viewModelStoreOwner, final Context context) {
        return new ViewModelProvider(viewModelStoreOwner, new ViewModelProvider.Factory(){

            public <T extends ViewModel> T create(Class<T> clazz) {
                return (T)((Object)new ActivityRetainedComponentViewModel(EntryPointAccessors.fromApplication(context, ActivityRetainedComponentBuilderEntryPoint.class).retainedComponentBuilder().build()));
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ActivityRetainedComponent generatedComponent() {
        if (this.component != null) return this.component;
        Object object = this.componentLock;
        synchronized (object) {
            if (this.component != null) return this.component;
            this.component = this.createComponent();
            return this.component;
        }
    }

    public static interface ActivityRetainedComponentBuilderEntryPoint {
        public ActivityRetainedComponentBuilder retainedComponentBuilder();
    }

    static final class ActivityRetainedComponentViewModel
    extends ViewModel {
        private final ActivityRetainedComponent component;

        ActivityRetainedComponentViewModel(ActivityRetainedComponent activityRetainedComponent) {
            this.component = activityRetainedComponent;
        }

        ActivityRetainedComponent getComponent() {
            return this.component;
        }

        protected void onCleared() {
            super.onCleared();
            ((Lifecycle)EntryPoints.get(this.component, ActivityRetainedLifecycleEntryPoint.class).getActivityRetainedLifecycle()).dispatchOnCleared();
        }
    }

    public static interface ActivityRetainedLifecycleEntryPoint {
        public ActivityRetainedLifecycle getActivityRetainedLifecycle();
    }

    static final class Lifecycle
    implements ActivityRetainedLifecycle {
        private final Set<ActivityRetainedLifecycle.OnClearedListener> listeners = new HashSet<ActivityRetainedLifecycle.OnClearedListener>();
        private boolean onClearedDispatched = false;

        @Inject
        Lifecycle() {
        }

        private void throwIfOnClearedDispatched() {
            if (!this.onClearedDispatched) {
                return;
            }
            throw new IllegalStateException("There was a race between the call to add/remove an OnClearedListener and onCleared(). This can happen when posting to the Main thread from a background thread, which is not supported.");
        }

        @Override
        public void addOnClearedListener(ActivityRetainedLifecycle.OnClearedListener onClearedListener) {
            ThreadUtil.ensureMainThread();
            this.throwIfOnClearedDispatched();
            this.listeners.add(onClearedListener);
        }

        void dispatchOnCleared() {
            ThreadUtil.ensureMainThread();
            this.onClearedDispatched = true;
            Iterator<ActivityRetainedLifecycle.OnClearedListener> iterator2 = this.listeners.iterator();
            while (iterator2.hasNext()) {
                iterator2.next().onCleared();
            }
        }

        @Override
        public void removeOnClearedListener(ActivityRetainedLifecycle.OnClearedListener onClearedListener) {
            ThreadUtil.ensureMainThread();
            this.throwIfOnClearedDispatched();
            this.listeners.remove(onClearedListener);
        }
    }

    @Module
    static abstract class LifecycleModule {
        LifecycleModule() {
        }

        @Binds
        abstract ActivityRetainedLifecycle bind(Lifecycle var1);
    }
}

