/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.internal.managers;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.os.Bundle;
import android.view.LayoutInflater;
import androidx.fragment.app.Fragment;
import dagger.hilt.EntryPoints;
import dagger.hilt.android.internal.builders.FragmentComponentBuilder;
import dagger.hilt.android.internal.managers.ViewComponentManager;
import dagger.hilt.internal.GeneratedComponentManager;
import dagger.hilt.internal.Preconditions;

public class FragmentComponentManager
implements GeneratedComponentManager<Object> {
    private volatile Object component;
    private final Object componentLock = new Object();
    private final Fragment fragment;

    public FragmentComponentManager(Fragment fragment) {
        this.fragment = fragment;
    }

    private Object createComponent() {
        Preconditions.checkNotNull(this.fragment.getHost(), "Hilt Fragments must be attached before creating the component.");
        Preconditions.checkState(this.fragment.getHost() instanceof GeneratedComponentManager, "Hilt Fragments must be attached to an @AndroidEntryPoint Activity. Found: %s", this.fragment.getHost().getClass());
        this.validate(this.fragment);
        return EntryPoints.get(this.fragment.getHost(), FragmentComponentBuilderEntryPoint.class).fragmentComponentBuilder().fragment(this.fragment).build();
    }

    public static ContextWrapper createContextWrapper(Context context, Fragment fragment) {
        return new ViewComponentManager.FragmentContextWrapper(context, fragment);
    }

    public static ContextWrapper createContextWrapper(LayoutInflater layoutInflater, Fragment fragment) {
        return new ViewComponentManager.FragmentContextWrapper(layoutInflater, fragment);
    }

    public static final Context findActivity(Context context) {
        while (context instanceof ContextWrapper && !(context instanceof Activity)) {
            context = ((ContextWrapper)context).getBaseContext();
        }
        return context;
    }

    public static final void initializeArguments(Fragment fragment) {
        Preconditions.checkNotNull(fragment);
        if (fragment.getArguments() == null) {
            fragment.setArguments(new Bundle());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object generatedComponent() {
        if (this.component != null) return this.component;
        Object object = this.componentLock;
        synchronized (object) {
            if (this.component != null) return this.component;
            this.component = this.createComponent();
            return this.component;
        }
    }

    protected void validate(Fragment fragment) {
    }

    public static interface FragmentComponentBuilderEntryPoint {
        public FragmentComponentBuilder fragmentComponentBuilder();
    }
}

