/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.internal.managers;

import android.content.Context;
import android.content.ContextWrapper;
import android.view.LayoutInflater;
import android.view.View;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleEventObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import dagger.hilt.EntryPoints;
import dagger.hilt.android.internal.Contexts;
import dagger.hilt.android.internal.builders.ViewComponentBuilder;
import dagger.hilt.android.internal.builders.ViewWithFragmentComponentBuilder;
import dagger.hilt.internal.GeneratedComponentManager;
import dagger.hilt.internal.Preconditions;

public final class ViewComponentManager
implements GeneratedComponentManager<Object> {
    private volatile Object component;
    private final Object componentLock = new Object();
    private final boolean hasFragmentBindings;
    private final View view;

    public ViewComponentManager(View view, boolean bl) {
        this.view = view;
        this.hasFragmentBindings = bl;
    }

    private Object createComponent() {
        GeneratedComponentManager<?> generatedComponentManager = this.getParentComponentManager(false);
        if (this.hasFragmentBindings) {
            return EntryPoints.get(generatedComponentManager, ViewWithFragmentComponentBuilderEntryPoint.class).viewWithFragmentComponentBuilder().view(this.view).build();
        }
        return EntryPoints.get(generatedComponentManager, ViewComponentBuilderEntryPoint.class).viewComponentBuilder().view(this.view).build();
    }

    private GeneratedComponentManager<?> getParentComponentManager(boolean bl) {
        if (this.hasFragmentBindings) {
            Context context = this.getParentContext(FragmentContextWrapper.class, bl);
            if (context instanceof FragmentContextWrapper) {
                return (GeneratedComponentManager)((FragmentContextWrapper)context).getFragment();
            }
            if (bl) {
                return null;
            }
            context = this.getParentContext(GeneratedComponentManager.class, bl);
            Preconditions.checkState(context instanceof GeneratedComponentManager ^ true, "%s, @WithFragmentBindings Hilt view must be attached to an @AndroidEntryPoint Fragment. Was attached to context %s", this.view.getClass(), context.getClass().getName());
        } else {
            Context context = this.getParentContext(GeneratedComponentManager.class, bl);
            if (context instanceof GeneratedComponentManager) {
                return (GeneratedComponentManager)context;
            }
            if (bl) {
                return null;
            }
        }
        throw new IllegalStateException(String.format("%s, Hilt view must be attached to an @AndroidEntryPoint Fragment or Activity.", this.view.getClass()));
    }

    private Context getParentContext(Class<?> context, boolean bl) {
        Context context2;
        context = context2 = ViewComponentManager.unwrap(this.view.getContext(), context);
        if (context2 == Contexts.getApplication(context2.getApplicationContext())) {
            Preconditions.checkState(bl, "%s, Hilt view cannot be created using the application context. Use a Hilt Fragment or Activity context.", this.view.getClass());
            context = null;
        }
        return context;
    }

    private static Context unwrap(Context context, Class<?> clazz) {
        while (context instanceof ContextWrapper && !clazz.isInstance(context)) {
            context = ((ContextWrapper)context).getBaseContext();
        }
        return context;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object generatedComponent() {
        if (this.component != null) return this.component;
        Object object = this.componentLock;
        synchronized (object) {
            if (this.component != null) return this.component;
            this.component = this.createComponent();
            return this.component;
        }
    }

    public GeneratedComponentManager<?> maybeGetParentComponentManager() {
        return this.getParentComponentManager(true);
    }

    public static final class FragmentContextWrapper
    extends ContextWrapper {
        private LayoutInflater baseInflater;
        private Fragment fragment;
        private final LifecycleEventObserver fragmentLifecycleObserver;
        private LayoutInflater inflater;

        FragmentContextWrapper(Context object, Fragment fragment) {
            super(Preconditions.checkNotNull(object));
            object = new LifecycleEventObserver(){

                public void onStateChanged(LifecycleOwner lifecycleOwner, Lifecycle.Event event) {
                    if (event == Lifecycle.Event.ON_DESTROY) {
                        FragmentContextWrapper.access$002(FragmentContextWrapper.this, null);
                        FragmentContextWrapper.access$102(FragmentContextWrapper.this, null);
                        FragmentContextWrapper.access$202(FragmentContextWrapper.this, null);
                    }
                }
            };
            this.fragmentLifecycleObserver = object;
            this.baseInflater = null;
            this.fragment = fragment = Preconditions.checkNotNull(fragment);
            fragment.getLifecycle().addObserver((LifecycleObserver)object);
        }

        FragmentContextWrapper(LayoutInflater layoutInflater, Fragment fragment) {
            super(Preconditions.checkNotNull(Preconditions.checkNotNull(layoutInflater).getContext()));
            LifecycleEventObserver lifecycleEventObserver;
            this.fragmentLifecycleObserver = lifecycleEventObserver = new /* invalid duplicate definition of identical inner class */;
            this.baseInflater = layoutInflater;
            layoutInflater = Preconditions.checkNotNull(fragment);
            this.fragment = layoutInflater;
            layoutInflater.getLifecycle().addObserver((LifecycleObserver)lifecycleEventObserver);
        }

        static /* synthetic */ Fragment access$002(FragmentContextWrapper fragmentContextWrapper, Fragment fragment) {
            fragmentContextWrapper.fragment = fragment;
            return fragment;
        }

        static /* synthetic */ LayoutInflater access$102(FragmentContextWrapper fragmentContextWrapper, LayoutInflater layoutInflater) {
            fragmentContextWrapper.baseInflater = layoutInflater;
            return layoutInflater;
        }

        static /* synthetic */ LayoutInflater access$202(FragmentContextWrapper fragmentContextWrapper, LayoutInflater layoutInflater) {
            fragmentContextWrapper.inflater = layoutInflater;
            return layoutInflater;
        }

        Fragment getFragment() {
            Preconditions.checkNotNull(this.fragment, "The fragment has already been destroyed.");
            return this.fragment;
        }

        public Object getSystemService(String string2) {
            if (!"layout_inflater".equals(string2)) {
                return this.getBaseContext().getSystemService(string2);
            }
            if (this.inflater == null) {
                if (this.baseInflater == null) {
                    this.baseInflater = (LayoutInflater)this.getBaseContext().getSystemService("layout_inflater");
                }
                this.inflater = this.baseInflater.cloneInContext((Context)this);
            }
            return this.inflater;
        }
    }

    public static interface ViewComponentBuilderEntryPoint {
        public ViewComponentBuilder viewComponentBuilder();
    }

    public static interface ViewWithFragmentComponentBuilderEntryPoint {
        public ViewWithFragmentComponentBuilder viewWithFragmentComponentBuilder();
    }
}

