/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.migration;

import android.app.Service;
import android.content.BroadcastReceiver;
import android.view.View;
import androidx.activity.ComponentActivity;
import androidx.fragment.app.Fragment;
import dagger.hilt.android.internal.migration.InjectedByHilt;
import dagger.hilt.internal.Preconditions;

public final class OptionalInjectCheck {
    private OptionalInjectCheck() {
    }

    private static boolean check(Object object) {
        Preconditions.checkNotNull(object);
        Preconditions.checkArgument(object instanceof InjectedByHilt, "'%s' is not an optionally injected android entry point. Check that you have annotated the class with both @AndroidEntryPoint and @OptionalInject.", object.getClass());
        return ((InjectedByHilt)object).wasInjectedByHilt();
    }

    public static boolean wasInjectedByHilt(Service service) {
        return OptionalInjectCheck.check(service);
    }

    public static boolean wasInjectedByHilt(BroadcastReceiver broadcastReceiver) {
        return OptionalInjectCheck.check(broadcastReceiver);
    }

    public static boolean wasInjectedByHilt(View view) {
        return OptionalInjectCheck.check(view);
    }

    public static boolean wasInjectedByHilt(ComponentActivity componentActivity) {
        return OptionalInjectCheck.check(componentActivity);
    }

    public static boolean wasInjectedByHilt(Fragment fragment) {
        return OptionalInjectCheck.check(fragment);
    }
}

