/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal;

import dagger.internal.DaggerCollections;
import dagger.internal.DelegateFactory;
import dagger.internal.Factory;
import dagger.internal.Preconditions;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Provider;

abstract class AbstractMapFactory<K, V, V2>
implements Factory<Map<K, V2>> {
    private final Map<K, Provider<V>> contributingMap;

    AbstractMapFactory(Map<K, Provider<V>> map) {
        this.contributingMap = Collections.unmodifiableMap(map);
    }

    final Map<K, Provider<V>> contributingMap() {
        return this.contributingMap;
    }

    public static abstract class Builder<K, V, V2> {
        final LinkedHashMap<K, Provider<V>> map;

        Builder(int n) {
            this.map = DaggerCollections.newLinkedHashMapWithExpectedSize(n);
        }

        Builder<K, V, V2> put(K k, Provider<V> provider) {
            this.map.put(Preconditions.checkNotNull(k, "key"), Preconditions.checkNotNull(provider, "provider"));
            return this;
        }

        Builder<K, V, V2> putAll(Provider<Map<K, V2>> abstractMapFactory) {
            if (abstractMapFactory instanceof DelegateFactory) {
                return this.putAll(((DelegateFactory)((Object)abstractMapFactory)).getDelegate());
            }
            abstractMapFactory = abstractMapFactory;
            this.map.putAll(abstractMapFactory.contributingMap);
            return this;
        }
    }
}

