/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal;

import dagger.internal.Factory;
import dagger.internal.Preconditions;
import javax.inject.Provider;

public final class DelegateFactory<T>
implements Factory<T> {
    private Provider<T> delegate;

    public static <T> void setDelegate(Provider<T> delegateFactory, Provider<T> provider) {
        Preconditions.checkNotNull(provider);
        delegateFactory = delegateFactory;
        if (delegateFactory.delegate == null) {
            delegateFactory.delegate = provider;
            return;
        }
        throw new IllegalStateException();
    }

    @Override
    public T get() {
        Provider<T> provider = this.delegate;
        if (provider != null) {
            return provider.get();
        }
        throw new IllegalStateException();
    }

    Provider<T> getDelegate() {
        return Preconditions.checkNotNull(this.delegate);
    }

    @Deprecated
    public void setDelegatedProvider(Provider<T> provider) {
        DelegateFactory.setDelegate(this, provider);
    }
}

