/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal;

import dagger.internal.DaggerCollections;
import dagger.internal.Factory;
import dagger.internal.InstanceFactory;
import dagger.internal.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Provider;

public final class SetFactory<T>
implements Factory<Set<T>> {
    private static final Factory<Set<Object>> EMPTY_FACTORY = InstanceFactory.create(Collections.emptySet());
    private final List<Provider<Collection<T>>> collectionProviders;
    private final List<Provider<T>> individualProviders;

    private SetFactory(List<Provider<T>> list, List<Provider<Collection<T>>> list2) {
        this.individualProviders = list;
        this.collectionProviders = list2;
    }

    public static <T> Builder<T> builder(int n, int n2) {
        return new Builder(n, n2);
    }

    public static <T> Factory<Set<T>> empty() {
        return EMPTY_FACTORY;
    }

    @Override
    public Set<T> get() {
        Object object;
        int n;
        int n2 = this.individualProviders.size();
        ArrayList<Collection<T>> arrayList = new ArrayList<Collection<T>>(this.collectionProviders.size());
        int n3 = this.collectionProviders.size();
        int n4 = 0;
        for (n = 0; n < n3; ++n) {
            object = this.collectionProviders.get(n).get();
            n2 += object.size();
            arrayList.add((Collection<T>)object);
        }
        HashSet hashSet = DaggerCollections.newHashSetWithExpectedSize(n2);
        n2 = this.individualProviders.size();
        for (n = 0; n < n2; ++n) {
            hashSet.add(Preconditions.checkNotNull(this.individualProviders.get(n).get()));
        }
        n2 = arrayList.size();
        for (n = n4; n < n2; ++n) {
            object = ((Collection)arrayList.get(n)).iterator();
            while (object.hasNext()) {
                hashSet.add(Preconditions.checkNotNull(object.next()));
            }
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public static final class Builder<T> {
        static final /* synthetic */ boolean $assertionsDisabled = false;
        private final List<Provider<Collection<T>>> collectionProviders;
        private final List<Provider<T>> individualProviders;

        private Builder(int n, int n2) {
            this.individualProviders = DaggerCollections.presizedList(n);
            this.collectionProviders = DaggerCollections.presizedList(n2);
        }

        public Builder<T> addCollectionProvider(Provider<? extends Collection<? extends T>> provider) {
            this.collectionProviders.add(provider);
            return this;
        }

        public Builder<T> addProvider(Provider<? extends T> provider) {
            this.individualProviders.add(provider);
            return this;
        }

        public SetFactory<T> build() {
            return new SetFactory(this.individualProviders, this.collectionProviders);
        }
    }
}

