/*
 * Decompiled with CFR 0.152.
 */
package kotlin.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionSystemProperties;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;

@Metadata(d1={"\u0000 \n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u001a#\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u0003H\u0000\u00a2\u0006\u0002\u0010\u0004\u001a\u001e\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u0005H\u0000\u001a\u001e\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u0006H\u0000\u001a,\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00052\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0005H\u0000\u001a\u0018\u0010\t\u001a\u00020\n\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u0001H\u0002\u00a8\u0006\u000b"}, d2={"convertToSetForSetOperation", "", "T", "", "([Ljava/lang/Object;)Ljava/util/Collection;", "", "Lkotlin/sequences/Sequence;", "convertToSetForSetOperationWith", "source", "safeToConvertToSet", "", "kotlin-stdlib"}, k=2, mv={1, 6, 0}, xi=48)
public final class BrittleContainsOptimizationKt {
    public static final <T> Collection<T> convertToSetForSetOperation(Iterable<? extends T> collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"<this>");
        if (collection instanceof Set) {
            collection = collection;
        } else if (collection instanceof Collection) {
            HashSet hashSet = collection;
            collection = BrittleContainsOptimizationKt.safeToConvertToSet(hashSet) ? (Collection)CollectionsKt.toHashSet(collection) : hashSet;
        } else {
            collection = CollectionSystemProperties.brittleContainsOptimizationEnabled ? CollectionsKt.toHashSet(collection) : CollectionsKt.toList(collection);
            collection = collection;
        }
        return collection;
    }

    public static final <T> Collection<T> convertToSetForSetOperation(Sequence<? extends T> object) {
        Intrinsics.checkNotNullParameter(object, (String)"<this>");
        object = CollectionSystemProperties.brittleContainsOptimizationEnabled ? SequencesKt.toHashSet(object) : SequencesKt.toList(object);
        return (Collection)object;
    }

    public static final <T> Collection<T> convertToSetForSetOperation(T[] object) {
        Intrinsics.checkNotNullParameter(object, (String)"<this>");
        object = CollectionSystemProperties.brittleContainsOptimizationEnabled ? ArraysKt.toHashSet(object) : ArraysKt.asList(object);
        return (Collection)object;
    }

    public static final <T> Collection<T> convertToSetForSetOperationWith(Iterable<? extends T> iterable, Iterable<? extends T> iterable2) {
        Intrinsics.checkNotNullParameter(iterable, (String)"<this>");
        Intrinsics.checkNotNullParameter(iterable2, (String)"source");
        if (iterable instanceof Set) {
            iterable = iterable;
        } else if (iterable instanceof Collection) {
            iterable = iterable2 instanceof Collection && ((Collection)iterable2).size() < 2 ? (Collection)iterable : (BrittleContainsOptimizationKt.safeToConvertToSet(iterable2 = iterable) ? (Collection)CollectionsKt.toHashSet(iterable) : iterable2);
        } else {
            iterable = CollectionSystemProperties.brittleContainsOptimizationEnabled ? CollectionsKt.toHashSet(iterable) : CollectionsKt.toList(iterable);
            iterable = iterable;
        }
        return iterable;
    }

    private static final <T> boolean safeToConvertToSet(Collection<? extends T> collection) {
        boolean bl = CollectionSystemProperties.brittleContainsOptimizationEnabled && collection.size() > 2 && collection instanceof ArrayList;
        return bl;
    }
}

