/*
 * Decompiled with CFR 0.152.
 */
package kotlin.io;

import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0014\u001a\u00020\u0004H\u0002J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0010H\u0002J\u0018\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0004H\u0002J\u0018\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\b\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020!H\u0002J\u0010\u0010#\u001a\u00020!2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u00060\u0012j\u0002`\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lkotlin/io/LineReader;", "", "()V", "BUFFER_SIZE", "", "byteBuf", "Ljava/nio/ByteBuffer;", "bytes", "", "charBuf", "Ljava/nio/CharBuffer;", "chars", "", "decoder", "Ljava/nio/charset/CharsetDecoder;", "directEOL", "", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "compactBytes", "decode", "endOfInput", "decodeEndOfInput", "nBytes", "nChars", "readLine", "", "inputStream", "Ljava/io/InputStream;", "charset", "Ljava/nio/charset/Charset;", "resetAll", "", "trimStringBuilder", "updateCharset", "kotlin-stdlib"}, k=1, mv={1, 6, 0}, xi=48)
public final class LineReader {
    private static final int BUFFER_SIZE = 32;
    public static final LineReader INSTANCE = new LineReader();
    private static final ByteBuffer byteBuf;
    private static final byte[] bytes;
    private static final CharBuffer charBuf;
    private static final char[] chars;
    private static CharsetDecoder decoder;
    private static boolean directEOL;
    private static final StringBuilder sb;

    static {
        Object object = new byte[32];
        bytes = object;
        Object object2 = new char[32];
        chars = object2;
        object = ByteBuffer.wrap(object);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"wrap(bytes)");
        byteBuf = object;
        object2 = CharBuffer.wrap(object2);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"wrap(chars)");
        charBuf = object2;
        sb = new StringBuilder();
    }

    private LineReader() {
    }

    private final int compactBytes() {
        ByteBuffer byteBuffer = byteBuf;
        byteBuffer.compact();
        int n = byteBuffer.position();
        byteBuffer.position(0);
        return n;
    }

    private final int decode(boolean bl) {
        while (true) {
            Object object;
            Object object2 = object = decoder;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"decoder");
                object2 = null;
            }
            Comparable<ByteBuffer> comparable = byteBuf;
            object = charBuf;
            object2 = ((CharsetDecoder)object2).decode((ByteBuffer)comparable, (CharBuffer)object, bl);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"decoder.decode(byteBuf, charBuf, endOfInput)");
            if (((CoderResult)object2).isError()) {
                this.resetAll();
                ((CoderResult)object2).throwException();
            }
            int n = ((Buffer)object).position();
            if (!((CoderResult)object2).isOverflow()) {
                return n;
            }
            comparable = sb;
            object2 = chars;
            ((StringBuilder)comparable).append((char[])object2, 0, --n);
            ((CharBuffer)object).position(0);
            ((CharBuffer)object).limit(32);
            ((CharBuffer)object).put((char)object2[n]);
        }
    }

    private final int decodeEndOfInput(int n, int n2) {
        CharsetDecoder charsetDecoder;
        ByteBuffer byteBuffer = byteBuf;
        byteBuffer.limit(n);
        charBuf.position(n2);
        n = this.decode(true);
        CharsetDecoder charsetDecoder2 = charsetDecoder = decoder;
        if (charsetDecoder == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"decoder");
            charsetDecoder2 = null;
        }
        charsetDecoder2.reset();
        byteBuffer.position(0);
        return n;
    }

    private final void resetAll() {
        CharsetDecoder charsetDecoder;
        CharsetDecoder charsetDecoder2 = charsetDecoder = decoder;
        if (charsetDecoder == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"decoder");
            charsetDecoder2 = null;
        }
        charsetDecoder2.reset();
        byteBuf.position(0);
        sb.setLength(0);
    }

    private final void trimStringBuilder() {
        StringBuilder stringBuilder = sb;
        stringBuilder.setLength(32);
        stringBuilder.trimToSize();
    }

    private final void updateCharset(Charset object) {
        object = ((Charset)object).newDecoder();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"charset.newDecoder()");
        decoder = object;
        ByteBuffer byteBuffer = byteBuf;
        byteBuffer.clear();
        CharBuffer charBuffer = charBuf;
        charBuffer.clear();
        byteBuffer.put((byte)10);
        byteBuffer.flip();
        CharsetDecoder charsetDecoder = decoder;
        object = charsetDecoder;
        if (charsetDecoder == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"decoder");
            object = null;
        }
        boolean bl = false;
        ((CharsetDecoder)object).decode(byteBuffer, charBuffer, false);
        boolean bl2 = bl;
        if (charBuffer.position() == 1) {
            bl2 = bl;
            if (charBuffer.get(0) == '\n') {
                bl2 = true;
            }
        }
        directEOL = bl2;
        this.resetAll();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final String readLine(InputStream object, Charset object2) {
        synchronized (this) {
            Object object3;
            block22: {
                block21: {
                    Intrinsics.checkNotNullParameter((Object)object, (String)"inputStream");
                    Intrinsics.checkNotNullParameter((Object)object3, (String)"charset");
                    CharsetDecoder charsetDecoder = decoder;
                    if (charsetDecoder == null) break block21;
                    CharsetDecoder charsetDecoder2 = charsetDecoder;
                    if (charsetDecoder == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"decoder");
                        charsetDecoder2 = null;
                    }
                    if (Intrinsics.areEqual((Object)charsetDecoder2.charset(), (Object)object3)) break block22;
                }
                this.updateCharset((Charset)object3);
            }
            int n = 0;
            int n2 = 0;
            while (true) {
                block25: {
                    int n3;
                    block24: {
                        int n4;
                        int n5;
                        block23: {
                            n5 = ((InputStream)object).read();
                            n3 = 1;
                            if (n5 != -1) break block23;
                            n4 = ((CharSequence)sb).length();
                            n4 = n4 == 0 ? 1 : 0;
                            if (n4 != 0 && n == 0 && n2 == 0) {
                                return null;
                            }
                            n2 = this.decodeEndOfInput(n, n2);
                            break block24;
                        }
                        object3 = bytes;
                        n4 = n + 1;
                        object3[n] = (byte)n5;
                        if (n5 != 10 && n4 != 32 && directEOL) {
                            n = n4;
                            continue;
                        }
                        object3 = byteBuf;
                        ((ByteBuffer)object3).limit(n4);
                        charBuf.position(n2);
                        n2 = this.decode(false);
                        if (n2 <= 0 || chars[n2 - 1] != '\n') break block25;
                        ((ByteBuffer)object3).position(0);
                    }
                    n = n2;
                    if (n2 > 0) {
                        object = chars;
                        n = n2;
                        if (object[n2 - 1] == 10) {
                            n = --n2;
                            if (n2 > 0) {
                                n = n2;
                                if (object[n2 - 1] == 13) {
                                    n = n2 - 1;
                                }
                            }
                        }
                    }
                    if ((n2 = ((CharSequence)(object = sb)).length() == 0 ? n3 : 0) != 0) {
                        return new String(chars, 0, n);
                    }
                    ((StringBuilder)object).append(chars, 0, n);
                    object3 = ((StringBuilder)object).toString();
                    Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"sb.toString()");
                    if (((StringBuilder)object).length() > 32) {
                        this.trimStringBuilder();
                    }
                    ((StringBuilder)object).setLength(0);
                    return object3;
                }
                n = this.compactBytes();
            }
        }
    }
}

