/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.io.Closeable;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import okhttp3.CipherSuite;
import okhttp3.Handshake;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.TlsVersion;
import okhttp3.internal.Util;
import okhttp3.internal.cache.CacheRequest;
import okhttp3.internal.cache.CacheStrategy;
import okhttp3.internal.cache.DiskLruCache;
import okhttp3.internal.cache.InternalCache;
import okhttp3.internal.http.HttpHeaders;
import okhttp3.internal.http.HttpMethod;
import okhttp3.internal.http.StatusLine;
import okhttp3.internal.io.FileSystem;
import okhttp3.internal.platform.Platform;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import okio.ForwardingSink;
import okio.ForwardingSource;
import okio.Okio;
import okio.Sink;
import okio.Source;

public final class Cache
implements Closeable,
Flushable {
    private static final int ENTRY_BODY = 1;
    private static final int ENTRY_COUNT = 2;
    private static final int ENTRY_METADATA = 0;
    private static final int VERSION = 201105;
    final DiskLruCache cache;
    private int hitCount;
    final InternalCache internalCache = new InternalCache(){

        @Override
        @Nullable
        public Response get(Request request) throws IOException {
            return Cache.this.get(request);
        }

        @Override
        @Nullable
        public CacheRequest put(Response response) throws IOException {
            return Cache.this.put(response);
        }

        @Override
        public void remove(Request request) throws IOException {
            Cache.this.remove(request);
        }

        @Override
        public void trackConditionalCacheHit() {
            Cache.this.trackConditionalCacheHit();
        }

        @Override
        public void trackResponse(CacheStrategy cacheStrategy) {
            Cache.this.trackResponse(cacheStrategy);
        }

        @Override
        public void update(Response response, Response response2) {
            Cache.this.update(response, response2);
        }
    };
    private int networkCount;
    private int requestCount;
    int writeAbortCount;
    int writeSuccessCount;

    public Cache(File file, long l) {
        this(file, l, FileSystem.SYSTEM);
    }

    Cache(File file, long l, FileSystem fileSystem) {
        this.cache = DiskLruCache.create(fileSystem, file, 201105, 2, l);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void abortQuietly(@Nullable DiskLruCache.Editor editor) {
        if (editor == null) return;
        try {
            editor.abort();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public static String key(HttpUrl httpUrl) {
        return ByteString.encodeUtf8(httpUrl.toString()).md5().hex();
    }

    static int readInt(BufferedSource object) throws IOException {
        String string2;
        long l;
        block4: {
            try {
                l = object.readDecimalLong();
                string2 = object.readUtf8LineStrict();
                if (l < 0L || l > Integer.MAX_VALUE) break block4;
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException(numberFormatException.getMessage());
            }
            if (!string2.isEmpty()) break block4;
            return (int)l;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("expected an int but was \"");
        ((StringBuilder)object).append(l);
        ((StringBuilder)object).append(string2);
        ((StringBuilder)object).append("\"");
        IOException iOException = new IOException(((StringBuilder)object).toString());
        throw iOException;
    }

    @Override
    public void close() throws IOException {
        this.cache.close();
    }

    public void delete() throws IOException {
        this.cache.delete();
    }

    public File directory() {
        return this.cache.getDirectory();
    }

    public void evictAll() throws IOException {
        this.cache.evictAll();
    }

    @Override
    public void flush() throws IOException {
        this.cache.flush();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    Response get(Request request) {
        Object object;
        block5: {
            object = Cache.key(request.url());
            try {
                object = this.cache.get((String)object);
                if (object != null) break block5;
                return null;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        try {
            Entry entry = new Entry(((DiskLruCache.Snapshot)object).getSource(0));
            object = entry.response((DiskLruCache.Snapshot)object);
            if (entry.matches(request, (Response)object)) return object;
        }
        catch (IOException iOException) {
            Util.closeQuietly((Closeable)object);
            return null;
        }
        Util.closeQuietly(((Response)object).body());
        return null;
    }

    public int hitCount() {
        synchronized (this) {
            int n = this.hitCount;
            return n;
        }
    }

    public void initialize() throws IOException {
        this.cache.initialize();
    }

    public boolean isClosed() {
        return this.cache.isClosed();
    }

    public long maxSize() {
        return this.cache.getMaxSize();
    }

    public int networkCount() {
        synchronized (this) {
            int n = this.networkCount;
            return n;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    CacheRequest put(Response object) {
        Object object2;
        block9: {
            object2 = ((Response)object).request().method();
            if (HttpMethod.invalidatesCache(((Response)object).request().method())) {
                this.remove(((Response)object).request());
                return null;
            }
            if (!((String)object2).equals("GET")) {
                return null;
            }
            if (HttpHeaders.hasVaryAll((Response)object)) {
                return null;
            }
            object2 = new Entry((Response)object);
            object = this.cache.edit(Cache.key(((Response)object).request().url()));
            if (object != null) break block9;
            return null;
        }
        ((Entry)object2).writeTo((DiskLruCache.Editor)object);
        return new CacheRequestImpl((DiskLruCache.Editor)object);
        {
            catch (IOException iOException) {}
        }
        catch (IOException iOException) {
            block10: {
                object = null;
                break block10;
                catch (IOException iOException2) {
                    return null;
                }
            }
            this.abortQuietly((DiskLruCache.Editor)object);
            return null;
        }
    }

    void remove(Request request) throws IOException {
        this.cache.remove(Cache.key(request.url()));
    }

    public int requestCount() {
        synchronized (this) {
            int n = this.requestCount;
            return n;
        }
    }

    public long size() throws IOException {
        return this.cache.size();
    }

    void trackConditionalCacheHit() {
        synchronized (this) {
            ++this.hitCount;
            return;
        }
    }

    void trackResponse(CacheStrategy cacheStrategy) {
        synchronized (this) {
            ++this.requestCount;
            if (cacheStrategy.networkRequest != null) {
                ++this.networkCount;
            } else if (cacheStrategy.cacheResponse != null) {
                ++this.hitCount;
            }
            return;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void update(Response object, Response object2) {
        object2 = new Entry((Response)object2);
        object = ((CacheResponseBody)((Response)object).body()).snapshot;
        object = ((DiskLruCache.Snapshot)object).edit();
        if (object == null) return;
        ((Entry)object2).writeTo((DiskLruCache.Editor)object);
        ((DiskLruCache.Editor)object).commit();
        return;
        {
            catch (IOException iOException) {}
        }
        catch (IOException iOException) {
            object = null;
            this.abortQuietly((DiskLruCache.Editor)object);
        }
    }

    public Iterator<String> urls() throws IOException {
        return new Iterator<String>(){
            boolean canRemove;
            final Iterator<DiskLruCache.Snapshot> delegate;
            @Nullable
            String nextUrl;
            {
                this.delegate = Cache.this.cache.snapshots();
            }

            /*
             * Exception decompiling
             */
            @Override
            public boolean hasNext() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            @Override
            public String next() {
                if (this.hasNext()) {
                    String string2 = this.nextUrl;
                    this.nextUrl = null;
                    this.canRemove = true;
                    return string2;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                if (this.canRemove) {
                    this.delegate.remove();
                    return;
                }
                throw new IllegalStateException("remove() before next()");
            }
        };
    }

    public int writeAbortCount() {
        synchronized (this) {
            int n = this.writeAbortCount;
            return n;
        }
    }

    public int writeSuccessCount() {
        synchronized (this) {
            int n = this.writeSuccessCount;
            return n;
        }
    }

    private final class CacheRequestImpl
    implements CacheRequest {
        private Sink body;
        private Sink cacheOut;
        boolean done;
        private final DiskLruCache.Editor editor;

        CacheRequestImpl(final DiskLruCache.Editor editor) {
            this.editor = editor;
            this.cacheOut = editor.newSink(1);
            this.body = new ForwardingSink(this.cacheOut){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void close() throws IOException {
                    Cache cache = Cache.this;
                    synchronized (cache) {
                        if (CacheRequestImpl.this.done) {
                            return;
                        }
                        CacheRequestImpl.this.done = true;
                        Cache cache2 = Cache.this;
                        ++cache2.writeSuccessCount;
                    }
                    super.close();
                    editor.commit();
                }
            };
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void abort() {
            Cache cache = Cache.this;
            synchronized (cache) {
                if (this.done) {
                    return;
                }
                this.done = true;
                Cache cache2 = Cache.this;
                ++cache2.writeAbortCount;
            }
            Util.closeQuietly(this.cacheOut);
            try {
                this.editor.abort();
                return;
            }
            catch (IOException iOException) {
                return;
            }
        }

        @Override
        public Sink body() {
            return this.body;
        }
    }

    private static class CacheResponseBody
    extends ResponseBody {
        private final BufferedSource bodySource;
        @Nullable
        private final String contentLength;
        @Nullable
        private final String contentType;
        final DiskLruCache.Snapshot snapshot;

        CacheResponseBody(final DiskLruCache.Snapshot snapshot, String string2, String string3) {
            this.snapshot = snapshot;
            this.contentType = string2;
            this.contentLength = string3;
            this.bodySource = Okio.buffer(new ForwardingSource(snapshot.getSource(1)){

                @Override
                public void close() throws IOException {
                    snapshot.close();
                    super.close();
                }
            });
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public long contentLength() {
            String string2;
            long l = -1L;
            try {
                string2 = this.contentLength;
                long l2 = l;
                if (string2 == null) return l2;
            }
            catch (NumberFormatException numberFormatException) {
                return l;
            }
            return Long.parseLong(string2);
        }

        @Override
        public MediaType contentType() {
            Object object = this.contentType;
            object = object != null ? MediaType.parse((String)object) : null;
            return object;
        }

        @Override
        public BufferedSource source() {
            return this.bodySource;
        }
    }

    private static final class Entry {
        private static final String RECEIVED_MILLIS;
        private static final String SENT_MILLIS;
        private final int code;
        @Nullable
        private final Handshake handshake;
        private final String message;
        private final Protocol protocol;
        private final long receivedResponseMillis;
        private final String requestMethod;
        private final Headers responseHeaders;
        private final long sentRequestMillis;
        private final String url;
        private final Headers varyHeaders;

        static {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(Platform.get().getPrefix());
            stringBuilder.append("-Sent-Millis");
            SENT_MILLIS = stringBuilder.toString();
            stringBuilder = new StringBuilder();
            stringBuilder.append(Platform.get().getPrefix());
            stringBuilder.append("-Received-Millis");
            RECEIVED_MILLIS = stringBuilder.toString();
        }

        Entry(Response response) {
            this.url = response.request().url().toString();
            this.varyHeaders = HttpHeaders.varyHeaders(response);
            this.requestMethod = response.request().method();
            this.protocol = response.protocol();
            this.code = response.code();
            this.message = response.message();
            this.responseHeaders = response.headers();
            this.handshake = response.handshake();
            this.sentRequestMillis = response.sentRequestAtMillis();
            this.receivedResponseMillis = response.receivedResponseAtMillis();
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        Entry(Source source) throws IOException {
            int n;
            BufferedSource bufferedSource = Okio.buffer(source);
            this.url = bufferedSource.readUtf8LineStrict();
            this.requestMethod = bufferedSource.readUtf8LineStrict();
            Object object = new Object();
            int n2 = Cache.readInt(bufferedSource);
            int n3 = 0;
            for (n = 0; n < n2; ++n) {
                ((Headers.Builder)object).addLenient(bufferedSource.readUtf8LineStrict());
            }
            this.varyHeaders = ((Headers.Builder)object).build();
            object = StatusLine.parse(bufferedSource.readUtf8LineStrict());
            this.protocol = ((StatusLine)object).protocol;
            this.code = ((StatusLine)object).code;
            this.message = ((StatusLine)object).message;
            Object object2 = new Headers.Builder();
            n2 = Cache.readInt(bufferedSource);
            for (n = n3; n < n2; ++n) {
                ((Headers.Builder)object2).addLenient(bufferedSource.readUtf8LineStrict());
            }
            object = SENT_MILLIS;
            String string2 = ((Headers.Builder)object2).get((String)object);
            List<Certificate> list = RECEIVED_MILLIS;
            String string3 = ((Headers.Builder)object2).get((String)((Object)list));
            ((Headers.Builder)object2).removeAll((String)object);
            ((Headers.Builder)object2).removeAll((String)((Object)list));
            long l = 0L;
            long l2 = string2 != null ? Long.parseLong(string2) : 0L;
            this.sentRequestMillis = l2;
            l2 = l;
            if (string3 != null) {
                l2 = Long.parseLong(string3);
            }
            this.receivedResponseMillis = l2;
            this.responseHeaders = ((Headers.Builder)object2).build();
            if (this.isHttps()) {
                void var2_5;
                object = bufferedSource.readUtf8LineStrict();
                if (((String)object).length() > 0) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("expected \"\" but was \"");
                    stringBuilder.append((String)object);
                    stringBuilder.append("\"");
                    super(stringBuilder.toString());
                    throw list;
                }
                object2 = CipherSuite.forJavaName(bufferedSource.readUtf8LineStrict());
                list = this.readCertificateList(bufferedSource);
                object = this.readCertificateList(bufferedSource);
                if (!bufferedSource.exhausted()) {
                    TlsVersion tlsVersion = TlsVersion.forJavaName(bufferedSource.readUtf8LineStrict());
                } else {
                    TlsVersion tlsVersion = TlsVersion.SSL_3_0;
                }
                this.handshake = Handshake.get((TlsVersion)var2_5, (CipherSuite)object2, list, object);
                return;
            }
            this.handshake = null;
            return;
        }

        private boolean isHttps() {
            return this.url.startsWith("https://");
        }

        private List<Certificate> readCertificateList(BufferedSource bufferedSource) throws IOException {
            ArrayList<Certificate> arrayList;
            CertificateFactory certificateFactory;
            int n = Cache.readInt(bufferedSource);
            if (n == -1) {
                return Collections.emptyList();
            }
            try {
                certificateFactory = CertificateFactory.getInstance("X.509");
                arrayList = new ArrayList<Certificate>(n);
            }
            catch (CertificateException certificateException) {
                throw new IOException(certificateException.getMessage());
            }
            for (int i = 0; i < n; ++i) {
                String string2 = bufferedSource.readUtf8LineStrict();
                Buffer buffer = new Buffer();
                buffer.write(ByteString.decodeBase64(string2));
                arrayList.add(certificateFactory.generateCertificate(buffer.inputStream()));
                continue;
            }
            return arrayList;
        }

        private void writeCertList(BufferedSink bufferedSink, List<Certificate> list) throws IOException {
            int n;
            bufferedSink.writeDecimalLong(list.size()).writeByte(10);
            try {
                n = list.size();
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new IOException(certificateEncodingException.getMessage());
            }
            for (int i = 0; i < n; ++i) {
                bufferedSink.writeUtf8(ByteString.of(list.get(i).getEncoded()).base64()).writeByte(10);
                continue;
            }
            return;
        }

        public boolean matches(Request request, Response response) {
            boolean bl = this.url.equals(request.url().toString()) && this.requestMethod.equals(request.method()) && HttpHeaders.varyMatches(response, this.varyHeaders, request);
            return bl;
        }

        public Response response(DiskLruCache.Snapshot snapshot) {
            String string2 = this.responseHeaders.get("Content-Type");
            String string3 = this.responseHeaders.get("Content-Length");
            Request request = new Request.Builder().url(this.url).method(this.requestMethod, null).headers(this.varyHeaders).build();
            return new Response.Builder().request(request).protocol(this.protocol).code(this.code).message(this.message).headers(this.responseHeaders).body(new CacheResponseBody(snapshot, string2, string3)).handshake(this.handshake).sentRequestAtMillis(this.sentRequestMillis).receivedResponseAtMillis(this.receivedResponseMillis).build();
        }

        public void writeTo(DiskLruCache.Editor object) throws IOException {
            int n;
            int n2 = 0;
            object = Okio.buffer(((DiskLruCache.Editor)object).newSink(0));
            object.writeUtf8(this.url).writeByte(10);
            object.writeUtf8(this.requestMethod).writeByte(10);
            object.writeDecimalLong(this.varyHeaders.size()).writeByte(10);
            int n3 = this.varyHeaders.size();
            for (n = 0; n < n3; ++n) {
                object.writeUtf8(this.varyHeaders.name(n)).writeUtf8(": ").writeUtf8(this.varyHeaders.value(n)).writeByte(10);
            }
            object.writeUtf8(new StatusLine(this.protocol, this.code, this.message).toString()).writeByte(10);
            object.writeDecimalLong(this.responseHeaders.size() + 2).writeByte(10);
            n3 = this.responseHeaders.size();
            for (n = n2; n < n3; ++n) {
                object.writeUtf8(this.responseHeaders.name(n)).writeUtf8(": ").writeUtf8(this.responseHeaders.value(n)).writeByte(10);
            }
            object.writeUtf8(SENT_MILLIS).writeUtf8(": ").writeDecimalLong(this.sentRequestMillis).writeByte(10);
            object.writeUtf8(RECEIVED_MILLIS).writeUtf8(": ").writeDecimalLong(this.receivedResponseMillis).writeByte(10);
            if (this.isHttps()) {
                object.writeByte(10);
                object.writeUtf8(this.handshake.cipherSuite().javaName()).writeByte(10);
                this.writeCertList((BufferedSink)object, this.handshake.peerCertificates());
                this.writeCertList((BufferedSink)object, this.handshake.localCertificates());
                object.writeUtf8(this.handshake.tlsVersion().javaName()).writeByte(10);
            }
            object.close();
        }
    }
}

