/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.net.ssl.SSLPeerUnverifiedException;
import okhttp3.HttpUrl;
import okhttp3.internal.tls.CertificateChainCleaner;
import okio.ByteString;

public final class CertificatePinner {
    public static final CertificatePinner DEFAULT = new Builder().build();
    @Nullable
    private final CertificateChainCleaner certificateChainCleaner;
    private final Set<Pin> pins;

    CertificatePinner(Set<Pin> set, @Nullable CertificateChainCleaner certificateChainCleaner) {
        this.pins = set;
        this.certificateChainCleaner = certificateChainCleaner;
    }

    public static String pin(Certificate certificate) {
        if (certificate instanceof X509Certificate) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("sha256/");
            stringBuilder.append(CertificatePinner.sha256((X509Certificate)certificate).base64());
            return stringBuilder.toString();
        }
        throw new IllegalArgumentException("Certificate pinning requires X509 certificates");
    }

    static ByteString sha1(X509Certificate x509Certificate) {
        return ByteString.of(x509Certificate.getPublicKey().getEncoded()).sha1();
    }

    static ByteString sha256(X509Certificate x509Certificate) {
        return ByteString.of(x509Certificate.getPublicKey().getEncoded()).sha256();
    }

    public void check(String object, List<Certificate> object2) throws SSLPeerUnverifiedException {
        int n;
        int n2;
        List<Pin> list = this.findMatchingPins((String)object);
        if (list.isEmpty()) {
            return;
        }
        Object object3 = this.certificateChainCleaner;
        List<Certificate> list2 = object2;
        if (object3 != null) {
            list2 = ((CertificateChainCleaner)object3).clean((List<Certificate>)object2, (String)object);
        }
        int n3 = list2.size();
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            X509Certificate x509Certificate = (X509Certificate)list2.get(n2);
            int n5 = list.size();
            object3 = null;
            object2 = null;
            for (n = 0; n < n5; ++n) {
                Object object4;
                Pin pin = list.get(n);
                if (pin.hashAlgorithm.equals("sha256/")) {
                    object4 = object3;
                    if (object3 == null) {
                        object4 = CertificatePinner.sha256(x509Certificate);
                    }
                    object3 = object4;
                    if (!pin.hash.equals(object4)) continue;
                    return;
                }
                if (pin.hashAlgorithm.equals("sha1/")) {
                    object4 = object2;
                    if (object2 == null) {
                        object4 = CertificatePinner.sha1(x509Certificate);
                    }
                    object2 = object4;
                    if (!pin.hash.equals(object4)) continue;
                    return;
                }
                object = new StringBuilder();
                ((StringBuilder)object).append("unsupported hashAlgorithm: ");
                ((StringBuilder)object).append(pin.hashAlgorithm);
                throw new AssertionError((Object)((StringBuilder)object).toString());
            }
        }
        object2 = new StringBuilder();
        ((StringBuilder)object2).append("Certificate pinning failure!");
        ((StringBuilder)object2).append("\n  Peer certificate chain:");
        n = list2.size();
        for (n2 = 0; n2 < n; ++n2) {
            object3 = (X509Certificate)list2.get(n2);
            ((StringBuilder)object2).append("\n    ");
            ((StringBuilder)object2).append(CertificatePinner.pin((Certificate)object3));
            ((StringBuilder)object2).append(": ");
            ((StringBuilder)object2).append(((X509Certificate)object3).getSubjectDN().getName());
        }
        ((StringBuilder)object2).append("\n  Pinned certificates for ");
        ((StringBuilder)object2).append((String)object);
        ((StringBuilder)object2).append(":");
        n = list.size();
        for (n2 = n4; n2 < n; ++n2) {
            object = list.get(n2);
            ((StringBuilder)object2).append("\n    ");
            ((StringBuilder)object2).append(object);
        }
        throw new SSLPeerUnverifiedException(((StringBuilder)object2).toString());
    }

    public void check(String string2, Certificate ... certificateArray) throws SSLPeerUnverifiedException {
        this.check(string2, Arrays.asList(certificateArray));
    }

    public boolean equals(@Nullable Object object) {
        boolean bl;
        block5: {
            block4: {
                bl = true;
                if (object == this) {
                    return true;
                }
                if (!(object instanceof CertificatePinner)) break block4;
                CertificateChainCleaner certificateChainCleaner = this.certificateChainCleaner;
                object = (CertificatePinner)object;
                if (Objects.equals(certificateChainCleaner, ((CertificatePinner)object).certificateChainCleaner) && this.pins.equals(((CertificatePinner)object).pins)) break block5;
            }
            bl = false;
        }
        return bl;
    }

    List<Pin> findMatchingPins(String string2) {
        List<Pin> list = Collections.emptyList();
        for (Pin pin : this.pins) {
            if (!pin.matches(string2)) continue;
            List<Pin> list2 = list;
            if (list.isEmpty()) {
                list2 = new ArrayList<Pin>();
            }
            list2.add(pin);
            list = list2;
        }
        return list;
    }

    public int hashCode() {
        return Objects.hashCode(this.certificateChainCleaner) * 31 + this.pins.hashCode();
    }

    CertificatePinner withCertificateChainCleaner(@Nullable CertificateChainCleaner object) {
        object = Objects.equals(this.certificateChainCleaner, object) ? this : new CertificatePinner(this.pins, (CertificateChainCleaner)object);
        return object;
    }

    public static final class Builder {
        private final List<Pin> pins = new ArrayList<Pin>();

        public Builder add(String string2, String ... stringArray) {
            Objects.requireNonNull(string2, "pattern == null");
            for (String string3 : stringArray) {
                this.pins.add(new Pin(string2, string3));
            }
            return this;
        }

        public CertificatePinner build() {
            return new CertificatePinner(new LinkedHashSet<Pin>(this.pins), null);
        }
    }

    static final class Pin {
        private static final String WILDCARD = "*.";
        final String canonicalHostname;
        final ByteString hash;
        final String hashAlgorithm;
        final String pattern;

        Pin(String charSequence, String string2) {
            block8: {
                block7: {
                    block6: {
                        this.pattern = charSequence;
                        if (((String)charSequence).startsWith(WILDCARD)) {
                            StringBuilder stringBuilder = new StringBuilder();
                            stringBuilder.append("http://");
                            stringBuilder.append(((String)charSequence).substring(2));
                            charSequence = HttpUrl.get(stringBuilder.toString()).host();
                        } else {
                            StringBuilder stringBuilder = new StringBuilder();
                            stringBuilder.append("http://");
                            stringBuilder.append((String)charSequence);
                            charSequence = HttpUrl.get(stringBuilder.toString()).host();
                        }
                        this.canonicalHostname = charSequence;
                        if (!string2.startsWith("sha1/")) break block6;
                        this.hashAlgorithm = "sha1/";
                        this.hash = ByteString.decodeBase64(string2.substring(5));
                        break block7;
                    }
                    if (!string2.startsWith("sha256/")) break block8;
                    this.hashAlgorithm = "sha256/";
                    this.hash = ByteString.decodeBase64(string2.substring(7));
                }
                if (this.hash != null) {
                    return;
                }
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append("pins must be base64: ");
                ((StringBuilder)charSequence).append(string2);
                throw new IllegalArgumentException(((StringBuilder)charSequence).toString());
            }
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("pins must start with 'sha256/' or 'sha1/': ");
            ((StringBuilder)charSequence).append(string2);
            throw new IllegalArgumentException(((StringBuilder)charSequence).toString());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            if (!(object instanceof Pin)) return false;
            String string2 = this.pattern;
            object = (Pin)object;
            if (!string2.equals(((Pin)object).pattern)) return false;
            if (!this.hashAlgorithm.equals(((Pin)object).hashAlgorithm)) return false;
            if (!this.hash.equals(((Pin)object).hash)) return false;
            return true;
        }

        public int hashCode() {
            return ((527 + this.pattern.hashCode()) * 31 + this.hashAlgorithm.hashCode()) * 31 + this.hash.hashCode();
        }

        boolean matches(String string2) {
            if (this.pattern.startsWith(WILDCARD)) {
                String string3;
                int n = string2.indexOf(46);
                int n2 = string2.length();
                boolean bl = true;
                if (n2 - n - 1 != this.canonicalHostname.length() || !string2.regionMatches(false, n + 1, string3 = this.canonicalHostname, 0, string3.length())) {
                    bl = false;
                }
                return bl;
            }
            return string2.equals(this.canonicalHostname);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.hashAlgorithm);
            stringBuilder.append(this.hash.base64());
            return stringBuilder.toString();
        }
    }
}

