/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public final class Challenge {
    private final Map<String, String> authParams;
    private final String scheme;

    public Challenge(String string2, String string3) {
        Objects.requireNonNull(string2, "scheme == null");
        Objects.requireNonNull(string3, "realm == null");
        this.scheme = string2;
        this.authParams = Collections.singletonMap("realm", string3);
    }

    public Challenge(String string2, Map<String, String> object) {
        Objects.requireNonNull(string2, "scheme == null");
        Objects.requireNonNull(object, "authParams == null");
        this.scheme = string2;
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        for (Map.Entry entry : object.entrySet()) {
            string2 = entry.getKey() == null ? null : ((String)entry.getKey()).toLowerCase(Locale.US);
            linkedHashMap.put(string2, (String)entry.getValue());
        }
        this.authParams = Collections.unmodifiableMap(linkedHashMap);
    }

    public Map<String, String> authParams() {
        return this.authParams;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Charset charset() {
        String string2 = this.authParams.get("charset");
        if (string2 == null) return StandardCharsets.ISO_8859_1;
        try {
            return Charset.forName(string2);
        }
        catch (Exception exception) {
            return StandardCharsets.ISO_8859_1;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object object) {
        if (!(object instanceof Challenge)) return false;
        object = (Challenge)object;
        if (!((Challenge)object).scheme.equals(this.scheme)) return false;
        if (!((Challenge)object).authParams.equals(this.authParams)) return false;
        return true;
    }

    public int hashCode() {
        return (899 + this.scheme.hashCode()) * 31 + this.authParams.hashCode();
    }

    public String realm() {
        return this.authParams.get("realm");
    }

    public String scheme() {
        return this.scheme;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.scheme);
        stringBuilder.append(" authParams=");
        stringBuilder.append(this.authParams);
        return stringBuilder.toString();
    }

    public Challenge withCharset(Charset charset) {
        Objects.requireNonNull(charset, "charset == null");
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>(this.authParams);
        linkedHashMap.put("charset", charset.name());
        return new Challenge(this.scheme, linkedHashMap);
    }
}

