/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.net.ssl.SSLSocket;
import okhttp3.CipherSuite;
import okhttp3.TlsVersion;
import okhttp3.internal.Util;

public final class ConnectionSpec {
    private static final CipherSuite[] APPROVED_CIPHER_SUITES;
    public static final ConnectionSpec CLEARTEXT;
    public static final ConnectionSpec COMPATIBLE_TLS;
    public static final ConnectionSpec MODERN_TLS;
    private static final CipherSuite[] RESTRICTED_CIPHER_SUITES;
    public static final ConnectionSpec RESTRICTED_TLS;
    @Nullable
    final String[] cipherSuites;
    final boolean supportsTlsExtensions;
    final boolean tls;
    @Nullable
    final String[] tlsVersions;

    static {
        CipherSuite[] cipherSuiteArray = new CipherSuite[]{CipherSuite.TLS_AES_128_GCM_SHA256, CipherSuite.TLS_AES_256_GCM_SHA384, CipherSuite.TLS_CHACHA20_POLY1305_SHA256, CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384, CipherSuite.TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384, CipherSuite.TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256, CipherSuite.TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256};
        RESTRICTED_CIPHER_SUITES = cipherSuiteArray;
        CipherSuite[] cipherSuiteArray2 = new CipherSuite[]{CipherSuite.TLS_AES_128_GCM_SHA256, CipherSuite.TLS_AES_256_GCM_SHA384, CipherSuite.TLS_CHACHA20_POLY1305_SHA256, CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384, CipherSuite.TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384, CipherSuite.TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256, CipherSuite.TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256, CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA, CipherSuite.TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA, CipherSuite.TLS_RSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_RSA_WITH_AES_256_GCM_SHA384, CipherSuite.TLS_RSA_WITH_AES_128_CBC_SHA, CipherSuite.TLS_RSA_WITH_AES_256_CBC_SHA, CipherSuite.TLS_RSA_WITH_3DES_EDE_CBC_SHA};
        APPROVED_CIPHER_SUITES = cipherSuiteArray2;
        RESTRICTED_TLS = new Builder(true).cipherSuites(cipherSuiteArray).tlsVersions(TlsVersion.TLS_1_3, TlsVersion.TLS_1_2).supportsTlsExtensions(true).build();
        MODERN_TLS = new Builder(true).cipherSuites(cipherSuiteArray2).tlsVersions(TlsVersion.TLS_1_3, TlsVersion.TLS_1_2).supportsTlsExtensions(true).build();
        COMPATIBLE_TLS = new Builder(true).cipherSuites(cipherSuiteArray2).tlsVersions(TlsVersion.TLS_1_3, TlsVersion.TLS_1_2, TlsVersion.TLS_1_1, TlsVersion.TLS_1_0).supportsTlsExtensions(true).build();
        CLEARTEXT = new Builder(false).build();
    }

    ConnectionSpec(Builder builder) {
        this.tls = builder.tls;
        this.cipherSuites = builder.cipherSuites;
        this.tlsVersions = builder.tlsVersions;
        this.supportsTlsExtensions = builder.supportsTlsExtensions;
    }

    private ConnectionSpec supportedSpec(SSLSocket stringArray, boolean bl) {
        String[] stringArray2 = this.cipherSuites != null ? Util.intersect(CipherSuite.ORDER_BY_NAME, stringArray.getEnabledCipherSuites(), this.cipherSuites) : stringArray.getEnabledCipherSuites();
        String[] stringArray3 = this.tlsVersions != null ? Util.intersect(Util.NATURAL_ORDER, stringArray.getEnabledProtocols(), this.tlsVersions) : stringArray.getEnabledProtocols();
        String[] stringArray4 = stringArray.getSupportedCipherSuites();
        int n = Util.indexOf(CipherSuite.ORDER_BY_NAME, stringArray4, "TLS_FALLBACK_SCSV");
        stringArray = stringArray2;
        if (bl) {
            stringArray = stringArray2;
            if (n != -1) {
                stringArray = Util.concat(stringArray2, stringArray4[n]);
            }
        }
        return new Builder(this).cipherSuites(stringArray).tlsVersions(stringArray3).build();
    }

    void apply(SSLSocket sSLSocket, boolean bl) {
        String[] stringArray = this.supportedSpec(sSLSocket, bl);
        String[] stringArray2 = stringArray.tlsVersions;
        if (stringArray2 != null) {
            sSLSocket.setEnabledProtocols(stringArray2);
        }
        if ((stringArray = stringArray.cipherSuites) != null) {
            sSLSocket.setEnabledCipherSuites(stringArray);
        }
    }

    @Nullable
    public List<CipherSuite> cipherSuites() {
        Object object = this.cipherSuites;
        object = object != null ? CipherSuite.forJavaNames(object) : null;
        return object;
    }

    public boolean equals(@Nullable Object object) {
        if (!(object instanceof ConnectionSpec)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        object = (ConnectionSpec)object;
        boolean bl = this.tls;
        if (bl != ((ConnectionSpec)object).tls) {
            return false;
        }
        if (bl) {
            if (!Arrays.equals(this.cipherSuites, ((ConnectionSpec)object).cipherSuites)) {
                return false;
            }
            if (!Arrays.equals(this.tlsVersions, ((ConnectionSpec)object).tlsVersions)) {
                return false;
            }
            if (this.supportsTlsExtensions != ((ConnectionSpec)object).supportsTlsExtensions) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int n = this.tls ? ((527 + Arrays.hashCode(this.cipherSuites)) * 31 + Arrays.hashCode(this.tlsVersions)) * 31 + (this.supportsTlsExtensions ^ 1) : 17;
        return n;
    }

    public boolean isCompatible(SSLSocket sSLSocket) {
        if (!this.tls) {
            return false;
        }
        if (this.tlsVersions != null && !Util.nonEmptyIntersection(Util.NATURAL_ORDER, this.tlsVersions, sSLSocket.getEnabledProtocols())) {
            return false;
        }
        return this.cipherSuites == null || Util.nonEmptyIntersection(CipherSuite.ORDER_BY_NAME, this.cipherSuites, sSLSocket.getEnabledCipherSuites());
    }

    public boolean isTls() {
        return this.tls;
    }

    public boolean supportsTlsExtensions() {
        return this.supportsTlsExtensions;
    }

    @Nullable
    public List<TlsVersion> tlsVersions() {
        Object object = this.tlsVersions;
        object = object != null ? TlsVersion.forJavaNames(object) : null;
        return object;
    }

    public String toString() {
        if (!this.tls) {
            return "ConnectionSpec()";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ConnectionSpec(cipherSuites=");
        stringBuilder.append(Objects.toString(this.cipherSuites(), "[all enabled]"));
        stringBuilder.append(", tlsVersions=");
        stringBuilder.append(Objects.toString(this.tlsVersions(), "[all enabled]"));
        stringBuilder.append(", supportsTlsExtensions=");
        stringBuilder.append(this.supportsTlsExtensions);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static final class Builder {
        @Nullable
        String[] cipherSuites;
        boolean supportsTlsExtensions;
        boolean tls;
        @Nullable
        String[] tlsVersions;

        public Builder(ConnectionSpec connectionSpec) {
            this.tls = connectionSpec.tls;
            this.cipherSuites = connectionSpec.cipherSuites;
            this.tlsVersions = connectionSpec.tlsVersions;
            this.supportsTlsExtensions = connectionSpec.supportsTlsExtensions;
        }

        Builder(boolean bl) {
            this.tls = bl;
        }

        public Builder allEnabledCipherSuites() {
            if (this.tls) {
                this.cipherSuites = null;
                return this;
            }
            throw new IllegalStateException("no cipher suites for cleartext connections");
        }

        public Builder allEnabledTlsVersions() {
            if (this.tls) {
                this.tlsVersions = null;
                return this;
            }
            throw new IllegalStateException("no TLS versions for cleartext connections");
        }

        public ConnectionSpec build() {
            return new ConnectionSpec(this);
        }

        public Builder cipherSuites(String ... stringArray) {
            if (this.tls) {
                if (stringArray.length != 0) {
                    this.cipherSuites = (String[])stringArray.clone();
                    return this;
                }
                throw new IllegalArgumentException("At least one cipher suite is required");
            }
            throw new IllegalStateException("no cipher suites for cleartext connections");
        }

        public Builder cipherSuites(CipherSuite ... cipherSuiteArray) {
            if (this.tls) {
                String[] stringArray = new String[cipherSuiteArray.length];
                for (int i = 0; i < cipherSuiteArray.length; ++i) {
                    stringArray[i] = cipherSuiteArray[i].javaName;
                }
                return this.cipherSuites(stringArray);
            }
            throw new IllegalStateException("no cipher suites for cleartext connections");
        }

        public Builder supportsTlsExtensions(boolean bl) {
            if (this.tls) {
                this.supportsTlsExtensions = bl;
                return this;
            }
            throw new IllegalStateException("no TLS extensions for cleartext connections");
        }

        public Builder tlsVersions(String ... stringArray) {
            if (this.tls) {
                if (stringArray.length != 0) {
                    this.tlsVersions = (String[])stringArray.clone();
                    return this;
                }
                throw new IllegalArgumentException("At least one TLS version is required");
            }
            throw new IllegalStateException("no TLS versions for cleartext connections");
        }

        public Builder tlsVersions(TlsVersion ... tlsVersionArray) {
            if (this.tls) {
                String[] stringArray = new String[tlsVersionArray.length];
                for (int i = 0; i < tlsVersionArray.length; ++i) {
                    stringArray[i] = tlsVersionArray[i].javaName;
                }
                return this.tlsVersions(stringArray);
            }
            throw new IllegalStateException("no TLS versions for cleartext connections");
        }
    }
}

