/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.internal.Util;
import okhttp3.internal.http.HttpDate;
import okhttp3.internal.publicsuffix.PublicSuffixDatabase;

public final class Cookie {
    private static final Pattern DAY_OF_MONTH_PATTERN;
    private static final Pattern MONTH_PATTERN;
    private static final Pattern TIME_PATTERN;
    private static final Pattern YEAR_PATTERN;
    private final String domain;
    private final long expiresAt;
    private final boolean hostOnly;
    private final boolean httpOnly;
    private final String name;
    private final String path;
    private final boolean persistent;
    private final boolean secure;
    private final String value;

    static {
        YEAR_PATTERN = Pattern.compile("(\\d{2,4})[^\\d]*");
        MONTH_PATTERN = Pattern.compile("(?i)(jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec).*");
        DAY_OF_MONTH_PATTERN = Pattern.compile("(\\d{1,2})[^\\d]*");
        TIME_PATTERN = Pattern.compile("(\\d{1,2}):(\\d{1,2}):(\\d{1,2})[^\\d]*");
    }

    private Cookie(String string2, String string3, long l, String string4, String string5, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.name = string2;
        this.value = string3;
        this.expiresAt = l;
        this.domain = string4;
        this.path = string5;
        this.secure = bl;
        this.httpOnly = bl2;
        this.hostOnly = bl3;
        this.persistent = bl4;
    }

    Cookie(Builder builder) {
        Objects.requireNonNull(builder.name, "builder.name == null");
        Objects.requireNonNull(builder.value, "builder.value == null");
        Objects.requireNonNull(builder.domain, "builder.domain == null");
        this.name = builder.name;
        this.value = builder.value;
        this.expiresAt = builder.expiresAt;
        this.domain = builder.domain;
        this.path = builder.path;
        this.secure = builder.secure;
        this.httpOnly = builder.httpOnly;
        this.persistent = builder.persistent;
        this.hostOnly = builder.hostOnly;
    }

    private static int dateCharacterOffset(String string2, int n, int n2, boolean bl) {
        while (n < n2) {
            char c = string2.charAt(n);
            c = !(c < ' ' && c != '\t' || c >= '\u007f' || c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == ':') ? (char)'\u0000' : '\u0001';
            if (c == (bl ^ '\u0001')) {
                return n;
            }
            ++n;
        }
        return n2;
    }

    private static boolean domainMatch(String string2, String string3) {
        if (string2.equals(string3)) {
            return true;
        }
        return string2.endsWith(string3) && string2.charAt(string2.length() - string3.length() - 1) == '.' && !Util.verifyAsIpAddress(string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    static Cookie parse(long l, HttpUrl object, String string2) {
        String string3;
        int n = string2.length();
        int n2 = Util.delimiterOffset(string2, 0, n, ';');
        int n3 = Util.delimiterOffset(string2, 0, n2, '=');
        if (n3 == n2) {
            return null;
        }
        String string4 = Util.trimSubstring(string2, 0, n3);
        if (string4.isEmpty()) return null;
        if (Util.indexOfControlOrNonAscii(string4) != -1) {
            return null;
        }
        String string5 = Util.trimSubstring(string2, n3 + 1, n2);
        if (Util.indexOfControlOrNonAscii(string5) != -1) {
            return null;
        }
        ++n2;
        String string6 = string3 = null;
        long l2 = -1L;
        long l3 = 253402300799999L;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        boolean bl4 = false;
        while (true) {
            long l4;
            boolean bl5;
            boolean bl6;
            boolean bl7;
            String string7;
            long l5;
            String string8;
            int n4;
            block23: {
                block26: {
                    block27: {
                        block28: {
                            block25: {
                                block21: {
                                    String string9;
                                    block24: {
                                        block22: {
                                            block20: {
                                                if (n2 >= n) break block21;
                                                n4 = Util.delimiterOffset(string2, n2, n, ';');
                                                n3 = Util.delimiterOffset(string2, n2, n4, '=');
                                                string9 = Util.trimSubstring(string2, n2, n3);
                                                string8 = n3 < n4 ? Util.trimSubstring(string2, n3 + 1, n4) : "";
                                                if (string9.equalsIgnoreCase("expires")) {
                                                    l3 = l5 = Cookie.parseExpires(string8, 0, string8.length());
                                                    break block20;
                                                }
                                                if (!string9.equalsIgnoreCase("max-age")) break block22;
                                                try {
                                                    l2 = l5 = Cookie.parseMaxAge(string8);
                                                }
                                                catch (IllegalArgumentException | NumberFormatException illegalArgumentException) {
                                                    string8 = string3;
                                                    string7 = string6;
                                                    bl7 = bl;
                                                    bl6 = bl3;
                                                    bl5 = bl4;
                                                    l5 = l2;
                                                    l4 = l3;
                                                }
                                            }
                                            bl5 = true;
                                            string8 = string3;
                                            string7 = string6;
                                            bl7 = bl;
                                            bl6 = bl3;
                                            l5 = l2;
                                            l4 = l3;
                                            break block23;
                                        }
                                        if (string9.equalsIgnoreCase("domain")) {
                                            string7 = Cookie.parseDomain(string8);
                                            bl6 = false;
                                            string8 = string3;
                                            bl7 = bl;
                                            bl5 = bl4;
                                            l5 = l2;
                                            l4 = l3;
                                        }
                                        if (!string9.equalsIgnoreCase("path")) break block24;
                                        string7 = string6;
                                        bl7 = bl;
                                        bl6 = bl3;
                                        bl5 = bl4;
                                        l5 = l2;
                                        l4 = l3;
                                        break block23;
                                    }
                                    if (string9.equalsIgnoreCase("secure")) {
                                        bl7 = true;
                                        string8 = string3;
                                        string7 = string6;
                                        bl6 = bl3;
                                        bl5 = bl4;
                                        l5 = l2;
                                        l4 = l3;
                                        break block23;
                                    } else {
                                        string8 = string3;
                                        string7 = string6;
                                        bl7 = bl;
                                        bl6 = bl3;
                                        bl5 = bl4;
                                        l5 = l2;
                                        l4 = l3;
                                        if (string9.equalsIgnoreCase("httponly")) {
                                            bl2 = true;
                                            l4 = l3;
                                            l5 = l2;
                                            bl5 = bl4;
                                            bl6 = bl3;
                                            bl7 = bl;
                                            string7 = string6;
                                            string8 = string3;
                                        }
                                    }
                                    break block23;
                                }
                                l5 = Long.MIN_VALUE;
                                if (l2 != Long.MIN_VALUE) break block25;
                                l = l5;
                                break block26;
                            }
                            if (l2 == -1L) break block27;
                            l3 = l2 <= 9223372036854775L ? l2 * 1000L : Long.MAX_VALUE;
                            if ((l3 = l + l3) < l) break block28;
                            l = l3;
                            if (l3 <= 253402300799999L) break block26;
                        }
                        l = 253402300799999L;
                        break block26;
                    }
                    l = l3;
                }
                string8 = ((HttpUrl)object).host();
                if (string6 == null) {
                    string2 = string8;
                } else {
                    if (!Cookie.domainMatch(string8, string6)) {
                        return null;
                    }
                    string2 = string6;
                }
                if (string8.length() != string2.length() && PublicSuffixDatabase.get().getEffectiveTldPlusOne(string2) == null) {
                    return null;
                }
                string6 = "/";
                if (string3 != null && string3.startsWith("/")) {
                    object = string3;
                    return new Cookie(string4, string5, l, string2, (String)object, bl, bl2, bl3, bl4);
                }
                string3 = ((HttpUrl)object).encodedPath();
                n2 = string3.lastIndexOf(47);
                object = string6;
                if (n2 == 0) return new Cookie(string4, string5, l, string2, (String)object, bl, bl2, bl3, bl4);
                object = string3.substring(0, n2);
                return new Cookie(string4, string5, l, string2, (String)object, bl, bl2, bl3, bl4);
            }
            n2 = n4 + 1;
            string3 = string8;
            string6 = string7;
            bl = bl7;
            bl3 = bl6;
            bl4 = bl5;
            l2 = l5;
            l3 = l4;
        }
    }

    @Nullable
    public static Cookie parse(HttpUrl httpUrl, String string2) {
        return Cookie.parse(System.currentTimeMillis(), httpUrl, string2);
    }

    public static List<Cookie> parseAll(HttpUrl list, Headers object) {
        List<String> list2 = ((Headers)object).values("Set-Cookie");
        int n = list2.size();
        object = null;
        for (int i = 0; i < n; ++i) {
            Cookie cookie = Cookie.parse((HttpUrl)((Object)list), list2.get(i));
            if (cookie == null) continue;
            Object object2 = object;
            if (object == null) {
                object2 = new ArrayList();
            }
            object2.add(cookie);
            object = object2;
        }
        list = object != null ? Collections.unmodifiableList(object) : Collections.emptyList();
        return list;
    }

    private static String parseDomain(String string2) {
        if (!string2.endsWith(".")) {
            String string3 = string2;
            if (string2.startsWith(".")) {
                string3 = string2.substring(1);
            }
            if ((string2 = Util.canonicalizeHost(string3)) != null) {
                return string2;
            }
            throw new IllegalArgumentException();
        }
        throw new IllegalArgumentException();
    }

    private static long parseExpires(String object, int n, int n2) {
        int n3 = Cookie.dateCharacterOffset((String)object, n, n2, false);
        Matcher matcher = TIME_PATTERN.matcher((CharSequence)object);
        n = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        while (n3 < n2) {
            Pattern pattern;
            int n9;
            int n10;
            int n11;
            int n12;
            int n13;
            int n14 = Cookie.dateCharacterOffset((String)object, n3 + 1, n2, true);
            matcher.region(n3, n14);
            if (n4 == -1 && matcher.usePattern(TIME_PATTERN).matches()) {
                n13 = Integer.parseInt(matcher.group(1));
                n12 = Integer.parseInt(matcher.group(2));
                n11 = Integer.parseInt(matcher.group(3));
                n3 = n;
                n10 = n5;
                n9 = n6;
            } else if (n5 == -1 && matcher.usePattern(DAY_OF_MONTH_PATTERN).matches()) {
                n10 = Integer.parseInt(matcher.group(1));
                n3 = n;
                n13 = n4;
                n9 = n6;
                n12 = n7;
                n11 = n8;
            } else if (n6 == -1 && matcher.usePattern(pattern = MONTH_PATTERN).matches()) {
                String string2 = matcher.group(1).toLowerCase(Locale.US);
                n9 = pattern.pattern().indexOf(string2) / 4;
                n3 = n;
                n13 = n4;
                n10 = n5;
                n12 = n7;
                n11 = n8;
            } else {
                n3 = n;
                n13 = n4;
                n10 = n5;
                n9 = n6;
                n12 = n7;
                n11 = n8;
                if (n == -1) {
                    n3 = n;
                    n13 = n4;
                    n10 = n5;
                    n9 = n6;
                    n12 = n7;
                    n11 = n8;
                    if (matcher.usePattern(YEAR_PATTERN).matches()) {
                        n3 = Integer.parseInt(matcher.group(1));
                        n11 = n8;
                        n12 = n7;
                        n9 = n6;
                        n10 = n5;
                        n13 = n4;
                    }
                }
            }
            n14 = Cookie.dateCharacterOffset((String)object, n14 + 1, n2, false);
            n = n3;
            n4 = n13;
            n5 = n10;
            n6 = n9;
            n7 = n12;
            n8 = n11;
            n3 = n14;
        }
        n2 = n;
        if (n >= 70) {
            n2 = n;
            if (n <= 99) {
                n2 = n + 1900;
            }
        }
        n = n2;
        if (n2 >= 0) {
            n = n2;
            if (n2 <= 69) {
                n = n2 + 2000;
            }
        }
        if (n >= 1601) {
            if (n6 != -1) {
                if (n5 >= 1 && n5 <= 31) {
                    if (n4 >= 0 && n4 <= 23) {
                        if (n7 >= 0 && n7 <= 59) {
                            if (n8 >= 0 && n8 <= 59) {
                                object = new GregorianCalendar(Util.UTC);
                                ((Calendar)object).setLenient(false);
                                ((Calendar)object).set(1, n);
                                ((Calendar)object).set(2, n6 - 1);
                                ((Calendar)object).set(5, n5);
                                ((Calendar)object).set(11, n4);
                                ((Calendar)object).set(12, n7);
                                ((Calendar)object).set(13, n8);
                                ((Calendar)object).set(14, 0);
                                return ((Calendar)object).getTimeInMillis();
                            }
                            throw new IllegalArgumentException();
                        }
                        throw new IllegalArgumentException();
                    }
                    throw new IllegalArgumentException();
                }
                throw new IllegalArgumentException();
            }
            throw new IllegalArgumentException();
        }
        throw new IllegalArgumentException();
    }

    private static long parseMaxAge(String string2) {
        long l = Long.MIN_VALUE;
        try {
            long l2 = Long.parseLong(string2);
            if (l2 > 0L) {
                l = l2;
            }
            return l;
        }
        catch (NumberFormatException numberFormatException) {
            if (string2.matches("-?\\d+")) {
                if (!string2.startsWith("-")) {
                    l = Long.MAX_VALUE;
                }
                return l;
            }
            throw numberFormatException;
        }
    }

    private static boolean pathMatch(HttpUrl object, String string2) {
        if (((String)(object = ((HttpUrl)object).encodedPath())).equals(string2)) {
            return true;
        }
        if (((String)object).startsWith(string2)) {
            if (string2.endsWith("/")) {
                return true;
            }
            if (((String)object).charAt(string2.length()) == '/') {
                return true;
            }
        }
        return false;
    }

    public String domain() {
        return this.domain;
    }

    public boolean equals(@Nullable Object object) {
        boolean bl = object instanceof Cookie;
        boolean bl2 = false;
        if (!bl) {
            return false;
        }
        object = (Cookie)object;
        bl = bl2;
        if (((Cookie)object).name.equals(this.name)) {
            bl = bl2;
            if (((Cookie)object).value.equals(this.value)) {
                bl = bl2;
                if (((Cookie)object).domain.equals(this.domain)) {
                    bl = bl2;
                    if (((Cookie)object).path.equals(this.path)) {
                        bl = bl2;
                        if (((Cookie)object).expiresAt == this.expiresAt) {
                            bl = bl2;
                            if (((Cookie)object).secure == this.secure) {
                                bl = bl2;
                                if (((Cookie)object).httpOnly == this.httpOnly) {
                                    bl = bl2;
                                    if (((Cookie)object).persistent == this.persistent) {
                                        bl = bl2;
                                        if (((Cookie)object).hostOnly == this.hostOnly) {
                                            bl = true;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return bl;
    }

    public long expiresAt() {
        return this.expiresAt;
    }

    public int hashCode() {
        int n = this.name.hashCode();
        int n2 = this.value.hashCode();
        int n3 = this.domain.hashCode();
        int n4 = this.path.hashCode();
        long l = this.expiresAt;
        return ((((((((527 + n) * 31 + n2) * 31 + n3) * 31 + n4) * 31 + (int)(l ^ l >>> 32)) * 31 + (this.secure ^ 1)) * 31 + (this.httpOnly ^ 1)) * 31 + (this.persistent ^ 1)) * 31 + (this.hostOnly ^ 1);
    }

    public boolean hostOnly() {
        return this.hostOnly;
    }

    public boolean httpOnly() {
        return this.httpOnly;
    }

    public boolean matches(HttpUrl httpUrl) {
        boolean bl = this.hostOnly ? httpUrl.host().equals(this.domain) : Cookie.domainMatch(httpUrl.host(), this.domain);
        if (!bl) {
            return false;
        }
        if (!Cookie.pathMatch(httpUrl, this.path)) {
            return false;
        }
        return !this.secure || httpUrl.isHttps();
    }

    public String name() {
        return this.name;
    }

    public String path() {
        return this.path;
    }

    public boolean persistent() {
        return this.persistent;
    }

    public boolean secure() {
        return this.secure;
    }

    public String toString() {
        return this.toString(false);
    }

    String toString(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.name);
        stringBuilder.append('=');
        stringBuilder.append(this.value);
        if (this.persistent) {
            if (this.expiresAt == Long.MIN_VALUE) {
                stringBuilder.append("; max-age=0");
            } else {
                stringBuilder.append("; expires=");
                stringBuilder.append(HttpDate.format(new Date(this.expiresAt)));
            }
        }
        if (!this.hostOnly) {
            stringBuilder.append("; domain=");
            if (bl) {
                stringBuilder.append(".");
            }
            stringBuilder.append(this.domain);
        }
        stringBuilder.append("; path=");
        stringBuilder.append(this.path);
        if (this.secure) {
            stringBuilder.append("; secure");
        }
        if (this.httpOnly) {
            stringBuilder.append("; httponly");
        }
        return stringBuilder.toString();
    }

    public String value() {
        return this.value;
    }

    public static final class Builder {
        @Nullable
        String domain;
        long expiresAt = 253402300799999L;
        boolean hostOnly;
        boolean httpOnly;
        @Nullable
        String name;
        String path = "/";
        boolean persistent;
        boolean secure;
        @Nullable
        String value;

        private Builder domain(String string2, boolean bl) {
            Objects.requireNonNull(string2, "domain == null");
            CharSequence charSequence = Util.canonicalizeHost(string2);
            if (charSequence != null) {
                this.domain = charSequence;
                this.hostOnly = bl;
                return this;
            }
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("unexpected domain: ");
            ((StringBuilder)charSequence).append(string2);
            throw new IllegalArgumentException(((StringBuilder)charSequence).toString());
        }

        public Cookie build() {
            return new Cookie(this);
        }

        public Builder domain(String string2) {
            return this.domain(string2, false);
        }

        public Builder expiresAt(long l) {
            long l2 = l;
            if (l <= 0L) {
                l2 = Long.MIN_VALUE;
            }
            l = l2;
            if (l2 > 253402300799999L) {
                l = 253402300799999L;
            }
            this.expiresAt = l;
            this.persistent = true;
            return this;
        }

        public Builder hostOnlyDomain(String string2) {
            return this.domain(string2, true);
        }

        public Builder httpOnly() {
            this.httpOnly = true;
            return this;
        }

        public Builder name(String string2) {
            Objects.requireNonNull(string2, "name == null");
            if (string2.trim().equals(string2)) {
                this.name = string2;
                return this;
            }
            throw new IllegalArgumentException("name is not trimmed");
        }

        public Builder path(String string2) {
            if (string2.startsWith("/")) {
                this.path = string2;
                return this;
            }
            throw new IllegalArgumentException("path must start with '/'");
        }

        public Builder secure() {
            this.secure = true;
            return this;
        }

        public Builder value(String string2) {
            Objects.requireNonNull(string2, "value == null");
            if (string2.trim().equals(string2)) {
                this.value = string2;
                return this;
            }
            throw new IllegalArgumentException("value is not trimmed");
        }
    }
}

