/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import okhttp3.Call;
import okhttp3.RealCall;
import okhttp3.internal.Util;

public final class Dispatcher {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    @Nullable
    private ExecutorService executorService;
    @Nullable
    private Runnable idleCallback;
    private int maxRequests = 64;
    private int maxRequestsPerHost = 5;
    private final Deque<RealCall.AsyncCall> readyAsyncCalls = new ArrayDeque<RealCall.AsyncCall>();
    private final Deque<RealCall.AsyncCall> runningAsyncCalls = new ArrayDeque<RealCall.AsyncCall>();
    private final Deque<RealCall> runningSyncCalls = new ArrayDeque<RealCall>();

    public Dispatcher() {
    }

    public Dispatcher(ExecutorService executorService) {
        this.executorService = executorService;
    }

    @Nullable
    private RealCall.AsyncCall findExistingCallWithHost(String string2) {
        for (RealCall.AsyncCall asyncCall : this.runningAsyncCalls) {
            if (!asyncCall.host().equals(string2)) continue;
            return asyncCall;
        }
        for (RealCall.AsyncCall asyncCall : this.readyAsyncCalls) {
            if (!asyncCall.host().equals(string2)) continue;
            return asyncCall;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private <T> void finished(Deque<T> object, T t) {
        // MONITORENTER : this
        if (object.remove(t)) {
            object = this.idleCallback;
            // MONITOREXIT : this
            if (this.promoteAndExecute()) return;
            if (object == null) return;
            object.run();
            return;
        }
        object = new AssertionError((Object)"Call wasn't in-flight!");
        throw object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean promoteAndExecute() {
        boolean bl;
        int n;
        int n2;
        ArrayList<RealCall.AsyncCall> arrayList = new ArrayList<RealCall.AsyncCall>();
        synchronized (this) {
            Iterator<RealCall.AsyncCall> iterator2 = this.readyAsyncCalls.iterator();
            while (iterator2.hasNext()) {
                RealCall.AsyncCall asyncCall = iterator2.next();
                if (this.runningAsyncCalls.size() >= this.maxRequests) break;
                if (asyncCall.callsPerHost().get() >= this.maxRequestsPerHost) continue;
                iterator2.remove();
                asyncCall.callsPerHost().incrementAndGet();
                arrayList.add(asyncCall);
                this.runningAsyncCalls.add(asyncCall);
            }
            n2 = this.runningCallsCount();
            n = 0;
            bl = n2 > 0;
        }
        n2 = arrayList.size();
        while (n < n2) {
            ((RealCall.AsyncCall)arrayList.get(n)).executeOn(this.executorService());
            ++n;
        }
        return bl;
    }

    public void cancelAll() {
        synchronized (this) {
            Iterator<Object> iterator2 = this.readyAsyncCalls.iterator();
            while (iterator2.hasNext()) {
                iterator2.next().get().cancel();
            }
            iterator2 = this.runningAsyncCalls.iterator();
            while (iterator2.hasNext()) {
                iterator2.next().get().cancel();
            }
            iterator2 = this.runningSyncCalls.iterator();
            while (iterator2.hasNext()) {
                ((RealCall)iterator2.next()).cancel();
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void enqueue(RealCall.AsyncCall asyncCall) {
        synchronized (this) {
            RealCall.AsyncCall asyncCall2;
            this.readyAsyncCalls.add(asyncCall);
            if (!asyncCall.get().forWebSocket && (asyncCall2 = this.findExistingCallWithHost(asyncCall.host())) != null) {
                asyncCall.reuseCallsPerHostFrom(asyncCall2);
            }
        }
        this.promoteAndExecute();
    }

    void executed(RealCall realCall) {
        synchronized (this) {
            this.runningSyncCalls.add(realCall);
            return;
        }
    }

    public ExecutorService executorService() {
        synchronized (this) {
            ExecutorService executorService;
            if (this.executorService == null) {
                TimeUnit timeUnit = TimeUnit.SECONDS;
                SynchronousQueue<Runnable> synchronousQueue = new SynchronousQueue<Runnable>();
                executorService = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, timeUnit, synchronousQueue, Util.threadFactory("OkHttp Dispatcher", false));
                this.executorService = executorService;
            }
            executorService = this.executorService;
            return executorService;
        }
    }

    void finished(RealCall.AsyncCall asyncCall) {
        asyncCall.callsPerHost().decrementAndGet();
        this.finished(this.runningAsyncCalls, asyncCall);
    }

    void finished(RealCall realCall) {
        this.finished(this.runningSyncCalls, realCall);
    }

    public int getMaxRequests() {
        synchronized (this) {
            int n = this.maxRequests;
            return n;
        }
    }

    public int getMaxRequestsPerHost() {
        synchronized (this) {
            int n = this.maxRequestsPerHost;
            return n;
        }
    }

    public List<Call> queuedCalls() {
        synchronized (this) {
            ArrayList<RealCall> arrayList = new ArrayList<RealCall>();
            Object object = this.readyAsyncCalls.iterator();
            while (object.hasNext()) {
                arrayList.add(object.next().get());
            }
            object = Collections.unmodifiableList(arrayList);
            return object;
        }
    }

    public int queuedCallsCount() {
        synchronized (this) {
            int n = this.readyAsyncCalls.size();
            return n;
        }
    }

    public List<Call> runningCalls() {
        synchronized (this) {
            ArrayList<RealCall> arrayList = new ArrayList<RealCall>();
            arrayList.addAll(this.runningSyncCalls);
            Object object = this.runningAsyncCalls.iterator();
            while (object.hasNext()) {
                arrayList.add(object.next().get());
            }
            object = Collections.unmodifiableList(arrayList);
            return object;
        }
    }

    public int runningCallsCount() {
        synchronized (this) {
            int n = this.runningAsyncCalls.size();
            int n2 = this.runningSyncCalls.size();
            return n + n2;
        }
    }

    public void setIdleCallback(@Nullable Runnable runnable) {
        synchronized (this) {
            this.idleCallback = runnable;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setMaxRequests(int n) {
        if (n >= 1) {
            synchronized (this) {
                this.maxRequests = n;
            }
            this.promoteAndExecute();
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("max < 1: ");
        stringBuilder.append(n);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setMaxRequestsPerHost(int n) {
        if (n >= 1) {
            synchronized (this) {
                this.maxRequestsPerHost = n;
            }
            this.promoteAndExecute();
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("max < 1: ");
        stringBuilder.append(n);
        throw new IllegalArgumentException(stringBuilder.toString());
    }
}

