/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.Nullable;
import okhttp3.internal.Util;
import okhttp3.internal.http.HttpDate;

public final class Headers {
    private final String[] namesAndValues;

    Headers(Builder builder) {
        this.namesAndValues = builder.namesAndValues.toArray(new String[builder.namesAndValues.size()]);
    }

    private Headers(String[] stringArray) {
        this.namesAndValues = stringArray;
    }

    static void checkName(String string2) {
        Objects.requireNonNull(string2, "name == null");
        if (!string2.isEmpty()) {
            int n = string2.length();
            for (int i = 0; i < n; ++i) {
                char c = string2.charAt(i);
                if (c > ' ' && c < '\u007f') {
                    continue;
                }
                throw new IllegalArgumentException(Util.format("Unexpected char %#04x at %d in header name: %s", c, i, string2));
            }
            return;
        }
        throw new IllegalArgumentException("name is empty");
    }

    static void checkValue(String charSequence, String string2) {
        if (charSequence != null) {
            int n = ((String)charSequence).length();
            for (int i = 0; i < n; ++i) {
                char c = ((String)charSequence).charAt(i);
                if ((c > '\u001f' || c == '\t') && c < '\u007f') {
                    continue;
                }
                throw new IllegalArgumentException(Util.format("Unexpected char %#04x at %d in %s value: %s", c, i, string2, charSequence));
            }
            return;
        }
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append("value for name ");
        ((StringBuilder)charSequence).append(string2);
        ((StringBuilder)charSequence).append(" == null");
        throw new NullPointerException(((StringBuilder)charSequence).toString());
    }

    @Nullable
    private static String get(String[] stringArray, String string2) {
        for (int i = stringArray.length - 2; i >= 0; i -= 2) {
            if (!string2.equalsIgnoreCase(stringArray[i])) continue;
            return stringArray[i + 1];
        }
        return null;
    }

    public static Headers of(Map<String, String> object) {
        Objects.requireNonNull(object, "headers == null");
        String[] stringArray = new String[object.size() * 2];
        int n = 0;
        for (Map.Entry entry : object.entrySet()) {
            if (entry.getKey() != null && entry.getValue() != null) {
                String string2 = ((String)entry.getKey()).trim();
                String object2 = ((String)entry.getValue()).trim();
                Headers.checkName(string2);
                Headers.checkValue(object2, string2);
                stringArray[n] = string2;
                stringArray[n + 1] = object2;
                n += 2;
                continue;
            }
            throw new IllegalArgumentException("Headers cannot be null");
        }
        return new Headers(stringArray);
    }

    public static Headers of(String ... stringArray) {
        Objects.requireNonNull(stringArray, "namesAndValues == null");
        if (stringArray.length % 2 == 0) {
            block3: {
                stringArray = (String[])stringArray.clone();
                int n = 0;
                int n2 = 0;
                while (true) {
                    if (n2 >= stringArray.length) break block3;
                    if (stringArray[n2] == null) break;
                    stringArray[n2] = stringArray[n2].trim();
                    ++n2;
                }
                throw new IllegalArgumentException("Headers cannot be null");
            }
            for (int i = n; i < stringArray.length; i += 2) {
                String string2 = stringArray[i];
                String string3 = stringArray[i + 1];
                Headers.checkName(string2);
                Headers.checkValue(string3, string2);
            }
            return new Headers(stringArray);
        }
        throw new IllegalArgumentException("Expected alternating header names and values");
    }

    public long byteCount() {
        String[] stringArray = this.namesAndValues;
        long l = stringArray.length * 2;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            l += (long)this.namesAndValues[i].length();
        }
        return l;
    }

    public boolean equals(@Nullable Object object) {
        boolean bl = object instanceof Headers && Arrays.equals(((Headers)object).namesAndValues, this.namesAndValues);
        return bl;
    }

    @Nullable
    public String get(String string2) {
        return Headers.get(this.namesAndValues, string2);
    }

    @Nullable
    public Date getDate(String object) {
        object = (object = this.get((String)object)) != null ? HttpDate.parse((String)object) : null;
        return object;
    }

    @Nullable
    public Instant getInstant(String object) {
        object = (object = this.getDate((String)object)) != null ? ((Date)object).toInstant() : null;
        return object;
    }

    public int hashCode() {
        return Arrays.hashCode(this.namesAndValues);
    }

    public String name(int n) {
        return this.namesAndValues[n * 2];
    }

    public Set<String> names() {
        TreeSet<String> treeSet = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            treeSet.add(this.name(i));
        }
        return Collections.unmodifiableSet(treeSet);
    }

    public Builder newBuilder() {
        Builder builder = new Builder();
        Collections.addAll(builder.namesAndValues, this.namesAndValues);
        return builder;
    }

    public int size() {
        return this.namesAndValues.length / 2;
    }

    public Map<String, List<String>> toMultimap() {
        TreeMap<String, List<String>> treeMap = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            ArrayList<String> arrayList;
            String string2 = this.name(i).toLowerCase(Locale.US);
            ArrayList<String> arrayList2 = arrayList = (ArrayList<String>)treeMap.get(string2);
            if (arrayList == null) {
                arrayList2 = new ArrayList<String>(2);
                treeMap.put(string2, arrayList2);
            }
            arrayList2.add(this.value(i));
        }
        return treeMap;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(this.name(i));
            stringBuilder.append(": ");
            stringBuilder.append(this.value(i));
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public String value(int n) {
        return this.namesAndValues[n * 2 + 1];
    }

    public List<String> values(String list) {
        int n = this.size();
        ArrayList<String> arrayList = null;
        for (int i = 0; i < n; ++i) {
            ArrayList<String> arrayList2 = arrayList;
            if (((String)((Object)list)).equalsIgnoreCase(this.name(i))) {
                arrayList2 = arrayList;
                if (arrayList == null) {
                    arrayList2 = new ArrayList<String>(2);
                }
                arrayList2.add(this.value(i));
            }
            arrayList = arrayList2;
        }
        list = arrayList != null ? Collections.unmodifiableList(arrayList) : Collections.emptyList();
        return list;
    }

    public static final class Builder {
        final List<String> namesAndValues = new ArrayList<String>(20);

        public Builder add(String string2) {
            int n = string2.indexOf(":");
            if (n != -1) {
                return this.add(string2.substring(0, n).trim(), string2.substring(n + 1));
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Unexpected header: ");
            stringBuilder.append(string2);
            throw new IllegalArgumentException(stringBuilder.toString());
        }

        public Builder add(String string2, String string3) {
            Headers.checkName(string2);
            Headers.checkValue(string3, string2);
            return this.addLenient(string2, string3);
        }

        public Builder add(String string2, Instant comparable) {
            if (comparable != null) {
                return this.add(string2, new Date(((Instant)comparable).toEpochMilli()));
            }
            comparable = new StringBuilder();
            ((StringBuilder)comparable).append("value for name ");
            ((StringBuilder)comparable).append(string2);
            ((StringBuilder)comparable).append(" == null");
            throw new NullPointerException(((StringBuilder)comparable).toString());
        }

        public Builder add(String string2, Date comparable) {
            if (comparable != null) {
                this.add(string2, HttpDate.format((Date)comparable));
                return this;
            }
            comparable = new StringBuilder();
            ((StringBuilder)comparable).append("value for name ");
            ((StringBuilder)comparable).append(string2);
            ((StringBuilder)comparable).append(" == null");
            throw new NullPointerException(((StringBuilder)comparable).toString());
        }

        public Builder addAll(Headers headers) {
            int n = headers.size();
            for (int i = 0; i < n; ++i) {
                this.addLenient(headers.name(i), headers.value(i));
            }
            return this;
        }

        Builder addLenient(String string2) {
            int n = string2.indexOf(":", 1);
            if (n != -1) {
                return this.addLenient(string2.substring(0, n), string2.substring(n + 1));
            }
            if (string2.startsWith(":")) {
                return this.addLenient("", string2.substring(1));
            }
            return this.addLenient("", string2);
        }

        Builder addLenient(String string2, String string3) {
            this.namesAndValues.add(string2);
            this.namesAndValues.add(string3.trim());
            return this;
        }

        public Builder addUnsafeNonAscii(String string2, String string3) {
            Headers.checkName(string2);
            return this.addLenient(string2, string3);
        }

        public Headers build() {
            return new Headers(this);
        }

        @Nullable
        public String get(String string2) {
            for (int i = this.namesAndValues.size() - 2; i >= 0; i -= 2) {
                if (!string2.equalsIgnoreCase(this.namesAndValues.get(i))) continue;
                return this.namesAndValues.get(i + 1);
            }
            return null;
        }

        public Builder removeAll(String string2) {
            int n = 0;
            while (n < this.namesAndValues.size()) {
                int n2 = n;
                if (string2.equalsIgnoreCase(this.namesAndValues.get(n))) {
                    this.namesAndValues.remove(n);
                    this.namesAndValues.remove(n);
                    n2 = n - 2;
                }
                n = n2 + 2;
            }
            return this;
        }

        public Builder set(String string2, String string3) {
            Headers.checkName(string2);
            Headers.checkValue(string3, string2);
            this.removeAll(string2);
            this.addLenient(string2, string3);
            return this;
        }

        public Builder set(String string2, Instant comparable) {
            if (comparable != null) {
                return this.set(string2, new Date(((Instant)comparable).toEpochMilli()));
            }
            comparable = new StringBuilder();
            ((StringBuilder)comparable).append("value for name ");
            ((StringBuilder)comparable).append(string2);
            ((StringBuilder)comparable).append(" == null");
            throw new NullPointerException(((StringBuilder)comparable).toString());
        }

        public Builder set(String string2, Date comparable) {
            if (comparable != null) {
                this.set(string2, HttpDate.format((Date)comparable));
                return this;
            }
            comparable = new StringBuilder();
            ((StringBuilder)comparable).append("value for name ");
            ((StringBuilder)comparable).append(string2);
            ((StringBuilder)comparable).append(" == null");
            throw new NullPointerException(((StringBuilder)comparable).toString());
        }
    }
}

