/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import okhttp3.internal.Util;
import okhttp3.internal.publicsuffix.PublicSuffixDatabase;
import okio.Buffer;

public final class HttpUrl {
    static final String FORM_ENCODE_SET = " \"':;<=>@[]^`{}|/\\?#&!$(),~";
    static final String FRAGMENT_ENCODE_SET = "";
    static final String FRAGMENT_ENCODE_SET_URI = " \"#<>\\^`{|}";
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    static final String PASSWORD_ENCODE_SET = " \"':;<=>@[]^`{}|/\\?#";
    static final String PATH_SEGMENT_ENCODE_SET = " \"<>^`{}|/\\?#";
    static final String PATH_SEGMENT_ENCODE_SET_URI = "[]";
    static final String QUERY_COMPONENT_ENCODE_SET = " !\"#$&'(),/:;<=>?@[]\\^`{|}~";
    static final String QUERY_COMPONENT_ENCODE_SET_URI = "\\^`{|}";
    static final String QUERY_COMPONENT_REENCODE_SET = " \"'<>#&=";
    static final String QUERY_ENCODE_SET = " \"'<>#";
    static final String USERNAME_ENCODE_SET = " \"':;<=>@[]^`{}|/\\?#";
    @Nullable
    private final String fragment;
    final String host;
    private final String password;
    private final List<String> pathSegments;
    final int port;
    @Nullable
    private final List<String> queryNamesAndValues;
    final String scheme;
    private final String url;
    private final String username;

    HttpUrl(Builder builder) {
        this.scheme = builder.scheme;
        this.username = HttpUrl.percentDecode(builder.encodedUsername, false);
        this.password = HttpUrl.percentDecode(builder.encodedPassword, false);
        this.host = builder.host;
        this.port = builder.effectivePort();
        this.pathSegments = this.percentDecode(builder.encodedPathSegments, false);
        List<String> list = builder.encodedQueryNamesAndValues;
        Object var3_3 = null;
        list = list != null ? this.percentDecode(builder.encodedQueryNamesAndValues, true) : null;
        this.queryNamesAndValues = list;
        list = var3_3;
        if (builder.encodedFragment != null) {
            list = HttpUrl.percentDecode(builder.encodedFragment, false);
        }
        this.fragment = list;
        this.url = builder.toString();
    }

    static String canonicalize(String string2, int n, int n2, String string3, boolean bl, boolean bl2, boolean bl3, boolean bl4, @Nullable Charset charset) {
        int n3;
        for (int i = n; i < n2; i += Character.charCount(n3)) {
            n3 = string2.codePointAt(i);
            if (!(n3 < 32 || n3 == 127 || n3 >= 128 && bl4 || string3.indexOf(n3) != -1 || n3 == 37 && (!bl || bl2 && !HttpUrl.percentEncoded(string2, i, n2)) || n3 == 43 && bl3)) {
                continue;
            }
            Buffer buffer = new Buffer();
            buffer.writeUtf8(string2, n, i);
            HttpUrl.canonicalize(buffer, string2, i, n2, string3, bl, bl2, bl3, bl4, charset);
            return buffer.readUtf8();
        }
        return string2.substring(n, n2);
    }

    static String canonicalize(String string2, String string3, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        return HttpUrl.canonicalize(string2, 0, string2.length(), string3, bl, bl2, bl3, bl4, null);
    }

    static String canonicalize(String string2, String string3, boolean bl, boolean bl2, boolean bl3, boolean bl4, @Nullable Charset charset) {
        return HttpUrl.canonicalize(string2, 0, string2.length(), string3, bl, bl2, bl3, bl4, charset);
    }

    /*
     * Exception decompiling
     */
    static void canonicalize(Buffer var0, String var1_1, int var2_2, int var3_3, String var4_4, boolean var5_5, boolean var6_6, boolean var7_7, boolean var8_8, @Nullable Charset var9_9) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Statement already marked as first in another block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.markFirstStatementInBlock(Op03SimpleStatement.java:461)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Misc.markWholeBlock(Misc.java:251)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.considerAsSimpleIf(ConditionalRewriter.java:673)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.identifyNonjumpingConditionals(ConditionalRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:722)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static int defaultPort(String string2) {
        if (string2.equals("http")) {
            return 80;
        }
        if (string2.equals("https")) {
            return 443;
        }
        return -1;
    }

    public static HttpUrl get(String string2) {
        return new Builder().parse(null, string2).build();
    }

    @Nullable
    public static HttpUrl get(URI uRI) {
        return HttpUrl.parse(uRI.toString());
    }

    @Nullable
    public static HttpUrl get(URL uRL) {
        return HttpUrl.parse(uRL.toString());
    }

    static void namesAndValuesToQueryString(StringBuilder stringBuilder, List<String> list) {
        int n = list.size();
        for (int i = 0; i < n; i += 2) {
            String string2 = list.get(i);
            String string3 = list.get(i + 1);
            if (i > 0) {
                stringBuilder.append('&');
            }
            stringBuilder.append(string2);
            if (string3 == null) continue;
            stringBuilder.append('=');
            stringBuilder.append(string3);
        }
    }

    @Nullable
    public static HttpUrl parse(String object) {
        try {
            object = HttpUrl.get((String)object);
            return object;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    static void pathSegmentsToString(StringBuilder stringBuilder, List<String> list) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append('/');
            stringBuilder.append(list.get(i));
        }
    }

    static String percentDecode(String string2, int n, int n2, boolean bl) {
        for (int i = n; i < n2; ++i) {
            char c = string2.charAt(i);
            if (!(c == '%' || c == '+' && bl)) {
                continue;
            }
            Buffer buffer = new Buffer();
            buffer.writeUtf8(string2, n, i);
            HttpUrl.percentDecode(buffer, string2, i, n2, bl);
            return buffer.readUtf8();
        }
        return string2.substring(n, n2);
    }

    static String percentDecode(String string2, boolean bl) {
        return HttpUrl.percentDecode(string2, 0, string2.length(), bl);
    }

    private List<String> percentDecode(List<String> list, boolean bl) {
        int n = list.size();
        ArrayList<String> arrayList = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            String string2 = list.get(i);
            string2 = string2 != null ? HttpUrl.percentDecode(string2, bl) : null;
            arrayList.add(string2);
        }
        return Collections.unmodifiableList(arrayList);
    }

    /*
     * Unable to fully structure code
     */
    static void percentDecode(Buffer var0, String var1_1, int var2_2, int var3_3, boolean var4_4) {
        while (var2_2 < var3_3) {
            block4: {
                block3: {
                    var5_5 = var1_1.codePointAt(var2_2);
                    if (var5_5 != 37 || (var6_6 = var2_2 + 2) >= var3_3) break block3;
                    var7_7 = Util.decodeHexDigit(var1_1.charAt(var2_2 + 1));
                    var8_8 = Util.decodeHexDigit(var1_1.charAt(var6_6));
                    if (var7_7 == -1 || var8_8 == -1) ** GOTO lbl-1000
                    var0.writeByte((var7_7 << 4) + var8_8);
                    var2_2 = var6_6;
                    break block4;
                }
                if (var5_5 == 43 && var4_4) {
                    var0.writeByte(32);
                } else lbl-1000:
                // 2 sources

                {
                    var0.writeUtf8CodePoint(var5_5);
                }
            }
            var2_2 += Character.charCount(var5_5);
        }
    }

    static boolean percentEncoded(String string2, int n, int n2) {
        int n3 = n + 2;
        boolean bl = true;
        if (n3 >= n2 || string2.charAt(n) != '%' || Util.decodeHexDigit(string2.charAt(n + 1)) == -1 || Util.decodeHexDigit(string2.charAt(n3)) == -1) {
            bl = false;
        }
        return bl;
    }

    static List<String> queryStringToNamesAndValues(String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n <= string2.length()) {
            int n2;
            int n3 = n2 = string2.indexOf(38, n);
            if (n2 == -1) {
                n3 = string2.length();
            }
            if ((n2 = string2.indexOf(61, n)) != -1 && n2 <= n3) {
                arrayList.add(string2.substring(n, n2));
                arrayList.add(string2.substring(n2 + 1, n3));
            } else {
                arrayList.add(string2.substring(n, n3));
                arrayList.add(null);
            }
            n = n3 + 1;
        }
        return arrayList;
    }

    @Nullable
    public String encodedFragment() {
        if (this.fragment == null) {
            return null;
        }
        int n = this.url.indexOf(35);
        return this.url.substring(n + 1);
    }

    public String encodedPassword() {
        if (this.password.isEmpty()) {
            return FRAGMENT_ENCODE_SET;
        }
        int n = this.url.indexOf(58, this.scheme.length() + 3);
        int n2 = this.url.indexOf(64);
        return this.url.substring(n + 1, n2);
    }

    public String encodedPath() {
        int n = this.url.indexOf(47, this.scheme.length() + 3);
        String string2 = this.url;
        int n2 = Util.delimiterOffset(string2, n, string2.length(), "?#");
        return this.url.substring(n, n2);
    }

    public List<String> encodedPathSegments() {
        int n = this.url.indexOf(47, this.scheme.length() + 3);
        Object object = this.url;
        int n2 = Util.delimiterOffset((String)object, n, ((String)object).length(), "?#");
        object = new ArrayList();
        while (n < n2) {
            int n3 = n + 1;
            n = Util.delimiterOffset(this.url, n3, n2, '/');
            object.add(this.url.substring(n3, n));
        }
        return object;
    }

    @Nullable
    public String encodedQuery() {
        if (this.queryNamesAndValues == null) {
            return null;
        }
        int n = this.url.indexOf(63) + 1;
        String string2 = this.url;
        int n2 = Util.delimiterOffset(string2, n, string2.length(), '#');
        return this.url.substring(n, n2);
    }

    public String encodedUsername() {
        if (this.username.isEmpty()) {
            return FRAGMENT_ENCODE_SET;
        }
        int n = this.scheme.length() + 3;
        String string2 = this.url;
        int n2 = Util.delimiterOffset(string2, n, string2.length(), ":@");
        return this.url.substring(n, n2);
    }

    public boolean equals(@Nullable Object object) {
        boolean bl = object instanceof HttpUrl && ((HttpUrl)object).url.equals(this.url);
        return bl;
    }

    @Nullable
    public String fragment() {
        return this.fragment;
    }

    public int hashCode() {
        return this.url.hashCode();
    }

    public String host() {
        return this.host;
    }

    public boolean isHttps() {
        return this.scheme.equals("https");
    }

    public Builder newBuilder() {
        Builder builder = new Builder();
        builder.scheme = this.scheme;
        builder.encodedUsername = this.encodedUsername();
        builder.encodedPassword = this.encodedPassword();
        builder.host = this.host;
        int n = this.port != HttpUrl.defaultPort(this.scheme) ? this.port : -1;
        builder.port = n;
        builder.encodedPathSegments.clear();
        builder.encodedPathSegments.addAll(this.encodedPathSegments());
        builder.encodedQuery(this.encodedQuery());
        builder.encodedFragment = this.encodedFragment();
        return builder;
    }

    @Nullable
    public Builder newBuilder(String object) {
        try {
            Builder builder = new Builder();
            object = builder.parse(this, (String)object);
            return object;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public String password() {
        return this.password;
    }

    public List<String> pathSegments() {
        return this.pathSegments;
    }

    public int pathSize() {
        return this.pathSegments.size();
    }

    public int port() {
        return this.port;
    }

    @Nullable
    public String query() {
        if (this.queryNamesAndValues == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        HttpUrl.namesAndValuesToQueryString(stringBuilder, this.queryNamesAndValues);
        return stringBuilder.toString();
    }

    @Nullable
    public String queryParameter(String string2) {
        List<String> list = this.queryNamesAndValues;
        if (list == null) {
            return null;
        }
        int n = list.size();
        for (int i = 0; i < n; i += 2) {
            if (!string2.equals(this.queryNamesAndValues.get(i))) continue;
            return this.queryNamesAndValues.get(i + 1);
        }
        return null;
    }

    public String queryParameterName(int n) {
        List<String> list = this.queryNamesAndValues;
        if (list != null) {
            return list.get(n * 2);
        }
        throw new IndexOutOfBoundsException();
    }

    public Set<String> queryParameterNames() {
        if (this.queryNamesAndValues == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        int n = this.queryNamesAndValues.size();
        for (int i = 0; i < n; i += 2) {
            linkedHashSet.add(this.queryNamesAndValues.get(i));
        }
        return Collections.unmodifiableSet(linkedHashSet);
    }

    public String queryParameterValue(int n) {
        List<String> list = this.queryNamesAndValues;
        if (list != null) {
            return list.get(n * 2 + 1);
        }
        throw new IndexOutOfBoundsException();
    }

    public List<String> queryParameterValues(String string2) {
        if (this.queryNamesAndValues == null) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = this.queryNamesAndValues.size();
        for (int i = 0; i < n; i += 2) {
            if (!string2.equals(this.queryNamesAndValues.get(i))) continue;
            arrayList.add(this.queryNamesAndValues.get(i + 1));
        }
        return Collections.unmodifiableList(arrayList);
    }

    public int querySize() {
        List<String> list = this.queryNamesAndValues;
        int n = list != null ? list.size() / 2 : 0;
        return n;
    }

    public String redact() {
        return this.newBuilder("/...").username(FRAGMENT_ENCODE_SET).password(FRAGMENT_ENCODE_SET).build().toString();
    }

    @Nullable
    public HttpUrl resolve(String object) {
        object = (object = this.newBuilder((String)object)) != null ? ((Builder)object).build() : null;
        return object;
    }

    public String scheme() {
        return this.scheme;
    }

    public String toString() {
        return this.url;
    }

    @Nullable
    public String topPrivateDomain() {
        if (Util.verifyAsIpAddress(this.host)) {
            return null;
        }
        return PublicSuffixDatabase.get().getEffectiveTldPlusOne(this.host);
    }

    public URI uri() {
        Object object = this.newBuilder().reencodeForUri().toString();
        try {
            URI uRI = new URI((String)object);
            return uRI;
        }
        catch (URISyntaxException uRISyntaxException) {
            try {
                object = URI.create(((String)object).replaceAll("[\\u0000-\\u001F\\u007F-\\u009F\\p{javaWhitespace}]", FRAGMENT_ENCODE_SET));
                return object;
            }
            catch (Exception exception) {
                throw new RuntimeException(uRISyntaxException);
            }
        }
    }

    public URL url() {
        try {
            URL uRL = new URL(this.url);
            return uRL;
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    public String username() {
        return this.username;
    }

    public static final class Builder {
        static final String INVALID_HOST = "Invalid URL host";
        @Nullable
        String encodedFragment;
        String encodedPassword = "";
        final List<String> encodedPathSegments;
        @Nullable
        List<String> encodedQueryNamesAndValues;
        String encodedUsername = "";
        @Nullable
        String host;
        int port = -1;
        @Nullable
        String scheme;

        public Builder() {
            ArrayList<String> arrayList = new ArrayList<String>();
            this.encodedPathSegments = arrayList;
            arrayList.add(HttpUrl.FRAGMENT_ENCODE_SET);
        }

        private Builder addPathSegments(String string2, boolean bl) {
            int n;
            int n2 = 0;
            do {
                boolean bl2 = (n = Util.delimiterOffset(string2, n2, string2.length(), "/\\")) < string2.length();
                this.push(string2, n2, n, bl2, bl);
                n2 = ++n;
            } while (n <= string2.length());
            return this;
        }

        @Nullable
        private static String canonicalizeHost(String string2, int n, int n2) {
            return Util.canonicalizeHost(HttpUrl.percentDecode(string2, n, n2, false));
        }

        private boolean isDot(String string2) {
            boolean bl = string2.equals(".") || string2.equalsIgnoreCase("%2e");
            return bl;
        }

        private boolean isDotDot(String string2) {
            boolean bl = string2.equals("..") || string2.equalsIgnoreCase("%2e.") || string2.equalsIgnoreCase(".%2e") || string2.equalsIgnoreCase("%2e%2e");
            return bl;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static int parsePort(String string2, int n, int n2) {
            block3: {
                try {
                    n = Integer.parseInt(HttpUrl.canonicalize(string2, n, n2, HttpUrl.FRAGMENT_ENCODE_SET, false, false, false, true, null));
                    if (n <= 0 || n > 65535) break block3;
                    return n;
                }
                catch (NumberFormatException numberFormatException) {
                    return -1;
                }
            }
            return -1;
        }

        private void pop() {
            List<String> list = this.encodedPathSegments;
            if (list.remove(list.size() - 1).isEmpty() && !this.encodedPathSegments.isEmpty()) {
                list = this.encodedPathSegments;
                list.set(list.size() - 1, HttpUrl.FRAGMENT_ENCODE_SET);
            } else {
                this.encodedPathSegments.add(HttpUrl.FRAGMENT_ENCODE_SET);
            }
        }

        private static int portColonOffset(String string2, int n, int n2) {
            while (n < n2) {
                char c = string2.charAt(n);
                if (c != ':') {
                    int n3;
                    block5: {
                        n3 = n;
                        if (c != '[') {
                            n3 = n;
                        } else {
                            do {
                                n3 = n = n3 + 1;
                                if (n >= n2) break block5;
                                n3 = n;
                            } while (string2.charAt(n) != ']');
                            n3 = n;
                        }
                    }
                    n = n3 + 1;
                    continue;
                }
                return n;
            }
            return n2;
        }

        private void push(String string2, int n, int n2, boolean bl, boolean bl2) {
            if (this.isDot(string2 = HttpUrl.canonicalize(string2, n, n2, HttpUrl.PATH_SEGMENT_ENCODE_SET, bl2, false, false, true, null))) {
                return;
            }
            if (this.isDotDot(string2)) {
                this.pop();
                return;
            }
            List<String> list = this.encodedPathSegments;
            if (list.get(list.size() - 1).isEmpty()) {
                list = this.encodedPathSegments;
                list.set(list.size() - 1, string2);
            } else {
                this.encodedPathSegments.add(string2);
            }
            if (bl) {
                this.encodedPathSegments.add(HttpUrl.FRAGMENT_ENCODE_SET);
            }
        }

        private void removeAllCanonicalQueryParameters(String string2) {
            for (int i = this.encodedQueryNamesAndValues.size() - 2; i >= 0; i -= 2) {
                if (!string2.equals(this.encodedQueryNamesAndValues.get(i))) continue;
                this.encodedQueryNamesAndValues.remove(i + 1);
                this.encodedQueryNamesAndValues.remove(i);
                if (!this.encodedQueryNamesAndValues.isEmpty()) continue;
                this.encodedQueryNamesAndValues = null;
                return;
            }
        }

        /*
         * Unable to fully structure code
         */
        private void resolvePath(String var1_1, int var2_2, int var3_3) {
            block2: {
                if (var2_2 == var3_3) {
                    return;
                }
                var4_4 = var1_1.charAt(var2_2);
                if (var4_4 != 47 && var4_4 != 92) break block2;
                this.encodedPathSegments.clear();
                this.encodedPathSegments.add("");
                ** GOTO lbl20
            }
            var5_5 = this.encodedPathSegments;
            var5_5.set(var5_5.size() - 1, "");
            while (var2_2 < var3_3) {
                var4_4 = Util.delimiterOffset(var1_1, var2_2, var3_3, "/\\");
                var6_6 = var4_4 < var3_3;
                this.push(var1_1, var2_2, var4_4, var6_6, true);
                var2_2 = var4_4;
                if (!var6_6) continue;
                var2_2 = var4_4;
lbl20:
                // 2 sources

                ++var2_2;
            }
        }

        private static int schemeDelimiterOffset(String string2, int n, int n2) {
            block11: {
                int n3;
                char c;
                block10: {
                    block9: {
                        if (n2 - n < 2) {
                            return -1;
                        }
                        c = string2.charAt(n);
                        if (c < 'a') break block9;
                        n3 = n;
                        if (c <= 'z') break block10;
                    }
                    if (c < 'A') break block11;
                    n3 = n;
                    if (c > 'Z') break block11;
                }
                while ((n = n3 + 1) < n2) {
                    c = string2.charAt(n);
                    if (c >= 'a') {
                        n3 = n;
                        if (c <= 'z') continue;
                    }
                    if (c >= 'A') {
                        n3 = n;
                        if (c <= 'Z') continue;
                    }
                    if (c >= '0') {
                        n3 = n;
                        if (c <= '9') continue;
                    }
                    n3 = n;
                    if (c == '+') continue;
                    n3 = n;
                    if (c == '-') continue;
                    if (c == '.') {
                        n3 = n;
                        continue;
                    }
                    if (c != ':') break;
                    return n;
                }
            }
            return -1;
        }

        private static int slashCount(String string2, int n, int n2) {
            char c;
            int n3 = 0;
            while (n < n2 && ((c = string2.charAt(n)) == '\\' || c == '/')) {
                ++n3;
                ++n;
            }
            return n3;
        }

        public Builder addEncodedPathSegment(String string2) {
            Objects.requireNonNull(string2, "encodedPathSegment == null");
            this.push(string2, 0, string2.length(), false, true);
            return this;
        }

        public Builder addEncodedPathSegments(String string2) {
            Objects.requireNonNull(string2, "encodedPathSegments == null");
            return this.addPathSegments(string2, true);
        }

        public Builder addEncodedQueryParameter(String string2, @Nullable String string3) {
            Objects.requireNonNull(string2, "encodedName == null");
            if (this.encodedQueryNamesAndValues == null) {
                this.encodedQueryNamesAndValues = new ArrayList<String>();
            }
            this.encodedQueryNamesAndValues.add(HttpUrl.canonicalize(string2, HttpUrl.QUERY_COMPONENT_REENCODE_SET, true, false, true, true));
            List<String> list = this.encodedQueryNamesAndValues;
            string2 = string3 != null ? HttpUrl.canonicalize(string3, HttpUrl.QUERY_COMPONENT_REENCODE_SET, true, false, true, true) : null;
            list.add(string2);
            return this;
        }

        public Builder addPathSegment(String string2) {
            Objects.requireNonNull(string2, "pathSegment == null");
            this.push(string2, 0, string2.length(), false, false);
            return this;
        }

        public Builder addPathSegments(String string2) {
            Objects.requireNonNull(string2, "pathSegments == null");
            return this.addPathSegments(string2, false);
        }

        public Builder addQueryParameter(String string2, @Nullable String string3) {
            Objects.requireNonNull(string2, "name == null");
            if (this.encodedQueryNamesAndValues == null) {
                this.encodedQueryNamesAndValues = new ArrayList<String>();
            }
            this.encodedQueryNamesAndValues.add(HttpUrl.canonicalize(string2, HttpUrl.QUERY_COMPONENT_ENCODE_SET, false, false, true, true));
            List<String> list = this.encodedQueryNamesAndValues;
            string2 = string3 != null ? HttpUrl.canonicalize(string3, HttpUrl.QUERY_COMPONENT_ENCODE_SET, false, false, true, true) : null;
            list.add(string2);
            return this;
        }

        public HttpUrl build() {
            if (this.scheme != null) {
                if (this.host != null) {
                    return new HttpUrl(this);
                }
                throw new IllegalStateException("host == null");
            }
            throw new IllegalStateException("scheme == null");
        }

        int effectivePort() {
            int n = this.port;
            if (n == -1) {
                n = HttpUrl.defaultPort(this.scheme);
            }
            return n;
        }

        public Builder encodedFragment(@Nullable String string2) {
            string2 = string2 != null ? HttpUrl.canonicalize(string2, HttpUrl.FRAGMENT_ENCODE_SET, true, false, false, false) : null;
            this.encodedFragment = string2;
            return this;
        }

        public Builder encodedPassword(String string2) {
            Objects.requireNonNull(string2, "encodedPassword == null");
            this.encodedPassword = HttpUrl.canonicalize(string2, " \"':;<=>@[]^`{}|/\\?#", true, false, false, true);
            return this;
        }

        public Builder encodedPath(String string2) {
            Objects.requireNonNull(string2, "encodedPath == null");
            if (string2.startsWith("/")) {
                this.resolvePath(string2, 0, string2.length());
                return this;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("unexpected encodedPath: ");
            stringBuilder.append(string2);
            throw new IllegalArgumentException(stringBuilder.toString());
        }

        public Builder encodedQuery(@Nullable String list) {
            list = list != null ? HttpUrl.queryStringToNamesAndValues(HttpUrl.canonicalize((String)((Object)list), HttpUrl.QUERY_ENCODE_SET, true, false, true, true)) : null;
            this.encodedQueryNamesAndValues = list;
            return this;
        }

        public Builder encodedUsername(String string2) {
            Objects.requireNonNull(string2, "encodedUsername == null");
            this.encodedUsername = HttpUrl.canonicalize(string2, " \"':;<=>@[]^`{}|/\\?#", true, false, false, true);
            return this;
        }

        public Builder fragment(@Nullable String string2) {
            string2 = string2 != null ? HttpUrl.canonicalize(string2, HttpUrl.FRAGMENT_ENCODE_SET, false, false, false, false) : null;
            this.encodedFragment = string2;
            return this;
        }

        public Builder host(String string2) {
            Objects.requireNonNull(string2, "host == null");
            CharSequence charSequence = Builder.canonicalizeHost(string2, 0, string2.length());
            if (charSequence != null) {
                this.host = charSequence;
                return this;
            }
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("unexpected host: ");
            ((StringBuilder)charSequence).append(string2);
            throw new IllegalArgumentException(((StringBuilder)charSequence).toString());
        }

        Builder parse(@Nullable HttpUrl object, String string2) {
            block22: {
                int n;
                int n2;
                block26: {
                    int n3;
                    int n4;
                    int n5;
                    int n6;
                    block25: {
                        block23: {
                            block24: {
                                block20: {
                                    block18: {
                                        block21: {
                                            block19: {
                                                n6 = Util.skipLeadingAsciiWhitespace(string2, 0, string2.length());
                                                n4 = Builder.schemeDelimiterOffset(string2, n6, n5 = Util.skipTrailingAsciiWhitespace(string2, n6, string2.length()));
                                                if (n4 == -1) break block18;
                                                if (!string2.regionMatches(true, n6, "https:", 0, 6)) break block19;
                                                this.scheme = "https";
                                                n6 += 6;
                                                break block20;
                                            }
                                            if (!string2.regionMatches(true, n6, "http:", 0, 5)) break block21;
                                            this.scheme = "http";
                                            n6 += 5;
                                            break block20;
                                        }
                                        object = new StringBuilder();
                                        ((StringBuilder)object).append("Expected URL scheme 'http' or 'https' but was '");
                                        ((StringBuilder)object).append(string2.substring(0, n4));
                                        ((StringBuilder)object).append("'");
                                        throw new IllegalArgumentException(((StringBuilder)object).toString());
                                    }
                                    if (object == null) break block22;
                                    this.scheme = ((HttpUrl)object).scheme;
                                }
                                n4 = Builder.slashCount(string2, n6, n5);
                                if (n4 >= 2 || object == null || !((HttpUrl)object).scheme.equals(this.scheme)) break block23;
                                this.encodedUsername = ((HttpUrl)object).encodedUsername();
                                this.encodedPassword = ((HttpUrl)object).encodedPassword();
                                this.host = ((HttpUrl)object).host;
                                this.port = ((HttpUrl)object).port;
                                this.encodedPathSegments.clear();
                                this.encodedPathSegments.addAll(((HttpUrl)object).encodedPathSegments());
                                if (n6 == n5) break block24;
                                n4 = n6;
                                if (string2.charAt(n6) != '#') break block25;
                            }
                            this.encodedQuery(((HttpUrl)object).encodedQuery());
                            n4 = n6;
                            break block25;
                        }
                        n2 = n6 + n4;
                        n6 = 0;
                        n4 = 0;
                        while ((n = (n3 = Util.delimiterOffset(string2, n2, n5, "@/\\?#")) != n5 ? (int)string2.charAt(n3) : -1) != -1 && n != 35 && n != 47 && n != 92 && n != 63) {
                            if (n != 64) continue;
                            if (n6 == 0) {
                                int n7 = Util.delimiterOffset(string2, n2, n3, ':');
                                n = n3;
                                String string3 = HttpUrl.canonicalize(string2, n2, n7, " \"':;<=>@[]^`{}|/\\?#", true, false, false, true, null);
                                object = string3;
                                if (n4 != 0) {
                                    object = new StringBuilder();
                                    ((StringBuilder)object).append(this.encodedUsername);
                                    ((StringBuilder)object).append("%40");
                                    ((StringBuilder)object).append(string3);
                                    object = ((StringBuilder)object).toString();
                                }
                                this.encodedUsername = object;
                                if (n7 != n) {
                                    this.encodedPassword = HttpUrl.canonicalize(string2, n7 + 1, n, " \"':;<=>@[]^`{}|/\\?#", true, false, false, true, null);
                                    n6 = 1;
                                }
                                n4 = 1;
                            } else {
                                object = new StringBuilder();
                                ((StringBuilder)object).append(this.encodedPassword);
                                ((StringBuilder)object).append("%40");
                                ((StringBuilder)object).append(HttpUrl.canonicalize(string2, n2, n3, " \"':;<=>@[]^`{}|/\\?#", true, false, false, true, null));
                                this.encodedPassword = ((StringBuilder)object).toString();
                            }
                            n2 = n3 + 1;
                        }
                        n = Builder.portColonOffset(string2, n2, n3);
                        n6 = n + 1;
                        if (n6 < n3) {
                            this.host = Builder.canonicalizeHost(string2, n2, n);
                            this.port = n4 = Builder.parsePort(string2, n6, n3);
                            if (n4 == -1) {
                                object = new StringBuilder();
                                ((StringBuilder)object).append("Invalid URL port: \"");
                                ((StringBuilder)object).append(string2.substring(n6, n3));
                                ((StringBuilder)object).append('\"');
                                throw new IllegalArgumentException(((StringBuilder)object).toString());
                            }
                        } else {
                            this.host = Builder.canonicalizeHost(string2, n2, n);
                            this.port = HttpUrl.defaultPort(this.scheme);
                        }
                        if (this.host == null) break block26;
                        n4 = n3;
                    }
                    n3 = Util.delimiterOffset(string2, n4, n5, "?#");
                    this.resolvePath(string2, n4, n3);
                    n6 = n3;
                    if (n3 < n5) {
                        n6 = n3;
                        if (string2.charAt(n3) == '?') {
                            n6 = Util.delimiterOffset(string2, n3, n5, '#');
                            this.encodedQueryNamesAndValues = HttpUrl.queryStringToNamesAndValues(HttpUrl.canonicalize(string2, n3 + 1, n6, HttpUrl.QUERY_ENCODE_SET, true, false, true, true, null));
                        }
                    }
                    if (n6 < n5 && string2.charAt(n6) == '#') {
                        this.encodedFragment = HttpUrl.canonicalize(string2, 1 + n6, n5, HttpUrl.FRAGMENT_ENCODE_SET, true, false, false, false, null);
                    }
                    return this;
                }
                object = new StringBuilder();
                ((StringBuilder)object).append("Invalid URL host: \"");
                ((StringBuilder)object).append(string2.substring(n2, n));
                ((StringBuilder)object).append('\"');
                throw new IllegalArgumentException(((StringBuilder)object).toString());
            }
            throw new IllegalArgumentException("Expected URL scheme 'http' or 'https' but no colon was found");
        }

        public Builder password(String string2) {
            Objects.requireNonNull(string2, "password == null");
            this.encodedPassword = HttpUrl.canonicalize(string2, " \"':;<=>@[]^`{}|/\\?#", false, false, false, true);
            return this;
        }

        public Builder port(int n) {
            if (n > 0 && n <= 65535) {
                this.port = n;
                return this;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("unexpected port: ");
            stringBuilder.append(n);
            throw new IllegalArgumentException(stringBuilder.toString());
        }

        public Builder query(@Nullable String list) {
            list = list != null ? HttpUrl.queryStringToNamesAndValues(HttpUrl.canonicalize((String)((Object)list), HttpUrl.QUERY_ENCODE_SET, false, false, true, true)) : null;
            this.encodedQueryNamesAndValues = list;
            return this;
        }

        Builder reencodeForUri() {
            Object object;
            int n;
            int n2 = this.encodedPathSegments.size();
            int n3 = 0;
            for (n = 0; n < n2; ++n) {
                object = this.encodedPathSegments.get(n);
                this.encodedPathSegments.set(n, HttpUrl.canonicalize((String)object, HttpUrl.PATH_SEGMENT_ENCODE_SET_URI, true, true, false, true));
            }
            object = this.encodedQueryNamesAndValues;
            if (object != null) {
                n2 = object.size();
                for (n = n3; n < n2; ++n) {
                    object = this.encodedQueryNamesAndValues.get(n);
                    if (object == null) continue;
                    this.encodedQueryNamesAndValues.set(n, HttpUrl.canonicalize((String)object, HttpUrl.QUERY_COMPONENT_ENCODE_SET_URI, true, true, true, true));
                }
            }
            if ((object = this.encodedFragment) != null) {
                this.encodedFragment = HttpUrl.canonicalize((String)object, HttpUrl.FRAGMENT_ENCODE_SET_URI, true, true, false, false);
            }
            return this;
        }

        public Builder removeAllEncodedQueryParameters(String string2) {
            Objects.requireNonNull(string2, "encodedName == null");
            if (this.encodedQueryNamesAndValues == null) {
                return this;
            }
            this.removeAllCanonicalQueryParameters(HttpUrl.canonicalize(string2, HttpUrl.QUERY_COMPONENT_REENCODE_SET, true, false, true, true));
            return this;
        }

        public Builder removeAllQueryParameters(String string2) {
            Objects.requireNonNull(string2, "name == null");
            if (this.encodedQueryNamesAndValues == null) {
                return this;
            }
            this.removeAllCanonicalQueryParameters(HttpUrl.canonicalize(string2, HttpUrl.QUERY_COMPONENT_ENCODE_SET, false, false, true, true));
            return this;
        }

        public Builder removePathSegment(int n) {
            this.encodedPathSegments.remove(n);
            if (this.encodedPathSegments.isEmpty()) {
                this.encodedPathSegments.add(HttpUrl.FRAGMENT_ENCODE_SET);
            }
            return this;
        }

        public Builder scheme(String string2) {
            block4: {
                block3: {
                    block2: {
                        Objects.requireNonNull(string2, "scheme == null");
                        if (!string2.equalsIgnoreCase("http")) break block2;
                        this.scheme = "http";
                        break block3;
                    }
                    if (!string2.equalsIgnoreCase("https")) break block4;
                    this.scheme = "https";
                }
                return this;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("unexpected scheme: ");
            stringBuilder.append(string2);
            throw new IllegalArgumentException(stringBuilder.toString());
        }

        public Builder setEncodedPathSegment(int n, String string2) {
            Objects.requireNonNull(string2, "encodedPathSegment == null");
            CharSequence charSequence = HttpUrl.canonicalize(string2, 0, string2.length(), HttpUrl.PATH_SEGMENT_ENCODE_SET, true, false, false, true, null);
            this.encodedPathSegments.set(n, (String)charSequence);
            if (!this.isDot((String)charSequence) && !this.isDotDot((String)charSequence)) {
                return this;
            }
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("unexpected path segment: ");
            ((StringBuilder)charSequence).append(string2);
            throw new IllegalArgumentException(((StringBuilder)charSequence).toString());
        }

        public Builder setEncodedQueryParameter(String string2, @Nullable String string3) {
            this.removeAllEncodedQueryParameters(string2);
            this.addEncodedQueryParameter(string2, string3);
            return this;
        }

        public Builder setPathSegment(int n, String string2) {
            Objects.requireNonNull(string2, "pathSegment == null");
            CharSequence charSequence = HttpUrl.canonicalize(string2, 0, string2.length(), HttpUrl.PATH_SEGMENT_ENCODE_SET, false, false, false, true, null);
            if (!this.isDot((String)charSequence) && !this.isDotDot((String)charSequence)) {
                this.encodedPathSegments.set(n, (String)charSequence);
                return this;
            }
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("unexpected path segment: ");
            ((StringBuilder)charSequence).append(string2);
            throw new IllegalArgumentException(((StringBuilder)charSequence).toString());
        }

        public Builder setQueryParameter(String string2, @Nullable String string3) {
            this.removeAllQueryParameters(string2);
            this.addQueryParameter(string2, string3);
            return this;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = this.scheme;
            if (string2 != null) {
                stringBuilder.append(string2);
                stringBuilder.append("://");
            } else {
                stringBuilder.append("//");
            }
            if (!this.encodedUsername.isEmpty() || !this.encodedPassword.isEmpty()) {
                stringBuilder.append(this.encodedUsername);
                if (!this.encodedPassword.isEmpty()) {
                    stringBuilder.append(':');
                    stringBuilder.append(this.encodedPassword);
                }
                stringBuilder.append('@');
            }
            if ((string2 = this.host) != null) {
                if (string2.indexOf(58) != -1) {
                    stringBuilder.append('[');
                    stringBuilder.append(this.host);
                    stringBuilder.append(']');
                } else {
                    stringBuilder.append(this.host);
                }
            }
            if (this.port != -1 || this.scheme != null) {
                int n = this.effectivePort();
                string2 = this.scheme;
                if (string2 == null || n != HttpUrl.defaultPort(string2)) {
                    stringBuilder.append(':');
                    stringBuilder.append(n);
                }
            }
            HttpUrl.pathSegmentsToString(stringBuilder, this.encodedPathSegments);
            if (this.encodedQueryNamesAndValues != null) {
                stringBuilder.append('?');
                HttpUrl.namesAndValuesToQueryString(stringBuilder, this.encodedQueryNamesAndValues);
            }
            if (this.encodedFragment != null) {
                stringBuilder.append('#');
                stringBuilder.append(this.encodedFragment);
            }
            return stringBuilder.toString();
        }

        public Builder username(String string2) {
            Objects.requireNonNull(string2, "username == null");
            this.encodedUsername = HttpUrl.canonicalize(string2, " \"':;<=>@[]^`{}|/\\?#", false, false, false, true);
            return this;
        }
    }
}

