/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.nio.charset.Charset;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public final class MediaType {
    private static final Pattern PARAMETER;
    private static final String QUOTED = "\"([^\"]*)\"";
    private static final String TOKEN = "([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)";
    private static final Pattern TYPE_SUBTYPE;
    @Nullable
    private final String charset;
    private final String mediaType;
    private final String subtype;
    private final String type;

    static {
        TYPE_SUBTYPE = Pattern.compile("([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)/([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)");
        PARAMETER = Pattern.compile(";\\s*(?:([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)=(?:([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)|\"([^\"]*)\"))?");
    }

    private MediaType(String string2, String string3, String string4, @Nullable String string5) {
        this.mediaType = string2;
        this.type = string3;
        this.subtype = string4;
        this.charset = string5;
    }

    public static MediaType get(String string2) {
        Object object = TYPE_SUBTYPE.matcher(string2);
        if (((Matcher)object).lookingAt()) {
            String string3 = ((Matcher)object).group(1).toLowerCase(Locale.US);
            String string4 = ((Matcher)object).group(2).toLowerCase(Locale.US);
            Object object2 = null;
            Matcher matcher = PARAMETER.matcher(string2);
            int n = ((Matcher)object).end();
            while (n < string2.length()) {
                matcher.region(n, string2.length());
                if (matcher.lookingAt()) {
                    CharSequence charSequence = matcher.group(1);
                    object = object2;
                    if (charSequence != null) {
                        if (!((String)charSequence).equalsIgnoreCase("charset")) {
                            object = object2;
                        } else {
                            charSequence = matcher.group(2);
                            if (charSequence != null) {
                                object = charSequence;
                                if (((String)charSequence).startsWith("'")) {
                                    object = charSequence;
                                    if (((String)charSequence).endsWith("'")) {
                                        object = charSequence;
                                        if (((String)charSequence).length() > 2) {
                                            object = ((String)charSequence).substring(1, ((String)charSequence).length() - 1);
                                        }
                                    }
                                }
                            } else {
                                object = matcher.group(3);
                            }
                            if (object2 != null && !((String)object).equalsIgnoreCase((String)object2)) {
                                charSequence = new StringBuilder();
                                ((StringBuilder)charSequence).append("Multiple charsets defined: \"");
                                ((StringBuilder)charSequence).append((String)object2);
                                ((StringBuilder)charSequence).append("\" and: \"");
                                ((StringBuilder)charSequence).append((String)object);
                                ((StringBuilder)charSequence).append("\" for: \"");
                                ((StringBuilder)charSequence).append(string2);
                                ((StringBuilder)charSequence).append('\"');
                                throw new IllegalArgumentException(((StringBuilder)charSequence).toString());
                            }
                        }
                    }
                    n = matcher.end();
                    object2 = object;
                    continue;
                }
                object = new StringBuilder();
                ((StringBuilder)object).append("Parameter is not formatted correctly: \"");
                ((StringBuilder)object).append(string2.substring(n));
                ((StringBuilder)object).append("\" for: \"");
                ((StringBuilder)object).append(string2);
                ((StringBuilder)object).append('\"');
                throw new IllegalArgumentException(((StringBuilder)object).toString());
            }
            return new MediaType(string2, string3, string4, (String)object2);
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("No subtype found for: \"");
        ((StringBuilder)object).append(string2);
        ((StringBuilder)object).append('\"');
        throw new IllegalArgumentException(((StringBuilder)object).toString());
    }

    @Nullable
    public static MediaType parse(String object) {
        try {
            object = MediaType.get((String)object);
            return object;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    @Nullable
    public Charset charset() {
        return this.charset(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public Charset charset(@Nullable Charset charset) {
        String string2;
        try {
            string2 = this.charset;
            Charset charset2 = charset;
            if (string2 == null) return charset2;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return charset;
        }
        return Charset.forName(string2);
    }

    public boolean equals(@Nullable Object object) {
        boolean bl = object instanceof MediaType && ((MediaType)object).mediaType.equals(this.mediaType);
        return bl;
    }

    public int hashCode() {
        return this.mediaType.hashCode();
    }

    public String subtype() {
        return this.subtype;
    }

    public String toString() {
        return this.mediaType;
    }

    public String type() {
        return this.type;
    }
}

