/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.internal.Util;
import okio.Buffer;
import okio.BufferedSink;
import okio.ByteString;

public final class MultipartBody
extends RequestBody {
    public static final MediaType ALTERNATIVE;
    private static final byte[] COLONSPACE;
    private static final byte[] CRLF;
    private static final byte[] DASHDASH;
    public static final MediaType DIGEST;
    public static final MediaType FORM;
    public static final MediaType MIXED;
    public static final MediaType PARALLEL;
    private final ByteString boundary;
    private long contentLength = -1L;
    private final MediaType contentType;
    private final MediaType originalType;
    private final List<Part> parts;

    static {
        MIXED = MediaType.get("multipart/mixed");
        ALTERNATIVE = MediaType.get("multipart/alternative");
        DIGEST = MediaType.get("multipart/digest");
        PARALLEL = MediaType.get("multipart/parallel");
        FORM = MediaType.get("multipart/form-data");
        COLONSPACE = new byte[]{58, 32};
        CRLF = new byte[]{13, 10};
        DASHDASH = new byte[]{45, 45};
    }

    MultipartBody(ByteString byteString, MediaType mediaType, List<Part> list) {
        this.boundary = byteString;
        this.originalType = mediaType;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(mediaType);
        stringBuilder.append("; boundary=");
        stringBuilder.append(byteString.utf8());
        this.contentType = MediaType.get(stringBuilder.toString());
        this.parts = Util.immutableList(list);
    }

    static void appendQuotedString(StringBuilder stringBuilder, String string2) {
        stringBuilder.append('\"');
        int n = string2.length();
        for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            if (c != '\n') {
                if (c != '\r') {
                    if (c != '\"') {
                        stringBuilder.append(c);
                        continue;
                    }
                    stringBuilder.append("%22");
                    continue;
                }
                stringBuilder.append("%0D");
                continue;
            }
            stringBuilder.append("%0A");
        }
        stringBuilder.append('\"');
    }

    private long writeOrCountBytes(@Nullable BufferedSink bufferedSink, boolean bl) throws IOException {
        long l;
        Object object;
        BufferedSink bufferedSink2;
        if (bl) {
            bufferedSink = bufferedSink2 = new Buffer();
        } else {
            object = null;
            bufferedSink2 = bufferedSink;
            bufferedSink = object;
        }
        int n = this.parts.size();
        long l2 = 0L;
        for (int i = 0; i < n; ++i) {
            object = this.parts.get(i);
            Object object2 = ((Part)object).headers;
            object = ((Part)object).body;
            bufferedSink2.write(DASHDASH);
            bufferedSink2.write(this.boundary);
            bufferedSink2.write(CRLF);
            if (object2 != null) {
                int n2 = ((Headers)object2).size();
                for (int j = 0; j < n2; ++j) {
                    bufferedSink2.writeUtf8(((Headers)object2).name(j)).write(COLONSPACE).writeUtf8(((Headers)object2).value(j)).write(CRLF);
                }
            }
            if ((object2 = ((RequestBody)object).contentType()) != null) {
                bufferedSink2.writeUtf8("Content-Type: ").writeUtf8(((MediaType)object2).toString()).write(CRLF);
            }
            if ((l = ((RequestBody)object).contentLength()) != -1L) {
                bufferedSink2.writeUtf8("Content-Length: ").writeDecimalLong(l).write(CRLF);
            } else if (bl) {
                ((Buffer)bufferedSink).clear();
                return -1L;
            }
            object2 = CRLF;
            bufferedSink2.write((byte[])object2);
            if (bl) {
                l2 += l;
            } else {
                ((RequestBody)object).writeTo(bufferedSink2);
            }
            bufferedSink2.write((byte[])object2);
        }
        object = DASHDASH;
        bufferedSink2.write((byte[])object);
        bufferedSink2.write(this.boundary);
        bufferedSink2.write((byte[])object);
        bufferedSink2.write(CRLF);
        l = l2;
        if (bl) {
            l = l2 + ((Buffer)bufferedSink).size();
            ((Buffer)bufferedSink).clear();
        }
        return l;
    }

    public String boundary() {
        return this.boundary.utf8();
    }

    @Override
    public long contentLength() throws IOException {
        long l = this.contentLength;
        if (l != -1L) {
            return l;
        }
        this.contentLength = l = this.writeOrCountBytes(null, true);
        return l;
    }

    @Override
    public MediaType contentType() {
        return this.contentType;
    }

    public Part part(int n) {
        return this.parts.get(n);
    }

    public List<Part> parts() {
        return this.parts;
    }

    public int size() {
        return this.parts.size();
    }

    public MediaType type() {
        return this.originalType;
    }

    @Override
    public void writeTo(BufferedSink bufferedSink) throws IOException {
        this.writeOrCountBytes(bufferedSink, false);
    }

    public static final class Builder {
        private final ByteString boundary;
        private final List<Part> parts;
        private MediaType type = MIXED;

        public Builder() {
            this(UUID.randomUUID().toString());
        }

        public Builder(String string2) {
            this.parts = new ArrayList<Part>();
            this.boundary = ByteString.encodeUtf8(string2);
        }

        public Builder addFormDataPart(String string2, String string3) {
            return this.addPart(Part.createFormData(string2, string3));
        }

        public Builder addFormDataPart(String string2, @Nullable String string3, RequestBody requestBody) {
            return this.addPart(Part.createFormData(string2, string3, requestBody));
        }

        public Builder addPart(@Nullable Headers headers, RequestBody requestBody) {
            return this.addPart(Part.create(headers, requestBody));
        }

        public Builder addPart(Part part) {
            Objects.requireNonNull(part, "part == null");
            this.parts.add(part);
            return this;
        }

        public Builder addPart(RequestBody requestBody) {
            return this.addPart(Part.create(requestBody));
        }

        public MultipartBody build() {
            if (!this.parts.isEmpty()) {
                return new MultipartBody(this.boundary, this.type, this.parts);
            }
            throw new IllegalStateException("Multipart body must have at least one part.");
        }

        public Builder setType(MediaType mediaType) {
            Objects.requireNonNull(mediaType, "type == null");
            if (mediaType.type().equals("multipart")) {
                this.type = mediaType;
                return this;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("multipart != ");
            stringBuilder.append(mediaType);
            throw new IllegalArgumentException(stringBuilder.toString());
        }
    }

    public static final class Part {
        final RequestBody body;
        @Nullable
        final Headers headers;

        private Part(@Nullable Headers headers, RequestBody requestBody) {
            this.headers = headers;
            this.body = requestBody;
        }

        public static Part create(@Nullable Headers headers, RequestBody requestBody) {
            Objects.requireNonNull(requestBody, "body == null");
            if (headers != null && headers.get("Content-Type") != null) {
                throw new IllegalArgumentException("Unexpected header: Content-Type");
            }
            if (headers != null && headers.get("Content-Length") != null) {
                throw new IllegalArgumentException("Unexpected header: Content-Length");
            }
            return new Part(headers, requestBody);
        }

        public static Part create(RequestBody requestBody) {
            return Part.create(null, requestBody);
        }

        public static Part createFormData(String string2, String string3) {
            return Part.createFormData(string2, null, RequestBody.create(null, string3));
        }

        public static Part createFormData(String string2, @Nullable String string3, RequestBody requestBody) {
            Objects.requireNonNull(string2, "name == null");
            StringBuilder stringBuilder = new StringBuilder("form-data; name=");
            MultipartBody.appendQuotedString(stringBuilder, string2);
            if (string3 != null) {
                stringBuilder.append("; filename=");
                MultipartBody.appendQuotedString(stringBuilder, string3);
            }
            return Part.create(new Headers.Builder().addUnsafeNonAscii("Content-Disposition", stringBuilder.toString()).build(), requestBody);
        }

        public RequestBody body() {
            return this.body;
        }

        @Nullable
        public Headers headers() {
            return this.headers;
        }
    }
}

