/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.internal.NamedRunnable;
import okhttp3.internal.Util;
import okhttp3.internal.cache.CacheInterceptor;
import okhttp3.internal.connection.ConnectInterceptor;
import okhttp3.internal.connection.Transmitter;
import okhttp3.internal.http.BridgeInterceptor;
import okhttp3.internal.http.CallServerInterceptor;
import okhttp3.internal.http.RealInterceptorChain;
import okhttp3.internal.http.RetryAndFollowUpInterceptor;
import okhttp3.internal.platform.Platform;
import okio.Timeout;

final class RealCall
implements Call {
    final OkHttpClient client;
    private boolean executed;
    final boolean forWebSocket;
    final Request originalRequest;
    private Transmitter transmitter;

    private RealCall(OkHttpClient okHttpClient, Request request, boolean bl) {
        this.client = okHttpClient;
        this.originalRequest = request;
        this.forWebSocket = bl;
    }

    static RealCall newRealCall(OkHttpClient okHttpClient, Request object, boolean bl) {
        object = new RealCall(okHttpClient, (Request)object, bl);
        ((RealCall)object).transmitter = new Transmitter(okHttpClient, (Call)object);
        return object;
    }

    @Override
    public void cancel() {
        this.transmitter.cancel();
    }

    @Override
    public RealCall clone() {
        return RealCall.newRealCall(this.client, this.originalRequest, this.forWebSocket);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void enqueue(Callback object) {
        synchronized (this) {
            if (!this.executed) {
                this.executed = true;
                // MONITOREXIT @DISABLED, blocks:[2, 3] lbl4 : MonitorExitStatement: MONITOREXIT : this
                this.transmitter.callStart();
                this.client.dispatcher().enqueue(new AsyncCall((Callback)object));
                return;
            }
            object = new IllegalStateException("Already Executed");
            throw object;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Response execute() throws IOException {
        synchronized (this) {
            if (this.executed) {
                IllegalStateException illegalStateException = new IllegalStateException("Already Executed");
                throw illegalStateException;
            }
            this.executed = true;
        }
        this.transmitter.timeoutEnter();
        this.transmitter.callStart();
        try {
            this.client.dispatcher().executed(this);
            Response response = this.getResponseWithInterceptorChain();
            return response;
        }
        finally {
            this.client.dispatcher().finished(this);
        }
    }

    /*
     * WARNING - void declaration
     */
    Response getResponseWithInterceptorChain() throws IOException {
        void var1_5;
        boolean bl;
        Object object;
        block8: {
            object = new ArrayList<Interceptor>();
            object.addAll(this.client.interceptors());
            object.add(new RetryAndFollowUpInterceptor(this.client));
            object.add(new BridgeInterceptor(this.client.cookieJar()));
            object.add(new CacheInterceptor(this.client.internalCache()));
            object.add(new ConnectInterceptor(this.client));
            if (!this.forWebSocket) {
                object.addAll(this.client.networkInterceptors());
            }
            object.add(new CallServerInterceptor(this.forWebSocket));
            object = new RealInterceptorChain((List<Interceptor>)object, this.transmitter, null, 0, this.originalRequest, this, this.client.connectTimeoutMillis(), this.client.readTimeoutMillis(), this.client.writeTimeoutMillis());
            bl = false;
            object = object.proceed(this.originalRequest);
            boolean bl2 = this.transmitter.isCanceled();
            if (bl2) break block8;
            this.transmitter.noMoreExchanges(null);
            return object;
        }
        try {
            Util.closeQuietly((Closeable)object);
            object = new IOException("Canceled");
            throw object;
        }
        catch (Throwable throwable) {
        }
        catch (IOException iOException) {
            try {
                throw this.transmitter.noMoreExchanges(iOException);
            }
            catch (Throwable throwable) {
                bl = true;
            }
        }
        if (!bl) {
            this.transmitter.noMoreExchanges(null);
        }
        throw var1_5;
    }

    @Override
    public boolean isCanceled() {
        return this.transmitter.isCanceled();
    }

    @Override
    public boolean isExecuted() {
        synchronized (this) {
            boolean bl = this.executed;
            return bl;
        }
    }

    String redactedUrl() {
        return this.originalRequest.url().redact();
    }

    @Override
    public Request request() {
        return this.originalRequest;
    }

    @Override
    public Timeout timeout() {
        return this.transmitter.timeout();
    }

    String toLoggableString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = this.isCanceled() ? "canceled " : "";
        stringBuilder.append(string2);
        string2 = this.forWebSocket ? "web socket" : "call";
        stringBuilder.append(string2);
        stringBuilder.append(" to ");
        stringBuilder.append(this.redactedUrl());
        return stringBuilder.toString();
    }

    final class AsyncCall
    extends NamedRunnable {
        static final /* synthetic */ boolean $assertionsDisabled = false;
        private volatile AtomicInteger callsPerHost;
        private final Callback responseCallback;

        AsyncCall(Callback callback) {
            super("OkHttp %s", RealCall.this.redactedUrl());
            this.callsPerHost = new AtomicInteger(0);
            this.responseCallback = callback;
        }

        AtomicInteger callsPerHost() {
            return this.callsPerHost;
        }

        /*
         * Loose catch block
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected void execute() {
            Throwable throwable422;
            block13: {
                block10: {
                    void var1_8;
                    boolean bl;
                    block12: {
                        block11: {
                            RealCall.this.transmitter.timeoutEnter();
                            Response response = RealCall.this.getResponseWithInterceptorChain();
                            boolean bl2 = true;
                            bl = true;
                            try {
                                this.responseCallback.onResponse(RealCall.this, response);
                                break block10;
                            }
                            catch (Throwable throwable2) {
                                break block11;
                            }
                            catch (IOException iOException) {
                                bl = bl2;
                                break block12;
                            }
                            catch (Throwable throwable3) {
                                bl = false;
                            }
                        }
                        try {
                            void var1_5;
                            RealCall.this.cancel();
                            if (bl) throw var1_5;
                            StringBuilder stringBuilder = new StringBuilder();
                            stringBuilder.append("canceled due to ");
                            stringBuilder.append(var1_5);
                            IOException iOException = new IOException(stringBuilder.toString());
                            iOException.addSuppressed((Throwable)var1_5);
                            this.responseCallback.onFailure(RealCall.this, iOException);
                            throw var1_5;
                        }
                        catch (Throwable throwable422) {}
                        break block13;
                        catch (IOException iOException) {
                            bl = false;
                        }
                    }
                    if (bl) {
                        Platform platform = Platform.get();
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("Callback failure for ");
                        stringBuilder.append(RealCall.this.toLoggableString());
                        platform.log(4, stringBuilder.toString(), (Throwable)var1_8);
                    } else {
                        this.responseCallback.onFailure(RealCall.this, (IOException)var1_8);
                    }
                }
                RealCall.this.client.dispatcher().finished(this);
                return;
            }
            RealCall.this.client.dispatcher().finished(this);
            throw throwable422;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void executeOn(ExecutorService executorService) {
            try {
                try {
                    executorService.execute(this);
                    return;
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    InterruptedIOException interruptedIOException = new InterruptedIOException("executor rejected");
                    interruptedIOException.initCause(rejectedExecutionException);
                    RealCall.this.transmitter.noMoreExchanges(interruptedIOException);
                    this.responseCallback.onFailure(RealCall.this, interruptedIOException);
                    RealCall.this.client.dispatcher().finished(this);
                    return;
                }
            }
            catch (Throwable throwable) {}
            RealCall.this.client.dispatcher().finished(this);
            throw throwable;
        }

        RealCall get() {
            return RealCall.this;
        }

        String host() {
            return RealCall.this.originalRequest.url().host();
        }

        Request request() {
            return RealCall.this.originalRequest;
        }

        void reuseCallsPerHostFrom(AsyncCall asyncCall) {
            this.callsPerHost = asyncCall.callsPerHost;
        }
    }
}

