/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.net.URL;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import okhttp3.CacheControl;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.RequestBody;
import okhttp3.internal.Util;
import okhttp3.internal.http.HttpMethod;

public final class Request {
    @Nullable
    final RequestBody body;
    @Nullable
    private volatile CacheControl cacheControl;
    final Headers headers;
    final String method;
    final Map<Class<?>, Object> tags;
    final HttpUrl url;

    Request(Builder builder) {
        this.url = builder.url;
        this.method = builder.method;
        this.headers = builder.headers.build();
        this.body = builder.body;
        this.tags = Util.immutableMap(builder.tags);
    }

    @Nullable
    public RequestBody body() {
        return this.body;
    }

    public CacheControl cacheControl() {
        CacheControl cacheControl = this.cacheControl;
        if (cacheControl == null) {
            this.cacheControl = cacheControl = CacheControl.parse(this.headers);
        }
        return cacheControl;
    }

    @Nullable
    public String header(String string2) {
        return this.headers.get(string2);
    }

    public List<String> headers(String string2) {
        return this.headers.values(string2);
    }

    public Headers headers() {
        return this.headers;
    }

    public boolean isHttps() {
        return this.url.isHttps();
    }

    public String method() {
        return this.method;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    @Nullable
    public Object tag() {
        return this.tag(Object.class);
    }

    @Nullable
    public <T> T tag(Class<? extends T> clazz) {
        return clazz.cast(this.tags.get(clazz));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Request{method=");
        stringBuilder.append(this.method);
        stringBuilder.append(", url=");
        stringBuilder.append(this.url);
        stringBuilder.append(", tags=");
        stringBuilder.append(this.tags);
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public HttpUrl url() {
        return this.url;
    }

    public static class Builder {
        @Nullable
        RequestBody body;
        Headers.Builder headers;
        String method;
        Map<Class<?>, Object> tags = Collections.emptyMap();
        @Nullable
        HttpUrl url;

        public Builder() {
            this.method = "GET";
            this.headers = new Headers.Builder();
        }

        Builder(Request request) {
            this.url = request.url;
            this.method = request.method;
            this.body = request.body;
            Map<Object, Object> map = request.tags.isEmpty() ? Collections.emptyMap() : new LinkedHashMap(request.tags);
            this.tags = map;
            this.headers = request.headers.newBuilder();
        }

        public Builder addHeader(String string2, String string3) {
            this.headers.add(string2, string3);
            return this;
        }

        public Request build() {
            if (this.url != null) {
                return new Request(this);
            }
            throw new IllegalStateException("url == null");
        }

        public Builder cacheControl(CacheControl object) {
            if (((String)(object = ((CacheControl)object).toString())).isEmpty()) {
                return this.removeHeader("Cache-Control");
            }
            return this.header("Cache-Control", (String)object);
        }

        public Builder delete() {
            return this.delete(Util.EMPTY_REQUEST);
        }

        public Builder delete(@Nullable RequestBody requestBody) {
            return this.method("DELETE", requestBody);
        }

        public Builder get() {
            return this.method("GET", null);
        }

        public Builder head() {
            return this.method("HEAD", null);
        }

        public Builder header(String string2, String string3) {
            this.headers.set(string2, string3);
            return this;
        }

        public Builder headers(Headers headers) {
            this.headers = headers.newBuilder();
            return this;
        }

        public Builder method(String string2, @Nullable RequestBody object) {
            Objects.requireNonNull(string2, "method == null");
            if (string2.length() != 0) {
                if (object != null && !HttpMethod.permitsRequestBody(string2)) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append("method ");
                    ((StringBuilder)object).append(string2);
                    ((StringBuilder)object).append(" must not have a request body.");
                    throw new IllegalArgumentException(((StringBuilder)object).toString());
                }
                if (object == null && HttpMethod.requiresRequestBody(string2)) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append("method ");
                    ((StringBuilder)object).append(string2);
                    ((StringBuilder)object).append(" must have a request body.");
                    throw new IllegalArgumentException(((StringBuilder)object).toString());
                }
                this.method = string2;
                this.body = object;
                return this;
            }
            throw new IllegalArgumentException("method.length() == 0");
        }

        public Builder patch(RequestBody requestBody) {
            return this.method("PATCH", requestBody);
        }

        public Builder post(RequestBody requestBody) {
            return this.method("POST", requestBody);
        }

        public Builder put(RequestBody requestBody) {
            return this.method("PUT", requestBody);
        }

        public Builder removeHeader(String string2) {
            this.headers.removeAll(string2);
            return this;
        }

        public <T> Builder tag(Class<? super T> clazz, @Nullable T t) {
            Objects.requireNonNull(clazz, "type == null");
            if (t == null) {
                this.tags.remove(clazz);
            } else {
                if (this.tags.isEmpty()) {
                    this.tags = new LinkedHashMap();
                }
                this.tags.put(clazz, clazz.cast(t));
            }
            return this;
        }

        public Builder tag(@Nullable Object object) {
            return this.tag(Object.class, object);
        }

        public Builder url(String string2) {
            CharSequence charSequence;
            Objects.requireNonNull(string2, "url == null");
            if (string2.regionMatches(true, 0, "ws:", 0, 3)) {
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append("http:");
                ((StringBuilder)charSequence).append(string2.substring(3));
                charSequence = ((StringBuilder)charSequence).toString();
            } else {
                charSequence = string2;
                if (string2.regionMatches(true, 0, "wss:", 0, 4)) {
                    charSequence = new StringBuilder();
                    ((StringBuilder)charSequence).append("https:");
                    ((StringBuilder)charSequence).append(string2.substring(4));
                    charSequence = ((StringBuilder)charSequence).toString();
                }
            }
            return this.url(HttpUrl.get((String)charSequence));
        }

        public Builder url(URL uRL) {
            Objects.requireNonNull(uRL, "url == null");
            return this.url(HttpUrl.get(uRL.toString()));
        }

        public Builder url(HttpUrl httpUrl) {
            Objects.requireNonNull(httpUrl, "url == null");
            this.url = httpUrl;
            return this;
        }
    }
}

