/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.annotation.Nullable;
import okhttp3.MediaType;
import okhttp3.internal.Util;
import okio.BufferedSink;
import okio.ByteString;
import okio.Okio;
import okio.Source;

public abstract class RequestBody {
    public static RequestBody create(final @Nullable MediaType mediaType, final File file) {
        Objects.requireNonNull(file, "file == null");
        return new RequestBody(){

            @Override
            public long contentLength() {
                return file.length();
            }

            @Override
            @Nullable
            public MediaType contentType() {
                return mediaType;
            }

            @Override
            public void writeTo(BufferedSink bufferedSink) throws IOException {
                block7: {
                    Source source = Okio.source(file);
                    try {
                        bufferedSink.writeAll(source);
                        if (source == null) break block7;
                    }
                    catch (Throwable throwable) {
                        try {
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            if (source != null) {
                                try {
                                    source.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            }
                            throw throwable2;
                        }
                    }
                    source.close();
                }
            }
        };
    }

    public static RequestBody create(@Nullable MediaType mediaType, String string2) {
        Charset charset = StandardCharsets.UTF_8;
        Object object = mediaType;
        if (mediaType != null) {
            Charset charset2;
            charset = charset2 = mediaType.charset();
            object = mediaType;
            if (charset2 == null) {
                charset = StandardCharsets.UTF_8;
                object = new StringBuilder();
                ((StringBuilder)object).append(mediaType);
                ((StringBuilder)object).append("; charset=utf-8");
                object = MediaType.parse(((StringBuilder)object).toString());
            }
        }
        return RequestBody.create((MediaType)object, string2.getBytes(charset));
    }

    public static RequestBody create(final @Nullable MediaType mediaType, final ByteString byteString) {
        return new RequestBody(){

            @Override
            public long contentLength() throws IOException {
                return byteString.size();
            }

            @Override
            @Nullable
            public MediaType contentType() {
                return mediaType;
            }

            @Override
            public void writeTo(BufferedSink bufferedSink) throws IOException {
                bufferedSink.write(byteString);
            }
        };
    }

    public static RequestBody create(@Nullable MediaType mediaType, byte[] byArray) {
        return RequestBody.create(mediaType, byArray, 0, byArray.length);
    }

    public static RequestBody create(final @Nullable MediaType mediaType, final byte[] byArray, final int n, final int n2) {
        Objects.requireNonNull(byArray, "content == null");
        Util.checkOffsetAndCount(byArray.length, n, n2);
        return new RequestBody(){

            @Override
            public long contentLength() {
                return n2;
            }

            @Override
            @Nullable
            public MediaType contentType() {
                return mediaType;
            }

            @Override
            public void writeTo(BufferedSink bufferedSink) throws IOException {
                bufferedSink.write(byArray, n, n2);
            }
        };
    }

    public long contentLength() throws IOException {
        return -1L;
    }

    @Nullable
    public abstract MediaType contentType();

    public boolean isDuplex() {
        return false;
    }

    public boolean isOneShot() {
        return false;
    }

    public abstract void writeTo(BufferedSink var1) throws IOException;
}

