/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.annotation.Nullable;
import okhttp3.MediaType;
import okhttp3.internal.Util;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;

public abstract class ResponseBody
implements Closeable {
    @Nullable
    private Reader reader;

    private static /* synthetic */ void $closeResource(Throwable throwable, AutoCloseable autoCloseable) {
        if (throwable != null) {
            try {
                autoCloseable.close();
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
        } else {
            autoCloseable.close();
        }
    }

    private Charset charset() {
        Object object = this.contentType();
        object = object != null ? ((MediaType)object).charset(StandardCharsets.UTF_8) : StandardCharsets.UTF_8;
        return object;
    }

    public static ResponseBody create(final @Nullable MediaType mediaType, final long l, final BufferedSource bufferedSource) {
        Objects.requireNonNull(bufferedSource, "source == null");
        return new ResponseBody(){

            @Override
            public long contentLength() {
                return l;
            }

            @Override
            @Nullable
            public MediaType contentType() {
                return mediaType;
            }

            @Override
            public BufferedSource source() {
                return bufferedSource;
            }
        };
    }

    public static ResponseBody create(@Nullable MediaType object, String string2) {
        Charset charset = StandardCharsets.UTF_8;
        Object object2 = object;
        if (object != null) {
            Charset charset2;
            charset = charset2 = ((MediaType)object).charset();
            object2 = object;
            if (charset2 == null) {
                charset = StandardCharsets.UTF_8;
                object2 = new StringBuilder();
                ((StringBuilder)object2).append(object);
                ((StringBuilder)object2).append("; charset=utf-8");
                object2 = MediaType.parse(((StringBuilder)object2).toString());
            }
        }
        object = new Buffer().writeString(string2, charset);
        return ResponseBody.create((MediaType)object2, ((Buffer)object).size(), (BufferedSource)object);
    }

    public static ResponseBody create(@Nullable MediaType mediaType, ByteString byteString) {
        Buffer buffer = new Buffer().write(byteString);
        return ResponseBody.create(mediaType, byteString.size(), buffer);
    }

    public static ResponseBody create(@Nullable MediaType mediaType, byte[] byArray) {
        Buffer buffer = new Buffer().write(byArray);
        return ResponseBody.create(mediaType, byArray.length, buffer);
    }

    public final InputStream byteStream() {
        return this.source().inputStream();
    }

    public final byte[] bytes() throws IOException {
        long l = this.contentLength();
        if (l <= Integer.MAX_VALUE) {
            byte[] byArray;
            Object object;
            block7: {
                object = this.source();
                try {
                    byArray = object.readByteArray();
                    if (object == null) break block7;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        if (object != null) {
                            ResponseBody.$closeResource(throwable, (AutoCloseable)object);
                        }
                        throw throwable2;
                    }
                }
                ResponseBody.$closeResource(null, (AutoCloseable)object);
            }
            if (l != -1L && l != (long)byArray.length) {
                object = new StringBuilder();
                ((StringBuilder)object).append("Content-Length (");
                ((StringBuilder)object).append(l);
                ((StringBuilder)object).append(") and stream length (");
                ((StringBuilder)object).append(byArray.length);
                ((StringBuilder)object).append(") disagree");
                throw new IOException(((StringBuilder)object).toString());
            }
            return byArray;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Cannot buffer entire body for content length: ");
        stringBuilder.append(l);
        throw new IOException(stringBuilder.toString());
    }

    public final Reader charStream() {
        Reader reader = this.reader;
        if (reader == null) {
            this.reader = reader = new BomAwareReader(this.source(), this.charset());
        }
        return reader;
    }

    @Override
    public void close() {
        Util.closeQuietly(this.source());
    }

    public abstract long contentLength();

    @Nullable
    public abstract MediaType contentType();

    public abstract BufferedSource source();

    public final String string() throws IOException {
        String string2;
        block5: {
            BufferedSource bufferedSource = this.source();
            try {
                string2 = bufferedSource.readString(Util.bomAwareCharset(bufferedSource, this.charset()));
                if (bufferedSource == null) break block5;
            }
            catch (Throwable throwable) {
                try {
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    if (bufferedSource != null) {
                        ResponseBody.$closeResource(throwable, bufferedSource);
                    }
                    throw throwable2;
                }
            }
            ResponseBody.$closeResource(null, bufferedSource);
        }
        return string2;
    }

    static final class BomAwareReader
    extends Reader {
        private final Charset charset;
        private boolean closed;
        @Nullable
        private Reader delegate;
        private final BufferedSource source;

        BomAwareReader(BufferedSource bufferedSource, Charset charset) {
            this.source = bufferedSource;
            this.charset = charset;
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
            Reader reader = this.delegate;
            if (reader != null) {
                reader.close();
            } else {
                this.source.close();
            }
        }

        @Override
        public int read(char[] cArray, int n, int n2) throws IOException {
            if (!this.closed) {
                Reader reader = this.delegate;
                Object object = reader;
                if (reader == null) {
                    object = Util.bomAwareCharset(this.source, this.charset);
                    this.delegate = object = new InputStreamReader(this.source.inputStream(), (Charset)object);
                }
                return ((Reader)object).read(cArray, n, n2);
            }
            throw new IOException("Stream closed");
        }
    }
}

