/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal;

import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.IDN;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.AccessControlException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import okhttp3.internal.Internal;
import okhttp3.internal.Util$$ExternalSyntheticLambda0;
import okhttp3.internal.Util$$ExternalSyntheticLambda1;
import okhttp3.internal.http2.Header;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import okio.Options;
import okio.Source;

public final class Util {
    public static final byte[] EMPTY_BYTE_ARRAY;
    public static final Headers EMPTY_HEADERS;
    public static final RequestBody EMPTY_REQUEST;
    public static final ResponseBody EMPTY_RESPONSE;
    public static final String[] EMPTY_STRING_ARRAY;
    public static final Comparator<String> NATURAL_ORDER;
    private static final Options UNICODE_BOMS;
    public static final TimeZone UTC;
    private static final Charset UTF_32BE;
    private static final Charset UTF_32LE;
    private static final Pattern VERIFY_AS_IP_ADDRESS;
    private static final Method addSuppressedExceptionMethod;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        void var1_5;
        byte[] byArray = new byte[]{};
        EMPTY_BYTE_ARRAY = byArray;
        EMPTY_STRING_ARRAY = new String[0];
        EMPTY_HEADERS = Headers.of(new String[0]);
        Object var1_3 = null;
        EMPTY_RESPONSE = ResponseBody.create(null, byArray);
        EMPTY_REQUEST = RequestBody.create(null, byArray);
        UNICODE_BOMS = Options.of(ByteString.decodeHex("efbbbf"), ByteString.decodeHex("feff"), ByteString.decodeHex("fffe"), ByteString.decodeHex("0000ffff"), ByteString.decodeHex("ffff0000"));
        UTF_32BE = Charset.forName("UTF-32BE");
        UTF_32LE = Charset.forName("UTF-32LE");
        UTC = TimeZone.getTimeZone("GMT");
        NATURAL_ORDER = Util$$ExternalSyntheticLambda0.INSTANCE;
        try {
            Method method;
            Method method2 = method = Throwable.class.getDeclaredMethod("addSuppressed", Throwable.class);
        }
        catch (Exception exception) {}
        addSuppressedExceptionMethod = var1_5;
        VERIFY_AS_IP_ADDRESS = Pattern.compile("([0-9a-fA-F]*:[0-9a-fA-F:.]*)|([\\d.]+)");
    }

    private Util() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void addSuppressedIfPossible(Throwable throwable, Throwable throwable2) {
        Method method = addSuppressedExceptionMethod;
        if (method == null) return;
        try {
            method.invoke((Object)throwable, throwable2);
            return;
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            return;
        }
    }

    public static Charset bomAwareCharset(BufferedSource bufferedSource, Charset charset) throws IOException {
        int n = bufferedSource.select(UNICODE_BOMS);
        if (n != -1) {
            if (n != 0) {
                if (n != 1) {
                    if (n != 2) {
                        if (n != 3) {
                            if (n == 4) {
                                return UTF_32LE;
                            }
                            throw new AssertionError();
                        }
                        return UTF_32BE;
                    }
                    return StandardCharsets.UTF_16LE;
                }
                return StandardCharsets.UTF_16BE;
            }
            return StandardCharsets.UTF_8;
        }
        return charset;
    }

    public static String canonicalizeHost(String string2) {
        block8: {
            if (string2.contains(":")) {
                Serializable serializable = string2.startsWith("[") && string2.endsWith("]") ? Util.decodeIpv6(string2, 1, string2.length() - 1) : Util.decodeIpv6(string2, 0, string2.length());
                if (serializable == null) {
                    return null;
                }
                byte[] byArray = ((InetAddress)serializable).getAddress();
                if (byArray.length == 16) {
                    return Util.inet6AddressToAscii(byArray);
                }
                if (byArray.length == 4) {
                    return ((InetAddress)serializable).getHostAddress();
                }
                serializable = new StringBuilder();
                ((StringBuilder)serializable).append("Invalid IPv6 address: '");
                ((StringBuilder)serializable).append(string2);
                ((StringBuilder)serializable).append("'");
                throw new AssertionError((Object)((StringBuilder)serializable).toString());
            }
            try {
                string2 = IDN.toASCII(string2).toLowerCase(Locale.US);
                if (!string2.isEmpty()) break block8;
                return null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
        boolean bl = Util.containsInvalidHostnameAsciiCodes(string2);
        if (bl) {
            return null;
        }
        return string2;
    }

    public static int checkDuration(String string2, long l, TimeUnit object) {
        long l2 = l - 0L;
        long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
        if (l3 >= 0) {
            Objects.requireNonNull(object, "unit == null");
            l = ((TimeUnit)((Object)object)).toMillis(l);
            if (l <= Integer.MAX_VALUE) {
                if (l == 0L && l3 > 0) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append(string2);
                    ((StringBuilder)object).append(" too small.");
                    throw new IllegalArgumentException(((StringBuilder)object).toString());
                }
                return (int)l;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append(string2);
            ((StringBuilder)object).append(" too large.");
            throw new IllegalArgumentException(((StringBuilder)object).toString());
        }
        object = new StringBuilder();
        ((StringBuilder)object).append(string2);
        ((StringBuilder)object).append(" < 0");
        throw new IllegalArgumentException(((StringBuilder)object).toString());
    }

    public static void checkOffsetAndCount(long l, long l2, long l3) {
        if ((l2 | l3) >= 0L && l2 <= l && l - l2 >= l3) {
            return;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void closeQuietly(Closeable closeable) {
        if (closeable == null) return;
        try {
            closeable.close();
            return;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void closeQuietly(ServerSocket serverSocket) {
        if (serverSocket == null) return;
        try {
            serverSocket.close();
            return;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void closeQuietly(Socket socket) {
        if (socket == null) return;
        try {
            socket.close();
            return;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (AssertionError assertionError) {
            if (!Util.isAndroidGetsocknameError(assertionError)) throw assertionError;
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public static String[] concat(String[] stringArray, String string2) {
        int n = stringArray.length + 1;
        String[] stringArray2 = new String[n];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        stringArray2[n - 1] = string2;
        return stringArray2;
    }

    private static boolean containsInvalidHostnameAsciiCodes(String string2) {
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            if (c > '\u001f' && c < '\u007f') {
                if (" #%/:?@[\\]".indexOf(c) == -1) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int decodeHexDigit(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        int n = 97;
        if (c >= 'a' && c <= 'f') {
            return c - n + 10;
        }
        n = 65;
        if (c < 'A') return -1;
        if (c > 'F') return -1;
        return c - n + 10;
    }

    private static boolean decodeIpv4Suffix(String string2, int n, int n2, byte[] byArray, int n3) {
        int n4 = n3;
        int n5 = n;
        while (n5 < n2) {
            char c;
            if (n4 == byArray.length) {
                return false;
            }
            n = n5;
            if (n4 != n3) {
                if (string2.charAt(n5) != '.') {
                    return false;
                }
                n = n5 + 1;
            }
            int n6 = 0;
            for (n5 = n; n5 < n2 && (c = string2.charAt(n5)) >= '0' && c <= '9'; ++n5) {
                if (n6 == 0 && n != n5) {
                    return false;
                }
                if ((n6 = n6 * 10 + c - 48) <= 255) continue;
                return false;
            }
            if (n5 - n == 0) {
                return false;
            }
            byArray[n4] = (byte)n6;
            ++n4;
        }
        return n4 == n3 + 4;
    }

    @Nullable
    private static InetAddress decodeIpv6(String object, int n, int n2) {
        int n3;
        int n4;
        byte[] byArray;
        block16: {
            byArray = new byte[16];
            int n5 = 0;
            int n6 = -1;
            int n7 = -1;
            while (true) {
                n4 = n5;
                n3 = n6;
                if (n >= n2) break block16;
                if (n5 == 16) {
                    return null;
                }
                n3 = n + 2;
                if (n3 <= n2 && ((String)object).regionMatches(n, "::", 0, 2)) {
                    if (n6 != -1) {
                        return null;
                    }
                    n = n4 = n5 + 2;
                    if (n3 == n2) {
                        n3 = n;
                        break block16;
                    }
                    n7 = n3;
                    n5 = n4;
                    n6 = n;
                    n = n7;
                } else {
                    n4 = n;
                    if (n5 != 0) {
                        if (((String)object).regionMatches(n, ":", 0, 1)) {
                            n4 = n + 1;
                        } else {
                            if (((String)object).regionMatches(n, ".", 0, 1)) {
                                if (!Util.decodeIpv4Suffix((String)object, n7, n2, byArray, n5 - 2)) {
                                    return null;
                                }
                                n4 = n5 + 2;
                                n3 = n6;
                                break block16;
                            }
                            return null;
                        }
                    }
                    n = n4;
                }
                n7 = 0;
                for (n4 = n; n4 < n2 && (n3 = Util.decodeHexDigit(((String)object).charAt(n4))) != -1; ++n4) {
                    n7 = (n7 << 4) + n3;
                }
                n3 = n4 - n;
                if (n3 == 0 || n3 > 4) break;
                n3 = n5 + 1;
                byArray[n5] = (byte)(n7 >>> 8 & 0xFF);
                n5 = n3 + 1;
                byArray[n3] = (byte)(n7 & 0xFF);
                n7 = n;
                n = n4;
            }
            return null;
        }
        if (n4 != 16) {
            if (n3 == -1) {
                return null;
            }
            n = n4 - n3;
            System.arraycopy(byArray, n3, byArray, 16 - n, n);
            Arrays.fill(byArray, n3, 16 - n4 + n3, (byte)0);
        }
        try {
            object = InetAddress.getByAddress(byArray);
            return object;
        }
        catch (UnknownHostException unknownHostException) {
            throw new AssertionError();
        }
    }

    public static int delimiterOffset(String string2, int n, int n2, char c) {
        while (n < n2) {
            if (string2.charAt(n) == c) {
                return n;
            }
            ++n;
        }
        return n2;
    }

    public static int delimiterOffset(String string2, int n, int n2, String string3) {
        while (n < n2) {
            if (string3.indexOf(string2.charAt(n)) != -1) {
                return n;
            }
            ++n;
        }
        return n2;
    }

    public static boolean discard(Source source, int n, TimeUnit timeUnit) {
        try {
            boolean bl = Util.skipAll(source, n, timeUnit);
            return bl;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static String format(String string2, Object ... objectArray) {
        return String.format(Locale.US, string2, objectArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getSystemProperty(String string2, @Nullable String string3) {
        try {
            string2 = System.getProperty(string2);
            if (string2 == null) return string3;
            return string2;
        }
        catch (AccessControlException accessControlException) {
            return string3;
        }
    }

    public static String hostHeader(HttpUrl httpUrl, boolean bl) {
        CharSequence charSequence;
        block6: {
            CharSequence charSequence2;
            block5: {
                if (httpUrl.host().contains(":")) {
                    charSequence2 = new StringBuilder();
                    ((StringBuilder)charSequence2).append("[");
                    ((StringBuilder)charSequence2).append(httpUrl.host());
                    ((StringBuilder)charSequence2).append("]");
                    charSequence2 = ((StringBuilder)charSequence2).toString();
                } else {
                    charSequence2 = httpUrl.host();
                }
                if (bl) break block5;
                charSequence = charSequence2;
                if (httpUrl.port() == HttpUrl.defaultPort(httpUrl.scheme())) break block6;
            }
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append((String)charSequence2);
            ((StringBuilder)charSequence).append(":");
            ((StringBuilder)charSequence).append(httpUrl.port());
            charSequence = ((StringBuilder)charSequence).toString();
        }
        return charSequence;
    }

    public static <T> List<T> immutableList(List<T> list) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
    }

    @SafeVarargs
    public static <T> List<T> immutableList(T ... TArray) {
        return Collections.unmodifiableList(Arrays.asList((Object[])TArray.clone()));
    }

    public static <K, V> Map<K, V> immutableMap(Map<K, V> map) {
        map = map.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(new LinkedHashMap<K, V>(map));
        return map;
    }

    public static int indexOf(Comparator<String> comparator, String[] stringArray, String string2) {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (comparator.compare(stringArray[i], string2) != 0) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfControlOrNonAscii(String string2) {
        int n = string2.length();
        for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            if (c > '\u001f' && c < '\u007f') {
                continue;
            }
            return i;
        }
        return -1;
    }

    private static String inet6AddressToAscii(byte[] byArray) {
        int n;
        int n2 = 0;
        int n3 = -1;
        int n4 = 0;
        int n5 = 0;
        while (n4 < byArray.length) {
            int n6;
            for (n6 = n4; n6 < 16 && byArray[n6] == 0 && byArray[n6 + 1] == 0; n6 += 2) {
            }
            int n7 = n6 - n4;
            int n8 = n3;
            n = n5;
            if (n7 > n5) {
                n8 = n3;
                n = n5;
                if (n7 >= 4) {
                    n = n7;
                    n8 = n4;
                }
            }
            n4 = n6 + 2;
            n3 = n8;
            n5 = n;
        }
        Buffer buffer = new Buffer();
        n4 = n2;
        while (n4 < byArray.length) {
            if (n4 == n3) {
                buffer.writeByte(58);
                n4 = n = n4 + n5;
                if (n != 16) continue;
                buffer.writeByte(58);
                n4 = n;
                continue;
            }
            if (n4 > 0) {
                buffer.writeByte(58);
            }
            buffer.writeHexadecimalUnsignedLong((byArray[n4] & 0xFF) << 8 | byArray[n4 + 1] & 0xFF);
            n4 += 2;
        }
        return buffer.readUtf8();
    }

    public static String[] intersect(Comparator<? super String> comparator, String[] stringArray, String[] stringArray2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        block0: for (String string2 : stringArray) {
            int n = stringArray2.length;
            for (int i = 0; i < n; ++i) {
                if (comparator.compare(string2, stringArray2[i]) != 0) continue;
                arrayList.add(string2);
                continue block0;
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static boolean isAndroidGetsocknameError(AssertionError assertionError) {
        boolean bl = ((Throwable)((Object)assertionError)).getCause() != null && ((Throwable)((Object)assertionError)).getMessage() != null && ((Throwable)((Object)assertionError)).getMessage().contains("getsockname failed");
        return bl;
    }

    static /* synthetic */ Thread lambda$threadFactory$0(String object, boolean bl, Runnable runnable) {
        object = new Thread(runnable, (String)object);
        ((Thread)object).setDaemon(bl);
        return object;
    }

    public static boolean nonEmptyIntersection(Comparator<String> comparator, String[] stringArray, String[] stringArray2) {
        if (stringArray != null && stringArray2 != null && stringArray.length != 0 && stringArray2.length != 0) {
            for (String string2 : stringArray) {
                int n = stringArray2.length;
                for (int i = 0; i < n; ++i) {
                    if (comparator.compare(string2, stringArray2[i]) != 0) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static X509TrustManager platformTrustManager() {
        try {
            Object object = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            Object object2 = null;
            ((TrustManagerFactory)object).init((KeyStore)null);
            Object[] objectArray = ((TrustManagerFactory)object).getTrustManagers();
            if (objectArray.length == 1 && objectArray[0] instanceof X509TrustManager) {
                return (X509TrustManager)objectArray[0];
            }
            object2 = new StringBuilder();
            ((StringBuilder)object2).append("Unexpected default trust managers:");
            ((StringBuilder)object2).append(Arrays.toString(objectArray));
            object = new IllegalStateException(((StringBuilder)object2).toString());
            throw object;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new AssertionError("No System TLS", generalSecurityException);
        }
    }

    public static boolean sameConnection(HttpUrl httpUrl, HttpUrl httpUrl2) {
        boolean bl = httpUrl.host().equals(httpUrl2.host()) && httpUrl.port() == httpUrl2.port() && httpUrl.scheme().equals(httpUrl2.scheme());
        return bl;
    }

    public static boolean skipAll(Source source, int n, TimeUnit object) throws IOException {
        long l = System.nanoTime();
        long l2 = source.timeout().hasDeadline() ? source.timeout().deadlineNanoTime() - l : Long.MAX_VALUE;
        source.timeout().deadlineNanoTime(Math.min(l2, ((TimeUnit)((Object)object)).toNanos(n)) + l);
        try {
            object = new Buffer();
            while (source.read((Buffer)object, 8192L) != -1L) {
                ((Buffer)object).clear();
            }
            return true;
        }
        catch (InterruptedIOException interruptedIOException) {
            return false;
        }
        finally {
            if (l2 == Long.MAX_VALUE) {
                source.timeout().clearDeadline();
            } else {
                source.timeout().deadlineNanoTime(l + l2);
            }
        }
    }

    public static int skipLeadingAsciiWhitespace(String string2, int n, int n2) {
        while (n < n2) {
            char c = string2.charAt(n);
            if (c != '\t' && c != '\n' && c != '\f' && c != '\r' && c != ' ') {
                return n;
            }
            ++n;
        }
        return n2;
    }

    public static int skipTrailingAsciiWhitespace(String string2, int n, int n2) {
        --n2;
        while (n2 >= n) {
            char c = string2.charAt(n2);
            if (c != '\t' && c != '\n' && c != '\f' && c != '\r' && c != ' ') {
                return n2 + 1;
            }
            --n2;
        }
        return n;
    }

    public static ThreadFactory threadFactory(String string2, boolean bl) {
        return new Util$$ExternalSyntheticLambda1(string2, bl);
    }

    public static List<Header> toHeaderBlock(Headers headers) {
        ArrayList<Header> arrayList = new ArrayList<Header>();
        for (int i = 0; i < headers.size(); ++i) {
            arrayList.add(new Header(headers.name(i), headers.value(i)));
        }
        return arrayList;
    }

    public static Headers toHeaders(List<Header> object) {
        Headers.Builder builder = new Headers.Builder();
        object = object.iterator();
        while (object.hasNext()) {
            Header header = (Header)object.next();
            Internal.instance.addLenient(builder, header.name.utf8(), header.value.utf8());
        }
        return builder.build();
    }

    public static String trimSubstring(String string2, int n, int n2) {
        n = Util.skipLeadingAsciiWhitespace(string2, n, n2);
        return string2.substring(n, Util.skipTrailingAsciiWhitespace(string2, n, n2));
    }

    public static boolean verifyAsIpAddress(String string2) {
        return VERIFY_AS_IP_ADDRESS.matcher(string2).matches();
    }
}

