/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.cache;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.internal.Internal;
import okhttp3.internal.Util;
import okhttp3.internal.cache.CacheRequest;
import okhttp3.internal.cache.CacheStrategy;
import okhttp3.internal.cache.InternalCache;
import okhttp3.internal.http.HttpHeaders;
import okhttp3.internal.http.HttpMethod;
import okhttp3.internal.http.RealResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;
import okio.Timeout;

public final class CacheInterceptor
implements Interceptor {
    @Nullable
    final InternalCache cache;

    public CacheInterceptor(@Nullable InternalCache internalCache) {
        this.cache = internalCache;
    }

    private Response cacheWritingResponse(CacheRequest object, Response response) throws IOException {
        if (object == null) {
            return response;
        }
        Closeable closeable = object.body();
        if (closeable == null) {
            return response;
        }
        closeable = new Source(response.body().source(), (CacheRequest)object, Okio.buffer(closeable)){
            boolean cacheRequestClosed;
            final /* synthetic */ BufferedSink val$cacheBody;
            final /* synthetic */ CacheRequest val$cacheRequest;
            final /* synthetic */ BufferedSource val$source;
            {
                this.val$source = bufferedSource;
                this.val$cacheRequest = cacheRequest;
                this.val$cacheBody = bufferedSink;
            }

            @Override
            public void close() throws IOException {
                if (!this.cacheRequestClosed && !Util.discard(this, 100, TimeUnit.MILLISECONDS)) {
                    this.cacheRequestClosed = true;
                    this.val$cacheRequest.abort();
                }
                this.val$source.close();
            }

            @Override
            public long read(Buffer buffer, long l) throws IOException {
                block3: {
                    block4: {
                        try {
                            l = this.val$source.read(buffer, l);
                            if (l != -1L) break block3;
                            if (this.cacheRequestClosed) break block4;
                            this.cacheRequestClosed = true;
                        }
                        catch (IOException iOException) {
                            if (!this.cacheRequestClosed) {
                                this.cacheRequestClosed = true;
                                this.val$cacheRequest.abort();
                            }
                            throw iOException;
                        }
                        this.val$cacheBody.close();
                    }
                    return -1L;
                }
                buffer.copyTo(this.val$cacheBody.buffer(), buffer.size() - l, l);
                this.val$cacheBody.emitCompleteSegments();
                return l;
            }

            @Override
            public Timeout timeout() {
                return this.val$source.timeout();
            }
        };
        object = response.header("Content-Type");
        long l = response.body().contentLength();
        return response.newBuilder().body(new RealResponseBody((String)object, l, Okio.buffer((Source)closeable))).build();
    }

    private static Headers combine(Headers object, Headers headers) {
        int n;
        Headers.Builder builder = new Headers.Builder();
        int n2 = ((Headers)object).size();
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            String string2 = ((Headers)object).name(n);
            String string3 = ((Headers)object).value(n);
            if ("Warning".equalsIgnoreCase(string2) && string3.startsWith("1") || !CacheInterceptor.isContentSpecificHeader(string2) && CacheInterceptor.isEndToEnd(string2) && headers.get(string2) != null) continue;
            Internal.instance.addLenient(builder, string2, string3);
        }
        n2 = headers.size();
        for (n = n3; n < n2; ++n) {
            object = headers.name(n);
            if (CacheInterceptor.isContentSpecificHeader((String)object) || !CacheInterceptor.isEndToEnd((String)object)) continue;
            Internal.instance.addLenient(builder, (String)object, headers.value(n));
        }
        return builder.build();
    }

    static boolean isContentSpecificHeader(String string2) {
        boolean bl = "Content-Length".equalsIgnoreCase(string2) || "Content-Encoding".equalsIgnoreCase(string2) || "Content-Type".equalsIgnoreCase(string2);
        return bl;
    }

    static boolean isEndToEnd(String string2) {
        boolean bl = !"Connection".equalsIgnoreCase(string2) && !"Keep-Alive".equalsIgnoreCase(string2) && !"Proxy-Authenticate".equalsIgnoreCase(string2) && !"Proxy-Authorization".equalsIgnoreCase(string2) && !"TE".equalsIgnoreCase(string2) && !"Trailers".equalsIgnoreCase(string2) && !"Transfer-Encoding".equalsIgnoreCase(string2) && !"Upgrade".equalsIgnoreCase(string2);
        return bl;
    }

    private static Response stripBody(Response response) {
        Response response2 = response;
        if (response != null) {
            response2 = response;
            if (response.body() != null) {
                response2 = response.newBuilder().body(null).build();
            }
        }
        return response2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Response intercept(Interceptor.Chain object) throws IOException {
        Response response;
        Request request;
        Object object2;
        block11: {
            object2 = this.cache;
            object2 = object2 != null ? object2.get(object.request()) : null;
            CacheStrategy cacheStrategy = new CacheStrategy.Factory(System.currentTimeMillis(), object.request(), (Response)object2).get();
            request = cacheStrategy.networkRequest;
            response = cacheStrategy.cacheResponse;
            InternalCache internalCache = this.cache;
            if (internalCache != null) {
                internalCache.trackResponse(cacheStrategy);
            }
            if (object2 != null && response == null) {
                Util.closeQuietly(((Response)object2).body());
            }
            if (request == null && response == null) {
                return new Response.Builder().request(object.request()).protocol(Protocol.HTTP_1_1).code(504).message("Unsatisfiable Request (only-if-cached)").body(Util.EMPTY_RESPONSE).sentRequestAtMillis(-1L).receivedResponseAtMillis(System.currentTimeMillis()).build();
            }
            if (request == null) {
                return response.newBuilder().cacheResponse(CacheInterceptor.stripBody(response)).build();
            }
            try {
                object = object.proceed(request);
                if (object != null || object2 == null) break block11;
            }
            catch (Throwable throwable) {
                if (object2 == null) throw throwable;
                Util.closeQuietly(((Response)object2).body());
                throw throwable;
            }
            Util.closeQuietly(((Response)object2).body());
        }
        if (response != null) {
            if (((Response)object).code() == 304) {
                object2 = response.newBuilder().headers(CacheInterceptor.combine(response.headers(), ((Response)object).headers())).sentRequestAtMillis(((Response)object).sentRequestAtMillis()).receivedResponseAtMillis(((Response)object).receivedResponseAtMillis()).cacheResponse(CacheInterceptor.stripBody(response)).networkResponse(CacheInterceptor.stripBody((Response)object)).build();
                ((Response)object).body().close();
                this.cache.trackConditionalCacheHit();
                this.cache.update(response, (Response)object2);
                return object2;
            }
            Util.closeQuietly(response.body());
        }
        object = ((Response)object).newBuilder().cacheResponse(CacheInterceptor.stripBody(response)).networkResponse(CacheInterceptor.stripBody((Response)object)).build();
        if (this.cache == null) return object;
        if (HttpHeaders.hasBody((Response)object) && CacheStrategy.isCacheable((Response)object, request)) {
            return this.cacheWritingResponse(this.cache.put((Response)object), (Response)object);
        }
        if (!HttpMethod.invalidatesCache(request.method())) return object;
        try {}
        catch (IOException iOException) {
            return object;
        }
        this.cache.remove(request);
        return object;
    }
}

