/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.cache;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import okhttp3.CacheControl;
import okhttp3.Headers;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.internal.Internal;
import okhttp3.internal.http.HttpDate;
import okhttp3.internal.http.HttpHeaders;

public final class CacheStrategy {
    @Nullable
    public final Response cacheResponse;
    @Nullable
    public final Request networkRequest;

    CacheStrategy(Request request, Response response) {
        this.networkRequest = request;
        this.cacheResponse = response;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isCacheable(Response var0, Request var1_1) {
        block6: {
            var2_2 = var0.code();
            var3_3 = false;
            if (var2_2 == 200 || var2_2 == 410 || var2_2 == 414 || var2_2 == 501 || var2_2 == 203 || var2_2 == 204) break block6;
            if (var2_2 == 307) ** GOTO lbl-1000
            if (var2_2 == 308 || var2_2 == 404 || var2_2 == 405) break block6;
            switch (var2_2) {
                default: {
                    ** GOTO lbl11
                }
                case 302: lbl-1000:
                // 2 sources

                {
                    if (var0.header("Expires") != null || var0.cacheControl().maxAgeSeconds() != -1 || var0.cacheControl().isPublic() || var0.cacheControl().isPrivate()) break;
lbl11:
                    // 2 sources

                    return false;
                }
                case 300: 
                case 301: 
            }
        }
        var4_4 = var3_3;
        if (!var0.cacheControl().noStore()) {
            var4_4 = var3_3;
            if (!var1_1.cacheControl().noStore()) {
                var4_4 = true;
            }
        }
        return var4_4;
    }

    public static class Factory {
        private int ageSeconds = -1;
        final Response cacheResponse;
        private String etag;
        private Date expires;
        private Date lastModified;
        private String lastModifiedString;
        final long nowMillis;
        private long receivedResponseMillis;
        final Request request;
        private long sentRequestMillis;
        private Date servedDate;
        private String servedDateString;

        public Factory(long l, Request object, Response object2) {
            this.nowMillis = l;
            this.request = object;
            this.cacheResponse = object2;
            if (object2 != null) {
                this.sentRequestMillis = ((Response)object2).sentRequestAtMillis();
                this.receivedResponseMillis = ((Response)object2).receivedResponseAtMillis();
                Headers headers = ((Response)object2).headers();
                int n = headers.size();
                for (int i = 0; i < n; ++i) {
                    object = headers.name(i);
                    object2 = headers.value(i);
                    if ("Date".equalsIgnoreCase((String)object)) {
                        this.servedDate = HttpDate.parse((String)object2);
                        this.servedDateString = object2;
                        continue;
                    }
                    if ("Expires".equalsIgnoreCase((String)object)) {
                        this.expires = HttpDate.parse((String)object2);
                        continue;
                    }
                    if ("Last-Modified".equalsIgnoreCase((String)object)) {
                        this.lastModified = HttpDate.parse((String)object2);
                        this.lastModifiedString = object2;
                        continue;
                    }
                    if ("ETag".equalsIgnoreCase((String)object)) {
                        this.etag = object2;
                        continue;
                    }
                    if (!"Age".equalsIgnoreCase((String)object)) continue;
                    this.ageSeconds = HttpHeaders.parseSeconds((String)object2, -1);
                }
            }
        }

        private long cacheResponseAge() {
            Date date = this.servedDate;
            long l = 0L;
            if (date != null) {
                l = Math.max(0L, this.receivedResponseMillis - date.getTime());
            }
            long l2 = l;
            if (this.ageSeconds != -1) {
                l2 = Math.max(l, TimeUnit.SECONDS.toMillis(this.ageSeconds));
            }
            l = this.receivedResponseMillis;
            return l2 + (l - this.sentRequestMillis) + (this.nowMillis - l);
        }

        private long computeFreshnessLifetime() {
            Object object = this.cacheResponse.cacheControl();
            if (((CacheControl)object).maxAgeSeconds() != -1) {
                return TimeUnit.SECONDS.toMillis(((CacheControl)object).maxAgeSeconds());
            }
            object = this.expires;
            long l = 0L;
            if (object != null) {
                object = this.servedDate;
                long l2 = object != null ? ((Date)object).getTime() : this.receivedResponseMillis;
                l2 = this.expires.getTime() - l2;
                if (l2 > 0L) {
                    l = l2;
                }
                return l;
            }
            long l3 = l;
            if (this.lastModified != null) {
                l3 = l;
                if (this.cacheResponse.request().url().query() == null) {
                    object = this.servedDate;
                    l3 = object != null ? ((Date)object).getTime() : this.sentRequestMillis;
                    long l4 = l3 - this.lastModified.getTime();
                    l3 = l;
                    if (l4 > 0L) {
                        l3 = l4 / 10L;
                    }
                }
            }
            return l3;
        }

        private CacheStrategy getCandidate() {
            block12: {
                block16: {
                    Object object;
                    Object object2;
                    block14: {
                        block15: {
                            block13: {
                                long l;
                                if (this.cacheResponse == null) {
                                    return new CacheStrategy(this.request, null);
                                }
                                if (this.request.isHttps() && this.cacheResponse.handshake() == null) {
                                    return new CacheStrategy(this.request, null);
                                }
                                if (!CacheStrategy.isCacheable(this.cacheResponse, this.request)) {
                                    return new CacheStrategy(this.request, null);
                                }
                                object2 = this.request.cacheControl();
                                if (((CacheControl)object2).noCache() || Factory.hasConditions(this.request)) break block12;
                                object = this.cacheResponse.cacheControl();
                                long l2 = this.cacheResponseAge();
                                long l3 = l = this.computeFreshnessLifetime();
                                if (((CacheControl)object2).maxAgeSeconds() != -1) {
                                    l3 = Math.min(l, TimeUnit.SECONDS.toMillis(((CacheControl)object2).maxAgeSeconds()));
                                }
                                int n = ((CacheControl)object2).minFreshSeconds();
                                long l4 = 0L;
                                long l5 = n != -1 ? TimeUnit.SECONDS.toMillis(((CacheControl)object2).minFreshSeconds()) : 0L;
                                l = l4;
                                if (!((CacheControl)object).mustRevalidate()) {
                                    l = l4;
                                    if (((CacheControl)object2).maxStaleSeconds() != -1) {
                                        l = TimeUnit.SECONDS.toMillis(((CacheControl)object2).maxStaleSeconds());
                                    }
                                }
                                if (!((CacheControl)object).noCache() && (l5 += l2) < l + l3) {
                                    object = this.cacheResponse.newBuilder();
                                    if (l5 >= l3) {
                                        ((Response.Builder)object).addHeader("Warning", "110 HttpURLConnection \"Response is stale\"");
                                    }
                                    if (l2 > 86400000L && this.isFreshnessLifetimeHeuristic()) {
                                        ((Response.Builder)object).addHeader("Warning", "113 HttpURLConnection \"Heuristic expiration\"");
                                    }
                                    return new CacheStrategy(null, ((Response.Builder)object).build());
                                }
                                object = this.etag;
                                object2 = "If-Modified-Since";
                                if (object == null) break block13;
                                object2 = "If-None-Match";
                                break block14;
                            }
                            if (this.lastModified == null) break block15;
                            object = this.lastModifiedString;
                            break block14;
                        }
                        if (this.servedDate == null) break block16;
                        object = this.servedDateString;
                    }
                    Headers.Builder builder = this.request.headers().newBuilder();
                    Internal.instance.addLenient(builder, (String)object2, (String)object);
                    return new CacheStrategy(this.request.newBuilder().headers(builder.build()).build(), this.cacheResponse);
                }
                return new CacheStrategy(this.request, null);
            }
            return new CacheStrategy(this.request, null);
        }

        private static boolean hasConditions(Request request) {
            boolean bl = request.header("If-Modified-Since") != null || request.header("If-None-Match") != null;
            return bl;
        }

        private boolean isFreshnessLifetimeHeuristic() {
            boolean bl = this.cacheResponse.cacheControl().maxAgeSeconds() == -1 && this.expires == null;
            return bl;
        }

        public CacheStrategy get() {
            CacheStrategy cacheStrategy;
            CacheStrategy cacheStrategy2 = cacheStrategy = this.getCandidate();
            if (cacheStrategy.networkRequest != null) {
                cacheStrategy2 = cacheStrategy;
                if (this.request.cacheControl().onlyIfCached()) {
                    cacheStrategy2 = new CacheStrategy(null, null);
                }
            }
            return cacheStrategy2;
        }
    }
}

