/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.cache;

import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Flushable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.NoSuchElementException;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import okhttp3.internal.Util;
import okhttp3.internal.cache.FaultHidingSink;
import okhttp3.internal.io.FileSystem;
import okhttp3.internal.platform.Platform;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import okio.Source;

public final class DiskLruCache
implements Closeable,
Flushable {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    static final long ANY_SEQUENCE_NUMBER = -1L;
    private static final String CLEAN = "CLEAN";
    private static final String DIRTY = "DIRTY";
    static final String JOURNAL_FILE = "journal";
    static final String JOURNAL_FILE_BACKUP = "journal.bkp";
    static final String JOURNAL_FILE_TEMP = "journal.tmp";
    static final Pattern LEGAL_KEY_PATTERN = Pattern.compile("[a-z0-9_-]{1,120}");
    static final String MAGIC = "libcore.io.DiskLruCache";
    private static final String READ = "READ";
    private static final String REMOVE = "REMOVE";
    static final String VERSION_1 = "1";
    private final int appVersion;
    private final Runnable cleanupRunnable;
    boolean closed;
    final File directory;
    private final Executor executor;
    final FileSystem fileSystem;
    boolean hasJournalErrors;
    boolean initialized;
    private final File journalFile;
    private final File journalFileBackup;
    private final File journalFileTmp;
    BufferedSink journalWriter;
    final LinkedHashMap<String, Entry> lruEntries = new LinkedHashMap(0, 0.75f, true);
    private long maxSize;
    boolean mostRecentRebuildFailed;
    boolean mostRecentTrimFailed;
    private long nextSequenceNumber = 0L;
    int redundantOpCount;
    private long size = 0L;
    final int valueCount;

    private static /* synthetic */ void $closeResource(Throwable throwable, AutoCloseable autoCloseable) {
        if (throwable != null) {
            try {
                autoCloseable.close();
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
        } else {
            autoCloseable.close();
        }
    }

    DiskLruCache(FileSystem fileSystem, File file, int n, int n2, long l, Executor executor) {
        this.cleanupRunnable = new Runnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                DiskLruCache diskLruCache = DiskLruCache.this;
                synchronized (diskLruCache) {
                    boolean bl = !DiskLruCache.this.initialized;
                    if (bl | DiskLruCache.this.closed) {
                        return;
                    }
                    try {
                        DiskLruCache.this.trimToSize();
                    }
                    catch (IOException iOException) {
                        DiskLruCache.this.mostRecentTrimFailed = true;
                    }
                    try {
                        if (DiskLruCache.this.journalRebuildRequired()) {
                            DiskLruCache.this.rebuildJournal();
                            DiskLruCache.this.redundantOpCount = 0;
                        }
                    }
                    catch (IOException iOException) {
                        DiskLruCache.this.mostRecentRebuildFailed = true;
                        DiskLruCache.this.journalWriter = Okio.buffer(Okio.blackhole());
                    }
                    return;
                }
            }
        };
        this.fileSystem = fileSystem;
        this.directory = file;
        this.appVersion = n;
        this.journalFile = new File(file, JOURNAL_FILE);
        this.journalFileTmp = new File(file, JOURNAL_FILE_TEMP);
        this.journalFileBackup = new File(file, JOURNAL_FILE_BACKUP);
        this.valueCount = n2;
        this.maxSize = l;
        this.executor = executor;
    }

    private void checkNotClosed() {
        synchronized (this) {
            block4: {
                boolean bl = this.isClosed();
                if (bl) break block4;
                return;
            }
            IllegalStateException illegalStateException = new IllegalStateException("cache is closed");
            throw illegalStateException;
        }
    }

    public static DiskLruCache create(FileSystem fileSystem, File file, int n, int n2, long l) {
        if (l > 0L) {
            if (n2 > 0) {
                return new DiskLruCache(fileSystem, file, n, n2, l, new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), Util.threadFactory("OkHttp DiskLruCache", true)));
            }
            throw new IllegalArgumentException("valueCount <= 0");
        }
        throw new IllegalArgumentException("maxSize <= 0");
    }

    private BufferedSink newJournalWriter() throws FileNotFoundException {
        return Okio.buffer(new FaultHidingSink(this.fileSystem.appendingSink(this.journalFile)){
            static final /* synthetic */ boolean $assertionsDisabled = false;

            @Override
            protected void onException(IOException iOException) {
                DiskLruCache.this.hasJournalErrors = true;
            }
        });
    }

    private void processJournal() throws IOException {
        this.fileSystem.delete(this.journalFileTmp);
        Iterator<Entry> iterator2 = this.lruEntries.values().iterator();
        while (iterator2.hasNext()) {
            int n;
            Entry entry = iterator2.next();
            Editor editor = entry.currentEditor;
            int n2 = 0;
            if (editor == null) {
                for (n = 0; n < this.valueCount; ++n) {
                    this.size += entry.lengths[n];
                }
                continue;
            }
            entry.currentEditor = null;
            for (n = n2; n < this.valueCount; ++n) {
                this.fileSystem.delete(entry.cleanFiles[n]);
                this.fileSystem.delete(entry.dirtyFiles[n]);
            }
            iterator2.remove();
        }
    }

    /*
     * Loose catch block
     */
    private void readJournal() throws IOException {
        String string2;
        String string3;
        Object object;
        String string4;
        String string5;
        BufferedSource bufferedSource;
        block12: {
            boolean bl;
            bufferedSource = Okio.buffer(this.fileSystem.source(this.journalFile));
            string5 = bufferedSource.readUtf8LineStrict();
            string4 = bufferedSource.readUtf8LineStrict();
            object = bufferedSource.readUtf8LineStrict();
            string3 = bufferedSource.readUtf8LineStrict();
            string2 = bufferedSource.readUtf8LineStrict();
            if (!MAGIC.equals(string5) || !VERSION_1.equals(string4) || !Integer.toString(this.appVersion).equals(object) || !Integer.toString(this.valueCount).equals(string3) || !(bl = "".equals(string2))) break block12;
            int n = 0;
            while (true) {
                try {
                    this.readJournalLine(bufferedSource.readUtf8LineStrict());
                    ++n;
                }
                catch (EOFException eOFException) {
                    block13: {
                        this.redundantOpCount = n - this.lruEntries.size();
                        if (!bufferedSource.exhausted()) {
                            this.rebuildJournal();
                        } else {
                            this.journalWriter = this.newJournalWriter();
                        }
                        if (bufferedSource == null) break block13;
                        DiskLruCache.$closeResource(null, bufferedSource);
                    }
                    return;
                }
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("unexpected journal header: [");
        stringBuilder.append(string5);
        stringBuilder.append(", ");
        stringBuilder.append(string4);
        stringBuilder.append(", ");
        stringBuilder.append(string3);
        stringBuilder.append(", ");
        stringBuilder.append(string2);
        stringBuilder.append("]");
        object = new IOException(stringBuilder.toString());
        throw object;
        {
            catch (Throwable throwable) {
                try {
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    if (bufferedSource != null) {
                        DiskLruCache.$closeResource(throwable, bufferedSource);
                    }
                    throw throwable2;
                }
            }
        }
    }

    private void readJournalLine(String stringArray) throws IOException {
        block9: {
            CharSequence charSequence;
            block13: {
                block11: {
                    int n;
                    int n2;
                    block12: {
                        Object object;
                        block10: {
                            n2 = stringArray.indexOf(32);
                            if (n2 == -1) break block9;
                            int n3 = n2 + 1;
                            n = stringArray.indexOf(32, n3);
                            if (n == -1) {
                                object = stringArray.substring(n3);
                                charSequence = object;
                                if (n2 == 6) {
                                    charSequence = object;
                                    if (stringArray.startsWith(REMOVE)) {
                                        this.lruEntries.remove(object);
                                        return;
                                    }
                                }
                            } else {
                                charSequence = stringArray.substring(n3, n);
                            }
                            Entry entry = this.lruEntries.get(charSequence);
                            object = entry;
                            if (entry == null) {
                                object = new Entry((String)charSequence);
                                this.lruEntries.put((String)charSequence, (Entry)object);
                            }
                            if (n == -1 || n2 != 5 || !stringArray.startsWith(CLEAN)) break block10;
                            stringArray = stringArray.substring(n + 1).split(" ");
                            ((Entry)object).readable = true;
                            ((Entry)object).currentEditor = null;
                            ((Entry)object).setLengths(stringArray);
                            break block11;
                        }
                        if (n != -1 || n2 != 5 || !stringArray.startsWith(DIRTY)) break block12;
                        ((Entry)object).currentEditor = new Editor((Entry)object);
                        break block11;
                    }
                    if (n != -1 || n2 != 4 || !stringArray.startsWith(READ)) break block13;
                }
                return;
            }
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("unexpected journal line: ");
            ((StringBuilder)charSequence).append((String)stringArray);
            throw new IOException(((StringBuilder)charSequence).toString());
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("unexpected journal line: ");
        stringBuilder.append((String)stringArray);
        throw new IOException(stringBuilder.toString());
    }

    private void validateKey(String string2) {
        if (LEGAL_KEY_PATTERN.matcher(string2).matches()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("keys must match regex [a-z0-9_-]{1,120}: \"");
        stringBuilder.append(string2);
        stringBuilder.append("\"");
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() throws IOException {
        synchronized (this) {
            if (this.initialized && !this.closed) {
                Entry[] entryArray = this.lruEntries.values().toArray(new Entry[this.lruEntries.size()]);
                int n = entryArray.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) {
                        this.trimToSize();
                        this.journalWriter.close();
                        this.journalWriter = null;
                        this.closed = true;
                        return;
                    }
                    Entry entry = entryArray[n2];
                    if (entry.currentEditor != null) {
                        entry.currentEditor.abort();
                    }
                    ++n2;
                }
            }
            this.closed = true;
            return;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void completeEdit(Editor object, boolean bl) throws IOException {
        synchronized (this) {
            long l;
            void var2_2;
            int n;
            Object object2 = ((Editor)object).entry;
            if (((Entry)object2).currentEditor != object) {
                object = new IllegalStateException();
                throw object;
            }
            int n2 = n = 0;
            if (var2_2 != false) {
                n2 = n;
                if (!((Entry)object2).readable) {
                    int n3 = 0;
                    while (true) {
                        n2 = n;
                        if (n3 >= this.valueCount) break;
                        if (!((Editor)object).written[n3]) {
                            ((Editor)object).abort();
                            object = new StringBuilder();
                            ((StringBuilder)object).append("Newly created entry didn't create value for index ");
                            ((StringBuilder)object).append(n3);
                            object2 = new IllegalStateException(((StringBuilder)object).toString());
                            throw object2;
                        }
                        if (!this.fileSystem.exists(((Entry)object2).dirtyFiles[n3])) {
                            ((Editor)object).abort();
                            return;
                        }
                        ++n3;
                    }
                }
            }
            while (n2 < this.valueCount) {
                object = ((Entry)object2).dirtyFiles[n2];
                if (var2_2 != false) {
                    if (this.fileSystem.exists((File)object)) {
                        File file = ((Entry)object2).cleanFiles[n2];
                        this.fileSystem.rename((File)object, file);
                        long l2 = ((Entry)object2).lengths[n2];
                        ((Entry)object2).lengths[n2] = l = this.fileSystem.size(file);
                        this.size = this.size - l2 + l;
                    }
                } else {
                    this.fileSystem.delete((File)object);
                }
                ++n2;
            }
            ++this.redundantOpCount;
            ((Entry)object2).currentEditor = null;
            if ((((Entry)object2).readable | var2_2) != 0) {
                ((Entry)object2).readable = true;
                this.journalWriter.writeUtf8(CLEAN).writeByte(32);
                this.journalWriter.writeUtf8(((Entry)object2).key);
                ((Entry)object2).writeLengths(this.journalWriter);
                this.journalWriter.writeByte(10);
                if (var2_2 != false) {
                    l = this.nextSequenceNumber;
                    this.nextSequenceNumber = 1L + l;
                    ((Entry)object2).sequenceNumber = l;
                }
            } else {
                this.lruEntries.remove(((Entry)object2).key);
                this.journalWriter.writeUtf8(REMOVE).writeByte(32);
                this.journalWriter.writeUtf8(((Entry)object2).key);
                this.journalWriter.writeByte(10);
            }
            this.journalWriter.flush();
            if (this.size > this.maxSize || this.journalRebuildRequired()) {
                this.executor.execute(this.cleanupRunnable);
            }
            return;
        }
    }

    public void delete() throws IOException {
        this.close();
        this.fileSystem.deleteContents(this.directory);
    }

    @Nullable
    public Editor edit(String string2) throws IOException {
        return this.edit(string2, -1L);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Editor edit(String object, long l) throws IOException {
        synchronized (this) {
            Object object2;
            long l2;
            void var2_2;
            this.initialize();
            this.checkNotClosed();
            this.validateKey((String)object);
            Entry entry = this.lruEntries.get(object);
            if (var2_2 != -1L && (entry == null || (l2 = entry.sequenceNumber) != var2_2)) {
                return null;
            }
            if (entry != null && (object2 = entry.currentEditor) != null) {
                return null;
            }
            if (!this.mostRecentTrimFailed && !this.mostRecentRebuildFailed) {
                this.journalWriter.writeUtf8(DIRTY).writeByte(32).writeUtf8((String)object).writeByte(10);
                this.journalWriter.flush();
                boolean bl = this.hasJournalErrors;
                if (bl) {
                    return null;
                }
                object2 = entry;
                if (entry == null) {
                    object2 = new Entry((String)object);
                    this.lruEntries.put((String)object, (Entry)object2);
                }
                ((Entry)object2).currentEditor = object = new Editor((Entry)object2);
                return object;
            }
            this.executor.execute(this.cleanupRunnable);
            return null;
        }
    }

    public void evictAll() throws IOException {
        synchronized (this) {
            this.initialize();
            Entry[] entryArray = this.lruEntries.values().toArray(new Entry[this.lruEntries.size()]);
            int n = entryArray.length;
            for (int i = 0; i < n; ++i) {
                this.removeEntry(entryArray[i]);
                continue;
            }
            this.mostRecentTrimFailed = false;
            return;
        }
    }

    @Override
    public void flush() throws IOException {
        synchronized (this) {
            block4: {
                boolean bl = this.initialized;
                if (bl) break block4;
                return;
            }
            this.checkNotClosed();
            this.trimToSize();
            this.journalWriter.flush();
            return;
        }
    }

    public Snapshot get(String string2) throws IOException {
        synchronized (this) {
            block6: {
                Object object;
                block7: {
                    this.initialize();
                    this.checkNotClosed();
                    this.validateKey(string2);
                    object = this.lruEntries.get(string2);
                    if (object == null) break block6;
                    if (!((Entry)object).readable) break block6;
                    if ((object = ((Entry)object).snapshot()) != null) break block7;
                    return null;
                }
                ++this.redundantOpCount;
                this.journalWriter.writeUtf8(READ).writeByte(32).writeUtf8(string2).writeByte(10);
                if (this.journalRebuildRequired()) {
                    this.executor.execute(this.cleanupRunnable);
                }
                return object;
            }
            return null;
        }
    }

    public File getDirectory() {
        return this.directory;
    }

    public long getMaxSize() {
        synchronized (this) {
            long l = this.maxSize;
            return l;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initialize() throws IOException {
        synchronized (this) {
            boolean bl = this.initialized;
            if (bl) {
                return;
            }
            if (this.fileSystem.exists(this.journalFileBackup)) {
                if (this.fileSystem.exists(this.journalFile)) {
                    this.fileSystem.delete(this.journalFileBackup);
                } else {
                    this.fileSystem.rename(this.journalFileBackup, this.journalFile);
                }
            }
            if (bl = this.fileSystem.exists(this.journalFile)) {
                try {
                    this.readJournal();
                    this.processJournal();
                    this.initialized = true;
                    return;
                }
                catch (IOException iOException) {
                    Platform platform = Platform.get();
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("DiskLruCache ");
                    stringBuilder.append(this.directory);
                    stringBuilder.append(" is corrupt: ");
                    stringBuilder.append(iOException.getMessage());
                    stringBuilder.append(", removing");
                    platform.log(5, stringBuilder.toString(), iOException);
                    try {
                        this.delete();
                    }
                    finally {
                        this.closed = false;
                    }
                }
            }
            this.rebuildJournal();
            this.initialized = true;
            return;
        }
    }

    public boolean isClosed() {
        synchronized (this) {
            boolean bl = this.closed;
            return bl;
        }
    }

    boolean journalRebuildRequired() {
        int n = this.redundantOpCount;
        boolean bl = n >= 2000 && n >= this.lruEntries.size();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void rebuildJournal() throws IOException {
        synchronized (this) {
            block13: {
                BufferedSink bufferedSink = this.journalWriter;
                if (bufferedSink != null) {
                    bufferedSink.close();
                }
                bufferedSink = Okio.buffer(this.fileSystem.sink(this.journalFileTmp));
                try {
                    bufferedSink.writeUtf8(MAGIC).writeByte(10);
                    bufferedSink.writeUtf8(VERSION_1).writeByte(10);
                    bufferedSink.writeDecimalLong(this.appVersion).writeByte(10);
                    bufferedSink.writeDecimalLong(this.valueCount).writeByte(10);
                    bufferedSink.writeByte(10);
                    for (Entry entry : this.lruEntries.values()) {
                        if (entry.currentEditor != null) {
                            bufferedSink.writeUtf8(DIRTY).writeByte(32);
                            bufferedSink.writeUtf8(entry.key);
                            bufferedSink.writeByte(10);
                            continue;
                        }
                        bufferedSink.writeUtf8(CLEAN).writeByte(32);
                        bufferedSink.writeUtf8(entry.key);
                        entry.writeLengths(bufferedSink);
                        bufferedSink.writeByte(10);
                    }
                    if (bufferedSink == null) break block13;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        if (bufferedSink != null) {
                            DiskLruCache.$closeResource(throwable, bufferedSink);
                        }
                        throw throwable2;
                    }
                }
                DiskLruCache.$closeResource(null, bufferedSink);
            }
            if (this.fileSystem.exists(this.journalFile)) {
                this.fileSystem.rename(this.journalFile, this.journalFileBackup);
            }
            this.fileSystem.rename(this.journalFileTmp, this.journalFile);
            this.fileSystem.delete(this.journalFileBackup);
            this.journalWriter = this.newJournalWriter();
            this.hasJournalErrors = false;
            this.mostRecentRebuildFailed = false;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean remove(String object) throws IOException {
        synchronized (this) {
            this.initialize();
            this.checkNotClosed();
            this.validateKey((String)object);
            object = this.lruEntries.get(object);
            if (object == null) {
                return false;
            }
            boolean bl = this.removeEntry((Entry)object);
            if (bl && this.size <= this.maxSize) {
                this.mostRecentTrimFailed = false;
            }
            return bl;
        }
    }

    boolean removeEntry(Entry entry) throws IOException {
        if (entry.currentEditor != null) {
            entry.currentEditor.detach();
        }
        for (int i = 0; i < this.valueCount; ++i) {
            this.fileSystem.delete(entry.cleanFiles[i]);
            this.size -= entry.lengths[i];
            entry.lengths[i] = 0L;
        }
        ++this.redundantOpCount;
        this.journalWriter.writeUtf8(REMOVE).writeByte(32).writeUtf8(entry.key).writeByte(10);
        this.lruEntries.remove(entry.key);
        if (this.journalRebuildRequired()) {
            this.executor.execute(this.cleanupRunnable);
        }
        return true;
    }

    public void setMaxSize(long l) {
        synchronized (this) {
            this.maxSize = l;
            if (this.initialized) {
                this.executor.execute(this.cleanupRunnable);
            }
            return;
        }
    }

    public long size() throws IOException {
        synchronized (this) {
            this.initialize();
            long l = this.size;
            return l;
        }
    }

    public Iterator<Snapshot> snapshots() throws IOException {
        synchronized (this) {
            this.initialize();
            Iterator<Snapshot> iterator2 = new Iterator<Snapshot>(){
                final Iterator<Entry> delegate;
                Snapshot nextSnapshot;
                Snapshot removeSnapshot;
                {
                    this.delegate = new ArrayList<Entry>(DiskLruCache.this.lruEntries.values()).iterator();
                }

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public boolean hasNext() {
                    if (this.nextSnapshot != null) {
                        return true;
                    }
                    DiskLruCache diskLruCache = DiskLruCache.this;
                    synchronized (diskLruCache) {
                        Object object;
                        if (DiskLruCache.this.closed) {
                            return false;
                        }
                        do {
                            if (!this.delegate.hasNext()) {
                                return false;
                            }
                            object = this.delegate.next();
                        } while (!((Entry)object).readable || (object = ((Entry)object).snapshot()) == null);
                        this.nextSnapshot = object;
                        return true;
                    }
                }

                @Override
                public Snapshot next() {
                    if (this.hasNext()) {
                        Snapshot snapshot;
                        this.removeSnapshot = snapshot = this.nextSnapshot;
                        this.nextSnapshot = null;
                        return snapshot;
                    }
                    throw new NoSuchElementException();
                }

                /*
                 * Unable to fully structure code
                 */
                @Override
                public void remove() {
                    var1_1 = this.removeSnapshot;
                    if (var1_1 != null) {
                        try {
                            DiskLruCache.this.remove(Snapshot.access$000(var1_1));
                        }
                        catch (Throwable var1_2) {
                            this.removeSnapshot = null;
                            throw var1_2;
                        }
lbl10:
                        // 2 sources

                        while (true) {
                            this.removeSnapshot = null;
                            return;
                        }
                    }
                    throw new IllegalStateException("remove() before next()");
                    catch (IOException var1_3) {
                        ** continue;
                    }
                }
            };
            return iterator2;
        }
    }

    void trimToSize() throws IOException {
        while (this.size > this.maxSize) {
            this.removeEntry(this.lruEntries.values().iterator().next());
        }
        this.mostRecentTrimFailed = false;
    }

    public final class Editor {
        private boolean done;
        final Entry entry;
        final boolean[] written;

        Editor(Entry entry) {
            this.entry = entry;
            DiskLruCache.this = entry.readable ? null : (Object)new boolean[((DiskLruCache)DiskLruCache.this).valueCount];
            this.written = (boolean[])DiskLruCache.this;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void abort() throws IOException {
            DiskLruCache diskLruCache = DiskLruCache.this;
            synchronized (diskLruCache) {
                if (this.done) {
                    IllegalStateException illegalStateException = new IllegalStateException();
                    throw illegalStateException;
                }
                if (this.entry.currentEditor == this) {
                    DiskLruCache.this.completeEdit(this, false);
                }
                this.done = true;
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void abortUnlessCommitted() {
            DiskLruCache diskLruCache = DiskLruCache.this;
            synchronized (diskLruCache) {
                Editor editor;
                if (!this.done && (editor = this.entry.currentEditor) == this) {
                    try {
                        DiskLruCache.this.completeEdit(this, false);
                    }
                    catch (IOException iOException) {}
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void commit() throws IOException {
            DiskLruCache diskLruCache = DiskLruCache.this;
            synchronized (diskLruCache) {
                if (this.done) {
                    IllegalStateException illegalStateException = new IllegalStateException();
                    throw illegalStateException;
                }
                if (this.entry.currentEditor == this) {
                    DiskLruCache.this.completeEdit(this, true);
                }
                this.done = true;
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Lifted jumps to return sites
         */
        void detach() {
            if (this.entry.currentEditor != this) return;
            int n = 0;
            while (true) {
                if (n >= DiskLruCache.this.valueCount) {
                    this.entry.currentEditor = null;
                    return;
                }
                try {
                    DiskLruCache.this.fileSystem.delete(this.entry.dirtyFiles[n]);
                }
                catch (IOException iOException) {}
                ++n;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Sink newSink(int n) {
            DiskLruCache diskLruCache = DiskLruCache.this;
            synchronized (diskLruCache) {
                if (this.done) {
                    IllegalStateException illegalStateException = new IllegalStateException();
                    throw illegalStateException;
                }
                if (this.entry.currentEditor != this) {
                    return Okio.blackhole();
                }
                if (!this.entry.readable) {
                    this.written[n] = true;
                }
                Object object = this.entry.dirtyFiles[n];
                try {
                    object = DiskLruCache.this.fileSystem.sink((File)object);
                    return new FaultHidingSink((Sink)object){

                        /*
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        @Override
                        protected void onException(IOException iOException) {
                            DiskLruCache diskLruCache = DiskLruCache.this;
                            synchronized (diskLruCache) {
                                Editor.this.detach();
                                return;
                            }
                        }
                    };
                }
                catch (FileNotFoundException fileNotFoundException) {
                    return Okio.blackhole();
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Source newSource(int n) {
            DiskLruCache diskLruCache = DiskLruCache.this;
            synchronized (diskLruCache) {
                if (this.done) {
                    IllegalStateException illegalStateException = new IllegalStateException();
                    throw illegalStateException;
                }
                if (!this.entry.readable) return null;
                Editor editor = this.entry.currentEditor;
                if (editor == this) {
                    try {
                        return DiskLruCache.this.fileSystem.source(this.entry.cleanFiles[n]);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        return null;
                    }
                }
                return null;
            }
        }
    }

    private final class Entry {
        final File[] cleanFiles;
        Editor currentEditor;
        final File[] dirtyFiles;
        final String key;
        final long[] lengths;
        boolean readable;
        long sequenceNumber;

        Entry(String charSequence) {
            this.key = charSequence;
            this.lengths = new long[DiskLruCache.this.valueCount];
            this.cleanFiles = new File[DiskLruCache.this.valueCount];
            this.dirtyFiles = new File[DiskLruCache.this.valueCount];
            charSequence = new StringBuilder((String)charSequence);
            ((StringBuilder)charSequence).append('.');
            int n = ((StringBuilder)charSequence).length();
            for (int i = 0; i < DiskLruCache.this.valueCount; ++i) {
                ((StringBuilder)charSequence).append(i);
                this.cleanFiles[i] = new File(DiskLruCache.this.directory, ((StringBuilder)charSequence).toString());
                ((StringBuilder)charSequence).append(".tmp");
                this.dirtyFiles[i] = new File(DiskLruCache.this.directory, ((StringBuilder)charSequence).toString());
                ((StringBuilder)charSequence).setLength(n);
            }
        }

        private IOException invalidLengths(String[] stringArray) throws IOException {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("unexpected journal line: ");
            stringBuilder.append(Arrays.toString(stringArray));
            throw new IOException(stringBuilder.toString());
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void setLengths(String[] stringArray) throws IOException {
            if (stringArray.length != DiskLruCache.this.valueCount) {
                throw this.invalidLengths(stringArray);
            }
            int n = 0;
            try {
                while (true) {
                    if (n >= stringArray.length) {
                        return;
                    }
                    this.lengths[n] = Long.parseLong(stringArray[n]);
                    ++n;
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw this.invalidLengths(stringArray);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        Snapshot snapshot() {
            if (!Thread.holdsLock(DiskLruCache.this)) throw new AssertionError();
            Source[] sourceArray = new Source[DiskLruCache.this.valueCount];
            long[] lArray = (long[])this.lengths.clone();
            int n = 0;
            int n2 = 0;
            while (true) {
                if (n2 >= DiskLruCache.this.valueCount) break;
                sourceArray[n2] = DiskLruCache.this.fileSystem.source(this.cleanFiles[n2]);
                ++n2;
                continue;
                break;
            }
            try {
                return new Snapshot(this.key, this.sequenceNumber, sourceArray, lArray);
            }
            catch (FileNotFoundException fileNotFoundException) {
                for (n2 = n; n2 < DiskLruCache.this.valueCount && sourceArray[n2] != null; ++n2) {
                    Util.closeQuietly(sourceArray[n2]);
                }
                try {
                    DiskLruCache.this.removeEntry(this);
                    return null;
                }
                catch (IOException iOException) {
                    return null;
                }
            }
        }

        void writeLengths(BufferedSink bufferedSink) throws IOException {
            for (long l : this.lengths) {
                bufferedSink.writeByte(32).writeDecimalLong(l);
            }
        }
    }

    public final class Snapshot
    implements Closeable {
        private final String key;
        private final long[] lengths;
        private final long sequenceNumber;
        private final Source[] sources;

        Snapshot(String string2, long l, Source[] sourceArray, long[] lArray) {
            this.key = string2;
            this.sequenceNumber = l;
            this.sources = sourceArray;
            this.lengths = lArray;
        }

        static /* synthetic */ String access$000(Snapshot snapshot) {
            return snapshot.key;
        }

        @Override
        public void close() {
            Source[] sourceArray = this.sources;
            int n = sourceArray.length;
            for (int i = 0; i < n; ++i) {
                Util.closeQuietly(sourceArray[i]);
            }
        }

        @Nullable
        public Editor edit() throws IOException {
            return DiskLruCache.this.edit(this.key, this.sequenceNumber);
        }

        public long getLength(int n) {
            return this.lengths[n];
        }

        public Source getSource(int n) {
            return this.sources[n];
        }

        public String key() {
            return this.key;
        }
    }
}

