/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.cache2;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import okhttp3.internal.Util;
import okhttp3.internal.cache2.FileOperator;
import okio.Buffer;
import okio.ByteString;
import okio.Source;
import okio.Timeout;

final class Relay {
    private static final long FILE_HEADER_SIZE = 32L;
    static final ByteString PREFIX_CLEAN = ByteString.encodeUtf8("OkHttp cache v1\n");
    static final ByteString PREFIX_DIRTY = ByteString.encodeUtf8("OkHttp DIRTY :(\n");
    private static final int SOURCE_FILE = 2;
    private static final int SOURCE_UPSTREAM = 1;
    final Buffer buffer;
    final long bufferMaxSize;
    boolean complete;
    RandomAccessFile file;
    private final ByteString metadata;
    int sourceCount;
    Source upstream;
    final Buffer upstreamBuffer = new Buffer();
    long upstreamPos;
    Thread upstreamReader;

    private Relay(RandomAccessFile randomAccessFile, Source source, long l, ByteString byteString, long l2) {
        this.buffer = new Buffer();
        this.file = randomAccessFile;
        this.upstream = source;
        boolean bl = source == null;
        this.complete = bl;
        this.upstreamPos = l;
        this.metadata = byteString;
        this.bufferMaxSize = l2;
    }

    public static Relay edit(File object, Source object2, ByteString byteString, long l) throws IOException {
        object = new RandomAccessFile((File)object, "rw");
        object2 = new Relay((RandomAccessFile)object, (Source)object2, 0L, byteString, l);
        ((RandomAccessFile)object).setLength(0L);
        super.writeHeader(PREFIX_DIRTY, -1L, -1L);
        return object2;
    }

    public static Relay read(File object) throws IOException {
        object = new RandomAccessFile((File)object, "rw");
        FileOperator fileOperator = new FileOperator(((RandomAccessFile)object).getChannel());
        Buffer buffer = new Buffer();
        fileOperator.read(0L, buffer, 32L);
        Object object2 = PREFIX_CLEAN;
        if (buffer.readByteString(((ByteString)object2).size()).equals(object2)) {
            long l = buffer.readLong();
            long l2 = buffer.readLong();
            object2 = new Buffer();
            fileOperator.read(l + 32L, (Buffer)object2, l2);
            return new Relay((RandomAccessFile)object, null, l, ((Buffer)object2).readByteString(), 0L);
        }
        throw new IOException("unreadable cache file");
    }

    private void writeHeader(ByteString byteString, long l, long l2) throws IOException {
        Buffer buffer = new Buffer();
        buffer.write(byteString);
        buffer.writeLong(l);
        buffer.writeLong(l2);
        if (buffer.size() == 32L) {
            new FileOperator(this.file.getChannel()).write(0L, buffer, 32L);
            return;
        }
        throw new IllegalArgumentException();
    }

    private void writeMetadata(long l) throws IOException {
        Buffer buffer = new Buffer();
        buffer.write(this.metadata);
        new FileOperator(this.file.getChannel()).write(32L + l, buffer, this.metadata.size());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void commit(long l) throws IOException {
        this.writeMetadata(l);
        this.file.getChannel().force(false);
        this.writeHeader(PREFIX_CLEAN, l, this.metadata.size());
        this.file.getChannel().force(false);
        synchronized (this) {
            this.complete = true;
        }
        Util.closeQuietly(this.upstream);
        this.upstream = null;
    }

    boolean isClosed() {
        boolean bl = this.file == null;
        return bl;
    }

    public ByteString metadata() {
        return this.metadata;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Source newSource() {
        synchronized (this) {
            if (this.file == null) {
                return null;
            }
            ++this.sourceCount;
            return new RelaySource();
        }
    }

    class RelaySource
    implements Source {
        private FileOperator fileOperator;
        private long sourcePos;
        private final Timeout timeout = new Timeout();

        RelaySource() {
            this.fileOperator = new FileOperator(Relay.this.file.getChannel());
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void close() throws IOException {
            if (this.fileOperator == null) {
                return;
            }
            RandomAccessFile randomAccessFile = null;
            this.fileOperator = null;
            Relay relay = Relay.this;
            // MONITORENTER : relay
            Relay relay2 = Relay.this;
            --relay2.sourceCount;
            if (Relay.this.sourceCount == 0) {
                randomAccessFile = Relay.this.file;
                Relay.this.file = null;
            }
            // MONITOREXIT : relay
            if (randomAccessFile == null) return;
            Util.closeQuietly(randomAccessFile);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public long read(Buffer object, long l) throws IOException {
            long l2;
            Relay relay;
            block24: {
                long l3;
                block23: {
                    int n;
                    block22: {
                        if (this.fileOperator == null) throw new IllegalStateException("closed");
                        relay = Relay.this;
                        // MONITORENTER : relay
                        while ((l2 = this.sourcePos) == (l3 = Relay.this.upstreamPos)) {
                            if (Relay.this.complete) {
                                // MONITOREXIT : relay
                                return -1L;
                            }
                            if (Relay.this.upstreamReader != null) {
                                this.timeout.waitUntilNotified(Relay.this);
                                continue;
                            }
                            Relay.this.upstreamReader = Thread.currentThread();
                            n = 1;
                            // MONITOREXIT : relay
                            break block22;
                        }
                        long l4 = this.sourcePos;
                        l2 = l3 - Relay.this.buffer.size();
                        if (l4 >= l2) {
                            l = Math.min(l, l3 - l4);
                            Relay.this.buffer.copyTo((Buffer)object, this.sourcePos - l2, l);
                            this.sourcePos += l;
                            // MONITOREXIT : relay
                            return l;
                        }
                        // MONITOREXIT : relay
                        n = 2;
                    }
                    if (n == 2) {
                        l = Math.min(l, l3 - this.sourcePos);
                        this.fileOperator.read(this.sourcePos + 32L, (Buffer)object, l);
                        this.sourcePos += l;
                        return l;
                    }
                    try {
                        l2 = Relay.this.upstream.read(Relay.this.upstreamBuffer, Relay.this.bufferMaxSize);
                        if (l2 != -1L) break block23;
                        Relay.this.commit(l3);
                        relay = Relay.this;
                    }
                    catch (Throwable throwable) {
                        object = Relay.this;
                        // MONITORENTER : object
                        Relay.this.upstreamReader = null;
                        Relay.this.notifyAll();
                        // MONITOREXIT : object
                        throw throwable;
                    }
                    Relay.this.upstreamReader = null;
                    Relay.this.notifyAll();
                    // MONITOREXIT : relay
                    return -1L;
                }
                l = Math.min(l2, l);
                Relay.this.upstreamBuffer.copyTo((Buffer)object, 0L, l);
                this.sourcePos += l;
                this.fileOperator.write(l3 + 32L, (Buffer)Relay.this.upstreamBuffer.clone(), l2);
                object = Relay.this;
                // MONITORENTER : object
                Relay.this.buffer.write(Relay.this.upstreamBuffer, l2);
                if (Relay.this.buffer.size() <= Relay.this.bufferMaxSize) break block24;
                Relay.this.buffer.skip(Relay.this.buffer.size() - Relay.this.bufferMaxSize);
            }
            relay = Relay.this;
            relay.upstreamPos += l2;
            // MONITOREXIT : object
            relay = Relay.this;
            // MONITORENTER : relay
            Relay.this.upstreamReader = null;
            Relay.this.notifyAll();
            // MONITOREXIT : relay
            return l;
        }

        @Override
        public Timeout timeout() {
            return this.timeout;
        }
    }
}

