/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.connection;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ProtocolException;
import java.net.UnknownServiceException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import okhttp3.ConnectionSpec;
import okhttp3.internal.Internal;

final class ConnectionSpecSelector {
    private final List<ConnectionSpec> connectionSpecs;
    private boolean isFallback;
    private boolean isFallbackPossible;
    private int nextModeIndex = 0;

    ConnectionSpecSelector(List<ConnectionSpec> list) {
        this.connectionSpecs = list;
    }

    private boolean isFallbackPossible(SSLSocket sSLSocket) {
        for (int i = this.nextModeIndex; i < this.connectionSpecs.size(); ++i) {
            if (!this.connectionSpecs.get(i).isCompatible(sSLSocket)) continue;
            return true;
        }
        return false;
    }

    ConnectionSpec configureSecureSocket(SSLSocket sSLSocket) throws IOException {
        Object object;
        block2: {
            int n = this.connectionSpecs.size();
            for (int i = this.nextModeIndex; i < n; ++i) {
                object = this.connectionSpecs.get(i);
                if (!((ConnectionSpec)object).isCompatible(sSLSocket)) continue;
                this.nextModeIndex = i + 1;
                break block2;
            }
            object = null;
        }
        if (object != null) {
            this.isFallbackPossible = this.isFallbackPossible(sSLSocket);
            Internal.instance.apply((ConnectionSpec)object, sSLSocket, this.isFallback);
            return object;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Unable to find acceptable protocols. isFallback=");
        ((StringBuilder)object).append(this.isFallback);
        ((StringBuilder)object).append(", modes=");
        ((StringBuilder)object).append(this.connectionSpecs);
        ((StringBuilder)object).append(", supported protocols=");
        ((StringBuilder)object).append(Arrays.toString(sSLSocket.getEnabledProtocols()));
        throw new UnknownServiceException(((StringBuilder)object).toString());
    }

    boolean connectionFailed(IOException iOException) {
        this.isFallback = true;
        if (!this.isFallbackPossible) {
            return false;
        }
        if (iOException instanceof ProtocolException) {
            return false;
        }
        if (iOException instanceof InterruptedIOException) {
            return false;
        }
        if (iOException instanceof SSLHandshakeException && iOException.getCause() instanceof CertificateException) {
            return false;
        }
        if (iOException instanceof SSLPeerUnverifiedException) {
            return false;
        }
        return iOException instanceof SSLException;
    }
}

